/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import io.trino.hadoop.$internal.com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.FSProtos;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.InvalidPathHandleException;
import org.apache.hadoop.fs.PathHandle;

public class LocalFileSystemPathHandle
implements PathHandle {
    private final String path;
    private final Long mtime;

    public LocalFileSystemPathHandle(String path, Optional<Long> mtime) {
        this.path = path;
        this.mtime = mtime.orElse(null);
    }

    public LocalFileSystemPathHandle(ByteBuffer bytes) throws IOException {
        if (null == bytes) {
            throw new IOException("Missing PathHandle");
        }
        FSProtos.LocalFileSystemPathHandleProto p = FSProtos.LocalFileSystemPathHandleProto.parseFrom(ByteString.copyFrom(bytes));
        this.path = p.hasPath() ? p.getPath() : null;
        this.mtime = p.hasMtime() ? Long.valueOf(p.getMtime()) : null;
    }

    public String getPath() {
        return this.path;
    }

    public void verify(FileStatus stat) throws InvalidPathHandleException {
        if (null == stat) {
            throw new InvalidPathHandleException("Could not resolve handle");
        }
        if (this.mtime != null && this.mtime.longValue() != stat.getModificationTime()) {
            throw new InvalidPathHandleException("Content changed");
        }
    }

    @Override
    public ByteBuffer bytes() {
        FSProtos.LocalFileSystemPathHandleProto.Builder b = FSProtos.LocalFileSystemPathHandleProto.newBuilder();
        b.setPath(this.path);
        if (this.mtime != null) {
            b.setMtime(this.mtime);
        }
        return b.build().toByteString().asReadOnlyByteBuffer();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileSystemPathHandle that = (LocalFileSystemPathHandle)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.mtime, that.mtime);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.mtime);
    }

    public String toString() {
        return "LocalFileSystemPathHandle{path='" + this.path + '\'' + ", mtime=" + this.mtime + '}';
    }
}

