/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.datamodel;

import io.trino.hadoop.$internal.com.fasterxml.jackson.annotation.JsonIgnore;
import io.trino.hadoop.$internal.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectReader;
import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.apache.commons.io.FileUtils;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Planner;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.PlannerFactory;
import org.apache.hadoop.hdfs.web.JsonUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DiskBalancerCluster {
    private static final Logger LOG = LoggerFactory.getLogger(DiskBalancerCluster.class);
    private static final ObjectReader READER = new ObjectMapper().readerFor(DiskBalancerCluster.class);
    private final Set<String> exclusionList;
    private final Set<String> inclusionList;
    private ClusterConnector clusterConnector;
    private List<DiskBalancerDataNode> nodes = new LinkedList<DiskBalancerDataNode>();
    private String outputpath;
    @JsonIgnore
    private List<DiskBalancerDataNode> nodesToProcess;
    @JsonIgnore
    private final Map<String, DiskBalancerDataNode> ipList;
    @JsonIgnore
    private final Map<String, DiskBalancerDataNode> hostNames;
    @JsonIgnore
    private final Map<String, DiskBalancerDataNode> hostUUID;
    private float threshold;

    public DiskBalancerCluster() {
        this.exclusionList = new TreeSet<String>();
        this.inclusionList = new TreeSet<String>();
        this.ipList = new HashMap<String, DiskBalancerDataNode>();
        this.hostNames = new HashMap<String, DiskBalancerDataNode>();
        this.hostUUID = new HashMap<String, DiskBalancerDataNode>();
    }

    public DiskBalancerCluster(ClusterConnector connector) throws IOException {
        this();
        Preconditions.checkNotNull(connector);
        this.clusterConnector = connector;
    }

    public static DiskBalancerCluster parseJson(String json) throws IOException {
        return (DiskBalancerCluster)READER.readValue(json);
    }

    public void readClusterInfo() throws Exception {
        Preconditions.checkNotNull(this.clusterConnector);
        LOG.debug("Using connector : {}", (Object)this.clusterConnector.getConnectorInfo());
        this.nodes = this.clusterConnector.getNodes();
        for (DiskBalancerDataNode node : this.nodes) {
            if (node.getDataNodeIP() != null && !node.getDataNodeIP().isEmpty()) {
                this.ipList.put(node.getDataNodeIP(), node);
            }
            if (node.getDataNodeName() != null && !node.getDataNodeName().isEmpty()) {
                this.hostNames.put(node.getDataNodeName().toLowerCase(Locale.US), node);
            }
            if (node.getDataNodeUUID() == null || node.getDataNodeUUID().isEmpty()) continue;
            this.hostUUID.put(node.getDataNodeUUID(), node);
        }
    }

    public List<DiskBalancerDataNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<DiskBalancerDataNode> clusterNodes) {
        this.nodes = clusterNodes;
    }

    public Set<String> getExclusionList() {
        return this.exclusionList;
    }

    public void setExclusionList(Set<String> excludedNodes) {
        this.exclusionList.addAll(excludedNodes);
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float thresholdPercent) {
        Preconditions.checkState(thresholdPercent >= 0.0f && thresholdPercent <= 100.0f, "A percentage value expected.");
        this.threshold = thresholdPercent;
    }

    public Set<String> getInclusionList() {
        return this.inclusionList;
    }

    public void setInclusionList(Set<String> includeNodes) {
        this.inclusionList.addAll(includeNodes);
    }

    public String toJson() throws IOException {
        return JsonUtil.toJsonString(this);
    }

    @JsonIgnore
    public List<DiskBalancerDataNode> getNodesToProcess() {
        return this.nodesToProcess;
    }

    @JsonIgnore
    public void setNodesToProcess(List<DiskBalancerDataNode> dnNodesToProcess) {
        this.nodesToProcess = dnNodesToProcess;
    }

    public String getOutput() {
        return this.outputpath;
    }

    public void setOutput(String output) {
        this.outputpath = output;
    }

    public void createSnapshot(String snapShotName) throws IOException {
        String json = this.toJson();
        File outFile = new File(this.getOutput() + "/" + snapShotName);
        FileUtils.writeStringToFile(outFile, json, StandardCharsets.UTF_8);
    }

    public List<NodePlan> computePlan(double thresholdPercent) {
        LinkedList<NodePlan> planList = new LinkedList<NodePlan>();
        if (this.nodesToProcess == null) {
            LOG.warn("Nodes to process is null. No nodes processed.");
            return planList;
        }
        int poolSize = this.computePoolSize(this.nodesToProcess.size());
        ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
        LinkedList<Future<NodePlan>> futureList = new LinkedList<Future<NodePlan>>();
        for (int x = 0; x < this.nodesToProcess.size(); ++x) {
            final DiskBalancerDataNode diskBalancerDataNode = this.nodesToProcess.get(x);
            final Planner planner = PlannerFactory.getPlanner("greedyPlanner", diskBalancerDataNode, thresholdPercent);
            futureList.add(executorService.submit(new Callable<NodePlan>(){

                @Override
                public NodePlan call() throws Exception {
                    assert (planner != null);
                    return planner.plan(diskBalancerDataNode);
                }
            }));
        }
        for (Future future : futureList) {
            try {
                planList.add((NodePlan)future.get());
            }
            catch (InterruptedException e) {
                LOG.error("Compute Node plan was cancelled or interrupted : ", e);
            }
            catch (ExecutionException e) {
                LOG.error("Unable to compute plan : ", e);
            }
        }
        return planList;
    }

    private int computePoolSize(int nodeCount) {
        if (nodeCount < 10) {
            return nodeCount;
        }
        int threadRatio = nodeCount / 100;
        int modValue = threadRatio % 10;
        if (10 - modValue + threadRatio > 100) {
            return 100;
        }
        return 10 - modValue + threadRatio;
    }

    public DiskBalancerDataNode getNodeByUUID(String uuid) {
        return this.hostUUID.get(uuid);
    }

    public DiskBalancerDataNode getNodeByIPAddress(String ipAddresss) {
        return this.ipList.get(ipAddresss);
    }

    public DiskBalancerDataNode getNodeByName(String hostName) {
        return this.hostNames.get(hostName);
    }
}

