/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto.keytools;

import io.trino.hive.$internal.org.codehaus.jackson.map.ObjectMapper;
import io.trino.hive.$internal.org.codehaus.jackson.type.TypeReference;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.crypto.keytools.KeyMaterial;

public class KeyMetadata {
    static final String KEY_MATERIAL_INTERNAL_STORAGE_FIELD = "internalStorage";
    private static final String KEY_REFERENCE_FIELD = "keyReference";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final boolean isInternalStorage;
    private final String keyReference;
    private final KeyMaterial keyMaterial;

    private KeyMetadata(boolean isInternalStorage, String keyReference, KeyMaterial keyMaterial) {
        this.isInternalStorage = isInternalStorage;
        this.keyReference = keyReference;
        this.keyMaterial = keyMaterial;
    }

    static KeyMetadata parse(byte[] keyMetadataBytes) {
        String keyReference;
        KeyMaterial keyMaterial;
        String keyMetaDataString = new String(keyMetadataBytes, StandardCharsets.UTF_8);
        Map keyMetadataJson = null;
        try {
            keyMetadataJson = (Map)OBJECT_MAPPER.readValue((Reader)new StringReader(keyMetaDataString), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new ParquetCryptoRuntimeException("Failed to parse key metadata " + keyMetaDataString, e);
        }
        String keyMaterialType = (String)keyMetadataJson.get("keyMaterialType");
        if (!"PKMT1".equals(keyMaterialType)) {
            throw new ParquetCryptoRuntimeException("Wrong key material type: " + keyMaterialType + " vs " + "PKMT1");
        }
        Boolean isInternalStorage = (Boolean)keyMetadataJson.get(KEY_MATERIAL_INTERNAL_STORAGE_FIELD);
        if (isInternalStorage.booleanValue()) {
            keyMaterial = KeyMaterial.parse(keyMetadataJson);
            keyReference = null;
        } else {
            keyReference = (String)keyMetadataJson.get(KEY_REFERENCE_FIELD);
            keyMaterial = null;
        }
        return new KeyMetadata(isInternalStorage, keyReference, keyMaterial);
    }

    static String createSerializedForExternalMaterial(String keyReference) {
        HashMap<String, Object> keyMetadataMap = new HashMap<String, Object>(3);
        keyMetadataMap.put("keyMaterialType", "PKMT1");
        keyMetadataMap.put(KEY_MATERIAL_INTERNAL_STORAGE_FIELD, Boolean.FALSE);
        keyMetadataMap.put(KEY_REFERENCE_FIELD, keyReference);
        try {
            return OBJECT_MAPPER.writeValueAsString(keyMetadataMap);
        }
        catch (IOException e) {
            throw new ParquetCryptoRuntimeException("Failed to serialize key metadata", e);
        }
    }

    boolean keyMaterialStoredInternally() {
        return this.isInternalStorage;
    }

    KeyMaterial getKeyMaterial() {
        return this.keyMaterial;
    }

    String getKeyReference() {
        return this.keyReference;
    }
}

