/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerNetAddress;

@ThreadSafe
public final class BlockWorkerInfo {
    private final WorkerNetAddress mNetAddress;
    private final long mCapacityBytes;
    private final long mUsedBytes;

    public BlockWorkerInfo(WorkerNetAddress netAddress, long capacityBytes, long usedBytes) {
        this.mNetAddress = Preconditions.checkNotNull(netAddress, "netAddress");
        this.mCapacityBytes = capacityBytes;
        this.mUsedBytes = usedBytes;
    }

    public WorkerNetAddress getNetAddress() {
        return this.mNetAddress;
    }

    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public long getUsedBytes() {
        return this.mUsedBytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("netAddress", this.mNetAddress).add("capacityBytes", this.mCapacityBytes).add("usedBytes", this.mUsedBytes).toString();
    }
}

