/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile;

import io.airlift.slice.Slice;
import io.trino.rcfile.RcFileCorruptionException;
import io.trino.rcfile.RcFileDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;

public class AircompressorDecompressor
implements RcFileDecompressor {
    private final CompressionCodec codec;

    public AircompressorDecompressor(CompressionCodec codec) {
        this.codec = Objects.requireNonNull(codec, "codec is null");
    }

    @Override
    public void decompress(Slice compressed, Slice uncompressed) throws RcFileCorruptionException {
        try (CompressionInputStream decompressorStream = this.codec.createInputStream((InputStream)compressed.getInput());){
            uncompressed.setBytes(0, (InputStream)decompressorStream, uncompressed.length());
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new RcFileCorruptionException(e, "Compressed stream is truncated", new Object[0]);
        }
    }

    @Override
    public void destroy() {
    }
}

