/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.VertexDescription;
import java.util.HashMap;

final class VertexDescriptionHash {
    HashMap<Integer, VertexDescription> m_map = new HashMap();
    private static VertexDescription m_vd2D = new VertexDescription(1);
    private static VertexDescription m_vd3D = new VertexDescription(3);
    private static final VertexDescriptionHash INSTANCE = new VertexDescriptionHash();

    private VertexDescriptionHash() {
        this.m_map.put(1, m_vd2D);
        this.m_map.put(3, m_vd3D);
    }

    public static VertexDescriptionHash getInstance() {
        return INSTANCE;
    }

    public final VertexDescription getVD2D() {
        return m_vd2D;
    }

    public final VertexDescription getVD3D() {
        return m_vd3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final VertexDescription FindOrAdd(int bitSet) {
        if (bitSet == 1) {
            return m_vd2D;
        }
        if (bitSet == 3) {
            return m_vd3D;
        }
        VertexDescriptionHash vertexDescriptionHash = this;
        synchronized (vertexDescriptionHash) {
            VertexDescription vd = this.m_map.get(bitSet);
            if (vd == null) {
                vd = new VertexDescription(bitSet);
                this.m_map.put(bitSet, vd);
            }
            return vd;
        }
    }
}

