/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.collect.HashMultimap;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.ImmutableMultimap;
import com.linkedin.coral.com.google.common.collect.Multimap;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.common.functions.FunctionRegistry;
import com.linkedin.coral.common.functions.FunctionReturnTypes;
import com.linkedin.coral.common.functions.GenericProjectFunction;
import com.linkedin.coral.common.functions.OperandTypeInference;
import com.linkedin.coral.common.functions.SameOperandTypeExceptFirstOperandChecker;
import com.linkedin.coral.hive.hive2rel.functions.CoalesceStructUtility;
import com.linkedin.coral.hive.hive2rel.functions.HiveExplodeOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveJsonTupleOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveNamedStructFunction;
import com.linkedin.coral.hive.hive2rel.functions.HivePosExplodeOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveRLikeOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveReflectOperator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public class StaticHiveFunctionRegistry
implements FunctionRegistry {
    public static final String IS_TEST_MEMBER_ID_CLASS = "com.linkedin.dali.udf.istestmemberid.hive.IsTestMemberId";
    static final Multimap<String, Function> FUNCTION_MAP = HashMultimap.create();
    public static final Map<String, ImmutableList<String>> UDTF_RETURN_FIELD_NAME_MAP = new HashMap<String, ImmutableList<String>>();

    public Collection<Function> lookup(String functionName) {
        return FUNCTION_MAP.get((Object)functionName.toLowerCase());
    }

    public ImmutableMultimap<String, Function> getRegistry() {
        return ImmutableMultimap.copyOf(FUNCTION_MAP);
    }

    private static void addFunctionEntry(String functionName, SqlOperator operator) {
        FUNCTION_MAP.put((Object)functionName.toLowerCase(), (Object)new Function(functionName, operator));
    }

    public static void createAddUserDefinedFunction(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        StaticHiveFunctionRegistry.addFunctionEntry(functionName, StaticHiveFunctionRegistry.createCalciteUDF(functionName, returnTypeInference, operandTypeChecker));
    }

    public static void createAddUserDefinedFunction(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, String dependency) {
        String depPrefix = dependency.substring(0, 6).toLowerCase();
        if (!depPrefix.equals("ivy://")) {
            dependency = "ivy://" + dependency;
        }
        StaticHiveFunctionRegistry.addFunctionEntry(functionName, StaticHiveFunctionRegistry.createCalciteUDF(functionName, returnTypeInference, operandTypeChecker));
    }

    public static void createAddUserDefinedTableFunction(String functionName, ImmutableList<String> returnFieldNames, ImmutableList<?> returnFieldTypes, SqlOperandTypeChecker operandTypeChecker) {
        Preconditions.checkArgument((!returnFieldTypes.isEmpty() && returnFieldTypes.size() == returnFieldNames.size() && (returnFieldTypes.stream().allMatch(type -> type instanceof SqlTypeName) || returnFieldTypes.stream().allMatch(type -> type instanceof SqlReturnTypeInference)) ? 1 : 0) != 0);
        if (returnFieldTypes.get(0) instanceof SqlTypeName) {
            StaticHiveFunctionRegistry.createAddUserDefinedFunction(functionName, FunctionReturnTypes.rowOf(returnFieldNames, (ImmutableList)ImmutableList.copyOf((Collection)returnFieldTypes.stream().map(type -> (SqlTypeName)type).collect(Collectors.toList()))), operandTypeChecker);
        } else {
            StaticHiveFunctionRegistry.createAddUserDefinedFunction(functionName, FunctionReturnTypes.rowOfInference(returnFieldNames, (ImmutableList)ImmutableList.copyOf((Collection)returnFieldTypes.stream().map(type -> (SqlReturnTypeInference)type).collect(Collectors.toList()))), operandTypeChecker);
        }
        UDTF_RETURN_FIELD_NAME_MAP.put(functionName, returnFieldNames);
    }

    private static SqlOperator createCalciteUDF(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes) {
        return new SqlUserDefinedFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), returnTypeInference, operandTypeInference, operandTypeChecker, paramTypes, null);
    }

    private static SqlOperator createCalciteUDF(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return new SqlUserDefinedFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), returnTypeInference, null, operandTypeChecker, null, null);
    }

    private static SqlOperator createCalciteUDF(String functionName, SqlReturnTypeInference returnTypeInference) {
        return StaticHiveFunctionRegistry.createCalciteUDF(functionName, returnTypeInference, null);
    }

    private static void addCastOperatorEntries() {
        String[] castFunctions;
        for (String f : castFunctions = new String[]{"tok_boolean", "tok_int", "tok_string", "tok_double", "tok_float", "tok_bigint", "tok_tinyint", "tok_smallint", "tok_char", "tok_decimal", "tok_varchar", "tok_binary", "tok_date", "tok_timestamp"}) {
            FUNCTION_MAP.put((Object)f, (Object)HiveFunction.CAST);
        }
    }

    private static Predicate<Integer> optionalOrd(int ordinal) {
        return input -> input == ordinal;
    }

    private static Predicate<Integer> optionalOrd(List<Integer> ordinals) {
        return ordinals::contains;
    }

    static {
        StaticHiveFunctionRegistry.addFunctionEntry("sum", (SqlOperator)SqlStdOperatorTable.SUM);
        StaticHiveFunctionRegistry.addFunctionEntry("count", (SqlOperator)SqlStdOperatorTable.COUNT);
        StaticHiveFunctionRegistry.addFunctionEntry("avg", (SqlOperator)SqlStdOperatorTable.AVG);
        StaticHiveFunctionRegistry.addFunctionEntry("min", (SqlOperator)SqlStdOperatorTable.MIN);
        StaticHiveFunctionRegistry.addFunctionEntry("max", (SqlOperator)SqlStdOperatorTable.MAX);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("collect_list", FunctionReturnTypes.ARRAY_OF_ARG0_TYPE, (SqlOperandTypeChecker)OperandTypes.ANY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("collect_set", FunctionReturnTypes.ARRAY_OF_ARG0_TYPE, (SqlOperandTypeChecker)OperandTypes.ANY);
        StaticHiveFunctionRegistry.addFunctionEntry("row_number", (SqlOperator)SqlStdOperatorTable.ROW_NUMBER);
        StaticHiveFunctionRegistry.addFunctionEntry("rank", (SqlOperator)SqlStdOperatorTable.RANK);
        StaticHiveFunctionRegistry.addFunctionEntry("dense_rank", (SqlOperator)SqlStdOperatorTable.DENSE_RANK);
        StaticHiveFunctionRegistry.addFunctionEntry("cume_dist", (SqlOperator)SqlStdOperatorTable.CUME_DIST);
        StaticHiveFunctionRegistry.addFunctionEntry("percent_rank", (SqlOperator)SqlStdOperatorTable.PERCENT_RANK);
        StaticHiveFunctionRegistry.addFunctionEntry("first_value", (SqlOperator)SqlStdOperatorTable.FIRST_VALUE);
        StaticHiveFunctionRegistry.addFunctionEntry("last_value", (SqlOperator)SqlStdOperatorTable.LAST_VALUE);
        StaticHiveFunctionRegistry.addFunctionEntry("nth_value", (SqlOperator)SqlStdOperatorTable.NTH_VALUE);
        StaticHiveFunctionRegistry.addFunctionEntry("lag", (SqlOperator)SqlStdOperatorTable.LAG);
        StaticHiveFunctionRegistry.addFunctionEntry("lead", (SqlOperator)SqlStdOperatorTable.LEAD);
        StaticHiveFunctionRegistry.addFunctionEntry("stddev", (SqlOperator)SqlStdOperatorTable.STDDEV);
        StaticHiveFunctionRegistry.addFunctionEntry("stddev_samp", (SqlOperator)SqlStdOperatorTable.STDDEV_SAMP);
        StaticHiveFunctionRegistry.addFunctionEntry("stddev_pop", (SqlOperator)SqlStdOperatorTable.STDDEV_POP);
        StaticHiveFunctionRegistry.addFunctionEntry("variance", (SqlOperator)SqlStdOperatorTable.VARIANCE);
        StaticHiveFunctionRegistry.addFunctionEntry("var_samp", (SqlOperator)SqlStdOperatorTable.VAR_SAMP);
        StaticHiveFunctionRegistry.addFunctionEntry("var_pop", (SqlOperator)SqlStdOperatorTable.VAR_POP);
        FUNCTION_MAP.put((Object)"in", (Object)HiveFunction.IN);
        StaticHiveFunctionRegistry.addFunctionEntry("rlike", (SqlOperator)HiveRLikeOperator.RLIKE);
        StaticHiveFunctionRegistry.addFunctionEntry("regexp", (SqlOperator)HiveRLikeOperator.REGEXP);
        StaticHiveFunctionRegistry.addFunctionEntry("!=", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
        StaticHiveFunctionRegistry.addFunctionEntry("==", (SqlOperator)SqlStdOperatorTable.EQUALS);
        StaticHiveFunctionRegistry.addFunctionEntry("tok_isnull", (SqlOperator)SqlStdOperatorTable.IS_NULL);
        StaticHiveFunctionRegistry.addFunctionEntry("tok_isnotnull", (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL);
        FUNCTION_MAP.put((Object)"when", (Object)HiveFunction.WHEN);
        FUNCTION_MAP.put((Object)"case", (Object)HiveFunction.CASE);
        FUNCTION_MAP.put((Object)"between", (Object)HiveFunction.BETWEEN);
        StaticHiveFunctionRegistry.addFunctionEntry("nullif", (SqlOperator)SqlStdOperatorTable.NULLIF);
        StaticHiveFunctionRegistry.addFunctionEntry("isnull", (SqlOperator)SqlStdOperatorTable.IS_NULL);
        StaticHiveFunctionRegistry.addFunctionEntry("isnotnull", (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("nvl", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.and((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.ANY}), OperandTypes.SAME_SAME}));
        StaticHiveFunctionRegistry.addFunctionEntry("if", StaticHiveFunctionRegistry.createCalciteUDF("if", FunctionReturnTypes.IF_FUNC_RETURN_TYPE, OperandTypeInference.BOOLEAN_ANY_SAME, (SqlOperandTypeChecker)new SameOperandTypeExceptFirstOperandChecker(3, SqlTypeName.BOOLEAN), null));
        StaticHiveFunctionRegistry.addFunctionEntry("coalesce", (SqlOperator)SqlStdOperatorTable.COALESCE);
        StaticHiveFunctionRegistry.addCastOperatorEntries();
        StaticHiveFunctionRegistry.addFunctionEntry("array", (SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR);
        StaticHiveFunctionRegistry.addFunctionEntry("struct", (SqlOperator)SqlStdOperatorTable.ROW);
        StaticHiveFunctionRegistry.addFunctionEntry("map", (SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR);
        StaticHiveFunctionRegistry.addFunctionEntry("named_struct", (SqlOperator)HiveNamedStructFunction.NAMED_STRUCT);
        StaticHiveFunctionRegistry.addFunctionEntry("generic_project", (SqlOperator)GenericProjectFunction.GENERIC_PROJECT);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("binary", FunctionReturnTypes.BINARY, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("pmod", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("round", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(1)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("bround", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(1)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("floor", ReturnTypes.BIGINT_FORCE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ceil", ReturnTypes.BIGINT_FORCE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ceiling", ReturnTypes.BIGINT_FORCE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("rand", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(0)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("exp", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ln", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("log10", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("log2", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("log", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("pow", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("power", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sqrt", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("hex", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("unhex", FunctionReturnTypes.BINARY, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("conv", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("abs", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sin", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("asin", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("cos", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("acos", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("tan", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("atan", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("degrees", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("radians", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("positive", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("negative", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sign", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("e", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.NILADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("pi", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.NILADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("factorial", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("cbrt", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("shiftleft", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("shiftright", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("shiftrightunsigned", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("greatest", ReturnTypes.ARG0_NULLABLE, OperandTypes.SAME_VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("least", ReturnTypes.ARG0_NULLABLE, OperandTypes.SAME_VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("width_bucket", ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ascii", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("base64", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.BINARY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("character_length", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("chr", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("concat", FunctionReturnTypes.STRING, OperandTypes.SAME_VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("concat_ws", FunctionReturnTypes.STRING, new SqlOperandTypeChecker(){

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.ARRAY}).checkOperandTypes(callBinding, throwOnFailure) || new SameOperandTypeChecker(-1).checkOperandTypes(callBinding, throwOnFailure);
            }

            public SqlOperandCountRange getOperandCountRange() {
                return SqlOperandCountRanges.from((int)2);
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(STRING, ARRAY|STRING, ...)";
            }

            public SqlOperandTypeChecker.Consistency getConsistency() {
                return SqlOperandTypeChecker.Consistency.NONE;
            }

            public boolean isOptional(int i) {
                return false;
            }
        });
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("context_ngrams", ReturnTypes.LEAST_RESTRICTIVE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("decode", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("elt", FunctionReturnTypes.STRING, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("encode", FunctionReturnTypes.BINARY, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("field", ReturnTypes.INTEGER, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("find_in_set", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("format_number", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.NUMERIC_INTEGER);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("get_json_object", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("in_file", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("initcap", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("instr", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("length", ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("levenshtein", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("locate", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.addFunctionEntry("lower", (SqlOperator)SqlStdOperatorTable.LOWER);
        StaticHiveFunctionRegistry.addFunctionEntry("lcase", (SqlOperator)SqlStdOperatorTable.LOWER);
        StaticHiveFunctionRegistry.addFunctionEntry("translate", (SqlOperator)SqlLibraryOperators.TRANSLATE3);
        StaticHiveFunctionRegistry.addFunctionEntry("translate3", (SqlOperator)SqlLibraryOperators.TRANSLATE3);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("lpad", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ltrim", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ngrams", ReturnTypes.LEAST_RESTRICTIVE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("octet_length", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("parse_url", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family(Collections.nCopies(3, SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("printf", FunctionReturnTypes.STRING, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("regexp_extract", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("regexp_replace", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("repeat", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.addFunctionEntry("replace", (SqlOperator)SqlStdOperatorTable.REPLACE);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("reverse", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.NULLABLE_LITERAL}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("rpad", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("rtrim", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sentences", ReturnTypes.LEAST_RESTRICTIVE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("soundex", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("space", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("split", FunctionReturnTypes.arrayOfType((SqlTypeName)SqlTypeName.VARCHAR), (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("str_to_map", FunctionReturnTypes.mapOfType((SqlTypeName)SqlTypeName.VARCHAR, (SqlTypeName)SqlTypeName.VARCHAR), (SqlOperandTypeChecker)OperandTypes.family(Collections.nCopies(3, SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd((List<Integer>)ImmutableList.of((Object)1, (Object)2))));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("substr", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("substring", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("substring_index", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_INTEGER);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("trim", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("unbase64", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.NULLABLE_LITERAL}));
        StaticHiveFunctionRegistry.addFunctionEntry("upper", (SqlOperator)SqlStdOperatorTable.UPPER);
        StaticHiveFunctionRegistry.addFunctionEntry("ucase", (SqlOperator)SqlStdOperatorTable.UPPER);
        StaticHiveFunctionRegistry.addFunctionEntry("initcap", (SqlOperator)SqlStdOperatorTable.INITCAP);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("md5", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sha1", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sha", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("crc32", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath", FunctionReturnTypes.arrayOfType((SqlTypeName)SqlTypeName.VARCHAR), (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_string", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_boolean", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_short", FunctionReturnTypes.SMALLINT, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_int", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_long", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_float", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_double", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_number", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("from_unixtime", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd(1)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("unix_timestamp", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd((List<Integer>)ImmutableList.of((Object)0, (Object)1))));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("to_date", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.DATETIME}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date", ReturnTypes.DATE, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.DATETIME}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("year", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("quarter", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("month", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("day", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("dayofmonth", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("hour", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.DATETIME}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("minute", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("second", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("weekofyear", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("datediff", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date_add", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATE, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.TIMESTAMP, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date_sub", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATE, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.TIMESTAMP, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("from_utc_timestamp", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.TIMESTAMP), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.addFunctionEntry("current_date", (SqlOperator)SqlStdOperatorTable.CURRENT_DATE);
        StaticHiveFunctionRegistry.addFunctionEntry("current_timestamp", (SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("add_months", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("last_day", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("next_day", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("trunc", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("months_between", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATE, SqlTypeFamily.DATE}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date_format", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATE, SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.TIMESTAMP, SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("to_utc_timestamp", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING_STRING, OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING})}));
        StaticHiveFunctionRegistry.addFunctionEntry("size", (SqlOperator)SqlStdOperatorTable.CARDINALITY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("array_contains", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ANY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("map_keys", opBinding -> {
            RelDataType operandType = opBinding.getOperandType(0);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createArrayType(operandType.getKeyType(), -1L);
        }, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("map_values", opBinding -> {
            RelDataType operandType = opBinding.getOperandType(0);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createArrayType(operandType.getValueType(), -1L);
        }, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("array_contains", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ANY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sort_array", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.ARRAY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("extract_union", CoalesceStructUtility.COALESCE_STRUCT_FUNCTION_RETURN_STRATEGY, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("coalesce_struct", CoalesceStructUtility.COALESCE_STRUCT_FUNCTION_RETURN_STRATEGY, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.bug.DummyUdf", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.ARRAY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction(IS_TEST_MEMBER_ID_CLASS, ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.urnextractor.hive.UrnExtractor", FunctionReturnTypes.ARRAY_OF_STR_STR_MAP, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.ARRAY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udf.aws.ReadJsonUDF", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udf.hdfs.GetDatasetNameFromPathUDF", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.isguestmemberid.hive.IsGuestMemberId", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.watbotcrawlerlookup.hive.WATBotCrawlerLookup", FunctionReturnTypes.rowOf((ImmutableList)ImmutableList.of((Object)"iscrawler", (Object)"crawlerid"), (ImmutableList)ImmutableList.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.VARCHAR)), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd((List<Integer>)ImmutableList.of((Object)2, (Object)3))));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.userinterfacelookup.hive.UserInterfaceLookup", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family(Collections.nCopies(8, SqlTypeFamily.STRING)), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.portallookup.hive.PortalLookup", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.useragentparser.hive.UserAgentParser", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.maplookup.hive.MapLookup", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.monarch.UrnGenerator", FunctionReturnTypes.STRING, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.genericlookup.hive.GenericLookup", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.ANY, SqlTypeFamily.ANY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.UrnToID", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.date.hive.DateFormatToEpoch", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.date.hive.EpochToDateFormat", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.date.hive.EpochToEpochMilliseconds", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.sanitize.hive.Sanitize", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("org.apache.hadoop.hive.ql.udf.generic.GenericProject", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.GetIdFromUrn", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.GetPermissionsString", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.EpochTimeInSeconds", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.EpochTimeInSecondsNullable", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.IsUrnForType", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.PhoneNumberNormalizer", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.job.udf.GetUUID", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.BINARY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetOrderUrn", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetChooserId", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetFamily", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        SqlReturnTypeInference hitInfo = FunctionReturnTypes.rowOfInference((ImmutableList)ImmutableList.of((Object)"secondarysearchresultinfo", (Object)"entityawaresuggestioninfo"), (ImmutableList)ImmutableList.of((Object)FunctionReturnTypes.rowOf((ImmutableList)ImmutableList.of((Object)"vertical"), (ImmutableList)ImmutableList.of((Object)SqlTypeName.VARCHAR)), (Object)FunctionReturnTypes.rowOfInference((ImmutableList)ImmutableList.of((Object)"suggestedentities"), (ImmutableList)ImmutableList.of((Object)FunctionReturnTypes.arrayOfType((SqlTypeName)SqlTypeName.VARCHAR, (boolean)true)))));
        SqlReturnTypeInference gridPositionInfo = FunctionReturnTypes.rowOf((ImmutableList)ImmutableList.of((Object)"row", (Object)"column"), (ImmutableList)ImmutableList.of((Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.CreateSearchActionResultUDF", FunctionReturnTypes.rowOfInference((ImmutableList)ImmutableList.of((Object)"entityurn", (Object)"resulttype", (Object)"absoluteposition", (Object)"positioninvertical", (Object)"iscachehit", (Object)"isanonymized", (Object)"hitinfo", (Object)"gridposition", (Object)"isnamematch", (Object)"trackingid"), (ImmutableList)ImmutableList.of((Object)FunctionReturnTypes.STRING, (Object)FunctionReturnTypes.STRING, (Object)ReturnTypes.INTEGER_NULLABLE, (Object)ReturnTypes.INTEGER_NULLABLE, (Object)ReturnTypes.BOOLEAN, (Object)ReturnTypes.BOOLEAN, (Object)hitInfo, (Object)gridPositionInfo, (Object)ReturnTypes.BOOLEAN, (Object)FunctionReturnTypes.BINARY)), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.GetActionTypeUDF", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING_STRING_STRING, OperandTypes.STRING_STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.GetTYAHResultTypeUDF", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.GetVerticalUDF", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING_STRING_STRING, OperandTypes.STRING_STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.IsTYAHSearchResultsUDF", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.IsValidKeyUDF", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING_STRING_STRING, OperandTypes.STRING_STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.ds.udf.hive.filter.IsTestMemberId", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.ds.udf.hive.lookup.PortalLookup", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.ds.udf.hive.lookup.UserInterfaceLookup", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family(Collections.nCopies(8, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.ds.udf.hive.lookup.WATBotCrawlerLookup", FunctionReturnTypes.rowOf((ImmutableList)ImmutableList.of((Object)"iscrawler", (Object)"crawlerid"), (ImmutableList)ImmutableList.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.VARCHAR)), (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING_STRING_STRING, OperandTypes.STRING_STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dwh.udf.hive.lookup.OsLookup", FunctionReturnTypes.rowOf((ImmutableList)ImmutableList.of((Object)"os_name", (Object)"os_major_version", (Object)"os_full_version"), (ImmutableList)ImmutableList.of((Object)SqlTypeName.VARCHAR, (Object)SqlTypeName.VARCHAR, (Object)SqlTypeName.VARCHAR)), (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING_STRING, OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.ANY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dwh.udf.profile.GetProfileUrl", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dwh.udf.sessionization.CleanupBrowserId", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapSfdcProductName", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapSfdcProductCode", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapSfdcProductId", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("udfs.SeoReferrerTrkUdf", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.vector.daliview.udf.PresentDataType", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.vector.daliview.udf.PresentMediaType", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.vector.daliview.udf.UnifyVideoOrAudioDurationMicroSeconds", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.AdClickClassifier", FunctionReturnTypes.rowOf((ImmutableList)ImmutableList.of((Object)"clicks", (Object)"landingPageClicks", (Object)"totalEngagements", (Object)"otherEngagements", (Object)"likes", (Object)"commentLikes", (Object)"comments", (Object)"shares", (Object)"follows", (Object)"oneClickLeadFormOpens", (Object)"companyPageClicks", (Object)"fullScreenPlays", (Object[])new String[]{"viralClicks", "viralLandingPageClicks", "viralLikes", "viralCommentLikes", "viralComments", "viralShares", "viralFollows", "viralOneClickLeadFormOpens", "viralCompanyPageClicks", "viralFullScreenPlays", "viralTotalEngagements", "viralOtherEngagements", "adUnitClicks", "actionClicks", "textUrlClicks", "opens", "cardClicks", "viralCardClicks", "costInUsd", "costInLocalCurrency"}), (ImmutableList)ImmutableList.of((Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object[])new SqlTypeName[]{SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.DOUBLE, SqlTypeName.DOUBLE})), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.MAP, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.MAP, SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.UnifiedCampaignType", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.ActivityId", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.AdPlacementClassifier", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.SponsoredMessageNodeId", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.orbit.emerger.coercerudfs.DynamicsLineOfBusinessCoercer", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapD365OptionSet", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.DateFormatToEpoch", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.EpochToDateFormat", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.EpochToEpochMilliseconds", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.stringudfs.hive.InitCap", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.IsGuestMemberId", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.MapLookup", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.PortalLookup", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.Sanitize", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.jemslookup.udf.hive.JemsLookup", FunctionReturnTypes.rowOfInference((ImmutableList)ImmutableList.of((Object)"jobproductid", (Object)"jobproductname", (Object)"jobentitlementids", (Object)"jobentitlementnameswithnamespace", (Object)"listingtype", (Object)"sublistingtype", (Object)"istestjob"), (ImmutableList)ImmutableList.of((Object)ReturnTypes.BIGINT, (Object)FunctionReturnTypes.STRING, (Object)FunctionReturnTypes.arrayOfType((SqlTypeName)SqlTypeName.BIGINT, (boolean)true), (Object)FunctionReturnTypes.arrayOfType((SqlTypeName)SqlTypeName.VARCHAR, (boolean)true), (Object)FunctionReturnTypes.STRING, (Object)FunctionReturnTypes.STRING, (Object)ReturnTypes.BOOLEAN)), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.userinterfacelookup.hive.UserInterfaceLookup", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family(Collections.nCopies(8, SqlTypeFamily.STRING)), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.parsing.hive.UserAgentParser", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family(Collections.nCopies(2, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.parsing.hive.Ip2Str", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.lookup.hive.BrowserLookup", FunctionReturnTypes.rowOfInference((ImmutableList)ImmutableList.of((Object)"browser_name", (Object)"browser_major_version", (Object)"browser_full_version"), (ImmutableList)ImmutableList.of((Object)FunctionReturnTypes.STRING, (Object)FunctionReturnTypes.STRING, (Object)FunctionReturnTypes.STRING)), (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.IsTestMemberId", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMemberIdNumeric", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMemberIdNumericInt", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMemberIdNumericLong", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateAll", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateArray", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateArrayEvolve", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateStruct", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMap", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMapEvolve", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMapKeyEvolve", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMapValEvolve", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.jobs.udf.hive.ConvertIndustryCode", FunctionReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.customudf.date.hive.DateFormatToEpoch", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.addFunctionEntry("explode", (SqlOperator)HiveExplodeOperator.EXPLODE);
        StaticHiveFunctionRegistry.addFunctionEntry("posexplode", (SqlOperator)HivePosExplodeOperator.POS_EXPLODE);
        StaticHiveFunctionRegistry.addFunctionEntry("json_tuple", (SqlOperator)HiveJsonTupleOperator.JSON_TUPLE);
        StaticHiveFunctionRegistry.addFunctionEntry("reflect", (SqlOperator)HiveReflectOperator.REFLECT);
        StaticHiveFunctionRegistry.addFunctionEntry("java_method", (SqlOperator)HiveReflectOperator.REFLECT);
        StaticHiveFunctionRegistry.createAddUserDefinedTableFunction("com.linkedin.tsar.hive.udf.ToJymbiiScores", (ImmutableList<String>)ImmutableList.of((Object)"job_urn", (Object)"rank", (Object)"glmix_score", (Object)"global_model_score", (Object)"sentinel_score", (Object)"job_effect_score", (Object)"member_effect_score"), ImmutableList.of((Object)SqlTypeName.VARCHAR, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DOUBLE), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY}));
        StaticHiveFunctionRegistry.addFunctionEntry("current_user", (SqlOperator)SqlStdOperatorTable.CURRENT_USER);
    }
}

