/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.trino.parquet.writer.ColumnChunk;
import io.trino.parquet.writer.ColumnWriter;
import io.trino.parquet.writer.repdef.DefLevelIterable;
import io.trino.parquet.writer.repdef.DefLevelIterables;
import io.trino.parquet.writer.repdef.RepLevelIterable;
import io.trino.parquet.writer.repdef.RepLevelIterables;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class ArrayColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayColumnWriter.class).instanceSize();
    private final ColumnWriter elementWriter;
    private final int maxDefinitionLevel;
    private final int maxRepetitionLevel;

    public ArrayColumnWriter(ColumnWriter elementWriter, int maxDefinitionLevel, int maxRepetitionLevel) {
        this.elementWriter = Objects.requireNonNull(elementWriter, "elementWriter is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
        this.maxRepetitionLevel = maxRepetitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)columnChunk.getBlock());
        this.elementWriter.writeBlock(new ColumnChunk(columnarArray.getElementsBlock(), (List<DefLevelIterable>)ImmutableList.builder().addAll(columnChunk.getDefLevelIterables()).add((Object)DefLevelIterables.of(columnarArray, this.maxDefinitionLevel)).build(), (List<RepLevelIterable>)ImmutableList.builder().addAll(columnChunk.getRepLevelIterables()).add((Object)RepLevelIterables.of(columnarArray, this.maxRepetitionLevel)).build()));
    }

    @Override
    public void close() {
        this.elementWriter.close();
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        return ImmutableList.copyOf(this.elementWriter.getBuffer());
    }

    @Override
    public long getBufferedBytes() {
        return this.elementWriter.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.elementWriter.getRetainedBytes();
    }
}

