/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetSchemaConverter {
    private static final int[] PRECISION_TO_BYTE_COUNT = new int[39];
    public static final boolean HIVE_PARQUET_USE_LEGACY_DECIMAL_ENCODING = true;
    private Map<List<String>, io.trino.spi.type.Type> primitiveTypes = new HashMap<List<String>, io.trino.spi.type.Type>();
    private final boolean useLegacyDecimalEncoding;
    private final MessageType messageType;

    public ParquetSchemaConverter(List<io.trino.spi.type.Type> types, List<String> columnNames, boolean useLegacyDecimalEncoding) {
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Preconditions.checkArgument((types.size() == columnNames.size() ? 1 : 0) != 0, (Object)"types size not equals to columnNames size");
        this.useLegacyDecimalEncoding = useLegacyDecimalEncoding;
        this.messageType = this.convert(types, columnNames);
    }

    private MessageType convert(List<io.trino.spi.type.Type> types, List<String> columnNames) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        for (int i = 0; i < types.size(); ++i) {
            builder.addField(this.convert(types.get(i), columnNames.get(i), (List<String>)ImmutableList.of(), Type.Repetition.OPTIONAL));
        }
        return builder.named("trino_schema");
    }

    private Type convert(io.trino.spi.type.Type type, String name, List<String> parent, Type.Repetition repetition) {
        if ("row".equals(type.getTypeSignature().getBase())) {
            return this.getRowType((RowType)type, name, parent, repetition);
        }
        if ("map".equals(type.getTypeSignature().getBase())) {
            return this.getMapType((MapType)type, name, parent, repetition);
        }
        if ("array".equals(type.getTypeSignature().getBase())) {
            return this.getArrayType((ArrayType)type, name, parent, repetition);
        }
        return this.getPrimitiveType(type, name, parent, repetition);
    }

    private Type getPrimitiveType(io.trino.spi.type.Type type, String name, List<String> parent, Type.Repetition repetition) {
        ImmutableList fullName = ImmutableList.builder().addAll(parent).add((Object)name).build();
        this.primitiveTypes.put((List<String>)fullName, type);
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
        }
        if (IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (!this.useLegacyDecimalEncoding) {
                if (decimalType.getPrecision() <= 9) {
                    return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimalType.getScale(), (int)decimalType.getPrecision()))).named(name);
                }
                if (decimalType.isShort()) {
                    return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimalType.getScale(), (int)decimalType.getPrecision()))).named(name);
                }
            }
            return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(PRECISION_TO_BYTE_COUNT[decimalType.getPrecision()])).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimalType.getScale(), (int)decimalType.getPrecision()))).named(name);
        }
        if (DateType.DATE.equals((Object)type)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE)).named(name);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (timestampType.getPrecision() <= 3) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(name);
            }
            if (timestampType.getPrecision() <= 6) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named(name);
            }
            if (timestampType.getPrecision() <= 9) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS))).named(name);
            }
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
        }
        if (RealType.REAL.equals((Object)type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
        }
        if (type instanceof VarbinaryType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(name);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported primitive type: %s", type));
    }

    private Type getArrayType(ArrayType type, String name, List<String> parent, Type.Repetition repetition) {
        io.trino.spi.type.Type elementType = type.getElementType();
        return (Type)Types.list((Type.Repetition)repetition).element(this.convert(elementType, "array", (List<String>)ImmutableList.builder().addAll(parent).add((Object)name).add((Object)"list").build(), Type.Repetition.OPTIONAL)).named(name);
    }

    private Type getMapType(MapType type, String name, List<String> parent, Type.Repetition repetition) {
        parent = ImmutableList.builder().addAll(parent).add((Object)name).add((Object)"key_value").build();
        io.trino.spi.type.Type keyType = type.getKeyType();
        io.trino.spi.type.Type valueType = type.getValueType();
        return (Type)((Types.MapBuilder)((Types.MapBuilder)Types.map((Type.Repetition)repetition).key(this.convert(keyType, "key", (List<String>)parent, Type.Repetition.REQUIRED))).value(this.convert(valueType, "value", (List<String>)parent, Type.Repetition.OPTIONAL))).named(name);
    }

    private Type getRowType(RowType type, String name, List<String> parent, Type.Repetition repetition) {
        parent = ImmutableList.builder().addAll(parent).add((Object)name).build();
        Types.GroupBuilder builder = Types.buildGroup((Type.Repetition)repetition);
        for (RowType.Field field : type.getFields()) {
            Preconditions.checkArgument((boolean)field.getName().isPresent(), (Object)"field in struct type doesn't have name");
            builder.addField(this.convert(field.getType(), (String)field.getName().get(), (List<String>)parent, Type.Repetition.OPTIONAL));
        }
        return (Type)builder.named(name);
    }

    public Map<List<String>, io.trino.spi.type.Type> getPrimitiveTypes() {
        return this.primitiveTypes;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    static {
        for (int precision = 1; precision <= 38; ++precision) {
            ParquetSchemaConverter.PRECISION_TO_BYTE_COUNT[precision] = (int)Math.ceil((Math.log(Math.pow(10.0, precision) - 1.0) / Math.log(2.0) + 1.0) / 8.0);
        }
    }
}

