/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DoubleType;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class DoubleValueWriter
extends PrimitiveValueWriter {
    private final ValuesWriter valuesWriter;

    public DoubleValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.valuesWriter = Objects.requireNonNull(valuesWriter, "valuesWriter is null");
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            double value = DoubleType.DOUBLE.getDouble(block, i);
            this.valuesWriter.writeDouble(value);
            this.getStatistics().updateStats(value);
        }
    }
}

