/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.acid.AcidSchema;
import io.trino.plugin.hive.orc.OrcDeletedRows;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.RowBlock;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HiveUpdateProcessor {
    private final List<HiveColumnHandle> allDataColumns;
    private final List<HiveColumnHandle> updatedColumns;
    private final Set<String> updatedColumnNames;
    private final List<HiveColumnHandle> nonUpdatedColumns;
    private final Set<String> nonUpdatedColumnNames;

    @JsonCreator
    public HiveUpdateProcessor(@JsonProperty(value="allColumns") List<HiveColumnHandle> allDataColumns, @JsonProperty(value="updatedColumns") List<HiveColumnHandle> updatedColumns) {
        this.allDataColumns = Objects.requireNonNull(allDataColumns, "allDataColumns is null");
        this.updatedColumns = Objects.requireNonNull(updatedColumns, "updatedColumns is null");
        this.updatedColumnNames = (Set)updatedColumns.stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        Set allDataColumnNames = (Set)allDataColumns.stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((boolean)allDataColumnNames.containsAll(this.updatedColumnNames), (Object)"allColumns does not contain all updatedColumns");
        this.nonUpdatedColumns = (List)allDataColumns.stream().filter(column -> !this.updatedColumnNames.contains(column.getName())).collect(ImmutableList.toImmutableList());
        this.nonUpdatedColumnNames = (Set)this.nonUpdatedColumns.stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
    }

    @JsonProperty
    public List<HiveColumnHandle> getAllDataColumns() {
        return this.allDataColumns;
    }

    @JsonProperty
    public List<HiveColumnHandle> getUpdatedColumns() {
        return this.updatedColumns;
    }

    @JsonIgnore
    public List<HiveColumnHandle> getNonUpdatedColumns() {
        return this.nonUpdatedColumns;
    }

    public List<HiveColumnHandle> mergeWithNonUpdatedColumns(List<HiveColumnHandle> updateDependencies) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Set updateDependencyNames = (Set)updateDependencies.stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        for (HiveColumnHandle handle : this.allDataColumns) {
            if (!this.nonUpdatedColumnNames.contains(handle.getName()) && !updateDependencyNames.contains(handle.getName())) continue;
            builder.add((Object)handle);
        }
        builder.add((Object)updateDependencies.get(updateDependencies.size() - 1));
        return builder.build();
    }

    public Block createUpdateRowBlock(Page page, List<Integer> nonUpdatedChannelNumbers, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction) {
        Objects.requireNonNull(page, "page is null");
        Objects.requireNonNull(nonUpdatedChannelNumbers, "nonUpdatedChannelNumbers is null");
        int acidBlocks = 3;
        Preconditions.checkArgument((page.getChannelCount() >= acidBlocks + this.nonUpdatedColumns.size() ? 1 : 0) != 0, (Object)"page doesn't have enough columns");
        Block[] blocks = new Block[acidBlocks + (this.nonUpdatedColumns.isEmpty() ? 0 : 1)];
        blocks[0] = page.getBlock(0);
        blocks[1] = page.getBlock(1);
        blocks[2] = page.getBlock(2);
        if (!this.nonUpdatedColumns.isEmpty()) {
            Block[] nonUpdatedColumnBlocks = new Block[this.getNonUpdatedColumns().size()];
            int offset = 0;
            for (int sourceChannel : nonUpdatedChannelNumbers) {
                nonUpdatedColumnBlocks[offset] = page.getBlock(acidBlocks + sourceChannel);
                ++offset;
            }
            blocks[3] = RowBlock.fromFieldBlocks((int)page.getPositionCount(), Optional.empty(), (Block[])nonUpdatedColumnBlocks);
        }
        return maskDeletedRowsFunction.apply(RowBlock.fromFieldBlocks((int)page.getPositionCount(), Optional.empty(), (Block[])blocks));
    }

    public Page removeNonDependencyColumns(Page page, List<Integer> dependencyChannels) {
        int dependencyCount = dependencyChannels.size();
        Block[] blocks = new Block[dependencyCount + 1];
        int index = 0;
        for (Integer channel : dependencyChannels) {
            blocks[index] = page.getBlock(channel.intValue());
            ++index;
        }
        blocks[dependencyCount] = page.getBlock(page.getChannelCount() - 1);
        return new Page(blocks);
    }

    public static HiveColumnHandle getUpdateRowIdColumnHandle(List<HiveColumnHandle> nonUpdatedColumnHandles) {
        ArrayList<RowType.Field> allAcidFields = new ArrayList<RowType.Field>(AcidSchema.ACID_READ_FIELDS);
        if (!nonUpdatedColumnHandles.isEmpty()) {
            RowType userColumnRowType = RowType.from((List)((List)nonUpdatedColumnHandles.stream().map(column -> RowType.field((String)column.getName(), (Type)column.getType())).collect(ImmutableList.toImmutableList())));
            allAcidFields.add(RowType.field((String)"row", (Type)userColumnRowType));
        }
        RowType acidRowType = RowType.from(allAcidFields);
        return HiveColumnHandle.createBaseColumn("$row_id", -16, HiveType.toHiveType((Type)acidRowType), (Type)acidRowType, HiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty());
    }

    public ColumnarRow getAcidBlock(Page page, List<Integer> columnValueAndRowIdChannels) {
        Block acidBlock = page.getBlock(columnValueAndRowIdChannels.get(columnValueAndRowIdChannels.size() - 1).intValue());
        return ColumnarRow.toColumnarRow((Block)acidBlock);
    }

    public Block createMergedColumnsBlock(Page page, List<Integer> columnValueAndRowIdChannels) {
        ImmutableList nonUpdatedColumnRowBlocks;
        Objects.requireNonNull(page, "page is null");
        ColumnarRow acidBlock = this.getAcidBlock(page, columnValueAndRowIdChannels);
        int fieldCount = acidBlock.getFieldCount();
        if (this.nonUpdatedColumns.isEmpty()) {
            Preconditions.checkArgument((fieldCount == 3 ? 1 : 0) != 0, (String)"The ACID block must contain 3 children, but instead had %s children", (int)fieldCount);
            nonUpdatedColumnRowBlocks = ImmutableList.of();
        } else {
            Preconditions.checkArgument((fieldCount == 4 ? 1 : 0) != 0, (String)"The first RowBlock must contain 4 children, but instead had %s children", (int)fieldCount);
            Block lastAcidBlock = acidBlock.getField(3);
            Preconditions.checkArgument((boolean)(lastAcidBlock instanceof RowBlock), (String)"The last block in the acidBlock must be a RowBlock, but instead was %s", (Object)lastAcidBlock);
            ColumnarRow nonUpdatedColumnRow = ColumnarRow.toColumnarRow((Block)lastAcidBlock);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int field = 0; field < nonUpdatedColumnRow.getFieldCount(); ++field) {
                builder.add((Object)nonUpdatedColumnRow.getField(field));
            }
            nonUpdatedColumnRowBlocks = builder.build();
        }
        Block[] dataColumnBlocks = new Block[this.allDataColumns.size()];
        int targetColumnChannel = 0;
        int nonUpdatedColumnChannel = 0;
        int updatedColumnNumber = 0;
        for (HiveColumnHandle column : this.allDataColumns) {
            Block block;
            if (this.nonUpdatedColumnNames.contains(column.getName())) {
                block = (Block)nonUpdatedColumnRowBlocks.get(nonUpdatedColumnChannel);
                ++nonUpdatedColumnChannel;
            } else {
                int index = columnValueAndRowIdChannels.get(updatedColumnNumber);
                block = page.getBlock(index);
                ++updatedColumnNumber;
            }
            dataColumnBlocks[targetColumnChannel] = block;
            ++targetColumnChannel;
        }
        return RowBlock.fromFieldBlocks((int)page.getPositionCount(), Optional.empty(), (Block[])dataColumnBlocks);
    }

    public List<Integer> makeDependencyChannelNumbers(List<HiveColumnHandle> dependencyColumns) {
        ImmutableList.Builder dependencyIndexBuilder = ImmutableList.builder();
        Set dependencyColumnNames = (Set)dependencyColumns.stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        int dependencyIndex = 0;
        for (HiveColumnHandle handle : this.allDataColumns) {
            if (dependencyColumnNames.contains(handle.getName())) {
                dependencyIndexBuilder.add((Object)dependencyIndex);
                ++dependencyIndex;
                continue;
            }
            if (!this.nonUpdatedColumnNames.contains(handle.getName())) continue;
            ++dependencyIndex;
        }
        return dependencyIndexBuilder.build();
    }

    public List<Integer> makeNonUpdatedSourceChannels(List<HiveColumnHandle> dependencyColumns) {
        ImmutableMap.Builder nonUpdatedNumbersBuilder = ImmutableMap.builder();
        Set dependencyColumnNames = (Set)dependencyColumns.stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        int nonUpdatedIndex = 0;
        for (HiveColumnHandle handle : this.allDataColumns) {
            if (this.nonUpdatedColumnNames.contains(handle.getName())) {
                nonUpdatedNumbersBuilder.put((Object)handle, (Object)nonUpdatedIndex);
                ++nonUpdatedIndex;
                continue;
            }
            if (!dependencyColumnNames.contains(handle.getName())) continue;
            ++nonUpdatedIndex;
        }
        ImmutableMap nonUpdatedMap = nonUpdatedNumbersBuilder.buildOrThrow();
        return (List)this.nonUpdatedColumns.stream().map(((Map)nonUpdatedMap)::get).collect(ImmutableList.toImmutableList());
    }
}

