/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class ThriftMetastoreApiStats {
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat totalFailures = new CounterStat();
    private final CounterStat metastoreExceptions = new CounterStat();
    private final CounterStat thriftExceptions = new CounterStat();

    public <V> Callable<V> wrap(Callable<V> callable) {
        return () -> {
            Object v;
            block11: {
                TimeStat.BlockTimer ignored = this.time.time();
                try {
                    v = callable.call();
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (e instanceof MetaException) {
                            this.metastoreExceptions.update(1L);
                            this.totalFailures.update(1L);
                            throw e;
                        }
                        if (e instanceof TException) {
                            if (e instanceof TBase) {
                                throw e;
                            }
                            this.thriftExceptions.update(1L);
                            this.totalFailures.update(1L);
                            throw e;
                        }
                        this.totalFailures.update(1L);
                        throw e;
                    }
                }
                ignored.close();
            }
            return v;
        };
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getTotalFailures() {
        return this.totalFailures;
    }

    @Managed
    @Nested
    public CounterStat getThriftExceptions() {
        return this.thriftExceptions;
    }

    @Managed
    @Nested
    public CounterStat getMetastoreExceptions() {
        return this.metastoreExceptions;
    }
}

