/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.procedure.Procedures;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.hive.common.FileUtils;

public class UnregisterPartitionProcedure
implements Provider<Procedure> {
    private static final MethodHandle UNREGISTER_PARTITION = MethodHandleUtil.methodHandle(UnregisterPartitionProcedure.class, (String)"unregisterPartition", (Class[])new Class[]{ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, List.class, List.class});
    private final TransactionalMetadataFactory hiveMetadataFactory;

    @Inject
    public UnregisterPartitionProcedure(TransactionalMetadataFactory hiveMetadataFactory) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
    }

    public Procedure get() {
        return new Procedure("system", "unregister_partition", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("PARTITION_COLUMNS", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new Procedure.Argument("PARTITION_VALUES", (Type)new ArrayType((Type)VarcharType.VARCHAR))), UNREGISTER_PARTITION.bindTo(this));
    }

    public void unregisterPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, List<String> partitionColumn, List<String> partitionValues) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doUnregisterPartition(session, accessControl, schemaName, tableName, partitionColumn, partitionValues);
        }
    }

    private void doUnregisterPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, List<String> partitionColumn, List<String> partitionValues) {
        SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
        SemiTransactionalHiveMetastore metastore = this.hiveMetadataFactory.create(session.getIdentity(), true).getMetastore();
        Table table = metastore.getTable(schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        accessControl.checkCanDeleteFromTable(null, schemaTableName);
        Procedures.checkIsPartitionedTable(table);
        Procedures.checkPartitionColumns(table, partitionColumn);
        String partitionName = FileUtils.makePartName(partitionColumn, partitionValues);
        Partition partition = metastore.unsafeGetRawHiveMetastoreClosure().getPartition(schemaName, tableName, partitionValues).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Partition '%s' does not exist", partitionName)));
        metastore.dropPartition(session, table.getDatabaseName(), table.getTableName(), partition.getValues(), false);
        metastore.commit();
    }
}

