/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3Encryption;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.hash.Hashing;
import com.google.common.io.Closer;
import com.google.common.net.MediaType;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.hive.aws.AwsCurrentRegionHolder;
import io.trino.plugin.hive.s3.HiveS3Config;
import io.trino.plugin.hive.s3.TrinoS3AclType;
import io.trino.plugin.hive.s3.TrinoS3FileSystemMetricCollector;
import io.trino.plugin.hive.s3.TrinoS3FileSystemStats;
import io.trino.plugin.hive.s3.TrinoS3Protocol;
import io.trino.plugin.hive.s3.TrinoS3SseType;
import io.trino.plugin.hive.s3.TrinoS3StorageClass;
import io.trino.plugin.hive.util.FSDataInputStreamTail;
import io.trino.plugin.hive.util.RetryDriver;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class TrinoS3FileSystem
extends FileSystem {
    public static final String S3_USER_AGENT_PREFIX = "trino.s3.user-agent-prefix";
    public static final String S3_CREDENTIALS_PROVIDER = "trino.s3.credentials-provider";
    public static final String S3_SSE_TYPE = "trino.s3.sse.type";
    public static final String S3_SSE_ENABLED = "trino.s3.sse.enabled";
    public static final String S3_SSE_KMS_KEY_ID = "trino.s3.sse.kms-key-id";
    public static final String S3_KMS_KEY_ID = "trino.s3.kms-key-id";
    public static final String S3_ENCRYPTION_MATERIALS_PROVIDER = "trino.s3.encryption-materials-provider";
    public static final String S3_PIN_CLIENT_TO_CURRENT_REGION = "trino.s3.pin-client-to-current-region";
    public static final String S3_MULTIPART_MIN_PART_SIZE = "trino.s3.multipart.min-part-size";
    public static final String S3_MULTIPART_MIN_FILE_SIZE = "trino.s3.multipart.min-file-size";
    public static final String S3_STAGING_DIRECTORY = "trino.s3.staging-directory";
    public static final String S3_MAX_CONNECTIONS = "trino.s3.max-connections";
    public static final String S3_SOCKET_TIMEOUT = "trino.s3.socket-timeout";
    public static final String S3_CONNECT_TIMEOUT = "trino.s3.connect-timeout";
    public static final String S3_MAX_RETRY_TIME = "trino.s3.max-retry-time";
    public static final String S3_MAX_BACKOFF_TIME = "trino.s3.max-backoff-time";
    public static final String S3_MAX_CLIENT_RETRIES = "trino.s3.max-client-retries";
    public static final String S3_MAX_ERROR_RETRIES = "trino.s3.max-error-retries";
    public static final String S3_SSL_ENABLED = "trino.s3.ssl.enabled";
    public static final String S3_PATH_STYLE_ACCESS = "trino.s3.path-style-access";
    public static final String S3_SIGNER_TYPE = "trino.s3.signer-type";
    public static final String S3_SIGNER_CLASS = "trino.s3.signer-class";
    public static final String S3_ENDPOINT = "trino.s3.endpoint";
    public static final String S3_SECRET_KEY = "trino.s3.secret-key";
    public static final String S3_ACCESS_KEY = "trino.s3.access-key";
    public static final String S3_SESSION_TOKEN = "trino.s3.session-token";
    public static final String S3_IAM_ROLE = "trino.s3.iam-role";
    public static final String S3_EXTERNAL_ID = "trino.s3.external-id";
    public static final String S3_ACL_TYPE = "trino.s3.upload-acl-type";
    public static final String S3_SKIP_GLACIER_OBJECTS = "trino.s3.skip-glacier-objects";
    public static final String S3_REQUESTER_PAYS_ENABLED = "trino.s3.requester-pays.enabled";
    public static final String S3_STREAMING_UPLOAD_ENABLED = "trino.s3.streaming.enabled";
    public static final String S3_STREAMING_UPLOAD_PART_SIZE = "trino.s3.streaming.part-size";
    public static final String S3_STORAGE_CLASS = "trino.s3.storage-class";
    public static final String S3_ROLE_SESSION_NAME = "trino.s3.role-session-name";
    public static final String S3_PROXY_HOST = "trino.s3.proxy.host";
    public static final String S3_PROXY_PORT = "trino.s3.proxy.port";
    public static final String S3_PROXY_PROTOCOL = "trino.s3.proxy.protocol";
    public static final String S3_NON_PROXY_HOSTS = "trino.s3.proxy.non-proxy-hosts";
    public static final String S3_PROXY_USERNAME = "trino.s3.proxy.username";
    public static final String S3_PROXY_PASSWORD = "trino.s3.proxy.password";
    public static final String S3_PREEMPTIVE_BASIC_PROXY_AUTH = "trino.s3.proxy.preemptive-basic-auth";
    public static final String S3_STS_ENDPOINT = "trino.s3.sts.endpoint";
    public static final String S3_STS_REGION = "trino.s3.sts.region";
    private static final Logger log = Logger.get(TrinoS3FileSystem.class);
    private static final TrinoS3FileSystemStats STATS = new TrinoS3FileSystemStats();
    private static final RequestMetricCollector METRIC_COLLECTOR = new TrinoS3FileSystemMetricCollector(STATS);
    private static final String DIRECTORY_SUFFIX = "_$folder$";
    private static final DataSize BLOCK_SIZE = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize MAX_SKIP_SIZE = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final String PATH_SEPARATOR = "/";
    private static final Duration BACKOFF_MIN_SLEEP = new Duration(1.0, TimeUnit.SECONDS);
    private static final int HTTP_RANGE_NOT_SATISFIABLE = 416;
    private static final String S3_CUSTOM_SIGNER = "TrinoS3CustomSigner";
    private static final Set<String> GLACIER_STORAGE_CLASSES = ImmutableSet.of((Object)StorageClass.Glacier.toString(), (Object)StorageClass.DeepArchive.toString());
    private static final MediaType DIRECTORY_MEDIA_TYPE = MediaType.create((String)"application", (String)"x-directory");
    private static final String S3_DEFAULT_ROLE_SESSION_NAME = "trino-session";
    private URI uri;
    private Path workingDirectory;
    private AmazonS3 s3;
    private AWSCredentialsProvider credentialsProvider;
    private File stagingDirectory;
    private int maxAttempts;
    private Duration maxBackoffTime;
    private Duration maxRetryTime;
    private String iamRole;
    private String externalId;
    private boolean pinS3ClientToCurrentRegion;
    private boolean sseEnabled;
    private TrinoS3SseType sseType;
    private String sseKmsKeyId;
    private boolean isPathStyleAccess;
    private long multiPartUploadMinFileSize;
    private long multiPartUploadMinPartSize;
    private TrinoS3AclType s3AclType;
    private boolean skipGlacierObjects;
    private boolean requesterPaysEnabled;
    private boolean streamingUploadEnabled;
    private int streamingUploadPartSize;
    private TrinoS3StorageClass s3StorageClass;
    private String s3RoleSessionName;
    private final ExecutorService uploadExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"s3-upload-%s"));

    public void initialize(URI uri, Configuration conf) throws IOException {
        Objects.requireNonNull(uri, "uri is null");
        Objects.requireNonNull(conf, "conf is null");
        super.initialize(uri, conf);
        this.setConf(conf);
        try {
            this.uri = new URI(uri.getScheme(), uri.getAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid uri: " + uri, e);
        }
        this.workingDirectory = new Path(PATH_SEPARATOR).makeQualified(this.uri, new Path(PATH_SEPARATOR));
        HiveS3Config defaults = new HiveS3Config();
        this.stagingDirectory = new File(conf.get(S3_STAGING_DIRECTORY, defaults.getS3StagingDirectory().getPath()));
        this.maxAttempts = conf.getInt(S3_MAX_CLIENT_RETRIES, defaults.getS3MaxClientRetries()) + 1;
        this.maxBackoffTime = Duration.valueOf((String)conf.get(S3_MAX_BACKOFF_TIME, defaults.getS3MaxBackoffTime().toString()));
        this.maxRetryTime = Duration.valueOf((String)conf.get(S3_MAX_RETRY_TIME, defaults.getS3MaxRetryTime().toString()));
        int maxErrorRetries = conf.getInt(S3_MAX_ERROR_RETRIES, defaults.getS3MaxErrorRetries());
        boolean sslEnabled = conf.getBoolean(S3_SSL_ENABLED, defaults.isS3SslEnabled());
        Duration connectTimeout = Duration.valueOf((String)conf.get(S3_CONNECT_TIMEOUT, defaults.getS3ConnectTimeout().toString()));
        Duration socketTimeout = Duration.valueOf((String)conf.get(S3_SOCKET_TIMEOUT, defaults.getS3SocketTimeout().toString()));
        int maxConnections = conf.getInt(S3_MAX_CONNECTIONS, defaults.getS3MaxConnections());
        this.multiPartUploadMinFileSize = conf.getLong(S3_MULTIPART_MIN_FILE_SIZE, defaults.getS3MultipartMinFileSize().toBytes());
        this.multiPartUploadMinPartSize = conf.getLong(S3_MULTIPART_MIN_PART_SIZE, defaults.getS3MultipartMinPartSize().toBytes());
        this.isPathStyleAccess = conf.getBoolean(S3_PATH_STYLE_ACCESS, defaults.isS3PathStyleAccess());
        this.iamRole = conf.get(S3_IAM_ROLE, defaults.getS3IamRole());
        this.externalId = conf.get(S3_EXTERNAL_ID, defaults.getS3ExternalId());
        this.pinS3ClientToCurrentRegion = conf.getBoolean(S3_PIN_CLIENT_TO_CURRENT_REGION, defaults.isPinS3ClientToCurrentRegion());
        Verify.verify((!this.pinS3ClientToCurrentRegion || conf.get(S3_ENDPOINT) == null ? 1 : 0) != 0, (String)"Invalid configuration: either endpoint can be set or S3 client can be pinned to the current region", (Object[])new Object[0]);
        this.sseEnabled = conf.getBoolean(S3_SSE_ENABLED, defaults.isS3SseEnabled());
        this.sseType = TrinoS3SseType.valueOf(conf.get(S3_SSE_TYPE, defaults.getS3SseType().name()));
        this.sseKmsKeyId = conf.get(S3_SSE_KMS_KEY_ID, defaults.getS3SseKmsKeyId());
        this.s3AclType = TrinoS3AclType.valueOf(conf.get(S3_ACL_TYPE, defaults.getS3AclType().name()));
        String userAgentPrefix = conf.get(S3_USER_AGENT_PREFIX, defaults.getS3UserAgentPrefix());
        this.skipGlacierObjects = conf.getBoolean(S3_SKIP_GLACIER_OBJECTS, defaults.isSkipGlacierObjects());
        this.requesterPaysEnabled = conf.getBoolean(S3_REQUESTER_PAYS_ENABLED, defaults.isRequesterPaysEnabled());
        this.streamingUploadEnabled = conf.getBoolean(S3_STREAMING_UPLOAD_ENABLED, defaults.isS3StreamingUploadEnabled());
        this.streamingUploadPartSize = Math.toIntExact(conf.getLong(S3_STREAMING_UPLOAD_PART_SIZE, defaults.getS3StreamingPartSize().toBytes()));
        this.s3StorageClass = (TrinoS3StorageClass)conf.getEnum(S3_STORAGE_CLASS, (Enum)defaults.getS3StorageClass());
        this.s3RoleSessionName = conf.get(S3_ROLE_SESSION_NAME, S3_DEFAULT_ROLE_SESSION_NAME);
        ClientConfiguration configuration = new ClientConfiguration().withMaxErrorRetry(maxErrorRetries).withProtocol(sslEnabled ? Protocol.HTTPS : Protocol.HTTP).withConnectionTimeout(Math.toIntExact(connectTimeout.toMillis())).withSocketTimeout(Math.toIntExact(socketTimeout.toMillis())).withMaxConnections(maxConnections).withUserAgentPrefix(userAgentPrefix).withUserAgentSuffix("Trino");
        String proxyHost = conf.get(S3_PROXY_HOST);
        if (Objects.nonNull(proxyHost)) {
            String proxyPassword;
            String proxyUsername;
            String nonProxyHosts;
            configuration.setProxyHost(proxyHost);
            configuration.setProxyPort(conf.getInt(S3_PROXY_PORT, defaults.getS3ProxyPort()));
            String proxyProtocol = conf.get(S3_PROXY_PROTOCOL);
            if (proxyProtocol != null) {
                configuration.setProxyProtocol(TrinoS3Protocol.valueOf(proxyProtocol).getProtocol());
            }
            if ((nonProxyHosts = conf.get(S3_NON_PROXY_HOSTS)) != null) {
                configuration.setNonProxyHosts(nonProxyHosts);
            }
            if ((proxyUsername = conf.get(S3_PROXY_USERNAME)) != null) {
                configuration.setProxyUsername(proxyUsername);
            }
            if ((proxyPassword = conf.get(S3_PROXY_PASSWORD)) != null) {
                configuration.setProxyPassword(proxyPassword);
            }
            configuration.setPreemptiveBasicProxyAuth(Boolean.valueOf(conf.getBoolean(S3_PREEMPTIVE_BASIC_PROXY_AUTH, defaults.getS3PreemptiveBasicProxyAuth())));
        }
        this.credentialsProvider = this.createAwsCredentialsProvider(uri, conf);
        this.s3 = this.createAmazonS3Client(conf, configuration);
    }

    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> super.close());
            if (this.credentialsProvider instanceof Closeable) {
                closer.register((Closeable)this.credentialsProvider);
            }
            closer.register(this.uploadExecutor::shutdown);
            closer.register(() -> ((AmazonS3)this.s3).shutdown());
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path path) {
        this.workingDirectory = path;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        STATS.newListStatusCall();
        ArrayList<LocatedFileStatus> list = new ArrayList<LocatedFileStatus>();
        RemoteIterator<LocatedFileStatus> iterator = this.listLocatedStatus(path);
        while (iterator.hasNext()) {
            list.add((LocatedFileStatus)iterator.next());
        }
        return (FileStatus[])Iterables.toArray(list, LocatedFileStatus.class);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path path, boolean recursive) {
        return new S3ObjectsV2RemoteIterator(this.listPath(path, OptionalInt.empty(), recursive ? ListingMode.RECURSIVE_FILES_ONLY : ListingMode.SHALLOW_FILES_ONLY));
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path path) {
        STATS.newListLocatedStatusCall();
        return new S3ObjectsV2RemoteIterator(this.listPath(path, OptionalInt.empty(), ListingMode.SHALLOW_ALL));
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        if (path.getName().isEmpty()) {
            if (this.getS3ObjectMetadata(path) != null) {
                return new FileStatus(0L, true, 1, 0L, 0L, this.qualifiedPath(path));
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        ObjectMetadata metadata = this.getS3ObjectMetadata(path);
        if (metadata == null) {
            Iterator<LocatedFileStatus> iterator = this.listPath(path, OptionalInt.of(1), ListingMode.SHALLOW_ALL);
            if (iterator.hasNext()) {
                return new FileStatus(0L, true, 1, 0L, 0L, this.qualifiedPath(path));
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        return new FileStatus(this.getObjectSize(path, metadata), MediaType.parse((String)metadata.getContentType()).is(DIRECTORY_MEDIA_TYPE), 1, BLOCK_SIZE.toBytes(), TrinoS3FileSystem.lastModifiedTime(metadata), this.qualifiedPath(path));
    }

    private long getObjectSize(Path path, ObjectMetadata metadata) throws IOException {
        Map userMetadata = metadata.getUserMetadata();
        String length = (String)userMetadata.get("x-amz-unencrypted-content-length");
        if (userMetadata.containsKey("x-amz-server-side-encryption") && length == null) {
            throw new IOException(String.format("%s header is not set on an encrypted object: %s", "x-amz-unencrypted-content-length", path));
        }
        if (length != null) {
            return Long.parseLong(length);
        }
        long reportedObjectSize = metadata.getContentLength();
        if (this.s3 instanceof AmazonS3Encryption && "kms".equalsIgnoreCase((String)userMetadata.get("x-amz-wrap-alg"))) {
            try (FSDataInputStream in = this.open(path, 65);){
                long l = FSDataInputStreamTail.readTailForFileSize(path.toString(), reportedObjectSize, in);
                return l;
            }
        }
        return reportedObjectSize;
    }

    public FSDataInputStream open(Path path, int bufferSize) {
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new TrinoS3InputStream(this.s3, this.getBucketName(this.uri), path, this.requesterPaysEnabled, this.maxAttempts, this.maxBackoffTime, this.maxRetryTime), bufferSize));
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new FSDataOutputStream(this.createOutputStream(path), this.statistics);
    }

    private OutputStream createOutputStream(Path path) throws IOException {
        String bucketName = this.getBucketName(this.uri);
        String key = TrinoS3FileSystem.keyFromPath(this.qualifiedPath(path));
        if (this.streamingUploadEnabled) {
            Supplier<String> uploadIdFactory = () -> this.initMultipartUpload(bucketName, key).getUploadId();
            return new TrinoS3StreamingOutputStream(this.s3, bucketName, key, this::customizePutObjectRequest, uploadIdFactory, this.uploadExecutor, this.streamingUploadPartSize);
        }
        if (!this.stagingDirectory.exists()) {
            Files.createDirectories(this.stagingDirectory.toPath(), new FileAttribute[0]);
        }
        if (!this.stagingDirectory.isDirectory()) {
            throw new IOException("Configured staging path is not a directory: " + this.stagingDirectory);
        }
        File tempFile = Files.createTempFile(this.stagingDirectory.toPath(), "trino-s3-", ".tmp", new FileAttribute[0]).toFile();
        return new TrinoS3StagingOutputStream(this.s3, bucketName, key, tempFile, this::customizePutObjectRequest, this.multiPartUploadMinFileSize, this.multiPartUploadMinPartSize);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("append");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        boolean srcDirectory;
        try {
            srcDirectory = this.directory(src);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            if (!this.directory(dst)) {
                return false;
            }
            dst = new Path(dst, src.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (TrinoS3FileSystem.keysEqual(src, dst)) {
            return false;
        }
        if (srcDirectory) {
            for (FileStatus file : this.listStatus(src)) {
                this.rename(file.getPath(), new Path(dst, file.getPath().getName()));
            }
            this.deleteObject(TrinoS3FileSystem.keyFromPath(src) + DIRECTORY_SUFFIX);
        } else {
            this.s3.copyObject(new CopyObjectRequest(this.getBucketName(this.uri), TrinoS3FileSystem.keyFromPath(src), this.getBucketName(this.uri), TrinoS3FileSystem.keyFromPath(dst)).withRequesterPays(this.requesterPaysEnabled));
            this.delete(src, true);
        }
        return true;
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        try {
            if (!this.directory(path)) {
                return this.deleteObject(TrinoS3FileSystem.keyFromPath(path));
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (!recursive) {
            throw new IOException("Directory " + path + " is not empty");
        }
        for (FileStatus file : this.listStatus(path)) {
            this.delete(file.getPath(), true);
        }
        this.deleteObject(TrinoS3FileSystem.keyFromPath(path) + DIRECTORY_SUFFIX);
        return true;
    }

    private boolean directory(Path path) throws IOException {
        return this.getFileStatus(path).isDirectory();
    }

    private boolean deleteObject(String key) {
        try {
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this.getBucketName(this.uri), key);
            if (this.requesterPaysEnabled) {
                deleteObjectRequest.putCustomRequestHeader("x-amz-request-payer", "requester");
            }
            this.s3.deleteObject(deleteObjectRequest);
            return true;
        }
        catch (AmazonClientException e) {
            return false;
        }
    }

    public boolean mkdirs(Path f, FsPermission permission) {
        return true;
    }

    private Iterator<LocatedFileStatus> listPath(Path path, OptionalInt initialMaxKeys, ListingMode mode) {
        Object key = TrinoS3FileSystem.keyFromPath(path);
        if (!((String)key).isEmpty()) {
            key = (String)key + PATH_SEPARATOR;
        }
        final ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(this.getBucketName(this.uri)).withPrefix((String)key).withDelimiter(mode == ListingMode.RECURSIVE_FILES_ONLY ? null : PATH_SEPARATOR).withMaxKeys(initialMaxKeys.isPresent() ? Integer.valueOf(initialMaxKeys.getAsInt()) : null).withRequesterPays(this.requesterPaysEnabled);
        STATS.newListObjectsCall();
        AbstractSequentialIterator<ListObjectsV2Result> listings = new AbstractSequentialIterator<ListObjectsV2Result>(this.s3.listObjectsV2(request)){

            protected ListObjectsV2Result computeNext(ListObjectsV2Result previous) {
                if (!previous.isTruncated()) {
                    return null;
                }
                request.withMaxKeys(null).setContinuationToken(previous.getNextContinuationToken());
                return TrinoS3FileSystem.this.s3.listObjectsV2(request);
            }
        };
        Iterator results = Iterators.concat((Iterator)Iterators.transform((Iterator)listings, this::statusFromListing));
        if (mode.isFilesOnly()) {
            results = Iterators.filter((Iterator)results, FileStatus::isFile);
        }
        return results;
    }

    private Iterator<LocatedFileStatus> statusFromListing(ListObjectsV2Result listing) {
        List prefixes = listing.getCommonPrefixes();
        List objects = listing.getObjectSummaries();
        if (prefixes.isEmpty()) {
            return this.statusFromObjects(objects);
        }
        if (objects.isEmpty()) {
            return this.statusFromPrefixes(prefixes);
        }
        return Iterators.concat(this.statusFromPrefixes(prefixes), this.statusFromObjects(objects));
    }

    private Iterator<LocatedFileStatus> statusFromPrefixes(List<String> prefixes) {
        ArrayList<LocatedFileStatus> list = new ArrayList<LocatedFileStatus>(prefixes.size());
        for (String prefix : prefixes) {
            Path path = this.qualifiedPath(new Path(PATH_SEPARATOR + prefix));
            FileStatus status = new FileStatus(0L, true, 1, 0L, 0L, path);
            list.add(this.createLocatedFileStatus(status));
        }
        return list.iterator();
    }

    private Iterator<LocatedFileStatus> statusFromObjects(List<S3ObjectSummary> objects) {
        return objects.stream().filter(object -> !object.getKey().endsWith(PATH_SEPARATOR)).filter(object -> !this.skipGlacierObjects || !TrinoS3FileSystem.isGlacierObject(object)).filter(object -> !TrinoS3FileSystem.isHadoopFolderMarker(object)).map(object -> new FileStatus(object.getSize(), false, 1, BLOCK_SIZE.toBytes(), object.getLastModified().getTime(), this.qualifiedPath(new Path(PATH_SEPARATOR + object.getKey())))).map(this::createLocatedFileStatus).iterator();
    }

    private static boolean isGlacierObject(S3ObjectSummary object) {
        return GLACIER_STORAGE_CLASSES.contains(object.getStorageClass());
    }

    private static boolean isHadoopFolderMarker(S3ObjectSummary object) {
        return object.getKey().endsWith(DIRECTORY_SUFFIX);
    }

    @VisibleForTesting
    ObjectMetadata getS3ObjectMetadata(Path path) throws IOException {
        String key;
        String bucketName = this.getBucketName(this.uri);
        ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(path, bucketName, key = TrinoS3FileSystem.keyFromPath(path));
        if (s3ObjectMetadata == null && !key.isEmpty()) {
            return this.getS3ObjectMetadata(path, bucketName, key + PATH_SEPARATOR);
        }
        return s3ObjectMetadata;
    }

    private ObjectMetadata getS3ObjectMetadata(Path path, String bucketName, String key) throws IOException {
        try {
            return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).onRetry(STATS::newGetMetadataRetry).run("getS3ObjectMetadata", () -> {
                try {
                    STATS.newMetadataCall();
                    return this.s3.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key).withRequesterPays(this.requesterPaysEnabled));
                }
                catch (RuntimeException e) {
                    STATS.newGetMetadataError();
                    if (e instanceof AmazonServiceException) {
                        switch (((AmazonServiceException)((Object)((Object)e))).getStatusCode()) {
                            case 400: 
                            case 403: {
                                throw new UnrecoverableS3OperationException(path, (Throwable)e);
                            }
                        }
                    }
                    if (e instanceof AmazonS3Exception && ((AmazonS3Exception)e).getStatusCode() == 404) {
                        return null;
                    }
                    throw e;
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Path qualifiedPath(Path path) {
        return path.makeQualified(this.uri, this.getWorkingDirectory());
    }

    private LocatedFileStatus createLocatedFileStatus(FileStatus status) {
        try {
            BlockLocation[] fakeLocation = this.getFileBlockLocations(status, 0L, status.getLen());
            return new LocatedFileStatus(status, fakeLocation);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static long lastModifiedTime(ObjectMetadata metadata) {
        Date date = metadata.getLastModified();
        return date != null ? date.getTime() : 0L;
    }

    private static boolean keysEqual(Path p1, Path p2) {
        return TrinoS3FileSystem.keyFromPath(p1).equals(TrinoS3FileSystem.keyFromPath(p2));
    }

    public static String keyFromPath(Path path) {
        Preconditions.checkArgument((boolean)path.isAbsolute(), (String)"Path is not absolute: %s", (Object)path);
        String key = Optional.ofNullable(path.toUri().getFragment()).or(() -> Optional.ofNullable(path.toUri().getPath())).orElse("");
        if (key.startsWith(PATH_SEPARATOR)) {
            key = key.substring(PATH_SEPARATOR.length());
        }
        if (key.endsWith(PATH_SEPARATOR)) {
            key = key.substring(0, key.length() - PATH_SEPARATOR.length());
        }
        return key;
    }

    private AmazonS3 createAmazonS3Client(Configuration hadoopConfig, ClientConfiguration clientConfig) {
        String endpoint;
        String signerClass;
        Optional<EncryptionMaterialsProvider> encryptionMaterialsProvider = TrinoS3FileSystem.createEncryptionMaterialsProvider(hadoopConfig);
        String signerType = hadoopConfig.get(S3_SIGNER_TYPE);
        if (signerType != null) {
            clientConfig.withSignerOverride(signerType);
        }
        if ((signerClass = hadoopConfig.get(S3_SIGNER_CLASS)) != null) {
            Class<Signer> klass;
            try {
                klass = Class.forName(signerClass).asSubclass(Signer.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Signer class not found: " + signerClass, e);
            }
            SignerFactory.registerSigner((String)S3_CUSTOM_SIGNER, klass);
            clientConfig.setSignerOverride(S3_CUSTOM_SIGNER);
        }
        AmazonS3Builder clientBuilder = encryptionMaterialsProvider.isPresent() ? (AmazonS3Builder)((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClient.encryptionBuilder().withCredentials(this.credentialsProvider)).withEncryptionMaterials(encryptionMaterialsProvider.get()).withClientConfiguration(clientConfig)).withMetricsCollector(METRIC_COLLECTOR) : (AmazonS3Builder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials(this.credentialsProvider)).withClientConfiguration(clientConfig)).withMetricsCollector(METRIC_COLLECTOR);
        boolean regionOrEndpointSet = false;
        if (this.pinS3ClientToCurrentRegion) {
            clientBuilder.setRegion(AwsCurrentRegionHolder.getCurrentRegionFromEC2Metadata().getName());
            regionOrEndpointSet = true;
        }
        if ((endpoint = hadoopConfig.get(S3_ENDPOINT)) != null) {
            clientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, null));
            regionOrEndpointSet = true;
        }
        if (this.isPathStyleAccess) {
            clientBuilder.enablePathStyleAccess();
        }
        if (!regionOrEndpointSet) {
            clientBuilder.withRegion(Regions.US_EAST_1);
            clientBuilder.setForceGlobalBucketAccessEnabled(Boolean.valueOf(true));
        }
        return (AmazonS3)clientBuilder.build();
    }

    private static Optional<EncryptionMaterialsProvider> createEncryptionMaterialsProvider(Configuration hadoopConfig) {
        String kmsKeyId = hadoopConfig.get(S3_KMS_KEY_ID);
        if (kmsKeyId != null) {
            return Optional.of(new KMSEncryptionMaterialsProvider(kmsKeyId));
        }
        String empClassName = hadoopConfig.get(S3_ENCRYPTION_MATERIALS_PROVIDER);
        if (empClassName == null) {
            return Optional.empty();
        }
        try {
            Object instance = Class.forName(empClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(instance instanceof EncryptionMaterialsProvider)) {
                throw new RuntimeException("Invalid encryption materials provider class: " + instance.getClass().getName());
            }
            EncryptionMaterialsProvider emp = (EncryptionMaterialsProvider)instance;
            if (emp instanceof Configurable) {
                ((Configurable)emp).setConf(hadoopConfig);
            }
            return Optional.of(emp);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load or create S3 encryption materials provider: " + empClassName, e);
        }
    }

    private AWSCredentialsProvider createAwsCredentialsProvider(URI uri, Configuration conf) {
        Optional<AWSCredentials> credentials = TrinoS3FileSystem.getEmbeddedAwsCredentials(uri);
        if (credentials.isPresent()) {
            return new AWSStaticCredentialsProvider(credentials.get());
        }
        String providerClass = conf.get(S3_CREDENTIALS_PROVIDER);
        if (!Strings.isNullOrEmpty((String)providerClass)) {
            return TrinoS3FileSystem.getCustomAWSCredentialsProvider(uri, conf, providerClass);
        }
        AWSCredentialsProvider provider = TrinoS3FileSystem.getAwsCredentials(conf).map(value -> new AWSStaticCredentialsProvider(value)).orElseGet(DefaultAWSCredentialsProviderChain::getInstance);
        if (this.iamRole != null) {
            String region;
            String stsEndpointOverride = conf.get(S3_STS_ENDPOINT);
            String stsRegionOverride = conf.get(S3_STS_REGION);
            AWSSecurityTokenServiceClientBuilder stsClientBuilder = (AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(provider);
            if (!Strings.isNullOrEmpty((String)stsRegionOverride)) {
                region = stsRegionOverride;
            } else {
                DefaultAwsRegionProviderChain regionProviderChain = new DefaultAwsRegionProviderChain();
                try {
                    region = regionProviderChain.getRegion();
                }
                catch (SdkClientException ex) {
                    log.warn("Falling back to default AWS region " + Regions.US_EAST_1);
                    region = Regions.US_EAST_1.getName();
                }
            }
            if (!Strings.isNullOrEmpty((String)stsEndpointOverride)) {
                stsClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(stsEndpointOverride, region));
            } else {
                stsClientBuilder.withRegion(region);
            }
            provider = new STSAssumeRoleSessionCredentialsProvider.Builder(this.iamRole, this.s3RoleSessionName).withExternalId(this.externalId).withStsClient((AWSSecurityTokenService)stsClientBuilder.build()).build();
        }
        return provider;
    }

    private static AWSCredentialsProvider getCustomAWSCredentialsProvider(URI uri, Configuration conf, String providerClass) {
        try {
            log.debug("Using AWS credential provider %s for URI %s", new Object[]{providerClass, uri});
            return conf.getClassByName(providerClass).asSubclass(AWSCredentialsProvider.class).getConstructor(URI.class, Configuration.class).newInstance(uri, conf);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Error creating an instance of %s for URI %s", providerClass, uri), e);
        }
    }

    private static Optional<AWSCredentials> getEmbeddedAwsCredentials(URI uri) {
        String userInfo = Strings.nullToEmpty((String)uri.getUserInfo());
        List parts = Splitter.on((char)':').limit(2).splitToList((CharSequence)userInfo);
        if (parts.size() == 2) {
            String accessKey = (String)parts.get(0);
            String secretKey = (String)parts.get(1);
            if (!accessKey.isEmpty() && !secretKey.isEmpty()) {
                return Optional.of(new BasicAWSCredentials(accessKey, secretKey));
            }
        }
        return Optional.empty();
    }

    private static Optional<AWSCredentials> getAwsCredentials(Configuration conf) {
        String accessKey = conf.get(S3_ACCESS_KEY);
        String secretKey = conf.get(S3_SECRET_KEY);
        if (Strings.isNullOrEmpty((String)accessKey) || Strings.isNullOrEmpty((String)secretKey)) {
            return Optional.empty();
        }
        String sessionToken = conf.get(S3_SESSION_TOKEN);
        if (!Strings.isNullOrEmpty((String)sessionToken)) {
            return Optional.of(new BasicSessionCredentials(accessKey, secretKey, sessionToken));
        }
        return Optional.of(new BasicAWSCredentials(accessKey, secretKey));
    }

    private void customizePutObjectRequest(PutObjectRequest request) {
        if (request.getMetadata() == null) {
            request.setMetadata(new ObjectMetadata());
        }
        if (this.sseEnabled) {
            switch (this.sseType) {
                case KMS: {
                    request.setSSEAwsKeyManagementParams(this.getSseKeyManagementParams());
                    break;
                }
                case S3: {
                    request.getMetadata().setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                }
            }
        }
        request.setCannedAcl(this.s3AclType.getCannedACL());
        request.setRequesterPays(this.requesterPaysEnabled);
        request.setStorageClass(this.s3StorageClass.getS3StorageClass());
    }

    private InitiateMultipartUploadResult initMultipartUpload(String bucket, String key) {
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucket, key).withObjectMetadata(new ObjectMetadata()).withCannedACL(this.s3AclType.getCannedACL()).withRequesterPays(this.requesterPaysEnabled).withStorageClass(this.s3StorageClass.getS3StorageClass());
        if (this.sseEnabled) {
            switch (this.sseType) {
                case KMS: {
                    request.setSSEAwsKeyManagementParams(this.getSseKeyManagementParams());
                    break;
                }
                case S3: {
                    request.getObjectMetadata().setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                }
            }
        }
        return this.s3.initiateMultipartUpload(request);
    }

    private SSEAwsKeyManagementParams getSseKeyManagementParams() {
        return this.sseKmsKeyId != null ? new SSEAwsKeyManagementParams(this.sseKmsKeyId) : new SSEAwsKeyManagementParams();
    }

    @VisibleForTesting
    AmazonS3 getS3Client() {
        return this.s3;
    }

    @VisibleForTesting
    void setS3Client(AmazonS3 client) {
        this.s3 = client;
    }

    @VisibleForTesting
    protected String getBucketName(URI uri) {
        return TrinoS3FileSystem.extractBucketName(uri);
    }

    public static String extractBucketName(URI uri) {
        if (uri.getHost() != null) {
            return uri.getHost();
        }
        if (uri.getUserInfo() == null) {
            return uri.getAuthority();
        }
        throw new IllegalArgumentException("Unable to determine S3 bucket from URI.");
    }

    public static TrinoS3FileSystemStats getFileSystemStats() {
        return STATS;
    }

    private static String getMd5AsBase64(byte[] data, int offset, int length) {
        byte[] md5 = Hashing.md5().hashBytes(data, offset, length).asBytes();
        return Base64.getEncoder().encodeToString(md5);
    }

    private static class TrinoS3StreamingOutputStream
    extends OutputStream {
        private final AmazonS3 s3;
        private final String bucketName;
        private final String key;
        private final Consumer<PutObjectRequest> requestCustomizer;
        private final Supplier<String> uploadIdFactory;
        private final ExecutorService uploadExecutor;
        private int currentPartNumber;
        private byte[] buffer;
        private int bufferSize;
        private boolean closed;
        private boolean failed;
        private boolean multipartUploadStarted;
        private Optional<String> uploadId = Optional.empty();
        private Future<UploadPartResult> inProgressUploadFuture;
        private final List<UploadPartResult> parts = new ArrayList<UploadPartResult>();

        public TrinoS3StreamingOutputStream(AmazonS3 s3, String bucketName, String key, Consumer<PutObjectRequest> requestCustomizer, Supplier<String> uploadIdFactory, ExecutorService uploadExecutor, int partSize) {
            STATS.uploadStarted();
            this.s3 = Objects.requireNonNull(s3, "s3 is null");
            this.buffer = new byte[partSize];
            this.bucketName = Objects.requireNonNull(bucketName, "bucketName is null");
            this.key = Objects.requireNonNull(key, "key is null");
            this.requestCustomizer = Objects.requireNonNull(requestCustomizer, "requestCustomizer is null");
            this.uploadIdFactory = Objects.requireNonNull(uploadIdFactory, "uploadIdFactory is null");
            this.uploadExecutor = Objects.requireNonNull(uploadExecutor, "uploadExecutor is null");
        }

        @Override
        public void write(int b) throws IOException {
            this.flushBuffer(false);
            this.buffer[this.bufferSize] = (byte)b;
            ++this.bufferSize;
        }

        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            while (length > 0) {
                int copied = Math.min(this.buffer.length - this.bufferSize, length);
                System.arraycopy(bytes, offset, this.buffer, this.bufferSize, copied);
                this.bufferSize += copied;
                this.flushBuffer(false);
                offset += copied;
                length -= copied;
            }
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffer(false);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.failed) {
                try {
                    this.abortUpload();
                    return;
                }
                catch (RuntimeException e) {
                    throw new IOException(e);
                }
            }
            try {
                this.flushBuffer(true);
                this.waitForPreviousUploadFinish();
            }
            catch (IOException | RuntimeException e) {
                this.abortUploadSuppressed(e);
                throw e;
            }
            try {
                this.uploadId.ifPresent(this::finishUpload);
            }
            catch (RuntimeException e) {
                this.abortUploadSuppressed(e);
                throw new IOException(e);
            }
        }

        private void flushBuffer(boolean finished) throws IOException {
            if (finished && !this.multipartUploadStarted) {
                ByteArrayInputStream in = new ByteArrayInputStream(this.buffer, 0, this.bufferSize);
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength((long)this.bufferSize);
                metadata.setContentMD5(TrinoS3FileSystem.getMd5AsBase64(this.buffer, 0, this.bufferSize));
                PutObjectRequest request = new PutObjectRequest(this.bucketName, this.key, (InputStream)in, metadata);
                this.requestCustomizer.accept(request);
                try {
                    this.s3.putObject(request);
                    return;
                }
                catch (AmazonServiceException e) {
                    this.failed = true;
                    throw new IOException(e);
                }
            }
            if (this.bufferSize == this.buffer.length || finished && this.bufferSize > 0) {
                byte[] data = this.buffer;
                int length = this.bufferSize;
                if (finished) {
                    this.buffer = null;
                } else {
                    this.buffer = new byte[this.buffer.length];
                    this.bufferSize = 0;
                }
                try {
                    this.waitForPreviousUploadFinish();
                }
                catch (IOException e) {
                    this.failed = true;
                    this.abortUploadSuppressed(e);
                    throw e;
                }
                this.multipartUploadStarted = true;
                this.inProgressUploadFuture = this.uploadExecutor.submit(() -> this.uploadPage(data, length));
            }
        }

        private void waitForPreviousUploadFinish() throws IOException {
            if (this.inProgressUploadFuture == null) {
                return;
            }
            try {
                this.inProgressUploadFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
            catch (ExecutionException e) {
                throw new IOException("Streaming upload failed", e);
            }
        }

        private UploadPartResult uploadPage(byte[] data, int length) {
            if (this.uploadId.isEmpty()) {
                this.uploadId = Optional.of(this.uploadIdFactory.get());
            }
            ++this.currentPartNumber;
            UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId.get()).withPartNumber(this.currentPartNumber).withInputStream((InputStream)new ByteArrayInputStream(data, 0, length)).withPartSize((long)length).withMD5Digest(TrinoS3FileSystem.getMd5AsBase64(data, 0, length));
            UploadPartResult partResult = this.s3.uploadPart(uploadRequest);
            this.parts.add(partResult);
            return partResult;
        }

        private void finishUpload(String uploadId) {
            List etags = this.parts.stream().map(UploadPartResult::getPartETag).collect(Collectors.toList());
            this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, this.key, uploadId, etags));
            STATS.uploadSuccessful();
        }

        private void abortUpload() {
            STATS.uploadFailed();
            this.uploadId.ifPresent(id -> this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, this.key, id)));
        }

        private void abortUploadSuppressed(Throwable throwable) {
            block2: {
                try {
                    this.abortUpload();
                }
                catch (Throwable t) {
                    if (throwable == t) break block2;
                    throwable.addSuppressed(t);
                }
            }
        }
    }

    private static class TrinoS3StagingOutputStream
    extends FilterOutputStream {
        private final TransferManager transferManager;
        private final String bucket;
        private final String key;
        private final File tempFile;
        private final Consumer<PutObjectRequest> requestCustomizer;
        private boolean closed;

        public TrinoS3StagingOutputStream(AmazonS3 s3, String bucket, String key, File tempFile, Consumer<PutObjectRequest> requestCustomizer, long multiPartUploadMinFileSize, long multiPartUploadMinPartSize) throws IOException {
            super(new BufferedOutputStream(new FileOutputStream(Objects.requireNonNull(tempFile, "tempFile is null"))));
            this.transferManager = TransferManagerBuilder.standard().withS3Client(Objects.requireNonNull(s3, "s3 is null")).withMinimumUploadPartSize(Long.valueOf(multiPartUploadMinPartSize)).withMultipartUploadThreshold(Long.valueOf(multiPartUploadMinFileSize)).build();
            this.bucket = Objects.requireNonNull(bucket, "bucket is null");
            this.key = Objects.requireNonNull(key, "key is null");
            this.tempFile = tempFile;
            this.requestCustomizer = Objects.requireNonNull(requestCustomizer, "requestCustomizer is null");
            log.debug("OutputStream for key '%s' using file: %s", new Object[]{key, tempFile});
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            block4: {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    super.close();
                    this.uploadObject();
                    if (this.tempFile.delete()) break block4;
                }
                catch (Throwable throwable) {
                    if (!this.tempFile.delete()) {
                        log.warn("Could not delete temporary file: %s", new Object[]{this.tempFile});
                    }
                    this.transferManager.shutdownNow(false);
                    throw throwable;
                }
                log.warn("Could not delete temporary file: %s", new Object[]{this.tempFile});
            }
            this.transferManager.shutdownNow(false);
        }

        private void uploadObject() throws IOException {
            try {
                log.debug("Starting upload for bucket: %s, key: %s, file: %s, size: %s", new Object[]{this.bucket, this.key, this.tempFile, this.tempFile.length()});
                STATS.uploadStarted();
                PutObjectRequest request = new PutObjectRequest(this.bucket, this.key, this.tempFile);
                this.requestCustomizer.accept(request);
                Upload upload = this.transferManager.upload(request);
                if (log.isDebugEnabled()) {
                    upload.addProgressListener(this.createProgressListener((Transfer)upload));
                }
                upload.waitForCompletion();
                STATS.uploadSuccessful();
                log.debug("Completed upload for bucket: %s, key: %s", new Object[]{this.bucket, this.key});
            }
            catch (AmazonClientException e) {
                STATS.uploadFailed();
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                STATS.uploadFailed();
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }

        private ProgressListener createProgressListener(final Transfer transfer) {
            return new ProgressListener(){
                private ProgressEventType previousType;
                private double previousTransferred;

                public synchronized void progressChanged(ProgressEvent progressEvent) {
                    double transferred;
                    ProgressEventType eventType = progressEvent.getEventType();
                    if (this.previousType != eventType) {
                        log.debug("Upload progress event (%s/%s): %s", new Object[]{bucket, key, eventType});
                        this.previousType = eventType;
                    }
                    if ((transferred = transfer.getProgress().getPercentTransferred()) >= this.previousTransferred + 10.0) {
                        log.debug("Upload percentage (%s/%s): %.0f%%", new Object[]{bucket, key, transferred});
                        this.previousTransferred = transferred;
                    }
                }
            };
        }
    }

    private static class TrinoS3InputStream
    extends FSInputStream {
        private final AmazonS3 s3;
        private final String bucket;
        private final Path path;
        private final boolean requesterPaysEnabled;
        private final int maxAttempts;
        private final Duration maxBackoffTime;
        private final Duration maxRetryTime;
        private final AtomicBoolean closed = new AtomicBoolean();
        private InputStream in;
        private long streamPosition;
        private long nextReadPosition;

        public TrinoS3InputStream(AmazonS3 s3, String bucket, Path path, boolean requesterPaysEnabled, int maxAttempts, Duration maxBackoffTime, Duration maxRetryTime) {
            this.s3 = Objects.requireNonNull(s3, "s3 is null");
            this.bucket = Objects.requireNonNull(bucket, "bucket is null");
            this.path = Objects.requireNonNull(path, "path is null");
            this.requesterPaysEnabled = requesterPaysEnabled;
            Preconditions.checkArgument((maxAttempts >= 0 ? 1 : 0) != 0, (Object)"maxAttempts cannot be negative");
            this.maxAttempts = maxAttempts;
            this.maxBackoffTime = Objects.requireNonNull(maxBackoffTime, "maxBackoffTime is null");
            this.maxRetryTime = Objects.requireNonNull(maxRetryTime, "maxRetryTime is null");
        }

        public void close() {
            this.closed.set(true);
            this.closeStream();
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            this.checkClosed();
            if (position < 0L) {
                throw new EOFException("Cannot seek to a negative offset");
            }
            Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)buffer.length);
            if (length == 0) {
                return 0;
            }
            try {
                return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class, EOFException.class).onRetry(STATS::newGetObjectRetry).run("getS3Object", () -> {
                    S3ObjectInputStream stream;
                    try {
                        GetObjectRequest request = new GetObjectRequest(this.bucket, TrinoS3FileSystem.keyFromPath(this.path)).withRange(position, position + (long)length - 1L).withRequesterPays(this.requesterPaysEnabled);
                        stream = this.s3.getObject(request).getObjectContent();
                    }
                    catch (RuntimeException e) {
                        STATS.newGetObjectError();
                        if (e instanceof AmazonServiceException) {
                            switch (((AmazonServiceException)((Object)((Object)e))).getStatusCode()) {
                                case 400: 
                                case 403: {
                                    throw new UnrecoverableS3OperationException(this.path, (Throwable)e);
                                }
                            }
                        }
                        if (e instanceof AmazonS3Exception) {
                            switch (((AmazonS3Exception)e).getStatusCode()) {
                                case 416: {
                                    throw new EOFException("Attempted to seek or read past the end of the file");
                                }
                                case 404: {
                                    throw new UnrecoverableS3OperationException(this.path, (Throwable)e);
                                }
                            }
                        }
                        throw e;
                    }
                    STATS.connectionOpened();
                    try {
                        int read;
                        int n;
                        for (read = 0; read < length; read += n) {
                            n = stream.read(buffer, offset + read, length - read);
                            if (n > 0) continue;
                            if (read > 0) {
                                Integer n2 = read;
                                return n2;
                            }
                            Integer n3 = -1;
                            return n3;
                        }
                        Integer n4 = read;
                        return n4;
                    }
                    catch (Throwable t) {
                        STATS.newReadError(t);
                        TrinoS3InputStream.abortStream((InputStream)stream);
                        throw t;
                    }
                    finally {
                        STATS.connectionReleased();
                        stream.close();
                    }
                });
            }
            catch (Exception e) {
                throw TrinoS3InputStream.propagate(e);
            }
        }

        public void seek(long pos) throws IOException {
            this.checkClosed();
            if (pos < 0L) {
                throw new EOFException("Cannot seek to a negative offset");
            }
            this.nextReadPosition = pos;
        }

        public long getPos() {
            return this.nextReadPosition;
        }

        public int read() {
            throw new UnsupportedOperationException();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            this.checkClosed();
            try {
                int bytesRead = RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class, AbortedException.class).onRetry(STATS::newReadRetry).run("readStream", () -> {
                    this.seekStream();
                    try {
                        return this.in.read(buffer, offset, length);
                    }
                    catch (Exception e) {
                        STATS.newReadError(e);
                        this.closeStream();
                        throw e;
                    }
                });
                if (bytesRead != -1) {
                    this.streamPosition += (long)bytesRead;
                    this.nextReadPosition += (long)bytesRead;
                }
                return bytesRead;
            }
            catch (Exception e) {
                throw TrinoS3InputStream.propagate(e);
            }
        }

        public boolean seekToNewSource(long targetPos) {
            return false;
        }

        private void seekStream() throws IOException {
            long skip;
            if (this.in != null && this.nextReadPosition == this.streamPosition) {
                return;
            }
            if (this.in != null && this.nextReadPosition > this.streamPosition && (skip = this.nextReadPosition - this.streamPosition) <= Math.max((long)this.in.available(), MAX_SKIP_SIZE.toBytes())) {
                try {
                    if (this.in.skip(skip) == skip) {
                        this.streamPosition = this.nextReadPosition;
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.streamPosition = this.nextReadPosition;
            this.closeStream();
            this.openStream();
        }

        private void openStream() throws IOException {
            if (this.in == null) {
                this.in = this.openStream(this.path, this.nextReadPosition);
                this.streamPosition = this.nextReadPosition;
                STATS.connectionOpened();
            }
        }

        private InputStream openStream(Path path, long start) throws IOException {
            try {
                return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).onRetry(STATS::newGetObjectRetry).run("getS3Object", () -> {
                    try {
                        GetObjectRequest request = new GetObjectRequest(this.bucket, TrinoS3FileSystem.keyFromPath(path)).withRange(start).withRequesterPays(this.requesterPaysEnabled);
                        return this.s3.getObject(request).getObjectContent();
                    }
                    catch (RuntimeException e) {
                        STATS.newGetObjectError();
                        if (e instanceof AmazonServiceException) {
                            switch (((AmazonServiceException)((Object)((Object)e))).getStatusCode()) {
                                case 400: 
                                case 403: {
                                    throw new UnrecoverableS3OperationException(path, (Throwable)e);
                                }
                            }
                        }
                        if (e instanceof AmazonS3Exception) {
                            switch (((AmazonS3Exception)e).getStatusCode()) {
                                case 416: {
                                    return new ByteArrayInputStream(new byte[0]);
                                }
                                case 404: {
                                    throw new UnrecoverableS3OperationException(path, (Throwable)e);
                                }
                            }
                        }
                        throw e;
                    }
                });
            }
            catch (Exception e) {
                throw TrinoS3InputStream.propagate(e);
            }
        }

        private void closeStream() {
            if (this.in != null) {
                TrinoS3InputStream.abortStream(this.in);
                this.in = null;
                STATS.connectionReleased();
            }
        }

        private void checkClosed() throws IOException {
            if (this.closed.get()) {
                throw new IOException("Stream is closed!");
            }
        }

        private static void abortStream(InputStream in) {
            try {
                if (in instanceof S3ObjectInputStream) {
                    ((S3ObjectInputStream)in).abort();
                } else {
                    in.close();
                }
            }
            catch (AbortedException | IOException throwable) {
                // empty catch block
            }
        }

        private static RuntimeException propagate(Exception e) throws IOException {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IOException(e);
        }
    }

    public static class UnrecoverableS3OperationException
    extends IOException {
        public UnrecoverableS3OperationException(Path path, Throwable cause) {
            super(String.format("%s (Path: %s)", cause, path), cause);
        }
    }

    private static enum ListingMode {
        SHALLOW_ALL,
        SHALLOW_FILES_ONLY,
        RECURSIVE_FILES_ONLY;


        public boolean isFilesOnly() {
            return this == SHALLOW_FILES_ONLY || this == RECURSIVE_FILES_ONLY;
        }
    }

    private static final class S3ObjectsV2RemoteIterator
    implements RemoteIterator<LocatedFileStatus> {
        private final Iterator<LocatedFileStatus> iterator;

        public S3ObjectsV2RemoteIterator(Iterator<LocatedFileStatus> iterator) {
            this.iterator = Objects.requireNonNull(iterator, "iterator is null");
        }

        public boolean hasNext() throws IOException {
            try {
                return this.iterator.hasNext();
            }
            catch (AmazonClientException e) {
                throw new IOException(e);
            }
        }

        public LocatedFileStatus next() throws IOException {
            try {
                return this.iterator.next();
            }
            catch (AmazonClientException e) {
                throw new IOException(e);
            }
        }
    }
}

