/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.aws.AwsCurrentRegionHolder;
import io.trino.plugin.hive.s3.HiveS3Config;
import io.trino.plugin.hive.s3.TrinoS3FileSystem;
import io.trino.plugin.hive.s3.TrinoS3FileSystemMetricCollector;
import java.net.URI;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class TrinoS3ClientFactory {
    private static final String S3_SELECT_PUSHDOWN_MAX_CONNECTIONS = "hive.s3select-pushdown.max-connections";
    private final boolean enabled;
    private final int defaultMaxConnections;
    @GuardedBy(value="this")
    private AmazonS3 s3Client;

    @Inject
    public TrinoS3ClientFactory(HiveConfig config) {
        this.enabled = config.isS3SelectPushdownEnabled();
        this.defaultMaxConnections = config.getS3SelectPushdownMaxConnections();
    }

    synchronized AmazonS3 getS3Client(Configuration config) {
        if (this.s3Client == null) {
            this.s3Client = this.createS3Client(config);
        }
        return this.s3Client;
    }

    private AmazonS3 createS3Client(Configuration config) {
        HiveS3Config defaults = new HiveS3Config();
        String userAgentPrefix = config.get("trino.s3.user-agent-prefix", defaults.getS3UserAgentPrefix());
        int maxErrorRetries = config.getInt("trino.s3.max-error-retries", defaults.getS3MaxErrorRetries());
        boolean sslEnabled = config.getBoolean("trino.s3.ssl.enabled", defaults.isS3SslEnabled());
        Duration connectTimeout = Duration.valueOf((String)config.get("trino.s3.connect-timeout", defaults.getS3ConnectTimeout().toString()));
        Duration socketTimeout = Duration.valueOf((String)config.get("trino.s3.socket-timeout", defaults.getS3SocketTimeout().toString()));
        int maxConnections = config.getInt(S3_SELECT_PUSHDOWN_MAX_CONNECTIONS, this.defaultMaxConnections);
        ClientConfiguration clientConfiguration = new ClientConfiguration().withMaxErrorRetry(maxErrorRetries).withProtocol(sslEnabled ? Protocol.HTTPS : Protocol.HTTP).withConnectionTimeout(Math.toIntExact(connectTimeout.toMillis())).withSocketTimeout(Math.toIntExact(socketTimeout.toMillis())).withMaxConnections(maxConnections).withUserAgentPrefix(userAgentPrefix).withUserAgentSuffix(this.enabled ? "Trino-select" : "Trino");
        AWSCredentialsProvider awsCredentialsProvider = TrinoS3ClientFactory.getAwsCredentialsProvider(config);
        AmazonS3Builder clientBuilder = ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials(awsCredentialsProvider)).withClientConfiguration(clientConfiguration)).withMetricsCollector((RequestMetricCollector)new TrinoS3FileSystemMetricCollector(TrinoS3FileSystem.getFileSystemStats()))).enablePathStyleAccess();
        boolean regionOrEndpointSet = false;
        String endpoint = config.get("trino.s3.endpoint");
        boolean pinS3ClientToCurrentRegion = config.getBoolean("trino.s3.pin-client-to-current-region", defaults.isPinS3ClientToCurrentRegion());
        Verify.verify((!pinS3ClientToCurrentRegion || endpoint == null ? 1 : 0) != 0, (String)"Invalid configuration: either endpoint can be set or S3 client can be pinned to the current region", (Object[])new Object[0]);
        if (pinS3ClientToCurrentRegion) {
            clientBuilder.setRegion(AwsCurrentRegionHolder.getCurrentRegionFromEC2Metadata().getName());
            regionOrEndpointSet = true;
        }
        if (!Strings.isNullOrEmpty((String)endpoint)) {
            clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, null));
            regionOrEndpointSet = true;
        }
        if (!regionOrEndpointSet) {
            clientBuilder.withRegion(Regions.US_EAST_1);
            clientBuilder.setForceGlobalBucketAccessEnabled(Boolean.valueOf(true));
        }
        return (AmazonS3)clientBuilder.build();
    }

    private static AWSCredentialsProvider getAwsCredentialsProvider(Configuration conf) {
        Optional<AWSCredentials> credentials = TrinoS3ClientFactory.getAwsCredentials(conf);
        if (credentials.isPresent()) {
            return new AWSStaticCredentialsProvider(credentials.get());
        }
        String providerClass = conf.get("trino.s3.credentials-provider");
        if (!Strings.isNullOrEmpty((String)providerClass)) {
            return TrinoS3ClientFactory.getCustomAWSCredentialsProvider(conf, providerClass);
        }
        return DefaultAWSCredentialsProviderChain.getInstance();
    }

    private static AWSCredentialsProvider getCustomAWSCredentialsProvider(Configuration conf, String providerClass) {
        try {
            return conf.getClassByName(providerClass).asSubclass(AWSCredentialsProvider.class).getConstructor(URI.class, Configuration.class).newInstance(null, conf);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Error creating an instance of %s", providerClass), e);
        }
    }

    private static Optional<AWSCredentials> getAwsCredentials(Configuration conf) {
        String accessKey = conf.get("trino.s3.access-key");
        String secretKey = conf.get("trino.s3.secret-key");
        if (Strings.isNullOrEmpty((String)accessKey) || Strings.isNullOrEmpty((String)secretKey)) {
            return Optional.empty();
        }
        return Optional.of(new BasicAWSCredentials(accessKey, secretKey));
    }
}

