/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.com.google.common.collect;

import coral.shading.com.google.common.annotations.GwtCompatible;
import coral.shading.com.google.common.collect.Ordering;
import coral.shading.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.Serializable;

@GwtCompatible(serializable=true)
final class NullsLastOrdering<T>
extends Ordering<T>
implements Serializable {
    final Ordering<? super T> ordering;
    private static final long serialVersionUID = 0L;

    NullsLastOrdering(Ordering<? super T> ordering) {
        this.ordering = ordering;
    }

    @Override
    public int compare(@Nullable T left, @Nullable T right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        return this.ordering.compare(left, right);
    }

    @Override
    public <S extends T> Ordering<S> reverse() {
        return this.ordering.reverse().nullsFirst();
    }

    @Override
    public <S extends T> Ordering<S> nullsFirst() {
        return this.ordering.nullsFirst();
    }

    @Override
    public <S extends T> Ordering<S> nullsLast() {
        return this;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NullsLastOrdering) {
            NullsLastOrdering that = (NullsLastOrdering)object;
            return this.ordering.equals(that.ordering);
        }
        return false;
    }

    public int hashCode() {
        return this.ordering.hashCode() ^ 0xC9177248;
    }

    public String toString() {
        String string = String.valueOf(this.ordering);
        return new StringBuilder(12 + String.valueOf(string).length()).append(string).append(".nullsLast()").toString();
    }
}

