/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Identifier;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.Window;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WindowReference
extends Node
implements Window {
    private final Identifier name;

    public WindowReference(Identifier name) {
        this(Optional.empty(), name);
    }

    public WindowReference(NodeLocation location, Identifier name) {
        this(Optional.of(location), name);
    }

    private WindowReference(Optional<NodeLocation> location, Identifier name) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Identifier getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowReference(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowReference o = (WindowReference)obj;
        return Objects.equals(this.name, o.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return WindowReference.sameClass(this, other);
    }
}

