/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.Identifier;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.OrderBy;
import coral.shading.io.trino.sql.tree.Window;
import coral.shading.io.trino.sql.tree.WindowFrame;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WindowSpecification
extends Node
implements Window {
    private final Optional<Identifier> existingWindowName;
    private final List<Expression> partitionBy;
    private final Optional<OrderBy> orderBy;
    private final Optional<WindowFrame> frame;

    public WindowSpecification(Optional<Identifier> existingWindowName, List<Expression> partitionBy, Optional<OrderBy> orderBy, Optional<WindowFrame> frame) {
        this(Optional.empty(), existingWindowName, partitionBy, orderBy, frame);
    }

    public WindowSpecification(NodeLocation location, Optional<Identifier> existingWindowName, List<Expression> partitionBy, Optional<OrderBy> orderBy, Optional<WindowFrame> frame) {
        this(Optional.of(location), existingWindowName, partitionBy, orderBy, frame);
    }

    private WindowSpecification(Optional<NodeLocation> location, Optional<Identifier> existingWindowName, List<Expression> partitionBy, Optional<OrderBy> orderBy, Optional<WindowFrame> frame) {
        super(location);
        this.existingWindowName = Objects.requireNonNull(existingWindowName, "existingWindowName is null");
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.frame = Objects.requireNonNull(frame, "frame is null");
    }

    public Optional<Identifier> getExistingWindowName() {
        return this.existingWindowName;
    }

    public List<Expression> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<WindowFrame> getFrame() {
        return this.frame;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowSpecification(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.existingWindowName.ifPresent(nodes::add);
        nodes.addAll(this.partitionBy);
        this.orderBy.ifPresent(nodes::add);
        this.frame.ifPresent(nodes::add);
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowSpecification o = (WindowSpecification)obj;
        return Objects.equals(this.existingWindowName, o.existingWindowName) && Objects.equals(this.partitionBy, o.partitionBy) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.frame, o.frame);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.existingWindowName, this.partitionBy, this.orderBy, this.frame);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("existingWindowName", this.existingWindowName).add("partitionBy", this.partitionBy).add("orderBy", this.orderBy).add("frame", this.frame).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return WindowSpecification.sameClass(this, other);
    }
}

