/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunctionalOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Static;

public class HiveJsonTupleOperator
extends SqlFunctionalOperator {
    public static final HiveJsonTupleOperator JSON_TUPLE = new HiveJsonTupleOperator();

    public HiveJsonTupleOperator() {
        super("json_tuple", SqlKind.OTHER_FUNCTION, 200, true, null, null, null);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from((int)2);
    }

    protected void checkOperandCount(SqlValidator validator, SqlOperandTypeChecker argType, SqlCall call) {
        if (call.operandCount() < 2) {
            throw validator.newValidationError((SqlNode)call, Static.RESOURCE.wrongNumOfArguments());
        }
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        for (int operand = 0; operand < callBinding.getOperandCount(); ++operand) {
            RelDataType operandType = callBinding.getOperandType(operand);
            if (operandType.getSqlTypeName().equals((Object)SqlTypeName.VARCHAR)) continue;
            return false;
        }
        return true;
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory.FieldInfoBuilder builder = opBinding.getTypeFactory().builder();
        for (int i = 0; i < opBinding.getOperandCount() - 1; ++i) {
            builder.add("c" + i, SqlTypeName.VARCHAR);
        }
        return builder.build();
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        super.unparse(writer, call, leftPrec, rightPrec);
    }

    public boolean isDeterministic() {
        return true;
    }
}

