/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;

public interface HiveMetastoreFactory {
    public boolean isImpersonationEnabled();

    public HiveMetastore createMetastore(Optional<ConnectorIdentity> var1);

    public static HiveMetastoreFactory ofInstance(HiveMetastore metastore) {
        return new StaticHiveMetastoreFactory(metastore);
    }

    public static class StaticHiveMetastoreFactory
    implements HiveMetastoreFactory {
        private final HiveMetastore metastore;

        private StaticHiveMetastoreFactory(HiveMetastore metastore) {
            this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        }

        @Override
        public boolean isImpersonationEnabled() {
            return false;
        }

        @Override
        public HiveMetastore createMetastore(Optional<ConnectorIdentity> identity) {
            return this.metastore;
        }
    }
}

