/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.FormatMethod;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveUpdateProcessor;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.PartitionAndStatementId;
import io.trino.plugin.hive.PartitionNotFoundException;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.TableInvalidationCallback;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.AcidTransactionOwner;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HivePageSinkMetadata;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.HiveTransaction;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetadataMetastore;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.plugin.hive.util.RetryDriver;
import io.trino.plugin.hive.util.Statistics;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class SemiTransactionalHiveMetastore
implements SqlStandardAccessControlMetadataMetastore {
    private static final Logger log = Logger.get(SemiTransactionalHiveMetastore.class);
    private static final int PARTITION_COMMIT_BATCH_SIZE = 8;
    private static final Pattern DELTA_DIRECTORY_MATCHER = Pattern.compile("(delete_)?delta_[\\d]+_[\\d]+_[\\d]+$");
    private static final RetryDriver DELETE_RETRY = RetryDriver.retry().maxAttempts(3).exponentialBackoff(new Duration(1.0, TimeUnit.SECONDS), new Duration(1.0, TimeUnit.SECONDS), new Duration(10.0, TimeUnit.SECONDS), 2.0);
    private final HiveMetastoreClosure delegate;
    private final HdfsEnvironment hdfsEnvironment;
    private final Executor renameExecutor;
    private final Executor dropExecutor;
    private final Executor updateExecutor;
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final boolean deleteSchemaLocationsFallback;
    private final ScheduledExecutorService heartbeatExecutor;
    private final Optional<Duration> configuredTransactionHeartbeatInterval;
    private final TableInvalidationCallback tableInvalidationCallback;
    private boolean throwOnCleanupFailure;
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Action<TableAndMore>> tableActions = new HashMap<SchemaTableName, Action<TableAndMore>>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>> partitionActions = new HashMap<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>>();
    @GuardedBy(value="this")
    private long declaredIntentionsToWriteCounter;
    @GuardedBy(value="this")
    private final List<DeclaredIntentionToWrite> declaredIntentionsToWrite = new ArrayList<DeclaredIntentionToWrite>();
    @GuardedBy(value="this")
    private ExclusiveOperation bufferedExclusiveOperation;
    @GuardedBy(value="this")
    private State state = State.EMPTY;
    @GuardedBy(value="this")
    private Optional<String> currentQueryId = Optional.empty();
    @GuardedBy(value="this")
    private Optional<Supplier<HiveTransaction>> hiveTransactionSupplier = Optional.empty();
    @GuardedBy(value="this")
    private Optional<HiveTransaction> currentHiveTransaction = Optional.empty();

    public SemiTransactionalHiveMetastore(HdfsEnvironment hdfsEnvironment, HiveMetastoreClosure delegate, Executor renameExecutor, Executor dropExecutor, Executor updateExecutor, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean deleteSchemaLocationsFallback, Optional<Duration> hiveTransactionHeartbeatInterval, ScheduledExecutorService heartbeatService, TableInvalidationCallback tableInvalidationCallback) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.renameExecutor = Objects.requireNonNull(renameExecutor, "renameExecutor is null");
        this.dropExecutor = Objects.requireNonNull(dropExecutor, "dropExecutor is null");
        this.updateExecutor = Objects.requireNonNull(updateExecutor, "updateExecutor is null");
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        this.heartbeatExecutor = heartbeatService;
        this.configuredTransactionHeartbeatInterval = Objects.requireNonNull(hiveTransactionHeartbeatInterval, "hiveTransactionHeartbeatInterval is null");
        this.tableInvalidationCallback = Objects.requireNonNull(tableInvalidationCallback, "tableInvalidationCallback is null");
    }

    public synchronized List<String> getAllDatabases() {
        this.checkReadable();
        return this.delegate.getAllDatabases();
    }

    public HiveMetastoreClosure unsafeGetRawHiveMetastoreClosure() {
        return this.delegate;
    }

    public synchronized Optional<Database> getDatabase(String databaseName) {
        this.checkReadable();
        return this.delegate.getDatabase(databaseName);
    }

    public synchronized List<String> getAllTables(String databaseName) {
        this.checkReadable();
        if (!this.tableActions.isEmpty()) {
            throw new UnsupportedOperationException("Listing all tables after adding/dropping/altering tables/views in a transaction is not supported");
        }
        return this.delegate.getAllTables(databaseName);
    }

    public synchronized Optional<Table> getTable(String databaseName, String tableName) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return this.delegate.getTable(databaseName, tableName);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                return Optional.of(tableAction.getData().getTable());
            }
            case DROP: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown action type: " + tableAction.getType());
    }

    public synchronized boolean isReadableWithinTransaction(String databaseName, String tableName) {
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return true;
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: {
                return true;
            }
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                return false;
            }
            case DROP: 
            case DROP_PRESERVE_DATA: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown action type: " + tableAction.getType());
    }

    public synchronized Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    public synchronized PartitionStatistics getTableStatistics(String databaseName, String tableName) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return this.delegate.getTableStatistics(databaseName, tableName);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                return tableAction.getData().getStatistics();
            }
            case DROP: {
                return PartitionStatistics.empty();
            }
        }
        throw new IllegalStateException("Unknown action type: " + tableAction.getType());
    }

    public synchronized Map<String, PartitionStatistics> getPartitionStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        this.checkReadable();
        Optional<Table> table = this.getTable(databaseName, tableName);
        if (table.isEmpty()) {
            return ImmutableMap.of();
        }
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableSet.Builder partitionNamesToQuery = ImmutableSet.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        block4: for (String partitionName2 : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName2);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource) {
                    case PRE_EXISTING_TABLE: {
                        partitionNamesToQuery.add((Object)partitionName2);
                        continue block4;
                    }
                    case CREATED_IN_THIS_TRANSACTION: {
                        resultBuilder.put((Object)partitionName2, (Object)PartitionStatistics.empty());
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("unknown table source");
            }
            resultBuilder.put((Object)partitionName2, (Object)((PartitionAndMore)partitionAction.getData()).getStatistics());
        }
        Map<String, PartitionStatistics> delegateResult = this.delegate.getPartitionStatistics(databaseName, tableName, (Set<String>)partitionNamesToQuery.build());
        if (!delegateResult.isEmpty()) {
            resultBuilder.putAll(delegateResult);
        } else {
            partitionNamesToQuery.build().forEach(partitionName -> resultBuilder.put(partitionName, (Object)PartitionStatistics.empty()));
        }
        return resultBuilder.buildOrThrow();
    }

    @GuardedBy(value="this")
    private TableSource getTableSource(String databaseName, String tableName) {
        this.checkHoldsLock();
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return TableSource.PRE_EXISTING_TABLE;
        }
        switch (tableAction.getType()) {
            case ADD: {
                return TableSource.CREATED_IN_THIS_TRANSACTION;
            }
            case DROP: {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                return TableSource.PRE_EXISTING_TABLE;
            }
        }
        throw new IllegalStateException("Unknown action type: " + tableAction.getType());
    }

    public synchronized HivePageSinkMetadata generatePageSinkMetadata(SchemaTableName schemaTableName) {
        ImmutableMap modifiedPartitionMap;
        this.checkReadable();
        Optional<Table> table = this.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        if (table.isEmpty()) {
            return new HivePageSinkMetadata(schemaTableName, Optional.empty(), (Map<List<String>, Optional<Partition>>)ImmutableMap.of());
        }
        Map<List<String>, Action<PartitionAndMore>> partitionActionMap = this.partitionActions.get(schemaTableName);
        if (partitionActionMap == null) {
            modifiedPartitionMap = ImmutableMap.of();
        } else {
            ImmutableMap.Builder modifiedPartitionMapBuilder = ImmutableMap.builder();
            for (Map.Entry<List<String>, Action<PartitionAndMore>> entry : partitionActionMap.entrySet()) {
                modifiedPartitionMapBuilder.put(entry.getKey(), SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(entry.getValue()));
            }
            modifiedPartitionMap = modifiedPartitionMapBuilder.buildOrThrow();
        }
        return new HivePageSinkMetadata(schemaTableName, table, (Map<List<String>, Optional<Partition>>)modifiedPartitionMap);
    }

    public synchronized List<String> getAllViews(String databaseName) {
        this.checkReadable();
        if (!this.tableActions.isEmpty()) {
            throw new UnsupportedOperationException("Listing all tables after adding/dropping/altering tables/views in a transaction is not supported");
        }
        return this.delegate.getAllViews(databaseName);
    }

    public synchronized void createDatabase(Database database) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.createDatabase(database));
    }

    public synchronized void dropDatabase(ConnectorSession session, String schemaName) {
        Optional<Path> location = this.delegate.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName)).getLocation().map(Path::new);
        this.setExclusive((delegate, hdfsEnvironment) -> {
            boolean deleteData = location.map(path -> {
                Boolean bl;
                block8: {
                    HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session);
                    FileSystem fs = hdfsEnvironment.getFileSystem(context, (Path)path);
                    try {
                        bl = !fs.listLocatedStatus(path).hasNext();
                        if (fs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fs != null) {
                                try {
                                    fs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException | RuntimeException e) {
                            log.warn((Throwable)e, "Could not check schema directory '%s'", new Object[]{path});
                            return this.deleteSchemaLocationsFallback;
                        }
                    }
                    fs.close();
                }
                return bl;
            }).orElse(this.deleteSchemaLocationsFallback);
            delegate.dropDatabase(schemaName, deleteData);
        });
    }

    public synchronized void renameDatabase(String source, String target) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.renameDatabase(source, target));
    }

    public synchronized void setDatabaseOwner(String source, HivePrincipal principal) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.setDatabaseOwner(source, principal));
    }

    public synchronized void setTableStatistics(Table table, PartitionStatistics tableStatistics) {
        AcidTransaction transaction = this.currentHiveTransaction.isPresent() ? this.currentHiveTransaction.get().getTransaction() : AcidTransaction.NO_ACID_TRANSACTION;
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.updateTableStatistics(table.getDatabaseName(), table.getTableName(), transaction, statistics -> SemiTransactionalHiveMetastore.updatePartitionStatistics(statistics, tableStatistics)));
    }

    public synchronized void setPartitionStatistics(Table table, Map<List<String>, PartitionStatistics> partitionStatisticsMap) {
        Map updates = (Map)partitionStatisticsMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> SemiTransactionalHiveMetastore.getPartitionName(table, (List)entry.getKey()), entry -> oldPartitionStats -> SemiTransactionalHiveMetastore.updatePartitionStatistics(oldPartitionStats, (PartitionStatistics)entry.getValue())));
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.updatePartitionStatistics(table.getDatabaseName(), table.getTableName(), updates));
    }

    private static PartitionStatistics updatePartitionStatistics(PartitionStatistics oldPartitionStats, PartitionStatistics newPartitionStats) {
        HiveBasicStatistics oldBasicStatistics = oldPartitionStats.getBasicStatistics();
        HiveBasicStatistics newBasicStatistics = newPartitionStats.getBasicStatistics();
        HiveBasicStatistics updatedBasicStatistics = new HiveBasicStatistics(SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getFileCount(), oldBasicStatistics.getFileCount()), SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getRowCount(), oldBasicStatistics.getRowCount()), SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getInMemoryDataSizeInBytes(), oldBasicStatistics.getInMemoryDataSizeInBytes()), SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getOnDiskDataSizeInBytes(), oldBasicStatistics.getOnDiskDataSizeInBytes()));
        Map<String, HiveColumnStatistics> updatedColumnStatistics = SemiTransactionalHiveMetastore.updateColumnStatistics(oldPartitionStats.getColumnStatistics(), newPartitionStats.getColumnStatistics());
        return new PartitionStatistics(updatedBasicStatistics, updatedColumnStatistics);
    }

    private static Map<String, HiveColumnStatistics> updateColumnStatistics(Map<String, HiveColumnStatistics> oldColumnStats, Map<String, HiveColumnStatistics> newColumnStats) {
        HashMap<String, HiveColumnStatistics> result = new HashMap<String, HiveColumnStatistics>(oldColumnStats);
        result.putAll(newColumnStats);
        return ImmutableMap.copyOf(result);
    }

    private static OptionalLong firstPresent(OptionalLong first, OptionalLong second) {
        return first.isPresent() ? first : second;
    }

    public synchronized void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges, Optional<Path> currentPath, Optional<List<String>> files, boolean ignoreExisting, PartitionStatistics statistics, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        this.checkNoPartitionAction(table.getDatabaseName(), table.getTableName());
        Action<TableAndMore> oldTableAction = this.tableActions.get(table.getSchemaTableName());
        TableAndMore tableAndMore = new TableAndMore(table, Optional.of(principalPrivileges), currentPath, files, ignoreExisting, statistics, statistics, cleanExtraOutputFilesOnCommit);
        if (oldTableAction == null) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
            this.tableActions.put(table.getSchemaTableName(), new Action<TableAndMore>(ActionType.ADD, tableAndMore, hdfsContext, session.getQueryId()));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                if (!oldTableAction.getHdfsContext().getIdentity().getUser().equals(session.getUser())) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Operation on the same table with different user in the same transaction is not supported");
                }
                HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
                this.tableActions.put(table.getSchemaTableName(), new Action<TableAndMore>(ActionType.ALTER, tableAndMore, hdfsContext, session.getQueryId()));
                return;
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                throw new TableAlreadyExistsException(table.getSchemaTableName());
            }
        }
        throw new IllegalStateException("Unknown action type: " + oldTableAction.getType());
    }

    public synchronized void dropTable(ConnectorSession session, String databaseName, String tableName) {
        this.setShared();
        this.checkNoPartitionAction(databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null || oldTableAction.getType() == ActionType.ALTER) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
            this.tableActions.put(schemaTableName, new Action<Object>(ActionType.DROP, null, hdfsContext, session.getQueryId()));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                throw new UnsupportedOperationException("dropping a table added/modified in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type: " + oldTableAction.getType());
    }

    public synchronized void replaceTable(String databaseName, String tableName, Table table, PrincipalPrivileges principalPrivileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.replaceTable(databaseName, tableName, table, principalPrivileges));
    }

    public synchronized void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.setExclusive((delegate, hdfsEnvironment) -> {
            Optional<Table> oldTable = delegate.getTable(databaseName, tableName);
            try {
                delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
            }
            finally {
                oldTable.ifPresent(this.tableInvalidationCallback::invalidate);
            }
        });
    }

    public synchronized void commentTable(String databaseName, String tableName, Optional<String> comment) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.commentTable(databaseName, tableName, comment));
    }

    public synchronized void setTableOwner(String schema, String table, HivePrincipal principal) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.setTableOwner(schema, table, principal));
    }

    public synchronized void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.commentColumn(databaseName, tableName, columnName, comment));
    }

    public synchronized void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment));
    }

    public synchronized void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName));
    }

    public synchronized void dropColumn(String databaseName, String tableName, String columnName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.dropColumn(databaseName, tableName, columnName));
    }

    public synchronized void finishInsertIntoExistingTable(ConnectorSession session, String databaseName, String tableName, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null) {
            Table table = this.getExistingTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
            if (this.isAcidTransactionRunning()) {
                table = Table.builder(table).setWriteId(OptionalLong.of(this.currentHiveTransaction.orElseThrow().getTransaction().getWriteId())).build();
            }
            PartitionStatistics currentStatistics = this.getTableStatistics(databaseName, tableName);
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
            this.tableActions.put(schemaTableName, new Action<TableAndMore>(ActionType.INSERT_EXISTING, new TableAndMore(table, Optional.empty(), Optional.of(currentLocation), Optional.of(fileNames), false, Statistics.merge(currentStatistics, statisticsUpdate), statisticsUpdate, cleanExtraOutputFilesOnCommit), hdfsContext, session.getQueryId()));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                throw new UnsupportedOperationException("Inserting into an unpartitioned table that were added, altered, or inserted into in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type: " + oldTableAction.getType());
    }

    private boolean isAcidTransactionRunning() {
        return this.currentHiveTransaction.isPresent() && this.currentHiveTransaction.get().getTransaction().isAcidTransactionRunning();
    }

    public synchronized void truncateUnpartitionedTable(ConnectorSession session, String databaseName, String tableName) {
        this.checkReadable();
        Optional<Table> table = this.getTable(databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        if (table.isEmpty()) {
            throw new TableNotFoundException(schemaTableName);
        }
        if (!table.get().getTableType().equals(TableType.MANAGED_TABLE.toString())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot delete from non-managed Hive table");
        }
        if (!table.get().getPartitionColumns().isEmpty()) {
            throw new IllegalArgumentException("Table is partitioned");
        }
        Path path = new Path(table.get().getStorage().getLocation());
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session);
        this.setExclusive((delegate, hdfsEnvironment) -> {
            RecursiveDeleteResult recursiveDeleteResult = SemiTransactionalHiveMetastore.recursiveDeleteFiles(hdfsEnvironment, context, path, (Set<String>)ImmutableSet.of((Object)""), false);
            if (!recursiveDeleteResult.getNotDeletedEligibleItems().isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error deleting from unpartitioned table %s. These items cannot be deleted: %s", schemaTableName, recursiveDeleteResult.getNotDeletedEligibleItems()));
            }
        });
    }

    public synchronized void finishRowLevelDelete(ConnectorSession session, String databaseName, String tableName, Path currentLocation, List<PartitionAndStatementId> partitionAndStatementIds) {
        if (partitionAndStatementIds.isEmpty()) {
            return;
        }
        this.setShared();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null) {
            Table table = this.getExistingTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
            PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(table.getOwner().orElseThrow());
            this.tableActions.put(schemaTableName, new Action<TableAndAcidDirectories>(ActionType.DELETE_ROWS, new TableAndAcidDirectories(table, Optional.of(principalPrivileges), Optional.of(currentLocation), partitionAndStatementIds), hdfsContext, session.getQueryId()));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                throw new UnsupportedOperationException("Inserting or deleting in an unpartitioned table that were added, altered, or inserted into in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type: " + oldTableAction.getType());
    }

    public synchronized void finishUpdate(ConnectorSession session, String databaseName, String tableName, Path currentLocation, List<PartitionAndStatementId> partitionAndStatementIds) {
        if (partitionAndStatementIds.isEmpty()) {
            return;
        }
        this.setShared();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null) {
            Table table = this.getExistingTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
            PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(table.getOwner().orElseThrow());
            this.tableActions.put(schemaTableName, new Action<TableAndAcidDirectories>(ActionType.UPDATE, new TableAndAcidDirectories(table, Optional.of(principalPrivileges), Optional.of(currentLocation), partitionAndStatementIds), hdfsContext, session.getQueryId()));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                throw new UnsupportedOperationException("Inserting, updating or deleting in a table that was added, altered, inserted into, updated or deleted from in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type: " + oldTableAction.getType());
    }

    public synchronized Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        Optional<Table> table = this.getTable(databaseName, tableName);
        if (table.isEmpty()) {
            return Optional.empty();
        }
        List columnNames = (List)table.get().getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        return this.doGetPartitionNames(databaseName, tableName, columnNames, (TupleDomain<String>)TupleDomain.all());
    }

    public synchronized Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.doGetPartitionNames(databaseName, tableName, columnNames, partitionKeysFilter);
    }

    @GuardedBy(value="this")
    private Optional<List<String>> doGetPartitionNames(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        Object partitionNames;
        this.checkHoldsLock();
        this.checkReadable();
        if (partitionKeysFilter.isNone()) {
            return Optional.of(ImmutableList.of());
        }
        Optional<Table> table = this.getTable(databaseName, tableName);
        if (table.isEmpty()) {
            return Optional.empty();
        }
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        switch (tableSource) {
            case CREATED_IN_THIS_TRANSACTION: {
                partitionNames = ImmutableList.of();
                break;
            }
            case PRE_EXISTING_TABLE: {
                Optional<List<String>> partitionNameResult = this.delegate.getPartitionNamesByFilter(databaseName, tableName, columnNames, partitionKeysFilter);
                if (partitionNameResult.isEmpty()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table '%s.%s' was dropped by another transaction", databaseName, tableName));
                }
                partitionNames = partitionNameResult.get();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown table source");
            }
        }
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        Iterator<Object> iterator = partitionNames.iterator();
        block9: while (iterator.hasNext()) {
            String partitionName = (String)iterator.next();
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                resultBuilder.add((Object)partitionName);
                continue;
            }
            switch (partitionAction.getType()) {
                case ADD: {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Another transaction created partition %s in table %s.%s", partitionValues, databaseName, tableName));
                }
                case DROP: 
                case DROP_PRESERVE_DATA: {
                    continue block9;
                }
                case ALTER: 
                case INSERT_EXISTING: 
                case DELETE_ROWS: 
                case UPDATE: {
                    resultBuilder.add((Object)partitionName);
                    continue block9;
                }
            }
            throw new IllegalStateException("Unknown action type: " + partitionAction.getType());
        }
        if (!partitionActionsOfTable.isEmpty()) {
            for (Action partitionAction : partitionActionsOfTable.values()) {
                if (partitionAction.getType() != ActionType.ADD) continue;
                List<String> values = ((PartitionAndMore)partitionAction.getData()).getPartition().getValues();
                resultBuilder.add((Object)FileUtils.makePartName(columnNames, values));
            }
        }
        return Optional.of(resultBuilder.build());
    }

    public synchronized Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        this.checkReadable();
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        ImmutableList.Builder partitionNamesToQueryBuilder = ImmutableList.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        block4: for (String partitionName : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource) {
                    case PRE_EXISTING_TABLE: {
                        partitionNamesToQueryBuilder.add((Object)partitionName);
                        continue block4;
                    }
                    case CREATED_IN_THIS_TRANSACTION: {
                        resultBuilder.put((Object)partitionName, Optional.empty());
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("unknown table source");
            }
            resultBuilder.put((Object)partitionName, SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(partitionAction));
        }
        ImmutableList partitionNamesToQuery = partitionNamesToQueryBuilder.build();
        if (!partitionNamesToQuery.isEmpty()) {
            Map<String, Optional<Partition>> delegateResult = this.delegate.getPartitionsByNames(databaseName, tableName, (List<String>)partitionNamesToQuery);
            resultBuilder.putAll(delegateResult);
        }
        return resultBuilder.buildOrThrow();
    }

    private static Optional<Partition> getPartitionFromPartitionAction(Action<PartitionAndMore> partitionAction) {
        switch (partitionAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                return Optional.of(partitionAction.getData().getAugmentedPartitionForInTransactionRead());
            }
            case DROP: 
            case DROP_PRESERVE_DATA: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown action type: " + partitionAction.getType());
    }

    public synchronized void addPartition(ConnectorSession session, String databaseName, String tableName, Partition partition, Path currentLocation, Optional<List<String>> files, PartitionStatistics statistics, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getPrestoQueryId(partition).isPresent());
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partition.getValues());
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        if (oldPartitionAction == null) {
            partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ADD, new PartitionAndMore(partition, currentLocation, files, statistics, statistics, cleanExtraOutputFilesOnCommit), hdfsContext, session.getQueryId()));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: 
            case DROP_PRESERVE_DATA: {
                if (!oldPartitionAction.getHdfsContext().getIdentity().getUser().equals(session.getUser())) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Operation on the same partition with different user in the same transaction is not supported");
                }
                partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ALTER, new PartitionAndMore(partition, currentLocation, files, statistics, statistics, cleanExtraOutputFilesOnCommit), hdfsContext, session.getQueryId()));
                return;
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Partition already exists for table '%s.%s': %s", databaseName, tableName, partition.getValues()));
            }
        }
        throw new IllegalStateException("Unknown action type: " + oldPartitionAction.getType());
    }

    public synchronized void dropPartition(ConnectorSession session, String databaseName, String tableName, List<String> partitionValues, boolean deleteData) {
        this.setShared();
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (oldPartitionAction == null) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
            if (deleteData) {
                partitionActionsOfTable.put(partitionValues, new Action<Object>(ActionType.DROP, null, hdfsContext, session.getQueryId()));
            } else {
                partitionActionsOfTable.put(partitionValues, new Action<Object>(ActionType.DROP_PRESERVE_DATA, null, hdfsContext, session.getQueryId()));
            }
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: 
            case DROP_PRESERVE_DATA: {
                throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("dropping a partition added in the same transaction is not supported: %s %s %s", databaseName, tableName, partitionValues));
            }
        }
        throw new IllegalStateException("Unknown action type: " + oldPartitionAction.getType());
    }

    public synchronized void finishInsertIntoExistingPartition(ConnectorSession session, String databaseName, String tableName, List<String> partitionValues, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(schemaTableName, k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (oldPartitionAction == null) {
            Partition partition = this.delegate.getPartition(databaseName, tableName, partitionValues).orElseThrow(() -> new PartitionNotFoundException(schemaTableName, partitionValues));
            String partitionName = this.getPartitionName(databaseName, tableName, partitionValues);
            PartitionStatistics currentStatistics = this.delegate.getPartitionStatistics(databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName);
            if (currentStatistics == null) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "currentStatistics is null");
            }
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session);
            partitionActionsOfTable.put(partitionValues, new Action<PartitionAndMore>(ActionType.INSERT_EXISTING, new PartitionAndMore(partition, currentLocation, Optional.of(fileNames), Statistics.merge(currentStatistics, statisticsUpdate), statisticsUpdate, cleanExtraOutputFilesOnCommit), context, session.getQueryId()));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: 
            case DROP_PRESERVE_DATA: {
                throw new PartitionNotFoundException(schemaTableName, partitionValues);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                throw new UnsupportedOperationException("Inserting into a partition that were added, altered, or inserted into in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type: " + oldPartitionAction.getType());
    }

    private synchronized AcidTransaction getCurrentAcidTransaction() {
        return this.currentHiveTransaction.map(HiveTransaction::getTransaction).orElseThrow(() -> new IllegalStateException("currentHiveTransaction not present"));
    }

    private String getPartitionName(String databaseName, String tableName, List<String> partitionValues) {
        Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        return SemiTransactionalHiveMetastore.getPartitionName(table, partitionValues);
    }

    private static String getPartitionName(Table table, List<String> partitionValues) {
        List columnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        return FileUtils.makePartName((List)columnNames, partitionValues);
    }

    @Override
    public synchronized void createRole(String role, String grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.createRole(role, grantor));
    }

    @Override
    public synchronized void dropRole(String role) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.dropRole(role));
    }

    @Override
    public synchronized Set<String> listRoles() {
        this.checkReadable();
        return this.delegate.listRoles();
    }

    @Override
    public synchronized void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.grantRoles(roles, grantees, adminOption, grantor));
    }

    @Override
    public synchronized void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.revokeRoles(roles, grantees, adminOption, grantor));
    }

    @Override
    public synchronized Set<RoleGrant> listGrantedPrincipals(String role) {
        this.checkReadable();
        return this.delegate.listGrantedPrincipals(role);
    }

    @Override
    public synchronized Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        this.checkReadable();
        return this.delegate.listRoleGrants(principal);
    }

    @Override
    public synchronized Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<HivePrincipal> principal) {
        this.checkReadable();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> tableAction = this.tableActions.get(schemaTableName);
        if (tableAction == null) {
            return this.delegate.listTablePrivileges(databaseName, tableName, this.getExistingTable(databaseName, tableName).getOwner(), principal);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: {
                if (principal.isPresent() && principal.get().getType() == PrincipalType.ROLE) {
                    return ImmutableSet.of();
                }
                Optional<String> owner = tableAction.getData().getTable().getOwner();
                if (owner.isEmpty()) {
                    return ImmutableSet.of();
                }
                String ownerUsername = owner.orElseThrow();
                if (principal.isPresent() && !principal.get().getName().equals(ownerUsername)) {
                    return ImmutableSet.of();
                }
                Set privileges = tableAction.getData().getPrincipalPrivileges().getUserPrivileges().get((Object)ownerUsername);
                return ImmutableSet.builder().addAll((Iterable)privileges).add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, new HivePrincipal(PrincipalType.USER, ownerUsername), new HivePrincipal(PrincipalType.USER, ownerUsername))).build();
            }
            case INSERT_EXISTING: 
            case DELETE_ROWS: 
            case UPDATE: {
                return this.delegate.listTablePrivileges(databaseName, tableName, this.getExistingTable(databaseName, tableName).getOwner(), principal);
            }
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
        }
        throw new IllegalStateException("Unknown action type: " + tableAction.getType());
    }

    private synchronized String getRequiredTableOwner(String databaseName, String tableName) {
        return this.getExistingTable(databaseName, tableName).getOwner().orElseThrow();
    }

    private Table getExistingTable(String databaseName, String tableName) {
        return this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    @Override
    public synchronized void grantTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.grantTablePrivileges(databaseName, tableName, this.getRequiredTableOwner(databaseName, tableName), grantee, grantor, privileges, grantOption));
    }

    @Override
    public synchronized void revokeTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.revokeTablePrivileges(databaseName, tableName, this.getRequiredTableOwner(databaseName, tableName), grantee, grantor, privileges, grantOption));
    }

    public synchronized String declareIntentionToWrite(ConnectorSession session, LocationHandle.WriteMode writeMode, Path stagingPathRoot, SchemaTableName schemaTableName) {
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable;
        this.setShared();
        if (writeMode == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY && (partitionActionsOfTable = this.partitionActions.get(schemaTableName)) != null && !partitionActionsOfTable.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot insert into a table with a partition that has been modified in the same transaction when Trino is configured to skip temporary directories.");
        }
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        String queryId = session.getQueryId();
        String declarationId = queryId + "_" + this.declaredIntentionsToWriteCounter;
        ++this.declaredIntentionsToWriteCounter;
        this.declaredIntentionsToWrite.add(new DeclaredIntentionToWrite(declarationId, writeMode, hdfsContext, queryId, stagingPathRoot, schemaTableName));
        return declarationId;
    }

    public synchronized void dropDeclaredIntentionToWrite(String declarationId) {
        boolean removed = this.declaredIntentionsToWrite.removeIf(intention -> intention.getDeclarationId().equals(declarationId));
        if (!removed) {
            throw new IllegalArgumentException("Declaration with id " + declarationId + " not found");
        }
    }

    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    public synchronized void commit() {
        try {
            switch (this.state) {
                case EMPTY: {
                    return;
                }
                case SHARED_OPERATION_BUFFERED: {
                    this.commitShared();
                    return;
                }
                case EXCLUSIVE_OPERATION_BUFFERED: {
                    Objects.requireNonNull(this.bufferedExclusiveOperation, "bufferedExclusiveOperation is null");
                    this.bufferedExclusiveOperation.execute(this.delegate, this.hdfsEnvironment);
                    return;
                }
                case FINISHED: {
                    throw new IllegalStateException("Tried to commit buffered metastore operations after transaction has been committed/aborted");
                }
            }
            throw new IllegalStateException("Unknown state: " + this.state);
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    public synchronized void rollback() {
        try {
            switch (this.state) {
                case EMPTY: 
                case EXCLUSIVE_OPERATION_BUFFERED: {
                    return;
                }
                case SHARED_OPERATION_BUFFERED: {
                    this.rollbackShared();
                    return;
                }
                case FINISHED: {
                    throw new IllegalStateException("Tried to rollback buffered metastore operations after transaction has been committed/aborted");
                }
            }
            throw new IllegalStateException("Unknown state: " + this.state);
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginQuery(ConnectorSession session) {
        String queryId = session.getQueryId();
        SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = this;
        synchronized (semiTransactionalHiveMetastore) {
            Preconditions.checkState((this.currentQueryId.isEmpty() && this.hiveTransactionSupplier.isEmpty() ? 1 : 0) != 0, (String)"Query already begun: %s while starting query %s", this.currentQueryId, (Object)queryId);
            this.currentQueryId = Optional.of(queryId);
            this.hiveTransactionSupplier = Optional.of(() -> this.makeHiveTransaction(session, transactionId -> AcidTransaction.NO_ACID_TRANSACTION));
        }
    }

    public AcidTransaction beginInsert(ConnectorSession session, Table table) {
        return this.beginOperation(session, table, AcidOperation.INSERT, DataOperationType.INSERT, Optional.empty());
    }

    public AcidTransaction beginDelete(ConnectorSession session, Table table) {
        return this.beginOperation(session, table, AcidOperation.DELETE, DataOperationType.DELETE, Optional.empty());
    }

    public AcidTransaction beginUpdate(ConnectorSession session, Table table, HiveUpdateProcessor updateProcessor) {
        return this.beginOperation(session, table, AcidOperation.UPDATE, DataOperationType.UPDATE, Optional.of(updateProcessor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcidTransaction beginOperation(ConnectorSession session, Table table, AcidOperation operation, DataOperationType hiveOperation, Optional<HiveUpdateProcessor> updateProcessor) {
        String queryId = session.getQueryId();
        SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = this;
        synchronized (semiTransactionalHiveMetastore) {
            this.currentQueryId = Optional.of(queryId);
            HiveTransaction hiveTransaction = this.makeHiveTransaction(session, transactionId -> {
                this.acquireTableWriteLock(new AcidTransactionOwner(session.getUser()), queryId, (long)transactionId, table.getDatabaseName(), table.getTableName(), hiveOperation, !table.getPartitionColumns().isEmpty());
                long writeId = this.allocateWriteId(table.getDatabaseName(), table.getTableName(), (long)transactionId);
                return new AcidTransaction(operation, (long)transactionId, writeId, updateProcessor);
            });
            this.hiveTransactionSupplier = Optional.of(() -> hiveTransaction);
            this.currentHiveTransaction = Optional.of(hiveTransaction);
            return hiveTransaction.getTransaction();
        }
    }

    private HiveTransaction makeHiveTransaction(ConnectorSession session, Function<Long, AcidTransaction> transactionMaker) {
        String queryId = session.getQueryId();
        long heartbeatInterval = this.configuredTransactionHeartbeatInterval.map(Duration::toMillis).orElseGet(this::getServerExpectedHeartbeatIntervalMillis);
        long transactionId = this.delegate.openTransaction(new AcidTransactionOwner(session.getUser()));
        log.debug("Using hive transaction %s for %s", new Object[]{transactionId, queryId});
        ScheduledFuture<?> heartbeatTask = this.heartbeatExecutor.scheduleAtFixedRate(() -> this.delegate.sendTransactionHeartbeat(transactionId), 0L, heartbeatInterval, TimeUnit.MILLISECONDS);
        AcidTransaction transaction = transactionMaker.apply(transactionId);
        return new HiveTransaction(queryId, transactionId, heartbeatTask, transaction);
    }

    private long getServerExpectedHeartbeatIntervalMillis() {
        String hiveServerTransactionTimeout = this.delegate.getConfigValue(MetastoreConf.ConfVars.TXN_TIMEOUT.getVarname()).orElseGet(() -> MetastoreConf.ConfVars.TXN_TIMEOUT.getDefaultVal().toString());
        Configuration configuration = ConfigurationInstantiator.newEmptyConfiguration();
        configuration.set(MetastoreConf.ConfVars.TXN_TIMEOUT.toString(), hiveServerTransactionTimeout);
        return MetastoreConf.getTimeVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) / 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ValidTxnWriteIdList> getValidWriteIds(ConnectorSession session, HiveTableHandle tableHandle) {
        HiveTransaction hiveTransaction;
        SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = this;
        synchronized (semiTransactionalHiveMetastore) {
            String queryId = session.getQueryId();
            Preconditions.checkState((boolean)this.currentQueryId.equals(Optional.of(queryId)), (String)"Invalid query id %s while current query is", (Object)queryId, this.currentQueryId);
            if (!AcidUtils.isTransactionalTable(tableHandle.getTableParameters().orElseThrow(() -> new IllegalStateException("tableParameters missing")))) {
                return Optional.empty();
            }
            if (this.currentHiveTransaction.isEmpty()) {
                this.currentHiveTransaction = Optional.of(this.hiveTransactionSupplier.orElseThrow(() -> new IllegalStateException("hiveTransactionSupplier is not set")).get());
            }
            hiveTransaction = this.currentHiveTransaction.get();
        }
        return Optional.of(hiveTransaction.getValidWriteIds(new AcidTransactionOwner(session.getUser()), this.delegate, tableHandle));
    }

    public synchronized void cleanupQuery(ConnectorSession session) {
        String queryId = session.getQueryId();
        Preconditions.checkState((boolean)this.currentQueryId.equals(Optional.of(queryId)), (String)"Invalid query id %s while current query is", (Object)queryId, this.currentQueryId);
        Optional<HiveTransaction> transaction = this.currentHiveTransaction;
        if (transaction.isEmpty()) {
            this.clearCurrentTransaction();
            return;
        }
        try {
            this.commit();
        }
        catch (Throwable commitFailure) {
            block5: {
                try {
                    this.postCommitCleanup(transaction, false);
                }
                catch (Throwable cleanupFailure) {
                    if (cleanupFailure == commitFailure) break block5;
                    commitFailure.addSuppressed(cleanupFailure);
                }
            }
            throw commitFailure;
        }
        this.postCommitCleanup(transaction, true);
    }

    private void postCommitCleanup(Optional<HiveTransaction> transaction, boolean commit) {
        this.clearCurrentTransaction();
        long transactionId = transaction.orElseThrow().getTransactionId();
        ScheduledFuture<?> heartbeatTask = transaction.get().getHeartbeatTask();
        heartbeatTask.cancel(true);
        if (commit) {
            this.delegate.commitTransaction(transactionId);
        } else {
            this.delegate.abortTransaction(transactionId);
        }
    }

    @GuardedBy(value="this")
    private synchronized void clearCurrentTransaction() {
        this.currentQueryId = Optional.empty();
        this.currentHiveTransaction = Optional.empty();
        this.hiveTransactionSupplier = Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    private void commitShared() {
        this.checkHoldsLock();
        AcidTransaction transaction = this.currentHiveTransaction.isEmpty() ? AcidTransaction.NO_ACID_TRANSACTION : this.currentHiveTransaction.get().getTransaction();
        Committer committer = new Committer(transaction);
        try {
            SchemaTableName schemaTableName;
            block26: for (Map.Entry<SchemaTableName, Action<TableAndMore>> entry : this.tableActions.entrySet()) {
                schemaTableName = entry.getKey();
                Action<TableAndMore> action = entry.getValue();
                switch (action.getType()) {
                    case DROP: {
                        committer.prepareDropTable(schemaTableName);
                        continue block26;
                    }
                    case ALTER: {
                        committer.prepareAlterTable(action.getHdfsContext(), action.getQueryId(), action.getData());
                        continue block26;
                    }
                    case ADD: {
                        committer.prepareAddTable(action.getHdfsContext(), action.getQueryId(), action.getData());
                        continue block26;
                    }
                    case INSERT_EXISTING: {
                        committer.prepareInsertExistingTable(action.getHdfsContext(), action.getQueryId(), action.getData());
                        continue block26;
                    }
                    case DELETE_ROWS: {
                        committer.prepareDeleteRowsFromExistingTable(action.getHdfsContext(), action.getData());
                        continue block26;
                    }
                    case UPDATE: {
                        committer.prepareUpdateExistingTable(action.getHdfsContext(), action.getData());
                        continue block26;
                    }
                }
                throw new IllegalStateException("Unknown action type: " + action.getType());
            }
            for (Map.Entry<SchemaTableName, Object> entry : this.partitionActions.entrySet()) {
                schemaTableName = entry.getKey();
                block28: for (Map.Entry partitionEntry : ((Map)entry.getValue()).entrySet()) {
                    List partitionValues = (List)partitionEntry.getKey();
                    Action action = (Action)partitionEntry.getValue();
                    switch (action.getType()) {
                        case DROP: {
                            committer.prepareDropPartition(schemaTableName, partitionValues, true);
                            continue block28;
                        }
                        case DROP_PRESERVE_DATA: {
                            committer.prepareDropPartition(schemaTableName, partitionValues, false);
                            continue block28;
                        }
                        case ALTER: {
                            committer.prepareAlterPartition(action.getHdfsContext(), action.getQueryId(), (PartitionAndMore)action.getData());
                            continue block28;
                        }
                        case ADD: {
                            committer.prepareAddPartition(action.getHdfsContext(), action.getQueryId(), (PartitionAndMore)action.getData());
                            continue block28;
                        }
                        case INSERT_EXISTING: {
                            committer.prepareInsertExistingPartition(action.getHdfsContext(), action.getQueryId(), (PartitionAndMore)action.getData());
                            continue block28;
                        }
                        case DELETE_ROWS: 
                        case UPDATE: {
                            continue block28;
                        }
                    }
                    throw new IllegalStateException("Unknown action type: " + action.getType());
                }
            }
            committer.waitForAsyncRenames();
            committer.executeAddTableOperations(transaction);
            committer.executeAlterTableOperations();
            committer.executeAlterPartitionOperations();
            committer.executeAddPartitionOperations(transaction);
            committer.executeUpdateStatisticsOperations(transaction);
        }
        catch (Throwable t) {
            log.warn("Rolling back due to metastore commit failure: %s", new Object[]{t.getMessage()});
            try {
                committer.cancelUnstartedAsyncRenames();
                committer.undoUpdateStatisticsOperations(transaction);
                committer.undoAddPartitionOperations();
                committer.undoAddTableOperations();
                committer.waitForAsyncRenamesSuppressThrowables();
                committer.executeCleanupTasksForAbort(this.declaredIntentionsToWrite);
                committer.executeRenameTasksForAbort();
                committer.undoAlterTableOperations();
                committer.undoAlterPartitionOperations();
                this.rollbackShared();
            }
            catch (RuntimeException runtimeException) {
                t.addSuppressed(new Exception("Failed to roll back after commit failure", runtimeException));
            }
            throw t;
        }
        finally {
            committer.executeTableInvalidationCallback();
        }
        try {
            committer.executeIrreversibleMetastoreOperations();
        }
        finally {
            committer.executeDeletionTasksForFinish();
            committer.pruneAndDeleteStagingDirectories(this.declaredIntentionsToWrite);
        }
    }

    @GuardedBy(value="this")
    private void rollbackShared() {
        this.checkHoldsLock();
        block4: for (DeclaredIntentionToWrite declaredIntentionToWrite : this.declaredIntentionsToWrite) {
            switch (declaredIntentionToWrite.getMode()) {
                case STAGE_AND_MOVE_TO_TARGET_DIRECTORY: 
                case DIRECT_TO_TARGET_NEW_DIRECTORY: {
                    if (declaredIntentionToWrite.getMode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY && this.skipTargetCleanupOnRollback) break;
                    Path rootPath = declaredIntentionToWrite.getRootPath();
                    this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getHdfsContext(), rootPath, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.getQueryId()), true, String.format("staging/target_new directory rollback for table %s", declaredIntentionToWrite.getSchemaTableName()));
                    break;
                }
                case DIRECT_TO_TARGET_EXISTING_DIRECTORY: {
                    HashSet<Path> pathsToClean = new HashSet<Path>();
                    Path baseDirectory = declaredIntentionToWrite.getRootPath();
                    pathsToClean.add(baseDirectory);
                    SchemaTableName schemaTableName = declaredIntentionToWrite.getSchemaTableName();
                    Optional<Table> table = this.delegate.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    if (table.isPresent()) {
                        List<Column> partitionColumns = table.get().getPartitionColumns();
                        if (!partitionColumns.isEmpty()) {
                            List partitionColumnNames = (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
                            List<String> partitionNames = this.delegate.getPartitionNamesByFilter(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionColumnNames, (TupleDomain<String>)TupleDomain.all()).orElse((List<String>)ImmutableList.of());
                            for (List partitionNameBatch : Iterables.partition(partitionNames, (int)10)) {
                                Collection<Optional<Partition>> partitions = this.delegate.getPartitionsByNames(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionNameBatch).values();
                                partitions.stream().filter(Optional::isPresent).map(Optional::get).map(partition -> partition.getStorage().getLocation()).map(Path::new).filter(path -> !SemiTransactionalHiveMetastore.isSameOrParent(baseDirectory, path)).forEach(pathsToClean::add);
                            }
                        }
                    } else {
                        this.logCleanupFailure("Error rolling back write to table %s.%s. Data directory may contain temporary data. Table was dropped in another transaction.", schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    }
                    for (Path path2 : pathsToClean) {
                        this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getHdfsContext(), path2, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.getQueryId()), false, String.format("target_existing directory rollback for table %s", schemaTableName));
                    }
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown write mode");
                }
            }
        }
    }

    @VisibleForTesting
    public synchronized void testOnlyCheckIsReadOnly() {
        if (this.state != State.EMPTY) {
            throw new AssertionError((Object)"Test did not commit or rollback");
        }
    }

    @VisibleForTesting
    public void testOnlyThrowOnCleanupFailures() {
        this.throwOnCleanupFailure = true;
    }

    @GuardedBy(value="this")
    private void checkReadable() {
        this.checkHoldsLock();
        switch (this.state) {
            case EMPTY: 
            case SHARED_OPERATION_BUFFERED: {
                return;
            }
            case EXCLUSIVE_OPERATION_BUFFERED: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
            }
            case FINISHED: {
                throw new IllegalStateException("Tried to access metastore after transaction has been committed/aborted");
            }
        }
    }

    @GuardedBy(value="this")
    private void setShared() {
        this.checkHoldsLock();
        this.checkReadable();
        this.state = State.SHARED_OPERATION_BUFFERED;
    }

    @GuardedBy(value="this")
    private void setExclusive(ExclusiveOperation exclusiveOperation) {
        this.checkHoldsLock();
        if (this.state != State.EMPTY) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
        }
        this.state = State.EXCLUSIVE_OPERATION_BUFFERED;
        this.bufferedExclusiveOperation = exclusiveOperation;
    }

    @GuardedBy(value="this")
    private void checkNoPartitionAction(String databaseName, String tableName) {
        this.checkHoldsLock();
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable = this.partitionActions.get(new SchemaTableName(databaseName, tableName));
        if (partitionActionsOfTable != null && !partitionActionsOfTable.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot make schema changes to a table/view with modified partitions in the same transaction");
        }
    }

    private static boolean isSameOrParent(Path parent, Path child) {
        int childDepth;
        int parentDepth = parent.depth();
        if (parentDepth > (childDepth = child.depth())) {
            return false;
        }
        for (int i = childDepth; i > parentDepth; --i) {
            child = child.getParent();
        }
        return parent.equals((Object)child);
    }

    @FormatMethod
    private void logCleanupFailure(String format, Object ... args) {
        if (this.throwOnCleanupFailure) {
            throw new RuntimeException(String.format(format, args));
        }
        log.warn(format, args);
    }

    @FormatMethod
    private void logCleanupFailure(Throwable t, String format, Object ... args) {
        if (this.throwOnCleanupFailure) {
            throw new RuntimeException(String.format(format, args), t);
        }
        log.warn(t, format, args);
    }

    private static void addSuppressedExceptions(List<Throwable> suppressedExceptions, Throwable t, List<String> descriptions, String description) {
        descriptions.add(description);
        if (suppressedExceptions.size() < 5) {
            suppressedExceptions.add(t);
        }
    }

    private static void asyncRename(HdfsEnvironment hdfsEnvironment, Executor executor, AtomicBoolean cancelled, List<CompletableFuture<?>> fileRenameFutures, HdfsEnvironment.HdfsContext context, Path currentPath, Path targetPath, List<String> fileNames) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, currentPath);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files to final location. Error listing directory %s", currentPath), (Throwable)e);
        }
        for (String fileName : fileNames) {
            Path source = new Path(currentPath, fileName);
            Path target = new Path(targetPath, fileName);
            fileRenameFutures.add(CompletableFuture.runAsync(() -> {
                if (cancelled.get()) {
                    return;
                }
                try {
                    if (fileSystem.exists(target)) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files from %s to final location %s: target location already exists", source, target));
                    }
                    if (!fileSystem.rename(source, target)) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files from %s to final location %s: rename not successful", source, target));
                    }
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files from %s to final location %s", source, target), (Throwable)e);
                }
            }, executor));
        }
    }

    private void recursiveDeleteFilesAndLog(HdfsEnvironment.HdfsContext context, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories, String reason) {
        RecursiveDeleteResult recursiveDeleteResult = SemiTransactionalHiveMetastore.recursiveDeleteFiles(this.hdfsEnvironment, context, directory, queryIds, deleteEmptyDirectories);
        if (!recursiveDeleteResult.getNotDeletedEligibleItems().isEmpty()) {
            this.logCleanupFailure("Error deleting directory %s for %s. Some eligible items cannot be deleted: %s.", directory.toString(), reason, recursiveDeleteResult.getNotDeletedEligibleItems());
        } else if (deleteEmptyDirectories && !recursiveDeleteResult.isDirectoryNoLongerExists()) {
            this.logCleanupFailure("Error deleting directory %s for %s. Cannot delete the directory.", directory.toString(), reason);
        }
    }

    private static RecursiveDeleteResult recursiveDeleteFiles(HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext context, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, directory);
            if (!fileSystem.exists(directory)) {
                return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
            }
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(directory.toString() + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        return SemiTransactionalHiveMetastore.doRecursiveDeleteFiles(fileSystem, directory, queryIds, deleteEmptyDirectories);
    }

    private static RecursiveDeleteResult doRecursiveDeleteFiles(FileSystem fileSystem, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        FileStatus[] allFiles;
        if (directory.getName().startsWith(".trino")) {
            return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of());
        }
        try {
            allFiles = fileSystem.listStatus(directory);
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(directory + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        boolean allDescendentsDeleted = true;
        ImmutableList.Builder notDeletedEligibleItems = ImmutableList.builder();
        for (FileStatus fileStatus : allFiles) {
            if (fileStatus.isFile()) {
                Path filePath = fileStatus.getPath();
                String fileName = filePath.getName();
                boolean eligible = false;
                if (!fileName.startsWith(".trino")) {
                    eligible = queryIds.stream().anyMatch(id -> HiveWriteUtils.isFileCreatedByQuery(fileName, id));
                }
                if (eligible) {
                    if (SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, filePath, false)) continue;
                    allDescendentsDeleted = false;
                    notDeletedEligibleItems.add((Object)filePath.toString());
                    continue;
                }
                allDescendentsDeleted = false;
                continue;
            }
            if (fileStatus.isDirectory()) {
                RecursiveDeleteResult subResult = SemiTransactionalHiveMetastore.doRecursiveDeleteFiles(fileSystem, fileStatus.getPath(), queryIds, deleteEmptyDirectories);
                if (!subResult.isDirectoryNoLongerExists()) {
                    allDescendentsDeleted = false;
                }
                if (subResult.getNotDeletedEligibleItems().isEmpty()) continue;
                notDeletedEligibleItems.addAll(subResult.getNotDeletedEligibleItems());
                continue;
            }
            allDescendentsDeleted = false;
            notDeletedEligibleItems.add((Object)fileStatus.getPath().toString());
        }
        if (allDescendentsDeleted && (deleteEmptyDirectories || DELTA_DIRECTORY_MATCHER.matcher(directory.getName()).matches())) {
            Verify.verify((boolean)notDeletedEligibleItems.build().isEmpty());
            if (!SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, directory, false)) {
                return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of((Object)(directory + "/")));
            }
            return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
        }
        return new RecursiveDeleteResult(false, (List<String>)notDeletedEligibleItems.build());
    }

    private static boolean deleteIfExists(FileSystem fileSystem, Path path, boolean recursive) {
        try {
            if (fileSystem.delete(path, recursive)) {
                return true;
            }
            return !fileSystem.exists(path);
        }
        catch (FileNotFoundException ignored) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean deleteRecursivelyIfExists(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, path);
        }
        catch (IOException ignored) {
            return false;
        }
        return SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, path, true);
    }

    private static void renameDirectory(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path source, Path target, Runnable runWhenPathDoesntExist) {
        if (HiveWriteUtils.pathExists(context, hdfsEnvironment, target)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to rename from %s to %s: target directory already exists", source, target));
        }
        if (!HiveWriteUtils.pathExists(context, hdfsEnvironment, target.getParent())) {
            HiveWriteUtils.createDirectory(context, hdfsEnvironment, target.getParent());
        }
        runWhenPathDoesntExist.run();
        try {
            if (!hdfsEnvironment.getFileSystem(context, source).rename(source, target)) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s: rename returned false", source, target));
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s", source, target), (Throwable)e);
        }
    }

    private static Optional<String> getPrestoQueryId(Table table) {
        return Optional.ofNullable(table.getParameters().get("presto_query_id"));
    }

    private static Optional<String> getPrestoQueryId(Partition partition) {
        return Optional.ofNullable(partition.getParameters().get("presto_query_id"));
    }

    private void checkHoldsLock() {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException(String.format("Thread must hold a lock on the %s", this.getClass().getSimpleName()));
        }
    }

    private long allocateWriteId(String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(dbName, tableName, transactionId);
    }

    private void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isPartitioned) {
        this.delegate.acquireTableWriteLock(transactionOwner, queryId, transactionId, dbName, tableName, operation, isPartitioned);
    }

    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        this.delegate.updateTableWriteId(dbName, tableName, transactionId, writeId, rowCountChange);
    }

    public void alterPartitions(String dbName, String tableName, List<Partition> partitions, long writeId) {
        this.delegate.alterPartitions(dbName, tableName, partitions, writeId);
    }

    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        this.delegate.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation);
    }

    public void commitTransaction(long transactionId) {
        this.delegate.commitTransaction(transactionId);
    }

    public static void cleanExtraOutputFiles(HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext hdfsContext, String queryId, Path path, Set<String> filesToKeep) {
        LinkedList<String> filesToDelete = new LinkedList<String>();
        try {
            log.debug("Deleting failed attempt files from %s for query %s", new Object[]{path, queryId});
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(hdfsContext, path);
            if (!fileSystem.exists(path)) {
                return;
            }
            RemoteIterator iterator = fileSystem.listFiles(path, false);
            while (iterator.hasNext()) {
                Path file = ((LocatedFileStatus)iterator.next()).getPath();
                if (!HiveWriteUtils.isFileCreatedByQuery(file.getName(), queryId) || filesToKeep.contains(file.getName())) continue;
                filesToDelete.add(file.getName());
            }
            ImmutableList.Builder deletedFilesBuilder = ImmutableList.builder();
            Iterator filesToDeleteIterator = filesToDelete.iterator();
            while (filesToDeleteIterator.hasNext()) {
                String fileName = (String)filesToDeleteIterator.next();
                Path filePath = new Path(path, fileName);
                log.debug("Deleting failed attempt file %s for query %s", new Object[]{filePath, queryId});
                DELETE_RETRY.run("delete " + filePath, () -> {
                    HiveWriteUtils.checkedDelete(fileSystem, filePath, false);
                    return null;
                });
                deletedFilesBuilder.add((Object)fileName);
                filesToDeleteIterator.remove();
            }
            ImmutableList deletedFiles = deletedFilesBuilder.build();
            if (!deletedFiles.isEmpty()) {
                log.info("Deleted failed attempt files %s from %s for query %s", new Object[]{deletedFiles, path, queryId});
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error deleting failed retry attempt files from %s; remaining files %s; manual cleanup may be required", path, filesToDelete), (Throwable)e);
        }
    }

    private static enum State {
        EMPTY,
        SHARED_OPERATION_BUFFERED,
        EXCLUSIVE_OPERATION_BUFFERED,
        FINISHED;

    }

    public static class Action<T> {
        private final ActionType type;
        private final T data;
        private final HdfsEnvironment.HdfsContext hdfsContext;
        private final String queryId;

        public Action(ActionType type, T data, HdfsEnvironment.HdfsContext hdfsContext, String queryId) {
            this.type = Objects.requireNonNull(type, "type is null");
            if (type == ActionType.DROP || type == ActionType.DROP_PRESERVE_DATA) {
                Preconditions.checkArgument((data == null ? 1 : 0) != 0, (Object)"data is not null");
            } else {
                Objects.requireNonNull(data, "data is null");
            }
            this.data = data;
            this.hdfsContext = Objects.requireNonNull(hdfsContext, "hdfsContext is null");
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        }

        public ActionType getType() {
            return this.type;
        }

        public T getData() {
            Preconditions.checkState((this.type != ActionType.DROP ? 1 : 0) != 0);
            return this.data;
        }

        public HdfsEnvironment.HdfsContext getHdfsContext() {
            return this.hdfsContext;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("queryId", (Object)this.queryId).add("data", this.data).toString();
        }
    }

    private static enum ActionType {
        DROP,
        DROP_PRESERVE_DATA,
        ADD,
        ALTER,
        INSERT_EXISTING,
        DELETE_ROWS,
        UPDATE;

    }

    private static class TableAndMore {
        private final Table table;
        private final Optional<PrincipalPrivileges> principalPrivileges;
        private final Optional<Path> currentLocation;
        private final Optional<List<String>> fileNames;
        private final boolean ignoreExisting;
        private final PartitionStatistics statistics;
        private final PartitionStatistics statisticsUpdate;
        private final boolean cleanExtraOutputFilesOnCommit;

        public TableAndMore(Table table, Optional<PrincipalPrivileges> principalPrivileges, Optional<Path> currentLocation, Optional<List<String>> fileNames, boolean ignoreExisting, PartitionStatistics statistics, PartitionStatistics statisticsUpdate, boolean cleanExtraOutputFilesOnCommit) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.principalPrivileges = Objects.requireNonNull(principalPrivileges, "principalPrivileges is null");
            this.currentLocation = Objects.requireNonNull(currentLocation, "currentLocation is null");
            this.fileNames = Objects.requireNonNull(fileNames, "fileNames is null");
            this.ignoreExisting = ignoreExisting;
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.statisticsUpdate = Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
            this.cleanExtraOutputFilesOnCommit = cleanExtraOutputFilesOnCommit;
            Preconditions.checkArgument((!table.getStorage().getOptionalLocation().orElse("").isEmpty() || currentLocation.isEmpty() ? 1 : 0) != 0, (Object)"currentLocation cannot be supplied for table without location");
            Preconditions.checkArgument((fileNames.isEmpty() || currentLocation.isPresent() ? 1 : 0) != 0, (Object)"fileNames can be supplied only when currentLocation is supplied");
        }

        public boolean isIgnoreExisting() {
            return this.ignoreExisting;
        }

        public Table getTable() {
            return this.table;
        }

        public PrincipalPrivileges getPrincipalPrivileges() {
            Preconditions.checkState((boolean)this.principalPrivileges.isPresent());
            return this.principalPrivileges.get();
        }

        public Optional<Path> getCurrentLocation() {
            return this.currentLocation;
        }

        public Optional<List<String>> getFileNames() {
            return this.fileNames;
        }

        public PartitionStatistics getStatistics() {
            return this.statistics;
        }

        public PartitionStatistics getStatisticsUpdate() {
            return this.statisticsUpdate;
        }

        public boolean isCleanExtraOutputFilesOnCommit() {
            return this.cleanExtraOutputFilesOnCommit;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("principalPrivileges", this.principalPrivileges).add("currentLocation", this.currentLocation).add("fileNames", this.fileNames).add("ignoreExisting", this.ignoreExisting).add("statistics", (Object)this.statistics).add("statisticsUpdate", (Object)this.statisticsUpdate).add("cleanExtraOutputFilesOnCommit", this.cleanExtraOutputFilesOnCommit).toString();
        }
    }

    private static enum TableSource {
        CREATED_IN_THIS_TRANSACTION,
        PRE_EXISTING_TABLE;

    }

    private static class PartitionAndMore {
        private final Partition partition;
        private final Path currentLocation;
        private final Optional<List<String>> fileNames;
        private final PartitionStatistics statistics;
        private final PartitionStatistics statisticsUpdate;
        private final boolean cleanExtraOutputFilesOnCommit;

        public PartitionAndMore(Partition partition, Path currentLocation, Optional<List<String>> fileNames, PartitionStatistics statistics, PartitionStatistics statisticsUpdate, boolean cleanExtraOutputFilesOnCommit) {
            this.partition = Objects.requireNonNull(partition, "partition is null");
            this.currentLocation = Objects.requireNonNull(currentLocation, "currentLocation is null");
            this.fileNames = Objects.requireNonNull(fileNames, "fileNames is null");
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.statisticsUpdate = Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
            this.cleanExtraOutputFilesOnCommit = cleanExtraOutputFilesOnCommit;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public Path getCurrentLocation() {
            return this.currentLocation;
        }

        public List<String> getFileNames() {
            Preconditions.checkState((boolean)this.fileNames.isPresent());
            return this.fileNames.get();
        }

        public boolean hasFileNames() {
            return this.fileNames.isPresent();
        }

        public PartitionStatistics getStatistics() {
            return this.statistics;
        }

        public PartitionStatistics getStatisticsUpdate() {
            return this.statisticsUpdate;
        }

        public boolean isCleanExtraOutputFilesOnCommit() {
            return this.cleanExtraOutputFilesOnCommit;
        }

        public Partition getAugmentedPartitionForInTransactionRead() {
            Partition partition = this.partition;
            String currentLocation = this.currentLocation.toString();
            if (!currentLocation.equals(partition.getStorage().getLocation())) {
                partition = Partition.builder(partition).withStorage(storage -> storage.setLocation(currentLocation)).build();
            }
            return partition;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partition", (Object)this.partition).add("currentLocation", (Object)this.currentLocation).add("fileNames", this.fileNames).add("cleanExtraOutputFilesOnCommit", this.cleanExtraOutputFilesOnCommit).toString();
        }
    }

    private static interface ExclusiveOperation {
        public void execute(HiveMetastoreClosure var1, HdfsEnvironment var2);
    }

    private static class TableAndAcidDirectories
    extends TableAndMore {
        private final List<PartitionAndStatementId> partitionAndStatementIds;

        public TableAndAcidDirectories(Table table, Optional<PrincipalPrivileges> principalPrivileges, Optional<Path> currentLocation, List<PartitionAndStatementId> partitionAndStatementIds) {
            super(table, principalPrivileges, currentLocation, Optional.empty(), false, PartitionStatistics.empty(), PartitionStatistics.empty(), false);
            this.partitionAndStatementIds = partitionAndStatementIds;
        }

        public List<PartitionAndStatementId> getPartitionAndStatementIds() {
            return this.partitionAndStatementIds;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.getTable()).add("partitionAndStatementIds", this.partitionAndStatementIds).add("principalPrivileges", (Object)this.getPrincipalPrivileges()).add("currentLocation", this.getCurrentLocation()).toString();
        }
    }

    private static class DeclaredIntentionToWrite {
        private final String declarationId;
        private final LocationHandle.WriteMode mode;
        private final HdfsEnvironment.HdfsContext hdfsContext;
        private final String queryId;
        private final Path rootPath;
        private final SchemaTableName schemaTableName;

        public DeclaredIntentionToWrite(String declarationId, LocationHandle.WriteMode mode, HdfsEnvironment.HdfsContext hdfsContext, String queryId, Path stagingPathRoot, SchemaTableName schemaTableName) {
            this.declarationId = Objects.requireNonNull(declarationId, "declarationId is null");
            this.mode = Objects.requireNonNull(mode, "mode is null");
            this.hdfsContext = Objects.requireNonNull(hdfsContext, "hdfsContext is null");
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.rootPath = Objects.requireNonNull(stagingPathRoot, "stagingPathRoot is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        public String getDeclarationId() {
            return this.declarationId;
        }

        public LocationHandle.WriteMode getMode() {
            return this.mode;
        }

        public HdfsEnvironment.HdfsContext getHdfsContext() {
            return this.hdfsContext;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public Path getRootPath() {
            return this.rootPath;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).add("hdfsContext", (Object)this.hdfsContext).add("queryId", (Object)this.queryId).add("rootPath", (Object)this.rootPath).add("schemaTableName", (Object)this.schemaTableName).toString();
        }
    }

    private class Committer {
        private final AtomicBoolean fileRenameCancelled = new AtomicBoolean(false);
        private final List<CompletableFuture<?>> fileRenameFutures = new ArrayList();
        private final List<DirectoryDeletionTask> deletionTasksForFinish = new ArrayList<DirectoryDeletionTask>();
        private final List<DirectoryCleanUpTask> cleanUpTasksForAbort = new ArrayList<DirectoryCleanUpTask>();
        private final List<DirectoryRenameTask> renameTasksForAbort = new ArrayList<DirectoryRenameTask>();
        private final Set<Table> tablesToInvalidate = new LinkedHashSet<Table>();
        private final Set<Partition> partitionsToInvalidate = new LinkedHashSet<Partition>();
        private final List<CreateTableOperation> addTableOperations = new ArrayList<CreateTableOperation>();
        private final List<AlterTableOperation> alterTableOperations = new ArrayList<AlterTableOperation>();
        private final Map<SchemaTableName, PartitionAdder> partitionAdders = new HashMap<SchemaTableName, PartitionAdder>();
        private final List<AlterPartitionOperation> alterPartitionOperations = new ArrayList<AlterPartitionOperation>();
        private final List<UpdateStatisticsOperation> updateStatisticsOperations = new ArrayList<UpdateStatisticsOperation>();
        private final List<IrreversibleMetastoreOperation> metastoreDeleteOperations = new ArrayList<IrreversibleMetastoreOperation>();
        private final AcidTransaction transaction;
        private boolean deleteOnly = true;

        Committer(AcidTransaction transaction) {
            this.transaction = transaction;
        }

        private void prepareDropTable(SchemaTableName schemaTableName) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop table %s", schemaTableName), () -> {
                Optional<Table> droppedTable = SemiTransactionalHiveMetastore.this.delegate.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
                try {
                    SemiTransactionalHiveMetastore.this.delegate.dropTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), true);
                }
                finally {
                    droppedTable.ifPresent(SemiTransactionalHiveMetastore.this.tableInvalidationCallback::invalidate);
                }
            }));
        }

        private void prepareAlterTable(HdfsEnvironment.HdfsContext hdfsContext, String queryId, TableAndMore tableAndMore) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            String targetLocation = table.getStorage().getLocation();
            Table oldTable = SemiTransactionalHiveMetastore.this.delegate.getTable(table.getDatabaseName(), table.getTableName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "The table that this transaction modified was deleted in another transaction. " + table.getSchemaTableName()));
            String oldTableLocation = oldTable.getStorage().getLocation();
            Path oldTablePath = new Path(oldTableLocation);
            this.tablesToInvalidate.add(oldTable);
            this.cleanExtraOutputFiles(hdfsContext, queryId, tableAndMore);
            if (targetLocation.equals(oldTableLocation)) {
                Path oldTableStagingPath = new Path(oldTablePath.getParent(), "_temp_" + oldTablePath.getName() + "_" + queryId);
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, oldTablePath, oldTableStagingPath, () -> this.renameTasksForAbort.add(new DirectoryRenameTask(hdfsContext, oldTableStagingPath, oldTablePath)));
                if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                    this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldTableStagingPath));
                }
            } else if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldTablePath));
            }
            Path currentPath = tableAndMore.getCurrentLocation().orElseThrow(() -> new IllegalArgumentException("location should be present for alter table"));
            Path targetPath = new Path(targetLocation);
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true)));
            }
            this.alterTableOperations.add(new AlterTableOperation(tableAndMore.getTable(), oldTable, tableAndMore.getPrincipalPrivileges()));
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), false));
        }

        private void prepareAddTable(HdfsEnvironment.HdfsContext context, String queryId, TableAndMore tableAndMore) {
            Optional<String> targetLocation;
            this.deleteOnly = false;
            this.cleanExtraOutputFiles(context, queryId, tableAndMore);
            Table table = tableAndMore.getTable();
            if (table.getTableType().equals(TableType.MANAGED_TABLE.name()) && (targetLocation = table.getStorage().getOptionalLocation()).isPresent()) {
                Preconditions.checkArgument((!targetLocation.get().isEmpty() ? 1 : 0) != 0, (Object)"target location is empty");
                Optional<Path> currentPath = tableAndMore.getCurrentLocation();
                Path targetPath = new Path(targetLocation.get());
                if (table.getPartitionColumns().isEmpty() && currentPath.isPresent()) {
                    if (!targetPath.equals((Object)currentPath.get())) {
                        SemiTransactionalHiveMetastore.renameDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath.get(), targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true)));
                    }
                } else if (HiveWriteUtils.pathExists(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath)) {
                    if (!currentPath.isPresent() || !currentPath.get().equals((Object)targetPath)) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to create directory %s: target directory already exists", targetPath));
                    }
                } else {
                    this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true));
                    HiveWriteUtils.createDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath);
                }
            }
            this.addTableOperations.add(new CreateTableOperation(table, tableAndMore.getPrincipalPrivileges(), tableAndMore.isIgnoreExisting(), tableAndMore.getStatisticsUpdate()));
        }

        private void prepareInsertExistingTable(HdfsEnvironment.HdfsContext context, String queryId, TableAndMore tableAndMore) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            Path targetPath = new Path(table.getStorage().getLocation());
            this.tablesToInvalidate.add(table);
            Path currentPath = tableAndMore.getCurrentLocation().orElseThrow();
            this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, false));
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.asyncRename(SemiTransactionalHiveMetastore.this.hdfsEnvironment, SemiTransactionalHiveMetastore.this.renameExecutor, this.fileRenameCancelled, this.fileRenameFutures, context, currentPath, targetPath, tableAndMore.getFileNames().orElseThrow());
            } else {
                this.cleanExtraOutputFiles(context, queryId, tableAndMore);
            }
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), true));
            if (SemiTransactionalHiveMetastore.this.isAcidTransactionRunning()) {
                AcidTransaction transaction = SemiTransactionalHiveMetastore.this.getCurrentAcidTransaction();
                SemiTransactionalHiveMetastore.this.updateTableWriteId(table.getDatabaseName(), table.getTableName(), transaction.getAcidTransactionId(), transaction.getWriteId(), OptionalLong.empty());
            }
        }

        private void prepareDeleteRowsFromExistingTable(HdfsEnvironment.HdfsContext context, TableAndMore tableAndMore) {
            String tableName;
            TableAndAcidDirectories deletionState = (TableAndAcidDirectories)tableAndMore;
            List<PartitionAndStatementId> partitionAndStatementIds = deletionState.getPartitionAndStatementIds();
            Preconditions.checkArgument((!partitionAndStatementIds.isEmpty() ? 1 : 0) != 0, (Object)"partitionAndStatementIds is empty");
            this.deleteOnly = false;
            Table table = deletionState.getTable();
            this.tablesToInvalidate.add(table);
            Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.this.currentHiveTransaction.isPresent(), (Object)"currentHiveTransaction isn't present");
            AcidTransaction transaction = SemiTransactionalHiveMetastore.this.currentHiveTransaction.get().getTransaction();
            Preconditions.checkArgument((boolean)transaction.isDelete(), (String)"transaction should be delete, but is %s", (Object)transaction);
            this.cleanUpTasksForAbort.addAll((Collection)deletionState.getPartitionAndStatementIds().stream().map(ps -> new DirectoryCleanUpTask(context, new Path(ps.getDeleteDeltaDirectory()), true)).collect(ImmutableList.toImmutableList()));
            HashMap<String, Long> partitionRowCounts = new HashMap<String, Long>(partitionAndStatementIds.size());
            int totalRowsDeleted = 0;
            for (PartitionAndStatementId ps2 : partitionAndStatementIds) {
                long rowCount = ps2.getRowCount();
                partitionRowCounts.compute(ps2.getPartitionName(), (k, count) -> count != null ? count + rowCount : rowCount);
            }
            String databaseName = table.getDatabaseName();
            PartitionStatistics tableStatistics = SemiTransactionalHiveMetastore.this.getTableStatistics(databaseName, tableName = table.getTableName());
            HiveBasicStatistics basicStatistics = tableStatistics.getBasicStatistics();
            if (basicStatistics.getRowCount().isPresent()) {
                tableStatistics = tableStatistics.withAdjustedRowCount(-totalRowsDeleted);
                this.updateStatisticsOperations.add(new UpdateStatisticsOperation(table.getSchemaTableName(), Optional.empty(), tableStatistics, true));
            }
            if (table.getParameters() != null && table.getParameters().get("numRows") != null) {
                Table updatedTable = Table.builder(table).setParameters(MetastoreUtil.adjustRowCount(table.getParameters(), "decrement table rows", -totalRowsDeleted)).setWriteId(OptionalLong.of(transaction.getWriteId())).build();
                this.alterTableOperations.add(new AlterTableOperation(updatedTable, table, tableAndMore.getPrincipalPrivileges()));
            }
            Map<String, Optional<Partition>> partitionsOptionalMap = SemiTransactionalHiveMetastore.this.getPartitionsByNames(databaseName, tableName, new ArrayList<String>(partitionRowCounts.keySet()));
            HashMap<String, Partition> updatedPartitions = new HashMap<String, Partition>(partitionsOptionalMap.size());
            for (Map.Entry<String, Optional<Partition>> entry : partitionsOptionalMap.entrySet()) {
                Partition partition;
                String partitionId2 = entry.getKey();
                if (!entry.getValue().isPresent() || !(partition = entry.getValue().get()).getParameters().containsKey("numRows")) continue;
                Long rowCounter = (Long)partitionRowCounts.get(partitionId2);
                Objects.requireNonNull(rowCounter, "rowCounter is null");
                updatedPartitions.put(partitionId2, partition.withAdjustedRowCount(partitionId2, -rowCounter.longValue()));
            }
            Map<String, PartitionStatistics> allPartitionStatistics = SemiTransactionalHiveMetastore.this.getPartitionStatistics(databaseName, tableName, updatedPartitions.keySet());
            allPartitionStatistics.forEach((partitionId, statistics) -> {
                Long rowCount = (Long)partitionRowCounts.get(partitionId);
                Objects.requireNonNull(rowCount, "rowCount is null");
                PartitionStatistics updatedStatistics = statistics.withAdjustedRowCount(-rowCount.longValue());
                Objects.requireNonNull(updatedStatistics, "updatedStatistics is null");
                Partition updatedPartition = (Partition)updatedPartitions.get(partitionId);
                Objects.requireNonNull(updatedPartition, "updatedPartition is null");
                Partition originalPartition = (Partition)((Optional)partitionsOptionalMap.get(partitionId)).orElseThrow();
                this.alterPartitionOperations.add(new AlterPartitionOperation(new PartitionWithStatistics(updatedPartition, (String)partitionId, updatedStatistics), new PartitionWithStatistics(originalPartition, (String)partitionId, (PartitionStatistics)statistics)));
                this.updateStatisticsOperations.add(new UpdateStatisticsOperation(table.getSchemaTableName(), Optional.of(partitionId), updatedStatistics, false));
            });
            long writeId = transaction.getWriteId();
            long transactionId = transaction.getAcidTransactionId();
            if (!updatedPartitions.isEmpty()) {
                SemiTransactionalHiveMetastore.this.alterPartitions(databaseName, tableName, (List<Partition>)ImmutableList.copyOf(updatedPartitions.values()), writeId);
                SemiTransactionalHiveMetastore.this.addDynamicPartitions(databaseName, tableName, (List<String>)ImmutableList.copyOf(updatedPartitions.keySet()), transactionId, writeId, AcidOperation.DELETE);
            }
            SemiTransactionalHiveMetastore.this.updateTableWriteId(databaseName, tableName, transactionId, writeId, OptionalLong.of(-totalRowsDeleted));
        }

        private void prepareUpdateExistingTable(HdfsEnvironment.HdfsContext context, TableAndMore tableAndMore) {
            TableAndAcidDirectories updateState = (TableAndAcidDirectories)tableAndMore;
            List<PartitionAndStatementId> partitionAndStatementIds = updateState.getPartitionAndStatementIds();
            Preconditions.checkArgument((!partitionAndStatementIds.isEmpty() ? 1 : 0) != 0, (Object)"partitionAndStatementIds is empty");
            Table table = updateState.getTable();
            this.tablesToInvalidate.add(table);
            Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.this.currentHiveTransaction.isPresent(), (Object)"currentHiveTransaction isn't present");
            AcidTransaction transaction = SemiTransactionalHiveMetastore.this.currentHiveTransaction.get().getTransaction();
            Preconditions.checkArgument((boolean)transaction.isUpdate(), (String)"transaction should be update, but is %s", (Object)transaction);
            updateState.getPartitionAndStatementIds().stream().flatMap(ps -> ps.getAllDirectories().stream()).forEach(directory -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, new Path(directory), true)));
            String databaseName = table.getDatabaseName();
            String tableName = table.getTableName();
            long writeId = transaction.getWriteId();
            long transactionId = transaction.getAcidTransactionId();
            SemiTransactionalHiveMetastore.this.updateTableWriteId(databaseName, tableName, transactionId, writeId, OptionalLong.empty());
        }

        private void prepareDropPartition(SchemaTableName schemaTableName, List<String> partitionValues, boolean deleteData) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop partition %s.%s %s", schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues), () -> {
                Optional<Partition> droppedPartition = SemiTransactionalHiveMetastore.this.delegate.getPartition(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues);
                try {
                    SemiTransactionalHiveMetastore.this.delegate.dropPartition(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues, deleteData);
                }
                finally {
                    droppedPartition.ifPresent(SemiTransactionalHiveMetastore.this.tableInvalidationCallback::invalidate);
                }
            }));
        }

        private void prepareAlterPartition(HdfsEnvironment.HdfsContext hdfsContext, String queryId, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            this.partitionsToInvalidate.add(partition);
            String targetLocation = partition.getStorage().getLocation();
            Optional<Partition> oldPartition = SemiTransactionalHiveMetastore.this.delegate.getPartition(partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            if (oldPartition.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues()));
            }
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            PartitionStatistics oldPartitionStatistics = this.getExistingPartitionStatistics(partition, partitionName);
            String oldPartitionLocation = oldPartition.get().getStorage().getLocation();
            Path oldPartitionPath = new Path(oldPartitionLocation);
            this.cleanExtraOutputFiles(hdfsContext, queryId, partitionAndMore);
            if (targetLocation.equals(oldPartitionLocation)) {
                Path oldPartitionStagingPath = new Path(oldPartitionPath.getParent(), "_temp_" + oldPartitionPath.getName() + "_" + queryId);
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, oldPartitionPath, oldPartitionStagingPath, () -> this.renameTasksForAbort.add(new DirectoryRenameTask(hdfsContext, oldPartitionStagingPath, oldPartitionPath)));
                if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                    this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldPartitionStagingPath));
                }
            } else if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldPartitionPath));
            }
            Path currentPath = partitionAndMore.getCurrentLocation();
            Path targetPath = new Path(targetLocation);
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true)));
            }
            this.alterPartitionOperations.add(new AlterPartitionOperation(new PartitionWithStatistics(partition, partitionName, partitionAndMore.getStatisticsUpdate()), new PartitionWithStatistics(oldPartition.get(), partitionName, oldPartitionStatistics)));
        }

        private void cleanExtraOutputFiles(HdfsEnvironment.HdfsContext hdfsContext, String queryId, PartitionAndMore partitionAndMore) {
            if (!partitionAndMore.isCleanExtraOutputFilesOnCommit()) {
                return;
            }
            Verify.verify((boolean)partitionAndMore.hasFileNames(), (String)"fileNames expected to be set if isCleanExtraOutputFilesOnCommit is true", (Object[])new Object[0]);
            SemiTransactionalHiveMetastore.cleanExtraOutputFiles(SemiTransactionalHiveMetastore.this.hdfsEnvironment, hdfsContext, queryId, partitionAndMore.getCurrentLocation(), (Set<String>)ImmutableSet.copyOf(partitionAndMore.getFileNames()));
        }

        private void cleanExtraOutputFiles(HdfsEnvironment.HdfsContext hdfsContext, String queryId, TableAndMore tableAndMore) {
            if (!tableAndMore.isCleanExtraOutputFilesOnCommit()) {
                return;
            }
            Path tableLocation = tableAndMore.getCurrentLocation().orElseThrow(() -> new IllegalArgumentException("currentLocation expected to be set if isCleanExtraOutputFilesOnCommit is true"));
            List<String> files = tableAndMore.getFileNames().orElseThrow(() -> new IllegalArgumentException("fileNames expected to be set if isCleanExtraOutputFilesOnCommit is true"));
            SemiTransactionalHiveMetastore.cleanExtraOutputFiles(SemiTransactionalHiveMetastore.this.hdfsEnvironment, hdfsContext, queryId, tableLocation, (Set<String>)ImmutableSet.copyOf(files));
        }

        private PartitionStatistics getExistingPartitionStatistics(Partition partition, String partitionName) {
            try {
                PartitionStatistics statistics = SemiTransactionalHiveMetastore.this.delegate.getPartitionStatistics(partition.getDatabaseName(), partition.getTableName(), (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName);
                if (statistics == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues()));
                }
                return statistics;
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode())) {
                    log.warn((Throwable)e, "Corrupted statistics found when altering partition. Table: %s.%s. Partition: %s", new Object[]{partition.getDatabaseName(), partition.getTableName(), partition.getValues()});
                    return PartitionStatistics.empty();
                }
                throw e;
            }
        }

        private void prepareAddPartition(HdfsEnvironment.HdfsContext hdfsContext, String queryId, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            String targetLocation = partition.getStorage().getLocation();
            Path currentPath = partitionAndMore.getCurrentLocation();
            Path targetPath = new Path(targetLocation);
            this.cleanExtraOutputFiles(hdfsContext, queryId, partitionAndMore);
            PartitionAdder partitionAdder = this.partitionAdders.computeIfAbsent(partition.getSchemaTableName(), ignored -> new PartitionAdder(partition.getDatabaseName(), partition.getTableName(), SemiTransactionalHiveMetastore.this.delegate, 8));
            if (HiveWriteUtils.pathExists(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath)) {
                if (!targetPath.equals((Object)currentPath)) {
                    SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true)));
                }
            } else {
                this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true));
                HiveWriteUtils.createDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath);
            }
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            partitionAdder.addPartition(new PartitionWithStatistics(partition, partitionName, partitionAndMore.getStatisticsUpdate()));
        }

        private void prepareInsertExistingPartition(HdfsEnvironment.HdfsContext hdfsContext, String queryId, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            this.partitionsToInvalidate.add(partition);
            Path targetPath = new Path(partition.getStorage().getLocation());
            Path currentPath = partitionAndMore.getCurrentLocation();
            this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, false));
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.asyncRename(SemiTransactionalHiveMetastore.this.hdfsEnvironment, SemiTransactionalHiveMetastore.this.renameExecutor, this.fileRenameCancelled, this.fileRenameFutures, hdfsContext, currentPath, targetPath, partitionAndMore.getFileNames());
            } else {
                this.cleanExtraOutputFiles(hdfsContext, queryId, partitionAndMore);
            }
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(partition.getSchemaTableName(), Optional.of(SemiTransactionalHiveMetastore.this.getPartitionName(partition.getDatabaseName(), partition.getTableName(), partition.getValues())), partitionAndMore.getStatisticsUpdate(), true));
        }

        private void executeCleanupTasksForAbort(Collection<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            Set queryIds = (Set)declaredIntentionsToWrite.stream().map(DeclaredIntentionToWrite::getQueryId).collect(ImmutableSet.toImmutableSet());
            for (DirectoryCleanUpTask cleanUpTask : this.cleanUpTasksForAbort) {
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(cleanUpTask.getContext(), cleanUpTask.getPath(), queryIds, cleanUpTask.isDeleteEmptyDirectory(), "temporary directory commit abort");
            }
        }

        private void executeDeletionTasksForFinish() {
            for (DirectoryDeletionTask deletionTask : this.deletionTasksForFinish) {
                if (SemiTransactionalHiveMetastore.deleteRecursivelyIfExists(deletionTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, deletionTask.getPath())) continue;
                SemiTransactionalHiveMetastore.this.logCleanupFailure("Error deleting directory %s", deletionTask.getPath());
            }
        }

        private void executeRenameTasksForAbort() {
            for (DirectoryRenameTask directoryRenameTask : this.renameTasksForAbort) {
                try {
                    if (!HiveWriteUtils.pathExists(directoryRenameTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, directoryRenameTask.getRenameFrom())) continue;
                    SemiTransactionalHiveMetastore.renameDirectory(directoryRenameTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, directoryRenameTask.getRenameFrom(), directoryRenameTask.getRenameTo(), () -> {});
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to undo rename of partition directory: %s to %s", directoryRenameTask.getRenameFrom(), directoryRenameTask.getRenameTo());
                }
            }
        }

        private void pruneAndDeleteStagingDirectories(List<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            for (DeclaredIntentionToWrite declaredIntentionToWrite : declaredIntentionsToWrite) {
                if (declaredIntentionToWrite.getMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) continue;
                Set queryIds = (Set)declaredIntentionsToWrite.stream().map(DeclaredIntentionToWrite::getQueryId).collect(ImmutableSet.toImmutableSet());
                Path path = declaredIntentionToWrite.getRootPath();
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getHdfsContext(), path, queryIds, true, "staging directory cleanup");
            }
        }

        private void waitForAsyncRenames() {
            for (CompletableFuture<?> fileRenameFuture : this.fileRenameFutures) {
                MoreFutures.getFutureValue(fileRenameFuture, TrinoException.class);
            }
        }

        private void waitForAsyncRenamesSuppressThrowables() {
            for (CompletableFuture<?> future : this.fileRenameFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {}
            }
        }

        private void cancelUnstartedAsyncRenames() {
            this.fileRenameCancelled.set(true);
        }

        private void executeAddTableOperations(AcidTransaction transaction) {
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                addTableOperation.run(SemiTransactionalHiveMetastore.this.delegate, transaction);
            }
        }

        private void executeAlterTableOperations() {
            for (AlterTableOperation alterTableOperation : this.alterTableOperations) {
                alterTableOperation.run(SemiTransactionalHiveMetastore.this.delegate, this.transaction);
            }
        }

        private void executeAlterPartitionOperations() {
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                alterPartitionOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAddPartitionOperations(AcidTransaction transaction) {
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                partitionAdder.execute(transaction);
            }
        }

        private void executeUpdateStatisticsOperations(AcidTransaction transaction) {
            ImmutableList.Builder executeUpdateFutures = ImmutableList.builder();
            ArrayList failedUpdateStatisticsOperationDescriptions = new ArrayList();
            ArrayList suppressedExceptions = new ArrayList();
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                executeUpdateFutures.add(CompletableFuture.runAsync(() -> {
                    try {
                        operation.run(SemiTransactionalHiveMetastore.this.delegate, transaction);
                    }
                    catch (Throwable t) {
                        List list = failedUpdateStatisticsOperationDescriptions;
                        synchronized (list) {
                            SemiTransactionalHiveMetastore.addSuppressedExceptions(suppressedExceptions, t, failedUpdateStatisticsOperationDescriptions, operation.getDescription());
                        }
                    }
                }, SemiTransactionalHiveMetastore.this.updateExecutor));
            }
            for (CompletableFuture executeUpdateFuture : executeUpdateFutures.build()) {
                MoreFutures.getFutureValue((Future)executeUpdateFuture);
            }
            if (!suppressedExceptions.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append("All operations other than the following update operations were completed: ");
                Joiner.on((String)"; ").appendTo(message, failedUpdateStatisticsOperationDescriptions);
                TrinoException trinoException = new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, message.toString());
                suppressedExceptions.forEach(trinoException::addSuppressed);
                throw trinoException;
            }
        }

        private void executeTableInvalidationCallback() {
            this.tablesToInvalidate.forEach(SemiTransactionalHiveMetastore.this.tableInvalidationCallback::invalidate);
            this.partitionsToInvalidate.forEach(SemiTransactionalHiveMetastore.this.tableInvalidationCallback::invalidate);
        }

        private void undoAddPartitionOperations() {
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                List<List<String>> partitionsFailedToRollback = partitionAdder.rollback();
                if (partitionsFailedToRollback.isEmpty()) continue;
                SemiTransactionalHiveMetastore.this.logCleanupFailure("Failed to rollback: add_partition for partitions %s.%s %s", partitionAdder.getSchemaName(), partitionAdder.getTableName(), partitionsFailedToRollback);
            }
        }

        private void undoAddTableOperations() {
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                try {
                    addTableOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", addTableOperation.getDescription());
                }
            }
        }

        private void undoAlterTableOperations() {
            for (AlterTableOperation alterTableOperation : this.alterTableOperations) {
                try {
                    alterTableOperation.undo(SemiTransactionalHiveMetastore.this.delegate, this.transaction);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", alterTableOperation.getDescription());
                }
            }
        }

        private void undoAlterPartitionOperations() {
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                try {
                    alterPartitionOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", alterPartitionOperation.getDescription());
                }
            }
        }

        private void undoUpdateStatisticsOperations(AcidTransaction transaction) {
            ImmutableList.Builder undoUpdateFutures = ImmutableList.builder();
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                undoUpdateFutures.add(CompletableFuture.runAsync(() -> {
                    try {
                        operation.undo(SemiTransactionalHiveMetastore.this.delegate, transaction);
                    }
                    catch (Throwable throwable) {
                        SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", operation.getDescription());
                    }
                }, SemiTransactionalHiveMetastore.this.updateExecutor));
            }
            for (CompletableFuture undoUpdateFuture : undoUpdateFutures.build()) {
                MoreFutures.getFutureValue((Future)undoUpdateFuture);
            }
        }

        private void executeIrreversibleMetastoreOperations() {
            ArrayList failedIrreversibleOperationDescriptions = new ArrayList();
            ArrayList suppressedExceptions = new ArrayList();
            AtomicBoolean anySucceeded = new AtomicBoolean(false);
            ImmutableList.Builder dropFutures = ImmutableList.builder();
            for (IrreversibleMetastoreOperation irreversibleMetastoreOperation : this.metastoreDeleteOperations) {
                dropFutures.add(CompletableFuture.runAsync(() -> {
                    try {
                        irreversibleMetastoreOperation.run();
                        anySucceeded.set(true);
                    }
                    catch (Throwable t) {
                        List list = failedIrreversibleOperationDescriptions;
                        synchronized (list) {
                            SemiTransactionalHiveMetastore.addSuppressedExceptions(suppressedExceptions, t, failedIrreversibleOperationDescriptions, irreversibleMetastoreOperation.getDescription());
                        }
                    }
                }, SemiTransactionalHiveMetastore.this.dropExecutor));
            }
            for (CompletableFuture dropFuture : dropFutures.build()) {
                MoreFutures.getFutureValue((Future)dropFuture);
            }
            if (!suppressedExceptions.isEmpty()) {
                StringBuilder message = new StringBuilder();
                if (this.deleteOnly && !anySucceeded.get()) {
                    message.append("The following metastore delete operations failed: ");
                } else {
                    message.append("The transaction didn't commit cleanly. All operations other than the following delete operations were completed: ");
                }
                Joiner.on((String)"; ").appendTo(message, failedIrreversibleOperationDescriptions);
                TrinoException trinoException = new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, message.toString());
                suppressedExceptions.forEach(trinoException::addSuppressed);
                throw trinoException;
            }
        }
    }

    private static class RecursiveDeleteResult {
        private final boolean directoryNoLongerExists;
        private final List<String> notDeletedEligibleItems;

        public RecursiveDeleteResult(boolean directoryNoLongerExists, List<String> notDeletedEligibleItems) {
            this.directoryNoLongerExists = directoryNoLongerExists;
            this.notDeletedEligibleItems = notDeletedEligibleItems;
        }

        public boolean isDirectoryNoLongerExists() {
            return this.directoryNoLongerExists;
        }

        public List<String> getNotDeletedEligibleItems() {
            return this.notDeletedEligibleItems;
        }
    }

    private static class PartitionAdder {
        private final String schemaName;
        private final String tableName;
        private final HiveMetastoreClosure metastore;
        private final int batchSize;
        private final List<PartitionWithStatistics> partitions;
        private List<List<String>> createdPartitionValues = new ArrayList<List<String>>();

        public PartitionAdder(String schemaName, String tableName, HiveMetastoreClosure metastore, int batchSize) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.metastore = metastore;
            this.batchSize = batchSize;
            this.partitions = new ArrayList<PartitionWithStatistics>(batchSize);
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void addPartition(PartitionWithStatistics partition) {
            Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getPrestoQueryId(partition.getPartition()).isPresent());
            this.partitions.add(partition);
        }

        public void execute(AcidTransaction transaction) {
            List batchedPartitions = Lists.partition(this.partitions, (int)this.batchSize);
            for (List batch : batchedPartitions) {
                try {
                    this.metastore.addPartitions(this.schemaName, this.tableName, batch);
                    for (PartitionWithStatistics partition : batch) {
                        this.createdPartitionValues.add(partition.getPartition().getValues());
                    }
                }
                catch (Throwable t) {
                    boolean batchCompletelyAdded = true;
                    for (PartitionWithStatistics partition : batch) {
                        try {
                            Optional<Partition> remotePartition = this.metastore.getPartition(this.schemaName, this.tableName, partition.getPartition().getValues());
                            if (remotePartition.isPresent() && SemiTransactionalHiveMetastore.getPrestoQueryId(remotePartition.get()).equals(SemiTransactionalHiveMetastore.getPrestoQueryId(partition.getPartition()))) {
                                this.createdPartitionValues.add(partition.getPartition().getValues());
                                continue;
                            }
                            batchCompletelyAdded = false;
                        }
                        catch (Throwable ignored) {
                            batchCompletelyAdded = false;
                        }
                    }
                    if (batchCompletelyAdded) continue;
                    if (t instanceof TableNotFoundException) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY, t);
                    }
                    throw t;
                }
            }
            if (transaction.isAcidTransactionRunning()) {
                List<String> partitionNames = this.partitions.stream().map(PartitionWithStatistics::getPartitionName).collect(Collectors.toUnmodifiableList());
                this.metastore.addDynamicPartitions(this.schemaName, this.tableName, partitionNames, transaction.getAcidTransactionId(), transaction.getWriteId(), transaction.getOperation());
            }
            this.partitions.clear();
        }

        public List<List<String>> rollback() {
            ArrayList<List<String>> partitionsFailedToRollback = new ArrayList<List<String>>();
            for (List<String> createdPartitionValue : this.createdPartitionValues) {
                try {
                    this.metastore.dropPartition(this.schemaName, this.tableName, createdPartitionValue, false);
                }
                catch (PartitionNotFoundException partitionNotFoundException) {
                }
                catch (Throwable t) {
                    partitionsFailedToRollback.add(createdPartitionValue);
                }
            }
            this.createdPartitionValues = partitionsFailedToRollback;
            return partitionsFailedToRollback;
        }
    }

    private static class UpdateStatisticsOperation {
        private final SchemaTableName tableName;
        private final Optional<String> partitionName;
        private final PartitionStatistics statistics;
        private final boolean merge;
        private boolean done;

        public UpdateStatisticsOperation(SchemaTableName tableName, Optional<String> partitionName, PartitionStatistics statistics, boolean merge) {
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.merge = merge;
        }

        public void run(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.tableName.getSchemaName(), this.tableName.getTableName(), this.partitionName.get(), this::updateStatistics);
            } else {
                metastore.updateTableStatistics(this.tableName.getSchemaName(), this.tableName.getTableName(), transaction, this::updateStatistics);
            }
            this.done = true;
        }

        public void undo(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            if (!this.done) {
                return;
            }
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.tableName.getSchemaName(), this.tableName.getTableName(), this.partitionName.get(), this::resetStatistics);
            } else {
                metastore.updateTableStatistics(this.tableName.getSchemaName(), this.tableName.getTableName(), transaction, this::resetStatistics);
            }
        }

        public String getDescription() {
            if (this.partitionName.isPresent()) {
                return String.format("replace partition parameters %s %s", this.tableName, this.partitionName.get());
            }
            return String.format("replace table parameters %s", this.tableName);
        }

        private PartitionStatistics updateStatistics(PartitionStatistics currentStatistics) {
            return this.merge ? Statistics.merge(currentStatistics, this.statistics) : this.statistics;
        }

        private PartitionStatistics resetStatistics(PartitionStatistics currentStatistics) {
            return new PartitionStatistics(Statistics.reduce(currentStatistics.getBasicStatistics(), this.statistics.getBasicStatistics(), Statistics.ReduceOperator.SUBTRACT), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        }
    }

    private static class AlterPartitionOperation {
        private final PartitionWithStatistics newPartition;
        private final PartitionWithStatistics oldPartition;
        private boolean undo;

        public AlterPartitionOperation(PartitionWithStatistics newPartition, PartitionWithStatistics oldPartition) {
            this.newPartition = Objects.requireNonNull(newPartition, "newPartition is null");
            this.oldPartition = Objects.requireNonNull(oldPartition, "oldPartition is null");
            Preconditions.checkArgument((boolean)newPartition.getPartition().getDatabaseName().equals(oldPartition.getPartition().getDatabaseName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getTableName().equals(oldPartition.getPartition().getTableName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getValues().equals(oldPartition.getPartition().getValues()));
        }

        public String getDescription() {
            return String.format("alter partition %s.%s %s", this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition.getPartition().getValues());
        }

        public void run(HiveMetastoreClosure metastore) {
            this.undo = true;
            metastore.alterPartition(this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition);
        }

        public void undo(HiveMetastoreClosure metastore) {
            if (!this.undo) {
                return;
            }
            metastore.alterPartition(this.oldPartition.getPartition().getDatabaseName(), this.oldPartition.getPartition().getTableName(), this.oldPartition);
        }
    }

    private static class AlterTableOperation {
        private final Table newTable;
        private final Table oldTable;
        private final PrincipalPrivileges principalPrivileges;
        private boolean undo;

        public AlterTableOperation(Table newTable, Table oldTable, PrincipalPrivileges principalPrivileges) {
            this.newTable = Objects.requireNonNull(newTable, "newTable is null");
            this.oldTable = Objects.requireNonNull(oldTable, "oldTable is null");
            this.principalPrivileges = Objects.requireNonNull(principalPrivileges, "principalPrivileges is null");
            Preconditions.checkArgument((boolean)newTable.getDatabaseName().equals(oldTable.getDatabaseName()));
            Preconditions.checkArgument((boolean)newTable.getTableName().equals(oldTable.getTableName()));
        }

        public String getDescription() {
            return String.format("alter table %s.%s", this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public void run(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            this.undo = true;
            if (transaction.isTransactional()) {
                metastore.alterTransactionalTable(this.newTable, transaction.getAcidTransactionId(), transaction.getWriteId(), this.principalPrivileges);
            } else {
                metastore.replaceTable(this.newTable.getDatabaseName(), this.newTable.getTableName(), this.newTable, this.principalPrivileges);
            }
        }

        public void undo(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            if (!this.undo) {
                return;
            }
            if (transaction.isTransactional()) {
                metastore.alterTransactionalTable(this.oldTable, transaction.getAcidTransactionId(), transaction.getWriteId(), this.principalPrivileges);
            } else {
                metastore.replaceTable(this.oldTable.getDatabaseName(), this.oldTable.getTableName(), this.oldTable, this.principalPrivileges);
            }
        }
    }

    private static class CreateTableOperation {
        private final Table newTable;
        private final PrincipalPrivileges privileges;
        private boolean tableCreated;
        private final boolean ignoreExisting;
        private final PartitionStatistics statistics;
        private final String queryId;

        public CreateTableOperation(Table newTable, PrincipalPrivileges privileges, boolean ignoreExisting, PartitionStatistics statistics) {
            Objects.requireNonNull(newTable, "newTable is null");
            this.newTable = newTable;
            this.privileges = Objects.requireNonNull(privileges, "privileges is null");
            this.ignoreExisting = ignoreExisting;
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.queryId = SemiTransactionalHiveMetastore.getPrestoQueryId(newTable).orElseThrow(() -> new IllegalArgumentException("Query id is not present"));
        }

        public String getDescription() {
            return String.format("add table %s.%s", this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public void run(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            boolean created;
            block10: {
                created = false;
                try {
                    metastore.createTable(this.newTable, this.privileges);
                    created = true;
                }
                catch (RuntimeException e2) {
                    TrinoException e2;
                    boolean done = false;
                    try {
                        Optional<Table> existingTable = metastore.getTable(this.newTable.getDatabaseName(), this.newTable.getTableName());
                        if (existingTable.isPresent()) {
                            Table table = existingTable.get();
                            Optional<String> existingTableQueryId = SemiTransactionalHiveMetastore.getPrestoQueryId(table);
                            if (existingTableQueryId.isPresent() && existingTableQueryId.get().equals(this.queryId)) {
                                done = true;
                                created = true;
                            } else if (!CreateTableOperation.hasTheSameSchema(this.newTable, table)) {
                                e2 = new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table already exists with a different schema: '%s'", this.newTable.getTableName()));
                            } else {
                                done = this.ignoreExisting;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    if (done) break block10;
                    throw e2;
                }
            }
            this.tableCreated = true;
            if (created && !ViewReaderUtil.isPrestoView(this.newTable)) {
                metastore.updateTableStatistics(this.newTable.getDatabaseName(), this.newTable.getTableName(), transaction, ignored -> this.statistics);
            }
        }

        private static boolean hasTheSameSchema(Table newTable, Table existingTable) {
            List<Column> newTableColumns = newTable.getDataColumns();
            List<Column> existingTableColumns = existingTable.getDataColumns();
            if (newTableColumns.size() != existingTableColumns.size()) {
                return false;
            }
            for (Column existingColumn : existingTableColumns) {
                if (!newTableColumns.stream().noneMatch(newColumn -> newColumn.getName().equals(existingColumn.getName()) && newColumn.getType().equals(existingColumn.getType()))) continue;
                return false;
            }
            return true;
        }

        public void undo(HiveMetastoreClosure metastore) {
            if (!this.tableCreated) {
                return;
            }
            metastore.dropTable(this.newTable.getDatabaseName(), this.newTable.getTableName(), false);
        }
    }

    private static class IrreversibleMetastoreOperation {
        private final String description;
        private final Runnable action;

        public IrreversibleMetastoreOperation(String description, Runnable action) {
            this.description = Objects.requireNonNull(description, "description is null");
            this.action = Objects.requireNonNull(action, "action is null");
        }

        public String getDescription() {
            return this.description;
        }

        public void run() {
            this.action.run();
        }
    }

    private static class DirectoryRenameTask {
        private final HdfsEnvironment.HdfsContext context;
        private final Path renameFrom;
        private final Path renameTo;

        public DirectoryRenameTask(HdfsEnvironment.HdfsContext context, Path renameFrom, Path renameTo) {
            this.context = Objects.requireNonNull(context, "context is null");
            this.renameFrom = Objects.requireNonNull(renameFrom, "renameFrom is null");
            this.renameTo = Objects.requireNonNull(renameTo, "renameTo is null");
        }

        public HdfsEnvironment.HdfsContext getContext() {
            return this.context;
        }

        public Path getRenameFrom() {
            return this.renameFrom;
        }

        public Path getRenameTo() {
            return this.renameTo;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("renameFrom", (Object)this.renameFrom).add("renameTo", (Object)this.renameTo).toString();
        }
    }

    private static class DirectoryDeletionTask {
        private final HdfsEnvironment.HdfsContext context;
        private final Path path;

        public DirectoryDeletionTask(HdfsEnvironment.HdfsContext context, Path path) {
            this.context = context;
            this.path = path;
        }

        public HdfsEnvironment.HdfsContext getContext() {
            return this.context;
        }

        public Path getPath() {
            return this.path;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("path", (Object)this.path).toString();
        }
    }

    private static class DirectoryCleanUpTask {
        private final HdfsEnvironment.HdfsContext context;
        private final Path path;
        private final boolean deleteEmptyDirectory;

        public DirectoryCleanUpTask(HdfsEnvironment.HdfsContext context, Path path, boolean deleteEmptyDirectory) {
            this.context = context;
            this.path = path;
            this.deleteEmptyDirectory = deleteEmptyDirectory;
        }

        public HdfsEnvironment.HdfsContext getContext() {
            return this.context;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isDeleteEmptyDirectory() {
            return this.deleteEmptyDirectory;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("path", (Object)this.path).add("deleteEmptyDirectory", this.deleteEmptyDirectory).toString();
        }
    }
}

