/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.rubix;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.qubole.rubix.prestosql.CachingPrestoDistributedFileSystem;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.hive.DynamicConfigurationProvider;
import io.trino.plugin.hive.authentication.HdfsAuthenticationConfig;
import io.trino.plugin.hive.rubix.RubixConfig;
import io.trino.plugin.hive.rubix.RubixConfigurationInitializer;
import io.trino.plugin.hive.rubix.RubixHdfsInitializer;
import io.trino.plugin.hive.rubix.RubixInitializer;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;

public class RubixModule
implements Module {
    private static final String RUBIX_DISTRIBUTED_FS_CLASS_NAME = CachingPrestoDistributedFileSystem.class.getName();

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(RubixConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsAuthenticationConfig.class);
        binder.bind(RubixConfigurationInitializer.class).in(Scopes.SINGLETON);
        binder.bind(RubixInitializer.class).in(Scopes.SINGLETON);
        binder.bind(RubixStarter.class).asEagerSingleton();
        OptionalBinder.newOptionalBinder((Binder)binder, RubixHdfsInitializer.class).setDefault().to(DefaultRubixHdfsInitializer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class).addBinding().to(RubixConfigurationInitializer.class).in(Scopes.SINGLETON);
    }

    private static class RubixStarter {
        @Inject
        private RubixStarter(RubixInitializer rubixInitializer, Set<DynamicConfigurationProvider> configProviders) {
            Preconditions.checkArgument((configProviders.size() == 1 ? 1 : 0) != 0, (Object)"Rubix cache does not work with dynamic configuration providers");
            rubixInitializer.initializeRubix();
        }
    }

    @VisibleForTesting
    static class DefaultRubixHdfsInitializer
    implements RubixHdfsInitializer {
        private HdfsAuthenticationConfig authenticationConfig;

        @Inject
        public DefaultRubixHdfsInitializer(HdfsAuthenticationConfig authenticationConfig) {
            this.authenticationConfig = Objects.requireNonNull(authenticationConfig, "authenticationConfig is null");
        }

        @Override
        public void initializeConfiguration(Configuration config) {
            Preconditions.checkArgument((!this.authenticationConfig.isHdfsImpersonationEnabled() ? 1 : 0) != 0, (Object)"HDFS impersonation is not compatible with Hive caching");
            config.set("fs.hdfs.impl", RUBIX_DISTRIBUTED_FS_CLASS_NAME);
        }
    }
}

