/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.fasterxml.jackson.databind.JsonNode;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.plugin.hive.s3.S3SecurityMappingConfig;
import io.trino.plugin.hive.s3.S3SecurityMappings;
import java.util.Objects;

public class S3SecurityMappingsParser {
    protected final String jsonPointer;

    protected S3SecurityMappingsParser(S3SecurityMappingConfig config) {
        this.jsonPointer = Objects.requireNonNull(config.getJsonPointer());
    }

    public S3SecurityMappings parseJSONString(String jsonString) {
        JsonNode node = (JsonNode)JsonUtils.parseJson((String)jsonString, JsonNode.class);
        JsonNode mappingsNode = node.at(this.jsonPointer);
        return (S3SecurityMappings)JsonUtils.jsonTreeToValue((JsonNode)mappingsNode, S3SecurityMappings.class);
    }
}

