/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.connector.ConnectorSession;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public final class S3SelectPushdown {
    private static final Set<String> SUPPORTED_S3_PREFIXES = ImmutableSet.of((Object)"s3://", (Object)"s3a://", (Object)"s3n://");
    private static final Set<String> SUPPORTED_SERDES = ImmutableSet.of((Object)LazySimpleSerDe.class.getName());
    private static final Set<String> SUPPORTED_COLUMN_TYPES = ImmutableSet.of((Object)"boolean", (Object)"int", (Object)"tinyint", (Object)"smallint", (Object)"bigint", (Object)"string", (Object[])new String[]{"decimal", "date"});

    private S3SelectPushdown() {
    }

    private static boolean isSerdeSupported(Properties schema) {
        String serdeName = HiveUtil.getDeserializerClassName(schema);
        return SUPPORTED_SERDES.contains(serdeName);
    }

    private static boolean isInputFormatSupported(Properties schema) {
        String inputFormat = HiveUtil.getInputFormatName(schema);
        if (TextInputFormat.class.getName().equals(inputFormat)) {
            if (!Objects.equals(schema.getProperty("skip.header.line.count", "0"), "0")) {
                return false;
            }
            return Objects.equals(schema.getProperty("skip.footer.line.count", "0"), "0");
        }
        return false;
    }

    public static boolean isCompressionCodecSupported(InputFormat<?, ?> inputFormat, Path path) {
        if (inputFormat instanceof TextInputFormat) {
            return HiveUtil.getCompressionCodec((TextInputFormat)inputFormat, path).map(codec -> codec instanceof GzipCodec || codec instanceof BZip2Codec).orElse(true);
        }
        return false;
    }

    private static boolean areColumnTypesSupported(List<Column> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.isEmpty()) {
            return false;
        }
        for (Column column : columns) {
            String type = column.getType().getHiveTypeName().toString();
            if (column.getType().getTypeInfo() instanceof DecimalTypeInfo) {
                type = "decimal";
            }
            if (SUPPORTED_COLUMN_TYPES.contains(type)) continue;
            return false;
        }
        return true;
    }

    private static boolean isS3Storage(String path) {
        return SUPPORTED_S3_PREFIXES.stream().anyMatch(path::startsWith);
    }

    public static boolean shouldEnablePushdownForTable(ConnectorSession session, Table table, String path, Optional<Partition> optionalPartition) {
        if (!HiveSessionProperties.isS3SelectPushdownEnabled(session)) {
            return false;
        }
        if (path == null) {
            return false;
        }
        Properties schema = optionalPartition.map(partition -> MetastoreUtil.getHiveSchema(partition, table)).orElseGet(() -> MetastoreUtil.getHiveSchema(table));
        return S3SelectPushdown.shouldEnablePushdownForTable(table, path, schema);
    }

    private static boolean shouldEnablePushdownForTable(Table table, String path, Properties schema) {
        return S3SelectPushdown.isS3Storage(path) && S3SelectPushdown.isSerdeSupported(schema) && S3SelectPushdown.isInputFormatSupported(schema) && S3SelectPushdown.areColumnTypesSupported(table.getDataColumns());
    }
}

