/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.InternalHiveSplit;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.s3select.S3SelectPushdown;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.HostAddress;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;

public class InternalHiveSplitFactory {
    private final FileSystem fileSystem;
    private final String partitionName;
    private final InputFormat<?, ?> inputFormat;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final Optional<Domain> pathDomain;
    private final TableToPartitionMapping tableToPartitionMapping;
    private final BooleanSupplier partitionMatchSupplier;
    private final Optional<HiveSplit.BucketConversion> bucketConversion;
    private final Optional<HiveSplit.BucketValidation> bucketValidation;
    private final long minimumTargetSplitSizeInBytes;
    private final Optional<Long> maxSplitFileSize;
    private final boolean forceLocalScheduling;
    private final boolean s3SelectPushdownEnabled;
    private final Map<Integer, AtomicInteger> bucketStatementCounters = new ConcurrentHashMap<Integer, AtomicInteger>();

    public InternalHiveSplitFactory(FileSystem fileSystem, String partitionName, InputFormat<?, ?> inputFormat, Properties schema, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, BooleanSupplier partitionMatchSupplier, TableToPartitionMapping tableToPartitionMapping, Optional<HiveSplit.BucketConversion> bucketConversion, Optional<HiveSplit.BucketValidation> bucketValidation, DataSize minimumTargetSplitSize, boolean forceLocalScheduling, boolean s3SelectPushdownEnabled, AcidTransaction transaction, Optional<Long> maxSplitFileSize) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.partitionKeys = Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.pathDomain = InternalHiveSplitFactory.getPathDomain(Objects.requireNonNull(effectivePredicate, "effectivePredicate is null"));
        this.partitionMatchSupplier = Objects.requireNonNull(partitionMatchSupplier, "partitionMatchSupplier is null");
        this.tableToPartitionMapping = Objects.requireNonNull(tableToPartitionMapping, "tableToPartitionMapping is null");
        this.bucketConversion = Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        this.bucketValidation = Objects.requireNonNull(bucketValidation, "bucketValidation is null");
        this.forceLocalScheduling = forceLocalScheduling;
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        this.minimumTargetSplitSizeInBytes = Objects.requireNonNull(minimumTargetSplitSize, "minimumTargetSplitSize is null").toBytes();
        this.maxSplitFileSize = Objects.requireNonNull(maxSplitFileSize, "maxSplitFileSize is null");
        Preconditions.checkArgument((this.minimumTargetSplitSizeInBytes > 0L ? 1 : 0) != 0, (String)"minimumTargetSplitSize must be > 0, found: %s", (Object)minimumTargetSplitSize);
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(LocatedFileStatus status, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable, Optional<AcidInfo> acidInfo) {
        splittable = splittable && status.getLen() > this.minimumTargetSplitSizeInBytes && HiveUtil.isSplittable(this.inputFormat, this.fileSystem, status.getPath());
        return this.createInternalHiveSplit(status.getPath(), status.getBlockLocations(), 0L, status.getLen(), status.getLen(), status.getModificationTime(), readBucketNumber, tableBucketNumber, splittable, acidInfo);
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(FileSplit split) throws IOException {
        FileStatus file = this.fileSystem.getFileStatus(split.getPath());
        return this.createInternalHiveSplit(split.getPath(), this.fileSystem.getFileBlockLocations(file, split.getStart(), split.getLength()), split.getStart(), split.getLength(), file.getLen(), file.getModificationTime(), OptionalInt.empty(), OptionalInt.empty(), false, Optional.empty());
    }

    private Optional<InternalHiveSplit> createInternalHiveSplit(Path path, BlockLocation[] blockLocations, long start, long length, long estimatedFileSize, long fileModificationTime, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable, Optional<AcidInfo> acidInfo) {
        String pathString = path.toString();
        if (!InternalHiveSplitFactory.pathMatchesPredicate(this.pathDomain, pathString)) {
            return Optional.empty();
        }
        if (estimatedFileSize == 0L) {
            return Optional.empty();
        }
        if (!this.partitionMatchSupplier.getAsBoolean()) {
            return Optional.empty();
        }
        if (this.maxSplitFileSize.isPresent() && estimatedFileSize > this.maxSplitFileSize.get()) {
            return Optional.empty();
        }
        ImmutableList.Builder blockBuilder = ImmutableList.builder();
        for (BlockLocation blockLocation : blockLocations) {
            long blockEnd;
            long blockStart = Math.max(start, blockLocation.getOffset());
            if (blockStart > (blockEnd = Math.min(start + length, blockLocation.getOffset() + blockLocation.getLength())) || blockStart == blockEnd && (blockStart != start || blockEnd != start + length)) continue;
            blockBuilder.add((Object)new InternalHiveSplit.InternalHiveBlock(blockStart, blockEnd, InternalHiveSplitFactory.getHostAddresses(blockLocation)));
        }
        ImmutableList blocks = blockBuilder.build();
        InternalHiveSplitFactory.checkBlocks(path, (List<InternalHiveSplit.InternalHiveBlock>)blocks, start, length);
        if (!splittable) {
            blocks = ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(start, start + length, ((InternalHiveSplit.InternalHiveBlock)blocks.get(0)).getAddresses()));
        }
        int bucketNumberIndex = readBucketNumber.orElse(0);
        return Optional.of(new InternalHiveSplit(this.partitionName, pathString, start, start + length, estimatedFileSize, fileModificationTime, this.schema, this.partitionKeys, (List<InternalHiveSplit.InternalHiveBlock>)blocks, readBucketNumber, tableBucketNumber, () -> this.bucketStatementCounters.computeIfAbsent(bucketNumberIndex, index -> new AtomicInteger()).getAndIncrement(), splittable, this.forceLocalScheduling && InternalHiveSplitFactory.allBlocksHaveAddress((Collection<InternalHiveSplit.InternalHiveBlock>)blocks), this.tableToPartitionMapping, this.bucketConversion, this.bucketValidation, this.s3SelectPushdownEnabled && S3SelectPushdown.isCompressionCodecSupported(this.inputFormat, path), acidInfo, this.partitionMatchSupplier));
    }

    private static void checkBlocks(Path path, List<InternalHiveSplit.InternalHiveBlock> blocks, long start, long length) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (String)"Split (%s) has negative start (%s)", (Object)path, (long)start);
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (String)"Split (%s) has negative length (%s)", (Object)path, (long)length);
        Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0, (String)"Split (%s) has no blocks", (Object)path);
        Preconditions.checkArgument((start == blocks.get(0).getStart() ? 1 : 0) != 0, (String)"Split (%s) start (%s) does not match first block start (%s)", (Object)path, (Object)start, (Object)blocks.get(0).getStart());
        Preconditions.checkArgument((start + length == blocks.get(blocks.size() - 1).getEnd() ? 1 : 0) != 0, (String)"Split (%s) end (%s) does not match last block end (%s)", (Object)path, (Object)(start + length), (Object)blocks.get(blocks.size() - 1).getEnd());
        for (int i = 1; i < blocks.size(); ++i) {
            Preconditions.checkArgument((blocks.get(i - 1).getEnd() == blocks.get(i).getStart() ? 1 : 0) != 0, (String)"Split (%s) block end (%s) does not match next block start (%s)", (Object)path, (Object)blocks.get(i - 1).getEnd(), (Object)blocks.get(i).getStart());
        }
    }

    private static boolean allBlocksHaveAddress(Collection<InternalHiveSplit.InternalHiveBlock> blocks) {
        return blocks.stream().map(InternalHiveSplit.InternalHiveBlock::getAddresses).noneMatch(List::isEmpty);
    }

    private static List<HostAddress> getHostAddresses(BlockLocation blockLocation) {
        return (List)Arrays.stream(InternalHiveSplitFactory.getBlockHosts(blockLocation)).map(HostAddress::fromString).filter(address -> !address.getHostText().equals("localhost")).collect(ImmutableList.toImmutableList());
    }

    private static String[] getBlockHosts(BlockLocation blockLocation) {
        try {
            return blockLocation.getHosts();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Optional<Domain> getPathDomain(TupleDomain<HiveColumnHandle> effectivePredicate) {
        return effectivePredicate.getDomains().flatMap(domains -> domains.entrySet().stream().filter(entry -> HiveColumnHandle.isPathColumnHandle((HiveColumnHandle)entry.getKey())).map(Map.Entry::getValue).findFirst());
    }

    private static boolean pathMatchesPredicate(Optional<Domain> pathDomain, String path) {
        return pathDomain.map(domain -> domain.includesNullableValue((Object)Slices.utf8Slice((String)path))).orElse(true);
    }
}

