/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.linkedin.coral.com.google.common.collect.ArrayListMultimap;
import com.linkedin.coral.com.google.common.collect.BoundType;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.Iterables;
import com.linkedin.coral.com.google.common.collect.Range;
import com.linkedin.coral.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexAnalyzer;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexInterpreter;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class RexSimplify {
    private final boolean paranoid;
    public final RexBuilder rexBuilder;
    private final RelOptPredicateList predicates;
    final RexUnknownAs defaultUnknownAs;
    final boolean predicateElimination;
    private final RexExecutor executor;
    private final Strong strong;

    public RexSimplify(RexBuilder rexBuilder, RelOptPredicateList predicates, RexExecutor executor) {
        this(rexBuilder, predicates, RexUnknownAs.UNKNOWN, true, false, executor);
    }

    private RexSimplify(RexBuilder rexBuilder, RelOptPredicateList predicates, RexUnknownAs defaultUnknownAs, boolean predicateElimination, boolean paranoid, RexExecutor executor) {
        this.rexBuilder = Objects.requireNonNull(rexBuilder);
        this.predicates = Objects.requireNonNull(predicates);
        this.defaultUnknownAs = Objects.requireNonNull(defaultUnknownAs);
        this.predicateElimination = predicateElimination;
        this.paranoid = paranoid;
        this.executor = Objects.requireNonNull(executor);
        this.strong = new Strong();
    }

    @Deprecated
    public RexSimplify(RexBuilder rexBuilder, boolean unknownAsFalse, RexExecutor executor) {
        this(rexBuilder, RelOptPredicateList.EMPTY, RexUnknownAs.falseIf(unknownAsFalse), true, false, executor);
    }

    @Deprecated
    public RexSimplify(RexBuilder rexBuilder, RelOptPredicateList predicates, boolean unknownAsFalse, RexExecutor executor) {
        this(rexBuilder, predicates, RexUnknownAs.falseIf(unknownAsFalse), true, false, executor);
    }

    @Deprecated
    public RexSimplify withUnknownAsFalse(boolean unknownAsFalse) {
        RexUnknownAs defaultUnknownAs = RexUnknownAs.falseIf(unknownAsFalse);
        return defaultUnknownAs == this.defaultUnknownAs ? this : new RexSimplify(this.rexBuilder, this.predicates, defaultUnknownAs, this.predicateElimination, this.paranoid, this.executor);
    }

    public RexSimplify withPredicates(RelOptPredicateList predicates) {
        return predicates == this.predicates ? this : new RexSimplify(this.rexBuilder, predicates, this.defaultUnknownAs, this.predicateElimination, this.paranoid, this.executor);
    }

    public RexSimplify withParanoid(boolean paranoid) {
        return paranoid == this.paranoid ? this : new RexSimplify(this.rexBuilder, this.predicates, this.defaultUnknownAs, this.predicateElimination, paranoid, this.executor);
    }

    private RexSimplify withPredicateElimination(boolean predicateElimination) {
        return predicateElimination == this.predicateElimination ? this : new RexSimplify(this.rexBuilder, this.predicates, this.defaultUnknownAs, predicateElimination, this.paranoid, this.executor);
    }

    public RexNode simplifyPreservingType(RexNode e) {
        return this.simplifyPreservingType(e, this.defaultUnknownAs, true);
    }

    public RexNode simplifyPreservingType(RexNode e, RexUnknownAs unknownAs, boolean matchNullability) {
        RexNode e2 = this.simplifyUnknownAs(e, unknownAs);
        if (e2.getType() == e.getType()) {
            return e2;
        }
        RexNode e3 = this.rexBuilder.makeCast(e.getType(), e2, matchNullability);
        if (e3.equals(e)) {
            return e;
        }
        return e3;
    }

    public RexNode simplify(RexNode e) {
        return this.simplifyUnknownAs(e, this.defaultUnknownAs);
    }

    public final RexNode simplifyUnknownAsFalse(RexNode e) {
        return this.simplifyUnknownAs(e, RexUnknownAs.FALSE);
    }

    public RexNode simplifyUnknownAs(RexNode e, RexUnknownAs unknownAs) {
        RexNode simplified = this.withParanoid(false).simplify(e, unknownAs);
        if (this.paranoid) {
            this.verify(e, simplified, unknownAs);
        }
        return simplified;
    }

    RexNode simplify(RexNode e, RexUnknownAs unknownAs) {
        if (this.strong.isNull(e)) {
            if (e.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                switch (unknownAs) {
                    case FALSE: 
                    case TRUE: {
                        return this.rexBuilder.makeLiteral(unknownAs.toBoolean());
                    }
                }
            }
            return this.rexBuilder.makeNullLiteral(e.getType());
        }
        switch (e.getKind()) {
            case AND: {
                return this.simplifyAnd((RexCall)e, unknownAs);
            }
            case OR: {
                return this.simplifyOr((RexCall)e, unknownAs);
            }
            case NOT: {
                return this.simplifyNot((RexCall)e, unknownAs);
            }
            case CASE: {
                return this.simplifyCase((RexCall)e, unknownAs);
            }
            case COALESCE: {
                return this.simplifyCoalesce((RexCall)e);
            }
            case CAST: {
                return this.simplifyCast((RexCall)e);
            }
            case CEIL: 
            case FLOOR: {
                return this.simplifyCeilFloor((RexCall)e);
            }
            case IS_NULL: 
            case IS_NOT_NULL: 
            case IS_TRUE: 
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case IS_NOT_FALSE: {
                assert (e instanceof RexCall);
                return this.simplifyIs((RexCall)e, unknownAs);
            }
            case EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case NOT_EQUALS: {
                return this.simplifyComparison((RexCall)e, unknownAs);
            }
        }
        if (e.getClass() == RexCall.class) {
            return this.simplifyGenericNode((RexCall)e);
        }
        return e;
    }

    private RexNode simplifyGenericNode(RexCall e) {
        ArrayList<RexNode> operands = new ArrayList<RexNode>(e.operands);
        this.simplifyList(operands, RexUnknownAs.UNKNOWN);
        if (e.operands.equals(operands)) {
            return e;
        }
        return this.rexBuilder.makeCall(e.getType(), e.getOperator(), operands);
    }

    private RexNode simplifyComparison(RexCall e, RexUnknownAs unknownAs) {
        return this.simplifyComparison(e, unknownAs, Comparable.class);
    }

    private <C extends Comparable<C>> RexNode simplifyComparison(RexCall e, RexUnknownAs unknownAs, Class<C> clazz) {
        Comparison cmp;
        ArrayList<RexNode> operands = new ArrayList<RexNode>(e.operands);
        this.simplifyList(operands, RexUnknownAs.UNKNOWN);
        RexNode o0 = (RexNode)operands.get(0);
        RexNode o1 = (RexNode)operands.get(1);
        if (o0.equals(o1)) {
            switch (e.getKind()) {
                case EQUALS: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN_OR_EQUAL: {
                    RexNode newExpr = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, this.rexBuilder.makeNullLiteral(e.getType()), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, o0));
                    return this.simplify(newExpr, unknownAs);
                }
                case GREATER_THAN: 
                case LESS_THAN: 
                case NOT_EQUALS: {
                    RexNode newExpr = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, this.rexBuilder.makeNullLiteral(e.getType()), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, o0));
                    return this.simplify(newExpr, unknownAs);
                }
            }
        }
        if (o0.getType().getSqlTypeName() == SqlTypeName.BOOLEAN && (cmp = Comparison.of(this.rexBuilder.makeCall(e.getOperator(), o0, o1), node -> true)) != null) {
            if (cmp.literal.isAlwaysTrue()) {
                switch (cmp.kind) {
                    case EQUALS: 
                    case GREATER_THAN_OR_EQUAL: {
                        return cmp.ref;
                    }
                    case LESS_THAN: 
                    case NOT_EQUALS: {
                        return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, cmp.ref), unknownAs);
                    }
                    case GREATER_THAN: {
                        if (cmp.ref.getType().isNullable()) break;
                        return this.rexBuilder.makeLiteral(false);
                    }
                    case LESS_THAN_OR_EQUAL: {
                        if (cmp.ref.getType().isNullable()) break;
                        return this.rexBuilder.makeLiteral(true);
                    }
                }
            }
            if (cmp.literal.isAlwaysFalse()) {
                switch (cmp.kind) {
                    case EQUALS: 
                    case LESS_THAN_OR_EQUAL: {
                        return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, cmp.ref), unknownAs);
                    }
                    case GREATER_THAN: 
                    case NOT_EQUALS: {
                        return cmp.ref;
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        if (cmp.ref.getType().isNullable()) break;
                        return this.rexBuilder.makeLiteral(true);
                    }
                    case LESS_THAN: {
                        if (cmp.ref.getType().isNullable()) break;
                        return this.rexBuilder.makeLiteral(false);
                    }
                }
            }
        }
        if (o0.isA(SqlKind.LITERAL) && o1.isA(SqlKind.LITERAL) && SqlTypeUtil.equalSansNullability(this.rexBuilder.getTypeFactory(), o0.getType(), o1.getType())) {
            Comparable v0 = (Comparable)((RexLiteral)o0).getValueAs(clazz);
            Comparable v1 = (Comparable)((RexLiteral)o1).getValueAs(clazz);
            if (v0 == null || v1 == null) {
                return unknownAs == RexUnknownAs.FALSE ? this.rexBuilder.makeLiteral(false) : this.rexBuilder.makeNullLiteral(e.getType());
            }
            int comparisonResult = v0.compareTo(v1);
            switch (e.getKind()) {
                case EQUALS: {
                    return this.rexBuilder.makeLiteral(comparisonResult == 0);
                }
                case GREATER_THAN: {
                    return this.rexBuilder.makeLiteral(comparisonResult > 0);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.rexBuilder.makeLiteral(comparisonResult >= 0);
                }
                case LESS_THAN: {
                    return this.rexBuilder.makeLiteral(comparisonResult < 0);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.rexBuilder.makeLiteral(comparisonResult <= 0);
                }
                case NOT_EQUALS: {
                    return this.rexBuilder.makeLiteral(comparisonResult != 0);
                }
            }
            throw new AssertionError();
        }
        RexNode e2 = operands.equals(e.operands) ? e : this.rexBuilder.makeCall(e.op, operands);
        return this.simplifyUsingPredicates(e2, clazz);
    }

    @Deprecated
    public RexNode simplifyAnds(Iterable<? extends RexNode> nodes) {
        this.ensureParanoidOff();
        return this.simplifyAnds(nodes, this.defaultUnknownAs);
    }

    RexNode simplifyAnds(Iterable<? extends RexNode> nodes, RexUnknownAs unknownAs) {
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        for (RexNode rexNode : nodes) {
            RelOptUtil.decomposeConjunction(rexNode, terms, notTerms);
        }
        this.simplifyList(terms, RexUnknownAs.UNKNOWN);
        this.simplifyList(notTerms, RexUnknownAs.UNKNOWN);
        if (unknownAs == RexUnknownAs.FALSE) {
            return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms);
        }
        return this.simplifyAnd2(terms, notTerms);
    }

    private void simplifyList(List<RexNode> terms, RexUnknownAs unknownAs) {
        for (int i = 0; i < terms.size(); ++i) {
            terms.set(i, this.simplify(terms.get(i), unknownAs));
        }
    }

    private void simplifyAndTerms(List<RexNode> terms, RexUnknownAs unknownAs) {
        RexNode t;
        int i;
        RexSimplify simplify = this;
        for (i = 0; i < terms.size(); ++i) {
            t = terms.get(i);
            if (Predicate.of(t) == null) continue;
            terms.set(i, simplify.simplify(t, unknownAs));
            RelOptPredicateList newPredicates = simplify.predicates.union(this.rexBuilder, RelOptPredicateList.of(this.rexBuilder, terms.subList(i, i + 1)));
            simplify = simplify.withPredicates(newPredicates);
        }
        for (i = 0; i < terms.size(); ++i) {
            t = terms.get(i);
            if (Predicate.of(t) != null) continue;
            terms.set(i, simplify.simplify(t, unknownAs));
        }
    }

    private void simplifyOrTerms(List<RexNode> terms, RexUnknownAs unknownAs) {
        RexNode t;
        int i;
        RexSimplify simplify = this;
        for (i = 0; i < terms.size(); ++i) {
            t = terms.get(i);
            if (!this.allowedAsPredicateDuringOrSimplification(t)) continue;
            RexNode t2 = simplify.simplify(t, unknownAs);
            terms.set(i, t2);
            RexNode inverse = simplify.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, t2), RexUnknownAs.UNKNOWN);
            RelOptPredicateList newPredicates = simplify.predicates.union(this.rexBuilder, RelOptPredicateList.of(this.rexBuilder, ImmutableList.of(inverse)));
            simplify = simplify.withPredicates(newPredicates);
        }
        for (i = 0; i < terms.size(); ++i) {
            t = terms.get(i);
            if (this.allowedAsPredicateDuringOrSimplification(t)) continue;
            terms.set(i, simplify.simplify(t, unknownAs));
        }
    }

    private boolean allowedAsPredicateDuringOrSimplification(RexNode t) {
        Predicate predicate = Predicate.of(t);
        if (predicate == null) {
            return false;
        }
        SqlKind kind = t.getKind();
        if (!SqlKind.COMPARISON.contains((Object)kind)) {
            return true;
        }
        switch (kind) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return false;
            }
        }
        return true;
    }

    private RexNode simplifyNot(RexCall call, RexUnknownAs unknownAs) {
        RexNode a = call.getOperands().get(0);
        switch (a.getKind()) {
            case NOT: {
                return this.simplify(((RexCall)a).getOperands().get(0), unknownAs);
            }
            case LITERAL: {
                if (a.getType().getSqlTypeName() != SqlTypeName.BOOLEAN || RexLiteral.isNullLiteral(a)) break;
                return this.rexBuilder.makeLiteral(!RexLiteral.booleanValue(a));
            }
        }
        SqlKind negateKind = a.getKind().negate();
        if (a.getKind() != negateKind) {
            return this.simplify(this.rexBuilder.makeCall(RexUtil.op(negateKind), ((RexCall)a).getOperands()), unknownAs);
        }
        SqlKind negateKind2 = a.getKind().negateNullSafe();
        if (a.getKind() != negateKind2) {
            return this.simplify(this.rexBuilder.makeCall(RexUtil.op(negateKind2), ((RexCall)a).getOperands()), unknownAs);
        }
        if (a.getKind() == SqlKind.AND) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand), unknownAs));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, newOperands), unknownAs);
        }
        if (a.getKind() == SqlKind.OR) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand), unknownAs));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newOperands), unknownAs);
        }
        if (a.getKind() == SqlKind.CASE) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            List<RexNode> operands = ((RexCall)a).getOperands();
            for (int i = 0; i < operands.size(); i += 2) {
                if (i + 1 == operands.size()) {
                    newOperands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operands.get(i + 0)));
                    continue;
                }
                newOperands.add(operands.get(i + 0));
                newOperands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operands.get(i + 1)));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, newOperands), unknownAs);
        }
        RexNode a2 = this.simplify(a, unknownAs.negate());
        if (a == a2) {
            return call;
        }
        if (a2.isAlwaysTrue()) {
            return this.rexBuilder.makeLiteral(false);
        }
        if (a2.isAlwaysFalse()) {
            return this.rexBuilder.makeLiteral(true);
        }
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a2);
    }

    private RexNode simplifyIs(RexCall call, RexUnknownAs unknownAs) {
        SqlKind kind = call.getKind();
        RexNode a = call.getOperands().get(0);
        if (kind == SqlKind.IS_TRUE && unknownAs == RexUnknownAs.FALSE) {
            return this.simplify(a, unknownAs);
        }
        if (kind == SqlKind.IS_FALSE && unknownAs == RexUnknownAs.FALSE) {
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a), unknownAs);
        }
        if (kind == SqlKind.IS_NOT_FALSE && unknownAs == RexUnknownAs.TRUE) {
            return this.simplify(a, unknownAs);
        }
        if (kind == SqlKind.IS_NOT_TRUE && unknownAs == RexUnknownAs.TRUE) {
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a), unknownAs);
        }
        RexNode pred = this.simplifyIsPredicate(kind, a);
        if (pred != null) {
            return pred;
        }
        RexNode simplified = this.simplifyIs2(kind, a, unknownAs);
        if (simplified != null) {
            return simplified;
        }
        return call;
    }

    private RexNode simplifyIsPredicate(SqlKind kind, RexNode a) {
        if (!RexUtil.isReferenceOrAccess(a, true)) {
            return null;
        }
        for (RexNode p : this.predicates.pulledUpPredicates) {
            IsPredicate pred = IsPredicate.of(p);
            if (pred == null || !a.equals(pred.ref) || kind != pred.kind) continue;
            return this.rexBuilder.makeLiteral(true);
        }
        return null;
    }

    private RexNode simplifyIs2(SqlKind kind, RexNode a, RexUnknownAs unknownAs) {
        switch (kind) {
            case IS_NULL: {
                RexNode simplified = this.simplifyIsNull(a);
                if (simplified == null) break;
                return simplified;
            }
            case IS_NOT_NULL: {
                RexNode simplified = this.simplifyIsNotNull(a);
                if (simplified == null) break;
                return simplified;
            }
            case IS_TRUE: 
            case IS_NOT_FALSE: {
                if (!a.getType().isNullable()) {
                    return this.simplify(a, unknownAs);
                }
                RexNode newSub = this.simplify(a, kind == SqlKind.IS_TRUE ? RexUnknownAs.FALSE : RexUnknownAs.TRUE);
                if (newSub == a) {
                    return null;
                }
                return this.rexBuilder.makeCall(RexUtil.op(kind), ImmutableList.of(newSub));
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: {
                if (a.getType().isNullable()) break;
                return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a), unknownAs);
            }
        }
        switch (a.getKind()) {
            case NOT: {
                SqlOperator notKind = RexUtil.op(kind.negateNullSafe());
                RexNode arg = (RexNode)((RexCall)a).operands.get(0);
                return this.simplify(this.rexBuilder.makeCall(notKind, arg), RexUnknownAs.UNKNOWN);
            }
        }
        RexNode a2 = this.simplify(a, RexUnknownAs.UNKNOWN);
        if (a != a2) {
            return this.rexBuilder.makeCall(RexUtil.op(kind), ImmutableList.of(a2));
        }
        return null;
    }

    private RexNode simplifyIsNotNull(RexNode a) {
        if (!(a = this.simplify(a, RexUnknownAs.UNKNOWN)).getType().isNullable() && RexSimplify.isSafeExpression(a)) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (this.predicates.pulledUpPredicates.contains(a)) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (a.getKind() == SqlKind.CAST) {
            return null;
        }
        switch (Strong.policy(a.getKind())) {
            case NOT_NULL: {
                return this.rexBuilder.makeLiteral(true);
            }
            case ANY: {
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (RexNode operand : ((RexCall)a).getOperands()) {
                    RexNode simplified = this.simplifyIsNotNull(operand);
                    if (simplified == null) {
                        operands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand));
                        continue;
                    }
                    if (simplified.isAlwaysFalse()) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    operands.add(simplified);
                }
                return RexUtil.composeConjunction(this.rexBuilder, operands);
            }
            case CUSTOM: {
                switch (a.getKind()) {
                    case LITERAL: {
                        return this.rexBuilder.makeLiteral(!((RexLiteral)a).isNull());
                    }
                }
                throw new AssertionError((Object)("every CUSTOM policy needs a handler, " + (Object)((Object)a.getKind())));
            }
        }
        return null;
    }

    private RexNode simplifyIsNull(RexNode a) {
        if (!(a = this.simplify(a, RexUnknownAs.UNKNOWN)).getType().isNullable() && RexSimplify.isSafeExpression(a)) {
            return this.rexBuilder.makeLiteral(false);
        }
        if (RexUtil.isNull(a)) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (a.getKind() == SqlKind.CAST) {
            return null;
        }
        switch (Strong.policy(a.getKind())) {
            case NOT_NULL: {
                return this.rexBuilder.makeLiteral(false);
            }
            case ANY: {
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (RexNode operand : ((RexCall)a).getOperands()) {
                    RexNode simplified = this.simplifyIsNull(operand);
                    if (simplified == null) {
                        operands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, operand));
                        continue;
                    }
                    operands.add(simplified);
                }
                return RexUtil.composeDisjunction(this.rexBuilder, operands, false);
            }
        }
        return null;
    }

    private RexNode simplifyCoalesce(RexCall call) {
        HashSet<RexNode> operandSet = new HashSet<RexNode>();
        ArrayList<RexNode> operands = new ArrayList<RexNode>();
        for (RexNode operand : call.getOperands()) {
            if (!RexUtil.isNull(operand = this.simplify(operand, RexUnknownAs.UNKNOWN)) && operandSet.add(operand)) {
                operands.add(operand);
            }
            if (operand.getType().isNullable()) continue;
            break;
        }
        switch (operands.size()) {
            case 0: {
                return this.rexBuilder.makeNullLiteral(call.type);
            }
            case 1: {
                return (RexNode)operands.get(0);
            }
        }
        if (operands.equals(call.operands)) {
            return call;
        }
        return call.clone(call.type, operands);
    }

    private RexNode simplifyCase(RexCall call, RexUnknownAs unknownAs) {
        RexNode result;
        CaseBranch branch;
        List inputBranches = CaseBranch.fromCaseOperands(this.rexBuilder, new ArrayList<RexNode>(call.getOperands()));
        RexSimplify condSimplifier = this.withPredicates(RelOptPredicateList.EMPTY);
        RexSimplify valueSimplifier = this;
        RelDataType caseType = call.getType();
        boolean conditionNeedsSimplify = false;
        CaseBranch lastBranch = null;
        ArrayList<CaseBranch> branches = new ArrayList<CaseBranch>();
        for (CaseBranch inputBranch : inputBranches) {
            RexNode newCond = condSimplifier.simplify(inputBranch.cond, RexUnknownAs.FALSE);
            if (newCond.isAlwaysFalse()) continue;
            RexNode newValue = valueSimplifier.simplify(inputBranch.value, unknownAs);
            if (lastBranch != null) {
                if (lastBranch.value.equals(newValue) && RexSimplify.isSafeExpression(newCond)) {
                    newCond = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, lastBranch.cond, newCond);
                    conditionNeedsSimplify = true;
                } else {
                    CaseBranch branch2 = this.generateBranch(conditionNeedsSimplify, condSimplifier, lastBranch);
                    if (!branch2.cond.isAlwaysFalse()) {
                        branches.add(branch2);
                        if (branch2.cond.isAlwaysTrue()) {
                            lastBranch = null;
                            break;
                        }
                    }
                    conditionNeedsSimplify = false;
                }
            }
            lastBranch = new CaseBranch(newCond, newValue);
            if (!newCond.isAlwaysTrue()) continue;
            break;
        }
        if (lastBranch != null && !(branch = this.generateBranch(conditionNeedsSimplify, condSimplifier, lastBranch)).cond.isAlwaysFalse()) {
            branches.add(branch);
        }
        if (branches.size() == 1) {
            RexNode value = ((CaseBranch)branches.get(0)).value;
            if (this.sameTypeOrNarrowsNullability(caseType, value.getType())) {
                return value;
            }
            return this.rexBuilder.makeAbstractCast(caseType, value);
        }
        if (call.getType().getSqlTypeName() == SqlTypeName.BOOLEAN && (result = RexSimplify.simplifyBooleanCase(this.rexBuilder, branches, unknownAs, caseType)) != null) {
            if (this.sameTypeOrNarrowsNullability(caseType, result.getType())) {
                return this.simplify(result, unknownAs);
            }
            RexNode simplified = this.simplify(result, RexUnknownAs.UNKNOWN);
            if (!simplified.getType().isNullable()) {
                return simplified;
            }
            return this.rexBuilder.makeCast(call.getType(), simplified);
        }
        List newOperands = CaseBranch.toCaseOperands(this.rexBuilder, branches);
        if (newOperands.equals(call.getOperands())) {
            return call;
        }
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, newOperands);
    }

    private CaseBranch generateBranch(boolean simplifyCond, RexSimplify simplifier, CaseBranch branch) {
        if (simplifyCond) {
            return new CaseBranch(simplifier.simplify(branch.cond, RexUnknownAs.FALSE), branch.value);
        }
        return branch;
    }

    private boolean sameTypeOrNarrowsNullability(RelDataType oldType, RelDataType newType) {
        return oldType.equals(newType) || SqlTypeUtil.equalSansNullability(this.rexBuilder.typeFactory, oldType, newType) && oldType.isNullable();
    }

    static boolean isSafeExpression(RexNode r) {
        return r.accept(SafeRexVisitor.INSTANCE);
    }

    private static RexNode simplifyBooleanCase(RexBuilder rexBuilder, List<CaseBranch> inputBranches, RexUnknownAs unknownAs, RelDataType branchType) {
        ArrayList<CaseBranch> branches = new ArrayList<CaseBranch>();
        for (CaseBranch branch : inputBranches) {
            if (branches.size() > 0 && !RexSimplify.isSafeExpression(branch.cond) || !RexSimplify.isSafeExpression(branch.value)) {
                return null;
            }
            RexNode cond = branch.cond.getType().isNullable() ? rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, branch.cond) : branch.cond;
            RexNode value = !branchType.equals(branch.value.getType()) ? rexBuilder.makeAbstractCast(branchType, branch.value) : branch.value;
            branches.add(new CaseBranch(cond, value));
        }
        RexNode result = RexSimplify.simplifyBooleanCaseGeneric(rexBuilder, branches, branchType);
        return result;
    }

    private static RexNode simplifyBooleanCaseGeneric(RexBuilder rexBuilder, List<CaseBranch> branches, RelDataType outputType) {
        boolean booleanBranches = branches.stream().allMatch(branch -> ((CaseBranch)branch).value.isAlwaysTrue() || ((CaseBranch)branch).value.isAlwaysFalse());
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        for (CaseBranch branch2 : branches) {
            boolean useBranch;
            boolean bl = useBranch = !branch2.value.isAlwaysFalse();
            if (useBranch) {
                RexNode branchTerm = branch2.value.isAlwaysTrue() ? branch2.cond : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, branch2.cond, branch2.value);
                terms.add(RexUtil.andNot(rexBuilder, branchTerm, notTerms));
            }
            if (booleanBranches && useBranch) continue;
            notTerms.add(branch2.cond);
        }
        return RexUtil.composeDisjunction(rexBuilder, terms);
    }

    @Deprecated
    public RexNode simplifyAnd(RexCall e) {
        this.ensureParanoidOff();
        return this.simplifyAnd(e, this.defaultUnknownAs);
    }

    RexNode simplifyAnd(RexCall e, RexUnknownAs unknownAs) {
        List<RexNode> operands = RelOptUtil.conjunctions(e);
        if (unknownAs == RexUnknownAs.FALSE && this.predicateElimination) {
            this.simplifyAndTerms(operands, RexUnknownAs.FALSE);
        } else {
            this.simplifyList(operands, unknownAs);
        }
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        for (RexNode o : operands) {
            RelOptUtil.decomposeConjunction(o, terms, notTerms);
        }
        switch (unknownAs) {
            case FALSE: {
                return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms, Comparable.class);
            }
        }
        return this.simplifyAnd2(terms, notTerms);
    }

    RexNode simplifyAnd2(List<RexNode> terms, List<RexNode> notTerms) {
        for (RexNode term : terms) {
            if (!term.isAlwaysFalse()) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return this.rexBuilder.makeLiteral(true);
        }
        ArrayList<RexNode> notSatisfiableNullables = null;
        for (RexNode notDisjunction : notTerms) {
            List<RexNode> terms2 = RelOptUtil.conjunctions(notDisjunction);
            if (!terms.containsAll(terms2)) continue;
            if (!notDisjunction.getType().isNullable()) {
                return this.rexBuilder.makeLiteral(false);
            }
            if (notSatisfiableNullables == null) {
                notSatisfiableNullables = new ArrayList<RexNode>();
            }
            notSatisfiableNullables.add(notDisjunction);
        }
        if (notSatisfiableNullables != null) {
            terms.removeAll(notSatisfiableNullables);
            notTerms.removeAll(notSatisfiableNullables);
            terms.add(this.rexBuilder.makeNullLiteral(((RexNode)notSatisfiableNullables.get(0)).getType()));
            for (RexNode notSatisfiableNullable : notSatisfiableNullables) {
                terms.add(this.simplifyIs((RexCall)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, notSatisfiableNullable), RexUnknownAs.UNKNOWN));
            }
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction), RexUnknownAs.UNKNOWN));
        }
        return RexUtil.composeConjunction(this.rexBuilder, terms);
    }

    RexNode simplifyAnd2ForUnknownAsFalse(List<RexNode> terms, List<RexNode> notTerms) {
        return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms, Comparable.class);
    }

    private <C extends Comparable<C>> RexNode simplifyAnd2ForUnknownAsFalse(List<RexNode> terms, List<RexNode> notTerms, Class<C> clazz) {
        for (RexNode term : terms) {
            if (!term.isAlwaysFalse() && !RexLiteral.isNullLiteral(term)) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (terms.size() == 1 && notTerms.isEmpty()) {
            return this.simplify(terms.get(0), RexUnknownAs.FALSE);
        }
        ArrayListMultimap<RexNode, Pair<RexNode, RexNode>> equalityTerms = ArrayListMultimap.create();
        HashMap<RexNode, Pair<Range<C>, List<RexNode>>> rangeTerms = new HashMap<RexNode, Pair<Range<C>, List<RexNode>>>();
        HashMap<RexNode, RexLiteral> equalityConstantTerms = new HashMap<RexNode, RexLiteral>();
        HashSet<RexNode> negatedTerms = new HashSet<RexNode>();
        HashSet<RexNode> nullOperands = new HashSet<RexNode>();
        LinkedHashSet<RexNode> notNullOperands = new LinkedHashSet<RexNode>();
        HashSet<RexNode> comparedOperands = new HashSet<RexNode>();
        for (RexNode predicate : this.predicates.pulledUpPredicates) {
            RexNode result;
            Comparable v0;
            Comparison comparison = Comparison.of(predicate);
            if (comparison == null || comparison.kind == SqlKind.NOT_EQUALS || (v0 = (Comparable)comparison.literal.getValueAs(clazz)) == null || (result = RexSimplify.processRange(this.rexBuilder, terms, rangeTerms, predicate, comparison.ref, v0, comparison.kind)) == null) continue;
            return result;
        }
        block9: for (int i = 0; i < terms.size(); ++i) {
            RexCall call;
            RexNode term = terms.get(i);
            if (!RexUtil.isDeterministic(term)) continue;
            while (term.getKind() == SqlKind.EQUALS) {
                call = (RexCall)term;
                if (call.getOperands().get(0).isAlwaysTrue()) {
                    term = call.getOperands().get(1);
                    terms.set(i, term);
                    continue;
                }
                if (!call.getOperands().get(1).isAlwaysTrue()) break;
                term = call.getOperands().get(0);
                terms.set(i, term);
            }
            switch (term.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    Comparable constant;
                    RexNode result;
                    RexNode term2;
                    RexNode negatedTerm;
                    Comparison comparison;
                    call = (RexCall)term;
                    RexNode left = call.getOperands().get(0);
                    comparedOperands.add(left);
                    if (left.getKind() == SqlKind.CAST) {
                        RexCall leftCast = (RexCall)left;
                        comparedOperands.add(leftCast.getOperands().get(0));
                    }
                    RexNode right = call.getOperands().get(1);
                    comparedOperands.add(right);
                    if (right.getKind() == SqlKind.CAST) {
                        RexCall rightCast = (RexCall)right;
                        comparedOperands.add(rightCast.getOperands().get(0));
                    }
                    if ((comparison = Comparison.of(term)) != null && comparison.literal.getValue() == null) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    if (term.getKind() == SqlKind.EQUALS) {
                        if (comparison != null) {
                            RexLiteral literal = comparison.literal;
                            RexLiteral prevLiteral = equalityConstantTerms.put(comparison.ref, literal);
                            if (prevLiteral != null && !literal.equals(prevLiteral)) {
                                return this.rexBuilder.makeLiteral(false);
                            }
                        } else if (RexUtil.isReferenceOrAccess(left, true) && RexUtil.isReferenceOrAccess(right, true)) {
                            equalityTerms.put(left, Pair.of(right, term));
                        }
                    }
                    if ((negatedTerm = RexUtil.negate(this.rexBuilder, call)) != null) {
                        negatedTerms.add(negatedTerm);
                        RexNode invertNegatedTerm = RexUtil.invert(this.rexBuilder, (RexCall)negatedTerm);
                        if (invertNegatedTerm != null) {
                            negatedTerms.add(invertNegatedTerm);
                        }
                    }
                    if ((term2 = this.simplifyUsingPredicates(term, clazz)) != term) {
                        term = term2;
                        terms.set(i, term);
                    }
                    if (comparison == null || comparison.kind == SqlKind.NOT_EQUALS || (result = RexSimplify.processRange(this.rexBuilder, terms, rangeTerms, term, comparison.ref, constant = (Comparable)comparison.literal.getValueAs(clazz), comparison.kind)) == null) continue block9;
                    return result;
                }
                case IN: {
                    comparedOperands.add((RexNode)((RexCall)term).operands.get(0));
                    continue block9;
                }
                case BETWEEN: {
                    comparedOperands.add((RexNode)((RexCall)term).operands.get(1));
                    continue block9;
                }
                case IS_NOT_NULL: {
                    notNullOperands.add(((RexCall)term).getOperands().get(0));
                    terms.remove(i);
                    --i;
                    continue block9;
                }
                case IS_NULL: {
                    nullOperands.add(((RexCall)term).getOperands().get(0));
                }
            }
        }
        if (!Collections.disjoint(nullOperands, comparedOperands)) {
            return this.rexBuilder.makeLiteral(false);
        }
        for (RexNode ref1 : equalityTerms.keySet()) {
            RexLiteral literal1 = (RexLiteral)equalityConstantTerms.get(ref1);
            if (literal1 == null) continue;
            Collection references = equalityTerms.get(ref1);
            for (Pair ref2 : references) {
                RexLiteral literal2 = (RexLiteral)equalityConstantTerms.get(ref2.left);
                if (literal2 == null) continue;
                if (!literal1.equals(literal2)) {
                    return this.rexBuilder.makeLiteral(false);
                }
                terms.remove(ref2.right);
            }
        }
        for (RexNode operand : notNullOperands) {
            if (comparedOperands.contains(operand)) continue;
            terms.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand));
        }
        HashSet<RexNode> termsSet = new HashSet<RexNode>(terms);
        for (RexNode notDisjunction : notTerms) {
            List<RexNode> terms2Set;
            if (!RexUtil.isDeterministic(notDisjunction) || !termsSet.containsAll(terms2Set = RelOptUtil.conjunctions(notDisjunction))) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction));
        }
        for (RexNode negatedTerm : negatedTerms) {
            if (!termsSet.contains(negatedTerm)) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        return RexUtil.composeConjunction(this.rexBuilder, terms);
    }

    private <C extends Comparable<C>> RexNode simplifyUsingPredicates(RexNode e, Class<C> clazz) {
        Comparison comparison = Comparison.of(e);
        if (comparison == null || comparison.kind == SqlKind.NOT_EQUALS || comparison.literal.getValue() == null) {
            return e;
        }
        Comparable v0 = (Comparable)comparison.literal.getValueAs(clazz);
        Range<Comparable> range = RexSimplify.range(comparison.kind, v0);
        Range<Comparable> range2 = this.residue(comparison.ref, range, this.predicates.pulledUpPredicates, clazz);
        if (range2 == null) {
            return this.rexBuilder.makeLiteral(false);
        }
        if (range2.equals(range)) {
            return e;
        }
        if (range2.equals(Range.all())) {
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, comparison.ref), RexUnknownAs.UNKNOWN);
        }
        if (range2.lowerEndpoint().equals(range2.upperEndpoint())) {
            if (range2.lowerBoundType() == BoundType.OPEN || range2.upperBoundType() == BoundType.OPEN) {
                return this.rexBuilder.makeLiteral(false);
            }
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, comparison.ref, this.rexBuilder.makeLiteral(range2.lowerEndpoint(), comparison.literal.getType(), comparison.literal.getTypeName()));
        }
        return e;
    }

    private <C extends Comparable<C>> Range<C> residue(RexNode ref, Range<C> r0, List<RexNode> predicates, Class<C> clazz) {
        for (RexNode predicate : predicates) {
            switch (predicate.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    RexCall call = (RexCall)predicate;
                    if (!((RexNode)call.operands.get(0)).equals(ref) || !(call.operands.get(1) instanceof RexLiteral)) break;
                    RexLiteral literal = (RexLiteral)call.operands.get(1);
                    Comparable c1 = (Comparable)literal.getValueAs(clazz);
                    Range<Comparable> r1 = RexSimplify.range(predicate.getKind(), c1);
                    if (r0.encloses(r1)) {
                        return Range.all();
                    }
                    if (r0.isConnected(r1)) {
                        return r0.intersection(r1);
                    }
                    return null;
                }
            }
        }
        return r0;
    }

    @Deprecated
    public RexNode simplifyOr(RexCall call) {
        this.ensureParanoidOff();
        return this.simplifyOr(call, RexUnknownAs.UNKNOWN);
    }

    private RexNode simplifyOr(RexCall call, RexUnknownAs unknownAs) {
        assert (call.getKind() == SqlKind.OR);
        List<RexNode> terms = RelOptUtil.disjunctions(call);
        if (this.predicateElimination) {
            this.simplifyOrTerms(terms, unknownAs);
        } else {
            this.simplifyList(terms, unknownAs);
        }
        return this.simplifyOrs(terms, unknownAs);
    }

    @Deprecated
    public RexNode simplifyOrs(List<RexNode> terms) {
        this.ensureParanoidOff();
        return this.simplifyOrs(terms, RexUnknownAs.UNKNOWN);
    }

    private void ensureParanoidOff() {
        if (this.paranoid) {
            throw new UnsupportedOperationException("Paranoid is not supported for this method");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private RexNode simplifyOrs(List<RexNode> terms, RexUnknownAs unknownAs) {
        HashMap<RexNode, RexNode> notEqualsComparisonMap = new HashMap<RexNode, RexNode>();
        RexLiteral trueLiteral = this.rexBuilder.makeLiteral(true);
        int i = 0;
        while (true) {
            block13: {
                if (i >= terms.size()) {
                    return RexUtil.composeDisjunction(this.rexBuilder, terms);
                }
                RexNode term = terms.get(i);
                switch (term.getKind()) {
                    case LITERAL: {
                        if (RexLiteral.isNullLiteral(term)) {
                            if (unknownAs == RexUnknownAs.FALSE) {
                                terms.remove(i);
                                --i;
                                break block13;
                            } else {
                                if (unknownAs != RexUnknownAs.TRUE) break;
                                return trueLiteral;
                            }
                        }
                        if (RexLiteral.booleanValue(term)) {
                            return term;
                        }
                        terms.remove(i);
                        --i;
                        break block13;
                    }
                    case NOT_EQUALS: {
                        Comparable comparable2;
                        Comparable comparable1;
                        Comparison notEqualsComparison = Comparison.of(term);
                        if (notEqualsComparison == null) break;
                        RexNode prevNotEquals = (RexNode)notEqualsComparisonMap.get(notEqualsComparison.ref);
                        if (prevNotEquals == null) {
                            notEqualsComparisonMap.put(notEqualsComparison.ref, term);
                            break;
                        }
                        if (prevNotEquals.getKind() != SqlKind.IS_NOT_NULL && (comparable1 = notEqualsComparison.literal.getValue()).compareTo(comparable2 = Comparison.of((RexNode)prevNotEquals).literal.getValue()) != 0) {
                            RexLiteral constantNull;
                            RexNode isNotNull = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, notEqualsComparison.ref);
                            RexNode newCondition = this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, isNotNull, constantNull = this.rexBuilder.makeNullLiteral(trueLiteral.getType())), unknownAs);
                            if (newCondition.isAlwaysTrue()) {
                                return trueLiteral;
                            }
                            notEqualsComparisonMap.put(notEqualsComparison.ref, isNotNull);
                            int pos = terms.indexOf(prevNotEquals);
                            terms.set(pos, newCondition);
                        }
                        terms.remove(i);
                        --i;
                        break block13;
                    }
                }
                terms.set(i, term);
            }
            ++i;
        }
    }

    private void verify(RexNode before, RexNode simplified, RexUnknownAs unknownAs) {
        if (simplified.isAlwaysFalse() && before.isAlwaysTrue()) {
            throw new AssertionError((Object)("always true [" + before + "] simplified to always false [" + simplified + "]"));
        }
        if (simplified.isAlwaysTrue() && before.isAlwaysFalse()) {
            throw new AssertionError((Object)("always false [" + before + "] simplified to always true [" + simplified + "]"));
        }
        RexAnalyzer foo0 = new RexAnalyzer(before, this.predicates);
        RexAnalyzer foo1 = new RexAnalyzer(simplified, this.predicates);
        if (foo0.unsupportedCount > 0 || foo1.unsupportedCount > 0) {
            return;
        }
        if (!foo0.variables.containsAll(foo1.variables)) {
            throw new AssertionError((Object)("variable mismatch: " + before + " has " + foo0.variables + ", " + simplified + " has " + foo1.variables));
        }
        block3: for (Map<RexNode, Comparable> map : foo0.assignments()) {
            for (RexNode predicate : this.predicates.pulledUpPredicates) {
                Comparable v = RexInterpreter.evaluate(predicate, map);
                if (v.equals(true)) continue;
                continue block3;
            }
            Comparable v0 = RexInterpreter.evaluate(foo0.e, map);
            if (v0 == null) {
                throw new AssertionError((Object)("interpreter returned null for " + foo0.e));
            }
            Comparable v1 = RexInterpreter.evaluate(foo1.e, map);
            if (v1 == null) {
                throw new AssertionError((Object)("interpreter returned null for " + foo1.e));
            }
            if (before.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                switch (unknownAs) {
                    case FALSE: 
                    case TRUE: {
                        if (v0 == NullSentinel.INSTANCE) {
                            v0 = Boolean.valueOf(unknownAs.toBoolean());
                        }
                        if (v1 != NullSentinel.INSTANCE) break;
                        v1 = Boolean.valueOf(unknownAs.toBoolean());
                    }
                }
            }
            if (!v0.equals(v1)) {
                throw new AssertionError((Object)("result mismatch: when applied to " + map + ", " + before + " yielded " + v0 + ", and " + simplified + " yielded " + v1));
            }
        }
    }

    private RexNode simplifyCast(RexCall e) {
        RexNode operand = e.getOperands().get(0);
        operand = this.simplify(operand, RexUnknownAs.UNKNOWN);
        if (this.sameTypeOrNarrowsNullability(e.getType(), operand.getType())) {
            return operand;
        }
        switch (operand.getKind()) {
            case LITERAL: {
                RexLiteral literal = (RexLiteral)operand;
                Comparable value = literal.getValueAs(Comparable.class);
                SqlTypeName typeName = literal.getTypeName();
                if (this.rexBuilder.canRemoveCastFromLiteral(e.getType(), value, typeName)) {
                    return this.rexBuilder.makeCast(e.getType(), operand);
                }
                switch (literal.getTypeName()) {
                    case TIME: {
                        switch (e.getType().getSqlTypeName()) {
                            case TIMESTAMP: {
                                return e;
                            }
                        }
                    }
                }
                ArrayList<RexNode> reducedValues = new ArrayList<RexNode>();
                this.executor.reduce(this.rexBuilder, ImmutableList.of(e), reducedValues);
                return Objects.requireNonNull(Iterables.getOnlyElement(reducedValues));
            }
        }
        if (operand == e.getOperands().get(0)) {
            return e;
        }
        return this.rexBuilder.makeCast(e.getType(), operand);
    }

    private RexNode simplifyCeilFloor(RexCall e) {
        if (e.getOperands().size() != 2) {
            return e;
        }
        RexNode operand = this.simplify(e.getOperands().get(0), RexUnknownAs.UNKNOWN);
        if (e.getKind() == operand.getKind()) {
            assert (e.getKind() == SqlKind.CEIL || e.getKind() == SqlKind.FLOOR);
            RexCall child = (RexCall)operand;
            if (child.getOperands().size() != 2) {
                return e;
            }
            RexLiteral parentFlag = (RexLiteral)e.operands.get(1);
            TimeUnitRange parentFlagValue = (TimeUnitRange)((Object)parentFlag.getValue());
            RexLiteral childFlag = (RexLiteral)child.operands.get(1);
            TimeUnitRange childFlagValue = (TimeUnitRange)((Object)childFlag.getValue());
            if (parentFlagValue != null && childFlagValue != null && RexSimplify.canRollUp(parentFlagValue.startUnit, childFlagValue.startUnit)) {
                return e.clone(e.getType(), ImmutableList.of(child.getOperands().get(0), parentFlag));
            }
        }
        return e.clone(e.getType(), ImmutableList.of(operand, e.getOperands().get(1)));
    }

    private static boolean canRollUp(TimeUnit outer, TimeUnit inner) {
        switch (outer) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case MILLISECOND: 
            case MICROSECOND: {
                switch (inner) {
                    case YEAR: 
                    case QUARTER: 
                    case MONTH: 
                    case DAY: 
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: 
                    case MILLISECOND: 
                    case MICROSECOND: {
                        if (inner == TimeUnit.QUARTER) {
                            return outer == TimeUnit.YEAR || outer == TimeUnit.QUARTER;
                        }
                        return outer.ordinal() <= inner.ordinal();
                    }
                }
                break;
            }
            case QUARTER: {
                switch (inner) {
                    case QUARTER: 
                    case MONTH: 
                    case DAY: 
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: 
                    case MILLISECOND: 
                    case MICROSECOND: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public RexNode removeNullabilityCast(RexNode e) {
        return RexUtil.removeNullabilityCast(this.rexBuilder.getTypeFactory(), e);
    }

    private static <C extends Comparable<C>> RexNode processRange(RexBuilder rexBuilder, List<RexNode> terms, Map<RexNode, Pair<Range<C>, List<RexNode>>> rangeTerms, RexNode term, RexNode ref, C v0, SqlKind comparison) {
        Pair<Range<C>, List<RexNode>> p = rangeTerms.get(ref);
        if (p == null) {
            rangeTerms.put(ref, Pair.of(RexSimplify.range(comparison, v0), ImmutableList.of(term)));
        } else {
            ImmutableList.Builder newBounds;
            boolean removeUpperBound = false;
            boolean removeLowerBound = false;
            Range<C> r = (Range<C>)p.left;
            RexLiteral trueLiteral = rexBuilder.makeLiteral(true);
            switch (comparison) {
                case EQUALS: {
                    if (!r.contains(v0)) {
                        return rexBuilder.makeLiteral(false);
                    }
                    rangeTerms.put(ref, Pair.of(Range.singleton(v0), ImmutableList.of(term)));
                    for (RexNode e : (List)p.right) {
                        RexSimplify.replaceLast(terms, e, trueLiteral);
                    }
                    break;
                }
                case LESS_THAN: {
                    int comparisonResult = 0;
                    if (r.hasUpperBound()) {
                        comparisonResult = v0.compareTo(r.upperEndpoint());
                    }
                    if (comparisonResult <= 0) {
                        if (r.hasLowerBound()) {
                            if (v0.compareTo(r.lowerEndpoint()) <= 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(r.lowerEndpoint(), r.lowerBoundType(), v0, BoundType.OPEN);
                        } else {
                            r = Range.lessThan(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeUpperBound = true;
                        break;
                    }
                    RexSimplify.replaceLast(terms, term, trueLiteral);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    int comparisonResult = -1;
                    if (r.hasUpperBound()) {
                        comparisonResult = v0.compareTo(r.upperEndpoint());
                    }
                    if (comparisonResult < 0) {
                        if (r.hasLowerBound()) {
                            if (v0.compareTo(r.lowerEndpoint()) < 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(r.lowerEndpoint(), r.lowerBoundType(), v0, BoundType.CLOSED);
                        } else {
                            r = Range.atMost(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeUpperBound = true;
                        break;
                    }
                    RexSimplify.replaceLast(terms, term, trueLiteral);
                    break;
                }
                case GREATER_THAN: {
                    int comparisonResult = 0;
                    if (r.hasLowerBound()) {
                        comparisonResult = v0.compareTo(r.lowerEndpoint());
                    }
                    if (comparisonResult >= 0) {
                        if (r.hasUpperBound()) {
                            if (v0.compareTo(r.upperEndpoint()) >= 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(v0, BoundType.OPEN, r.upperEndpoint(), r.upperBoundType());
                        } else {
                            r = Range.greaterThan(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeLowerBound = true;
                        break;
                    }
                    RexSimplify.replaceLast(terms, term, trueLiteral);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    int comparisonResult = 1;
                    if (r.hasLowerBound()) {
                        comparisonResult = v0.compareTo(r.lowerEndpoint());
                    }
                    if (comparisonResult > 0) {
                        if (r.hasUpperBound()) {
                            if (v0.compareTo(r.upperEndpoint()) > 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(v0, BoundType.CLOSED, r.upperEndpoint(), r.upperBoundType());
                        } else {
                            r = Range.atLeast(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeLowerBound = true;
                        break;
                    }
                    RexSimplify.replaceLast(terms, term, trueLiteral);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (removeUpperBound) {
                newBounds = ImmutableList.builder();
                for (RexNode e : (List)p.right) {
                    if (RexSimplify.isUpperBound(e)) {
                        RexSimplify.replaceLast(terms, e, trueLiteral);
                        continue;
                    }
                    newBounds.add(e);
                }
                newBounds.add(term);
                rangeTerms.put(ref, Pair.of(r, newBounds.build()));
            } else if (removeLowerBound) {
                newBounds = ImmutableList.builder();
                for (RexNode e : (List)p.right) {
                    if (RexSimplify.isLowerBound(e)) {
                        RexSimplify.replaceLast(terms, e, trueLiteral);
                        continue;
                    }
                    newBounds.add(e);
                }
                newBounds.add(term);
                rangeTerms.put(ref, Pair.of(r, newBounds.build()));
            }
        }
        return null;
    }

    private static <C extends Comparable<C>> Range<C> range(SqlKind comparison, C c) {
        switch (comparison) {
            case EQUALS: {
                return Range.singleton(c);
            }
            case LESS_THAN: {
                return Range.lessThan(c);
            }
            case LESS_THAN_OR_EQUAL: {
                return Range.atMost(c);
            }
            case GREATER_THAN: {
                return Range.greaterThan(c);
            }
            case GREATER_THAN_OR_EQUAL: {
                return Range.atLeast(c);
            }
        }
        throw new AssertionError();
    }

    private static boolean isUpperBound(RexNode e) {
        switch (e.getKind()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(0), true) && operands.get(1).isA(SqlKind.LITERAL);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(1), true) && operands.get(0).isA(SqlKind.LITERAL);
            }
        }
        return false;
    }

    private static boolean isLowerBound(RexNode e) {
        switch (e.getKind()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(1), true) && operands.get(0).isA(SqlKind.LITERAL);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(0), true) && operands.get(1).isA(SqlKind.LITERAL);
            }
        }
        return false;
    }

    public RexNode simplifyFilterPredicates(Iterable<? extends RexNode> predicates) {
        RexNode simplifiedAnds = this.withPredicateElimination(false).simplifyUnknownAsFalse(RexUtil.composeConjunction(this.rexBuilder, predicates));
        if (simplifiedAnds.isAlwaysFalse()) {
            return null;
        }
        return this.removeNullabilityCast(simplifiedAnds);
    }

    private static <E> boolean replaceLast(List<E> list, E oldVal, E newVal) {
        int index = list.lastIndexOf(oldVal);
        if (index < 0) {
            return false;
        }
        list.set(index, newVal);
        return true;
    }

    private static class IsPredicate
    implements Predicate {
        final RexNode ref;
        final SqlKind kind;

        private IsPredicate(RexNode ref, SqlKind kind) {
            this.ref = Objects.requireNonNull(ref);
            this.kind = Objects.requireNonNull(kind);
        }

        static IsPredicate of(RexNode e) {
            switch (e.getKind()) {
                case IS_NULL: 
                case IS_NOT_NULL: {
                    RexNode pA = ((RexCall)e).getOperands().get(0);
                    if (!RexUtil.isReferenceOrAccess(pA, true)) {
                        return null;
                    }
                    return new IsPredicate(pA, e.getKind());
                }
            }
            return null;
        }
    }

    private static class Comparison
    implements Predicate {
        final RexNode ref;
        final SqlKind kind;
        final RexLiteral literal;

        private Comparison(RexNode ref, SqlKind kind, RexLiteral literal) {
            this.ref = Objects.requireNonNull(ref);
            this.kind = Objects.requireNonNull(kind);
            this.literal = Objects.requireNonNull(literal);
        }

        static Comparison of(RexNode e) {
            return Comparison.of(e, node -> RexUtil.isReferenceOrAccess(node, true));
        }

        /*
         * Enabled aggressive block sorting
         */
        static Comparison of(RexNode e, java.util.function.Predicate<RexNode> nodePredicate) {
            switch (e.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    RexCall call = (RexCall)e;
                    RexNode left = call.getOperands().get(0);
                    RexNode right = call.getOperands().get(1);
                    switch (right.getKind()) {
                        case LITERAL: {
                            if (!nodePredicate.test(left)) break;
                            return new Comparison(left, e.getKind(), (RexLiteral)right);
                        }
                    }
                    switch (left.getKind()) {
                        case LITERAL: {
                            if (!nodePredicate.test(right)) return null;
                            return new Comparison(right, e.getKind().reverse(), (RexLiteral)left);
                        }
                    }
                    return null;
                }
            }
            return null;
        }
    }

    private static interface Predicate {
        public static Predicate of(RexNode t) {
            Comparison p = Comparison.of(t);
            if (p != null) {
                return p;
            }
            return IsPredicate.of(t);
        }
    }

    static enum SafeRexVisitor implements RexVisitor<Boolean>
    {
        INSTANCE;

        private final Set<SqlKind> safeOps;

        private SafeRexVisitor() {
            EnumSet<SqlKind> safeOps = EnumSet.noneOf(SqlKind.class);
            safeOps.addAll(SqlKind.COMPARISON);
            safeOps.add(SqlKind.PLUS_PREFIX);
            safeOps.add(SqlKind.MINUS_PREFIX);
            safeOps.add(SqlKind.PLUS);
            safeOps.add(SqlKind.MINUS);
            safeOps.add(SqlKind.TIMES);
            safeOps.add(SqlKind.IS_FALSE);
            safeOps.add(SqlKind.IS_NOT_FALSE);
            safeOps.add(SqlKind.IS_TRUE);
            safeOps.add(SqlKind.IS_NOT_TRUE);
            safeOps.add(SqlKind.IS_NULL);
            safeOps.add(SqlKind.IS_NOT_NULL);
            safeOps.add(SqlKind.IS_DISTINCT_FROM);
            safeOps.add(SqlKind.IS_NOT_DISTINCT_FROM);
            safeOps.add(SqlKind.IN);
            safeOps.add(SqlKind.NOT_IN);
            safeOps.add(SqlKind.OR);
            safeOps.add(SqlKind.AND);
            safeOps.add(SqlKind.NOT);
            safeOps.add(SqlKind.CASE);
            safeOps.add(SqlKind.LIKE);
            safeOps.add(SqlKind.COALESCE);
            safeOps.add(SqlKind.TRIM);
            safeOps.add(SqlKind.LTRIM);
            safeOps.add(SqlKind.RTRIM);
            safeOps.add(SqlKind.BETWEEN);
            safeOps.add(SqlKind.CEIL);
            safeOps.add(SqlKind.FLOOR);
            safeOps.add(SqlKind.REVERSE);
            safeOps.add(SqlKind.TIMESTAMP_ADD);
            safeOps.add(SqlKind.TIMESTAMP_DIFF);
            safeOps.add(SqlKind.LIKE);
            this.safeOps = Sets.immutableEnumSet(safeOps);
        }

        @Override
        public Boolean visitInputRef(RexInputRef inputRef) {
            return true;
        }

        @Override
        public Boolean visitLocalRef(RexLocalRef localRef) {
            return false;
        }

        @Override
        public Boolean visitLiteral(RexLiteral literal) {
            return true;
        }

        @Override
        public Boolean visitCall(RexCall call) {
            if (!this.safeOps.contains((Object)call.getKind())) {
                return false;
            }
            for (RexNode o : call.getOperands()) {
                if (o.accept(this).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitOver(RexOver over) {
            return false;
        }

        @Override
        public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
            return false;
        }

        @Override
        public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
            return false;
        }

        @Override
        public Boolean visitRangeRef(RexRangeRef rangeRef) {
            return false;
        }

        @Override
        public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
            return true;
        }

        @Override
        public Boolean visitSubQuery(RexSubQuery subQuery) {
            return false;
        }

        @Override
        public Boolean visitTableInputRef(RexTableInputRef fieldRef) {
            return false;
        }

        @Override
        public Boolean visitPatternFieldRef(RexPatternFieldRef fieldRef) {
            return false;
        }
    }

    static final class CaseBranch {
        private final RexNode cond;
        private final RexNode value;

        CaseBranch(RexNode cond, RexNode value) {
            this.cond = cond;
            this.value = value;
        }

        public String toString() {
            return this.cond + " => " + this.value;
        }

        private static List<CaseBranch> fromCaseOperands(RexBuilder rexBuilder, List<RexNode> operands) {
            ArrayList<CaseBranch> ret = new ArrayList<CaseBranch>();
            for (int i = 0; i < operands.size() - 1; i += 2) {
                ret.add(new CaseBranch(operands.get(i), operands.get(i + 1)));
            }
            ret.add(new CaseBranch(rexBuilder.makeLiteral(true), Util.last(operands)));
            return ret;
        }

        private static List<RexNode> toCaseOperands(RexBuilder rexBuilder, List<CaseBranch> branches) {
            ArrayList<RexNode> ret = new ArrayList<RexNode>();
            for (int i = 0; i < branches.size() - 1; ++i) {
                CaseBranch branch = branches.get(i);
                ret.add(branch.cond);
                ret.add(branch.value);
            }
            CaseBranch lastBranch = Util.last(branches);
            assert (lastBranch.cond.isAlwaysTrue());
            ret.add(lastBranch.value);
            return ret;
        }
    }
}

