/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.linkedin.coral.com.google.common.collect.ForwardingMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SealableMap<K, V>
extends ForwardingMap<K, V> {
    private final Map<K, V> delegate;
    private final Map<K, V> readOnlyDelegate;
    private boolean sealed = false;

    public SealableMap(Map<K, V> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Delegate map cannot be null");
        this.readOnlyDelegate = Collections.unmodifiableMap(delegate);
    }

    public void seal() {
        this.sealed = true;
    }

    public void unseal() {
        this.sealed = false;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    protected Map<K, V> delegate() {
        return this.sealed ? this.readOnlyDelegate : this.delegate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SealableMap)) {
            return false;
        }
        SealableMap that = (SealableMap)o;
        return this.sealed == that.sealed && super.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegate, this.sealed);
    }

    @Override
    public String toString() {
        return "SealableMap{delegate=" + this.delegate + ", sealed=" + this.sealed + '}';
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.checkSealed();
        this.delegate.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.checkSealed();
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.checkSealed();
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkSealed();
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        this.checkSealed();
        return this.delegate.replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.checkSealed();
        return this.delegate.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkSealed();
        return this.delegate.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkSealed();
        return this.delegate.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.checkSealed();
        return this.delegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    private void checkSealed() {
        if (this.sealed) {
            throw new IllegalStateException("Cannot write to this map when it is sealed");
        }
    }
}

