/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.apache.http.client.utils.URIBuilder;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.FileSystemOperationUnhandledException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidFileSystemPropertyException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriAuthorityException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TimeoutException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultEntrySchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsAclHelper;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsPermission;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AzureBlobFileSystemStore {
    private static final Logger LOG = LoggerFactory.getLogger(AzureBlobFileSystemStore.class);
    private AbfsClient client;
    private URI uri;
    private final UserGroupInformation userGroupInformation;
    private final String userName;
    private final String primaryUserGroup;
    private static final String DATE_TIME_PATTERN = "E, dd MMM yyyy HH:mm:ss z";
    private static final String XMS_PROPERTIES_ENCODING = "ISO-8859-1";
    private static final int LIST_MAX_RESULTS = 5000;
    private static final int DELETE_DIRECTORY_TIMEOUT_MILISECONDS = 180000;
    private static final int RENAME_TIMEOUT_MILISECONDS = 180000;
    private final AbfsConfiguration abfsConfiguration;
    private final Set<String> azureAtomicRenameDirSet;
    private boolean isNamespaceEnabledSet;
    private boolean isNamespaceEnabled;

    public AzureBlobFileSystemStore(URI uri, boolean isSecureScheme, Configuration configuration, UserGroupInformation userGroupInformation) throws AzureBlobFileSystemException, IOException {
        this.uri = uri;
        String[] authorityParts = this.authorityParts(uri);
        String fileSystemName = authorityParts[0];
        String accountName = authorityParts[1];
        try {
            this.abfsConfiguration = new AbfsConfiguration(configuration, accountName);
        }
        catch (IllegalAccessException exception) {
            throw new FileSystemOperationUnhandledException(exception);
        }
        this.userGroupInformation = userGroupInformation;
        this.userName = userGroupInformation.getShortUserName();
        this.primaryUserGroup = !this.abfsConfiguration.getSkipUserGroupMetadataDuringInitialization() ? userGroupInformation.getPrimaryGroupName() : this.userName;
        this.azureAtomicRenameDirSet = new HashSet<String>(Arrays.asList(this.abfsConfiguration.getAzureAtomicRenameDirs().split(",")));
        boolean usingOauth = AuthType.OAuth == this.abfsConfiguration.getEnum("fs.azure.account.auth.type", AuthType.SharedKey);
        boolean useHttps = usingOauth || this.abfsConfiguration.isHttpsAlwaysUsed() ? true : isSecureScheme;
        this.initializeClient(uri, fileSystemName, accountName, useHttps);
    }

    private String[] authorityParts(URI uri) throws InvalidUriAuthorityException, InvalidUriException {
        String authority = uri.getRawAuthority();
        if (null == authority) {
            throw new InvalidUriAuthorityException(uri.toString());
        }
        if (!authority.contains("@")) {
            throw new InvalidUriAuthorityException(uri.toString());
        }
        String[] authorityParts = authority.split("@", 2);
        if (authorityParts.length < 2 || authorityParts[0] != null && authorityParts[0].isEmpty()) {
            String errMsg = String.format("'%s' has a malformed authority, expected container name. Authority takes the form abfs://[<container name>@]<account name>", uri.toString());
            throw new InvalidUriException(errMsg);
        }
        return authorityParts;
    }

    public boolean getIsNamespaceEnabled() throws AzureBlobFileSystemException {
        if (!this.isNamespaceEnabledSet) {
            LOG.debug("getFilesystemProperties for filesystem: {}", (Object)this.client.getFileSystem());
            AbfsRestOperation op = this.client.getFilesystemProperties();
            this.isNamespaceEnabled = Boolean.parseBoolean(op.getResult().getResponseHeader("x-ms-namespace-enabled"));
            this.isNamespaceEnabledSet = true;
        }
        return this.isNamespaceEnabled;
    }

    @.VisibleForTesting
    URIBuilder getURIBuilder(String hostName, boolean isSecure) {
        String scheme = isSecure ? "https" : "http";
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(scheme);
        String endPoint = this.abfsConfiguration.get("fs.azure.abfs.endpoint");
        if (endPoint == null || !endPoint.contains(":")) {
            uriBuilder.setHost(hostName);
            return uriBuilder;
        }
        String[] data = endPoint.split(":");
        if (data.length != 2) {
            throw new RuntimeException(String.format("ABFS endpoint is not set correctly : %s, Do not specify scheme when using {IP}:{PORT}", endPoint));
        }
        uriBuilder.setHost(data[0].trim());
        uriBuilder.setPort(Integer.parseInt(data[1].trim()));
        uriBuilder.setPath("/" + UriUtils.extractAccountNameFromHostName(hostName));
        return uriBuilder;
    }

    public AbfsConfiguration getAbfsConfiguration() {
        return this.abfsConfiguration;
    }

    public Hashtable<String, String> getFilesystemProperties() throws AzureBlobFileSystemException {
        LOG.debug("getFilesystemProperties for filesystem: {}", (Object)this.client.getFileSystem());
        AbfsRestOperation op = this.client.getFilesystemProperties();
        String xMsProperties = op.getResult().getResponseHeader("x-ms-properties");
        Hashtable<String, String> parsedXmsProperties = this.parseCommaSeparatedXmsProperties(xMsProperties);
        return parsedXmsProperties;
    }

    public void setFilesystemProperties(Hashtable<String, String> properties) throws AzureBlobFileSystemException {
        String commaSeparatedProperties;
        if (properties == null || properties.isEmpty()) {
            return;
        }
        LOG.debug("setFilesystemProperties for filesystem: {} with properties: {}", (Object)this.client.getFileSystem(), (Object)properties);
        try {
            commaSeparatedProperties = this.convertXmsPropertiesToCommaSeparatedString(properties);
        }
        catch (CharacterCodingException ex) {
            throw new InvalidAbfsRestOperationException(ex);
        }
        this.client.setFilesystemProperties(commaSeparatedProperties);
    }

    public Hashtable<String, String> getPathProperties(Path path) throws AzureBlobFileSystemException {
        LOG.debug("getPathProperties for filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
        AbfsRestOperation op = this.client.getPathProperties("/" + this.getRelativePath(path));
        String xMsProperties = op.getResult().getResponseHeader("x-ms-properties");
        Hashtable<String, String> parsedXmsProperties = this.parseCommaSeparatedXmsProperties(xMsProperties);
        return parsedXmsProperties;
    }

    public void setPathProperties(Path path, Hashtable<String, String> properties) throws AzureBlobFileSystemException {
        String commaSeparatedProperties;
        LOG.debug("setFilesystemProperties for filesystem: {} path: {} with properties: {}", this.client.getFileSystem(), path, properties);
        try {
            commaSeparatedProperties = this.convertXmsPropertiesToCommaSeparatedString(properties);
        }
        catch (CharacterCodingException ex) {
            throw new InvalidAbfsRestOperationException(ex);
        }
        this.client.setPathProperties("/" + this.getRelativePath(path), commaSeparatedProperties);
    }

    public void createFilesystem() throws AzureBlobFileSystemException {
        LOG.debug("createFilesystem for filesystem: {}", (Object)this.client.getFileSystem());
        this.client.createFilesystem();
    }

    public void deleteFilesystem() throws AzureBlobFileSystemException {
        LOG.debug("deleteFilesystem for filesystem: {}", (Object)this.client.getFileSystem());
        this.client.deleteFilesystem();
    }

    public OutputStream createFile(Path path, boolean overwrite, FsPermission permission, FsPermission umask) throws AzureBlobFileSystemException {
        boolean isNamespaceEnabled = this.getIsNamespaceEnabled();
        LOG.debug("createFile filesystem: {} path: {} overwrite: {} permission: {} umask: {} isNamespaceEnabled: {}", this.client.getFileSystem(), path, overwrite, permission.toString(), umask.toString(), isNamespaceEnabled);
        this.client.createPath("/" + this.getRelativePath(path), true, overwrite, isNamespaceEnabled ? this.getOctalNotation(permission) : null, isNamespaceEnabled ? this.getOctalNotation(umask) : null);
        return new AbfsOutputStream(this.client, "/" + this.getRelativePath(path), 0L, this.abfsConfiguration.getWriteBufferSize(), this.abfsConfiguration.isFlushEnabled());
    }

    public void createDirectory(Path path, FsPermission permission, FsPermission umask) throws AzureBlobFileSystemException {
        boolean isNamespaceEnabled = this.getIsNamespaceEnabled();
        LOG.debug("createDirectory filesystem: {} path: {} permission: {} umask: {} isNamespaceEnabled: {}", this.client.getFileSystem(), path, permission, umask, isNamespaceEnabled);
        this.client.createPath("/" + this.getRelativePath(path), false, true, isNamespaceEnabled ? this.getOctalNotation(permission) : null, isNamespaceEnabled ? this.getOctalNotation(umask) : null);
    }

    public AbfsInputStream openFileForRead(Path path, FileSystem.Statistics statistics) throws AzureBlobFileSystemException {
        LOG.debug("openFileForRead filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
        AbfsRestOperation op = this.client.getPathProperties("/" + this.getRelativePath(path));
        String resourceType = op.getResult().getResponseHeader("x-ms-resource-type");
        long contentLength = Long.parseLong(op.getResult().getResponseHeader("Content-Length"));
        String eTag = op.getResult().getResponseHeader("ETag");
        if (this.parseIsDirectory(resourceType)) {
            throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "openFileForRead must be used with files and not directories", null);
        }
        return new AbfsInputStream(this.client, statistics, "/" + this.getRelativePath(path), contentLength, this.abfsConfiguration.getReadBufferSize(), this.abfsConfiguration.getReadAheadQueueDepth(), eTag);
    }

    public OutputStream openFileForWrite(Path path, boolean overwrite) throws AzureBlobFileSystemException {
        LOG.debug("openFileForWrite filesystem: {} path: {} overwrite: {}", this.client.getFileSystem(), path, overwrite);
        AbfsRestOperation op = this.client.getPathProperties("/" + this.getRelativePath(path));
        String resourceType = op.getResult().getResponseHeader("x-ms-resource-type");
        Long contentLength = Long.valueOf(op.getResult().getResponseHeader("Content-Length"));
        if (this.parseIsDirectory(resourceType)) {
            throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "openFileForRead must be used with files and not directories", null);
        }
        long offset = overwrite ? 0L : contentLength;
        return new AbfsOutputStream(this.client, "/" + this.getRelativePath(path), offset, this.abfsConfiguration.getWriteBufferSize(), this.abfsConfiguration.isFlushEnabled());
    }

    public void rename(Path source, Path destination) throws AzureBlobFileSystemException {
        AbfsRestOperation op;
        if (this.isAtomicRenameKey(source.getName())) {
            LOG.warn("The atomic rename feature is not supported by the ABFS scheme; however rename, create and delete operations are atomic if Namespace is enabled for your Azure Storage account.");
        }
        LOG.debug("renameAsync filesystem: {} source: {} destination: {}", this.client.getFileSystem(), source, destination);
        String continuation = null;
        long deadline = Time.now() + 180000L;
        do {
            if (Time.now() <= deadline) continue;
            LOG.debug("Rename {} to {} timed out.", (Object)source, (Object)destination);
            throw new TimeoutException("Rename timed out.");
        } while ((continuation = (op = this.client.renamePath("/" + this.getRelativePath(source), "/" + this.getRelativePath(destination), continuation)).getResult().getResponseHeader("x-ms-continuation")) != null && !continuation.isEmpty());
    }

    public void delete(Path path, boolean recursive) throws AzureBlobFileSystemException {
        AbfsRestOperation op;
        LOG.debug("delete filesystem: {} path: {} recursive: {}", this.client.getFileSystem(), path, String.valueOf(recursive));
        String continuation = null;
        long deadline = Time.now() + 180000L;
        do {
            if (Time.now() <= deadline) continue;
            LOG.debug("Delete directory {} timed out.", (Object)path);
            throw new TimeoutException("Delete directory timed out.");
        } while ((continuation = (op = this.client.deletePath("/" + this.getRelativePath(path), recursive, continuation)).getResult().getResponseHeader("x-ms-continuation")) != null && !continuation.isEmpty());
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        boolean isNamespaceEnabled = this.getIsNamespaceEnabled();
        LOG.debug("getFileStatus filesystem: {} path: {} isNamespaceEnabled: {}", this.client.getFileSystem(), path, isNamespaceEnabled);
        if (path.isRoot()) {
            AbfsRestOperation op = isNamespaceEnabled ? this.client.getAclStatus("//") : this.client.getFilesystemProperties();
            long blockSize = this.abfsConfiguration.getAzureBlockSize();
            String owner = op.getResult().getResponseHeader("x-ms-owner");
            String group = op.getResult().getResponseHeader("x-ms-group");
            String permissions = op.getResult().getResponseHeader("x-ms-permissions");
            String eTag = op.getResult().getResponseHeader("ETag");
            String lastModified = op.getResult().getResponseHeader("Last-Modified");
            boolean hasAcl = AbfsPermission.isExtendedAcl(permissions);
            return new VersionedFileStatus(owner == null ? this.userName : owner, group == null ? this.primaryUserGroup : group, permissions == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(permissions), hasAcl, 0L, true, 1, blockSize, this.parseLastModifiedTime(lastModified), path, eTag);
        }
        AbfsRestOperation op = this.client.getPathProperties("/" + this.getRelativePath(path));
        long blockSize = this.abfsConfiguration.getAzureBlockSize();
        AbfsHttpOperation result = op.getResult();
        String eTag = result.getResponseHeader("ETag");
        String lastModified = result.getResponseHeader("Last-Modified");
        String contentLength = result.getResponseHeader("Content-Length");
        String resourceType = result.getResponseHeader("x-ms-resource-type");
        String owner = result.getResponseHeader("x-ms-owner");
        String group = result.getResponseHeader("x-ms-group");
        String permissions = result.getResponseHeader("x-ms-permissions");
        boolean hasAcl = AbfsPermission.isExtendedAcl(permissions);
        return new VersionedFileStatus(owner == null ? this.userName : owner, group == null ? this.primaryUserGroup : group, permissions == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(permissions), hasAcl, this.parseContentLength(contentLength), this.parseIsDirectory(resourceType), 1, blockSize, this.parseLastModifiedTime(lastModified), path, eTag);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        LOG.debug("listStatus filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
        String relativePath = path.isRoot() ? "" : this.getRelativePath(path);
        String continuation = null;
        ArrayList<VersionedFileStatus> fileStatuses = new ArrayList<VersionedFileStatus>();
        do {
            AbfsRestOperation op = this.client.listPath(relativePath, false, 5000, continuation);
            continuation = op.getResult().getResponseHeader("x-ms-continuation");
            ListResultSchema retrievedSchema = op.getResult().getListResultSchema();
            if (retrievedSchema == null) {
                throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "listStatusAsync path not found", null, op.getResult());
            }
            long blockSize = this.abfsConfiguration.getAzureBlockSize();
            for (ListResultEntrySchema entry : retrievedSchema.paths()) {
                boolean isDirectory;
                String owner = entry.owner() == null ? this.userName : entry.owner();
                String group = entry.group() == null ? this.primaryUserGroup : entry.group();
                AbfsPermission fsPermission = entry.permissions() == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(entry.permissions());
                boolean hasAcl = AbfsPermission.isExtendedAcl(entry.permissions());
                long lastModifiedMillis = 0L;
                long contentLength = entry.contentLength() == null ? 0L : entry.contentLength();
                boolean bl = isDirectory = entry.isDirectory() == null ? false : entry.isDirectory();
                if (entry.lastModified() != null && !entry.lastModified().isEmpty()) {
                    lastModifiedMillis = this.parseLastModifiedTime(entry.lastModified());
                }
                Path entryPath = new Path(File.separator + entry.name());
                entryPath = entryPath.makeQualified(this.uri, entryPath);
                fileStatuses.add(new VersionedFileStatus(owner, group, fsPermission, hasAcl, contentLength, isDirectory, 1, blockSize, lastModifiedMillis, entryPath, entry.eTag()));
            }
        } while (continuation != null && !continuation.isEmpty());
        return fileStatuses.toArray(new FileStatus[0]);
    }

    public void setOwner(Path path, String owner, String group) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        LOG.debug("setOwner filesystem: {} path: {} owner: {} group: {}", this.client.getFileSystem(), path.toString(), owner, group);
        this.client.setOwner("/" + this.getRelativePath(path, true), owner, group);
    }

    public void setPermission(Path path, FsPermission permission) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        LOG.debug("setPermission filesystem: {} path: {} permission: {}", this.client.getFileSystem(), path.toString(), permission.toString());
        this.client.setPermission("/" + this.getRelativePath(path, true), String.format("%04d", permission.toOctal()));
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        LOG.debug("modifyAclEntries filesystem: {} path: {} aclSpec: {}", this.client.getFileSystem(), path.toString(), AclEntry.aclSpecToString(aclSpec));
        Map<String, String> modifyAclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
        AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true));
        String eTag = op.getResult().getResponseHeader("ETag");
        Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
        for (Map.Entry<String, String> modifyAclEntry : modifyAclEntries.entrySet()) {
            aclEntries.put(modifyAclEntry.getKey(), modifyAclEntry.getValue());
        }
        if (!modifyAclEntries.containsKey("mask:")) {
            aclEntries.remove("mask:");
        }
        if (!modifyAclEntries.containsKey("default:mask:")) {
            aclEntries.remove("default:mask:");
        }
        this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(aclEntries), eTag);
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        LOG.debug("removeAclEntries filesystem: {} path: {} aclSpec: {}", this.client.getFileSystem(), path.toString(), AclEntry.aclSpecToString(aclSpec));
        Map<String, String> removeAclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
        AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true));
        String eTag = op.getResult().getResponseHeader("ETag");
        Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
        AbfsAclHelper.removeAclEntriesInternal(aclEntries, removeAclEntries);
        this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(aclEntries), eTag);
    }

    public void removeDefaultAcl(Path path) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        LOG.debug("removeDefaultAcl filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path.toString());
        AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true));
        String eTag = op.getResult().getResponseHeader("ETag");
        Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
        HashMap<String, String> defaultAclEntries = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : aclEntries.entrySet()) {
            if (!entry.getKey().startsWith("default:")) continue;
            defaultAclEntries.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : defaultAclEntries.entrySet()) {
            aclEntries.remove(entry.getKey());
        }
        this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(aclEntries), eTag);
    }

    public void removeAcl(Path path) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        LOG.debug("removeAcl filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path.toString());
        AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true));
        String eTag = op.getResult().getResponseHeader("ETag");
        Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
        HashMap<String, String> newAclEntries = new HashMap<String, String>();
        newAclEntries.put("user:", aclEntries.get("user:"));
        newAclEntries.put("group:", aclEntries.get("group:"));
        newAclEntries.put("other:", aclEntries.get("other:"));
        this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(newAclEntries), eTag);
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        LOG.debug("setAcl filesystem: {} path: {} aclspec: {}", this.client.getFileSystem(), path.toString(), AclEntry.aclSpecToString(aclSpec));
        Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
        AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true));
        String eTag = op.getResult().getResponseHeader("ETag");
        Map<String, String> getAclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
        for (Map.Entry<String, String> ace : getAclEntries.entrySet()) {
            if (!ace.getKey().startsWith("default:") || ace.getKey() == "default:mask:" || aclEntries.containsKey(ace.getKey())) continue;
            aclEntries.put(ace.getKey(), ace.getValue());
        }
        this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(aclEntries), eTag);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        LOG.debug("getAclStatus filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path.toString());
        AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true));
        AbfsHttpOperation result = op.getResult();
        String owner = result.getResponseHeader("x-ms-owner");
        String group = result.getResponseHeader("x-ms-group");
        String permissions = result.getResponseHeader("x-ms-permissions");
        String aclSpecString = op.getResult().getResponseHeader("x-ms-acl");
        List<AclEntry> processedAclEntries = AclEntry.parseAclSpec(AbfsAclHelper.processAclString(aclSpecString), true);
        AbfsPermission fsPermission = permissions == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(permissions);
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner(owner == null ? this.userName : owner);
        aclStatusBuilder.group(group == null ? this.primaryUserGroup : group);
        aclStatusBuilder.setPermission(fsPermission);
        aclStatusBuilder.stickyBit(fsPermission.getStickyBit());
        aclStatusBuilder.addEntries(processedAclEntries);
        return aclStatusBuilder.build();
    }

    public boolean isAtomicRenameKey(String key) {
        return this.isKeyForDirectorySet(key, this.azureAtomicRenameDirSet);
    }

    private void initializeClient(URI uri, String fileSystemName, String accountName, boolean isSecure) throws AzureBlobFileSystemException {
        URL baseUrl;
        if (this.client != null) {
            return;
        }
        URIBuilder uriBuilder = this.getURIBuilder(accountName, isSecure);
        String url = uriBuilder.toString() + "/" + fileSystemName;
        try {
            baseUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new InvalidUriException(uri.toString());
        }
        SharedKeyCredentials creds = null;
        AccessTokenProvider tokenProvider = null;
        if (this.abfsConfiguration.getAuthType(accountName) == AuthType.SharedKey) {
            int dotIndex = accountName.indexOf(".");
            if (dotIndex <= 0) {
                throw new InvalidUriException(uri.toString() + " - account name is not fully qualified.");
            }
            creds = new SharedKeyCredentials(accountName.substring(0, dotIndex), this.abfsConfiguration.getStorageAccountKey());
        } else {
            tokenProvider = this.abfsConfiguration.getTokenProvider();
        }
        this.client = new AbfsClient(baseUrl, creds, this.abfsConfiguration, new ExponentialRetryPolicy(), tokenProvider);
    }

    private String getOctalNotation(FsPermission fsPermission) {
        Preconditions.checkNotNull(fsPermission, "fsPermission");
        return String.format("%04d", fsPermission.toOctal());
    }

    private String getRelativePath(Path path) {
        return this.getRelativePath(path, false);
    }

    private String getRelativePath(Path path, boolean allowRootPath) {
        Preconditions.checkNotNull(path, "path");
        String relativePath = path.toUri().getPath();
        if (relativePath.length() == 0 || relativePath.length() == 1 && relativePath.charAt(0) == '/') {
            return allowRootPath ? "/" : "";
        }
        if (relativePath.charAt(0) == '/') {
            return relativePath.substring(1);
        }
        return relativePath;
    }

    private long parseContentLength(String contentLength) {
        if (contentLength == null) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    private boolean parseIsDirectory(String resourceType) {
        return resourceType != null && resourceType.equalsIgnoreCase("directory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long parseLastModifiedTime(String lastModifiedTime) {
        long parsedTime = 0L;
        try {
            Date utcDate = new SimpleDateFormat(DATE_TIME_PATTERN).parse(lastModifiedTime);
            parsedTime = utcDate.getTime();
            return parsedTime;
        }
        catch (ParseException e) {
            LOG.error("Failed to parse the date {}", (Object)lastModifiedTime);
        }
        finally {
            return parsedTime;
        }
    }

    private String convertXmsPropertiesToCommaSeparatedString(Hashtable<String, String> properties) throws CharacterCodingException {
        StringBuilder commaSeparatedProperties = new StringBuilder();
        CharsetEncoder encoder = Charset.forName(XMS_PROPERTIES_ENCODING).newEncoder();
        for (Map.Entry<String, String> propertyEntry : properties.entrySet()) {
            String key = propertyEntry.getKey();
            String value = propertyEntry.getValue();
            Boolean canEncodeValue = encoder.canEncode(value);
            if (!canEncodeValue.booleanValue()) {
                throw new CharacterCodingException();
            }
            String encodedPropertyValue = Base64.encode(encoder.encode(CharBuffer.wrap(value)).array());
            commaSeparatedProperties.append(key).append("=").append(encodedPropertyValue);
            commaSeparatedProperties.append(",");
        }
        if (commaSeparatedProperties.length() != 0) {
            commaSeparatedProperties.deleteCharAt(commaSeparatedProperties.length() - 1);
        }
        return commaSeparatedProperties.toString();
    }

    private Hashtable<String, String> parseCommaSeparatedXmsProperties(String xMsProperties) throws InvalidFileSystemPropertyException, InvalidAbfsRestOperationException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        CharsetDecoder decoder = Charset.forName(XMS_PROPERTIES_ENCODING).newDecoder();
        if (xMsProperties != null && !xMsProperties.isEmpty()) {
            String[] userProperties = xMsProperties.split(",");
            if (userProperties.length == 0) {
                return properties;
            }
            for (String property : userProperties) {
                String value;
                if (property.isEmpty()) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                String[] nameValue = property.split("=", 2);
                if (nameValue.length != 2) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                byte[] decodedValue = Base64.decode(nameValue[1]);
                try {
                    value = decoder.decode(ByteBuffer.wrap(decodedValue)).toString();
                }
                catch (CharacterCodingException ex) {
                    throw new InvalidAbfsRestOperationException(ex);
                }
                properties.put(nameValue[0], value);
            }
        }
        return properties;
    }

    private boolean isKeyForDirectorySet(String key, Set<String> dirSet) {
        for (String dir : dirSet) {
            if (dir.isEmpty() || key.startsWith(dir + "/")) {
                return true;
            }
            try {
                URI uri = new URI(dir);
                if (null != uri.getAuthority() || !key.startsWith(dir + "/")) continue;
                return true;
            }
            catch (URISyntaxException e) {
                LOG.info("URI syntax error creating URI for {}", (Object)dir);
            }
        }
        return false;
    }

    @.VisibleForTesting
    AbfsClient getClient() {
        return this.client;
    }

    private static class VersionedFileStatus
    extends FileStatus {
        private final String version;

        VersionedFileStatus(String owner, String group, FsPermission fsPermission, boolean hasAcl, long length, boolean isdir, int blockReplication, long blocksize, long modificationTime, Path path, String version) {
            super(length, isdir, blockReplication, blocksize, modificationTime, 0L, fsPermission, owner, group, null, path, hasAcl, false, false);
            this.version = version;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FileStatus)) {
                return false;
            }
            FileStatus other = (FileStatus)obj;
            if (!other.equals(this)) {
                return false;
            }
            if (other instanceof VersionedFileStatus) {
                return this.version.equals(((VersionedFileStatus)other).version);
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = this.getPath().hashCode();
            hash = 89 * hash + (this.version != null ? this.version.hashCode() : 0);
            return hash;
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("VersionedFileStatus{");
            sb.append(super.toString());
            sb.append("; version='").append(this.version).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

