/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.Gauge;
import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Ticker;
import com.google.shaded.shaded.common.cache.Cache;
import com.google.shaded.shaded.common.cache.CacheBuilder;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.thrift.HeartbeatStatus;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class CoordinatorBookKeeper
extends BookKeeper {
    private static Log log = LogFactory.getLog((String)CoordinatorBookKeeper.class.getName());
    protected Cache<String, Boolean> liveWorkerCache;
    protected Cache<String, Boolean> cachingValidatedWorkerCache;
    protected Cache<String, Boolean> fileValidatedWorkerCache;
    private final boolean isValidationEnabled;

    public CoordinatorBookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics) throws FileNotFoundException {
        this(conf, bookKeeperMetrics, Ticker.systemTicker());
    }

    @VisibleForTesting
    public CoordinatorBookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics, Ticker ticker) throws FileNotFoundException {
        super(conf, bookKeeperMetrics, ticker);
        this.isValidationEnabled = CacheConfig.isValidationEnabled(conf);
        this.liveWorkerCache = this.createHealthCache(conf, ticker);
        this.cachingValidatedWorkerCache = this.createHealthCache(conf, ticker);
        this.fileValidatedWorkerCache = this.createHealthCache(conf, ticker);
        this.registerMetrics();
    }

    @Override
    public void handleHeartbeat(String workerHostname, HeartbeatStatus heartbeatStatus) {
        if (CacheConfig.isHeartbeatEnabled(this.conf) || !CacheConfig.isEmbeddedModeEnabled(this.conf)) {
            this.liveWorkerCache.put(workerHostname, true);
            log.debug((Object)("Received heartbeat from " + workerHostname));
            if (this.isValidationEnabled) {
                if (heartbeatStatus.cachingValidationSucceeded) {
                    this.cachingValidatedWorkerCache.put(workerHostname, true);
                } else {
                    log.error((Object)String.format("Caching validation failed for worker node (hostname: %s)", workerHostname));
                }
                if (heartbeatStatus.fileValidationSucceeded) {
                    this.fileValidatedWorkerCache.put(workerHostname, true);
                } else {
                    log.error((Object)String.format("File validation failed for worker node (hostname: %s)", workerHostname));
                }
            }
        }
    }

    private void registerMetrics() {
        this.metrics.register(BookKeeperMetrics.HealthMetric.LIVE_WORKER_GAUGE.getMetricName(), new Gauge<Long>(){

            @Override
            public Long getValue() {
                CoordinatorBookKeeper.this.liveWorkerCache.cleanUp();
                log.debug((Object)String.format("Reporting %d live workers", CoordinatorBookKeeper.this.liveWorkerCache.size()));
                return CoordinatorBookKeeper.this.liveWorkerCache.size();
            }
        });
        if (this.isValidationEnabled) {
            this.metrics.register(BookKeeperMetrics.HealthMetric.CACHING_VALIDATED_WORKER_GAUGE.getMetricName(), new Gauge<Long>(){

                @Override
                public Long getValue() {
                    CoordinatorBookKeeper.this.cachingValidatedWorkerCache.cleanUp();
                    log.debug((Object)String.format("Caching validation passed for %d workers", CoordinatorBookKeeper.this.cachingValidatedWorkerCache.size()));
                    return CoordinatorBookKeeper.this.cachingValidatedWorkerCache.size();
                }
            });
            this.metrics.register(BookKeeperMetrics.HealthMetric.FILE_VALIDATED_WORKER_GAUGE.getMetricName(), new Gauge<Long>(){

                @Override
                public Long getValue() {
                    CoordinatorBookKeeper.this.fileValidatedWorkerCache.cleanUp();
                    log.debug((Object)String.format("File validation passed for %d workers", CoordinatorBookKeeper.this.fileValidatedWorkerCache.size()));
                    return CoordinatorBookKeeper.this.fileValidatedWorkerCache.size();
                }
            });
        }
    }

    private Cache<String, Boolean> createHealthCache(Configuration conf, Ticker ticker) {
        return CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(CacheConfig.getHealthStatusExpiry(conf), TimeUnit.MILLISECONDS).build();
    }
}

