/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi.fop;

import com.google.shaded.shaded.common.util.concurrent.AbstractScheduledService;
import com.qubole.rubix.spi.fop.ObjectFactory;
import com.qubole.rubix.spi.fop.ObjectPoolPartition;
import com.qubole.rubix.spi.fop.PoolConfig;
import com.qubole.rubix.spi.fop.Poolable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class ObjectPool<T> {
    private static final Log log = LogFactory.getLog(ObjectPool.class);
    private final PoolConfig config;
    private final ObjectFactory<T> factory;
    private final ConcurrentHashMap<String, ObjectPoolPartition<T>> hostToPoolMap;
    private final String name;
    private Scavenger scavenger;
    private volatile boolean shuttingDown;

    public ObjectPool(PoolConfig poolConfig, ObjectFactory<T> objectFactory, String name) {
        this.config = poolConfig;
        this.factory = objectFactory;
        this.hostToPoolMap = new ConcurrentHashMap();
        this.name = name;
        if (this.config.getScavengeIntervalMilliseconds() > 0) {
            this.scavenger = new Scavenger(name);
            this.scavenger.startAsync();
        }
    }

    public void registerHost(String host) {
        this.hostToPoolMap.put(host, new ObjectPoolPartition<T>(this, this.config, this.factory, this.createBlockingQueue(this.config), host, this.name));
    }

    protected BlockingQueue<Poolable<T>> createBlockingQueue(PoolConfig poolConfig) {
        return new ArrayBlockingQueue<Poolable<T>>(poolConfig.getMaxSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Poolable<T> borrowObject(String host, Configuration conf) {
        if (!this.hostToPoolMap.containsKey(host)) {
            ConcurrentHashMap<String, ObjectPoolPartition<T>> concurrentHashMap = this.hostToPoolMap;
            synchronized (concurrentHashMap) {
                if (!this.hostToPoolMap.containsKey(host)) {
                    this.registerHost(host);
                }
            }
        }
        log.debug((Object)(this.name + " : Borrowing object for partition: " + host));
        for (int i = 0; i < 3; ++i) {
            Poolable<T> result = this.getObject(false, host);
            if (this.factory.validate(result.getObject())) {
                return result;
            }
            this.hostToPoolMap.get(host).decreaseObject(result);
        }
        throw new RuntimeException("Cannot find a valid object");
    }

    private Poolable<T> getObject(boolean blocking, String host) {
        ObjectPoolPartition<T> subPool = this.hostToPoolMap.get(host);
        return subPool.getObject(blocking);
    }

    public void returnObject(Poolable<T> obj) {
        ObjectPoolPartition<T> subPool = this.hostToPoolMap.get(obj.getHost());
        subPool.returnObject(obj);
    }

    public int getSize() {
        int size = 0;
        for (ObjectPoolPartition<T> subPool : this.hostToPoolMap.values()) {
            size += subPool.getTotalCount();
        }
        return size;
    }

    public synchronized int shutdown() throws InterruptedException {
        this.shuttingDown = true;
        int removed = 0;
        if (this.scavenger != null) {
            this.scavenger.stopAsync();
        }
        for (ObjectPoolPartition<T> subPool : this.hostToPoolMap.values()) {
            removed += subPool.shutdown();
        }
        return removed;
    }

    private class Scavenger
    extends AbstractScheduledService {
        private final String poolName;

        public Scavenger(String poolName) {
            this.poolName = poolName;
        }

        @Override
        protected ScheduledExecutorService executor() {
            return Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("scavenger-" + this.poolName);
                t.setDaemon(true);
                return t;
            });
        }

        @Override
        protected AbstractScheduledService.Scheduler scheduler() {
            int delay = ObjectPool.this.config.getScavengeIntervalMilliseconds();
            log.debug((Object)("Starting scavenger for connection pool with delay: " + delay + " ms"));
            return AbstractScheduledService.Scheduler.newFixedDelaySchedule(delay, delay, TimeUnit.MILLISECONDS);
        }

        @Override
        protected void runOneIteration() {
            if (ObjectPool.this.shuttingDown) {
                log.debug((Object)(ObjectPool.this.name + " : Pool is shutting down, skip scavenger"));
                return;
            }
            try {
                log.debug((Object)(ObjectPool.this.name + " : Host pool map values: " + ObjectPool.this.hostToPoolMap.values()));
                for (ObjectPoolPartition subPool : ObjectPool.this.hostToPoolMap.values()) {
                    log.debug((Object)(ObjectPool.this.name + " : Scavenging sub pool of host: " + subPool.getHost()));
                    subPool.scavenge();
                }
            }
            catch (InterruptedException e) {
                log.warn((Object)(ObjectPool.this.name + " : Scavenge failed with error"), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

