/*
 * Decompiled with CFR 0.152.
 */
package com.readytalk.metrics;

import com.readytalk.metrics.DatagramSocketFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class StatsD
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(StatsD.class);
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final DatagramSocketFactory socketFactory;
    private InetSocketAddress address;
    private DatagramSocket socket;
    private int failures;

    StatsD(String host, int port) {
        this(new InetSocketAddress(host, port), new DatagramSocketFactory());
    }

    StatsD(InetSocketAddress address, DatagramSocketFactory socketFactory) {
        this.address = address;
        this.socketFactory = socketFactory;
    }

    public void connect() throws IOException {
        if (this.socket != null) {
            throw new IllegalStateException("Already connected");
        }
        if (this.address.getHostName() != null) {
            this.address = new InetSocketAddress(this.address.getHostName(), this.address.getPort());
        }
        this.socket = this.socketFactory.createSocket();
    }

    public void send(String name, String value) {
        try {
            String formatted = String.format("%s:%s|g", this.sanitize(name), this.sanitize(value));
            byte[] bytes = formatted.getBytes(UTF_8);
            this.socket.send(this.socketFactory.createPacket(bytes, bytes.length, this.address));
            this.failures = 0;
        }
        catch (IOException e) {
            ++this.failures;
            if (this.failures == 1) {
                LOG.warn("unable to send packet to statsd at '{}:{}'", (Object)this.address.getHostName(), (Object)this.address.getPort());
            }
            LOG.debug("unable to send packet to statsd at '{}:{}'", (Object)this.address.getHostName(), (Object)this.address.getPort());
        }
    }

    public int getFailures() {
        return this.failures;
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
    }

    private String sanitize(String s) {
        return WHITESPACE.matcher(s).replaceAll("-");
    }
}

