/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.com.google.common.base.MoreObjects;
import com.linkedin.coral.$internal.com.google.common.base.Preconditions;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.LongLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.Parameter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Limit
extends Node {
    private final Expression rowCount;

    public Limit(Expression rowCount) {
        this(Optional.empty(), rowCount);
    }

    public Limit(NodeLocation location, Expression rowCount) {
        this(Optional.of(location), rowCount);
    }

    public Limit(Optional<NodeLocation> location, Expression rowCount) {
        super(location);
        Preconditions.checkArgument(rowCount instanceof .AllRows || rowCount instanceof LongLiteral || rowCount instanceof Parameter, "unexpected rowCount class: %s", (Object)rowCount.getClass().getSimpleName());
        this.rowCount = rowCount;
    }

    public Expression getRowCount() {
        return this.rowCount;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of(this.rowCount);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Limit o = (Limit)obj;
        return Objects.equals(this.rowCount, o.rowCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rowCount);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("limit", this.rowCount).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Limit.sameClass(this, other);
    }
}

