/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.io;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.io.DataOutputBuffer;
import com.linkedin.coral.$internal.org.apache.hadoop.io.IOUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Text;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Writable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@.InterfaceAudience.Public
@.InterfaceStability.Stable
public final class WritableUtils {
    public static byte[] readCompressedByteArray(DataInput in) throws IOException {
        int len;
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buffer, 0, buffer.length));
        byte[] outbuf = new byte[length];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = gzi.read(outbuf, 0, outbuf.length)) != -1) {
            bos.write(outbuf, 0, len);
        }
        byte[] decompressed = bos.toByteArray();
        bos.close();
        gzi.close();
        return decompressed;
    }

    public static void skipCompressedByteArray(DataInput in) throws IOException {
        int length = in.readInt();
        if (length != -1) {
            WritableUtils.skipFully(in, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeCompressedByteArray(DataOutput out, byte[] bytes) throws IOException {
        if (bytes != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(bos);
            try {
                gzout.write(bytes, 0, bytes.length);
                gzout.close();
                gzout = null;
            }
            finally {
                IOUtils.closeStream(gzout);
            }
            byte[] buffer = bos.toByteArray();
            int len = buffer.length;
            out.writeInt(len);
            out.write(buffer, 0, len);
            return bytes.length != 0 ? 100 * buffer.length / bytes.length : 0;
        }
        out.writeInt(-1);
        return -1;
    }

    public static String readCompressedString(DataInput in) throws IOException {
        byte[] bytes = WritableUtils.readCompressedByteArray(in);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    public static int writeCompressedString(DataOutput out, String s2) throws IOException {
        return WritableUtils.writeCompressedByteArray(out, s2 != null ? s2.getBytes("UTF-8") : null);
    }

    public static void writeString(DataOutput out, String s2) throws IOException {
        if (s2 != null) {
            byte[] buffer = s2.getBytes("UTF-8");
            int len = buffer.length;
            out.writeInt(len);
            out.write(buffer, 0, len);
        } else {
            out.writeInt(-1);
        }
    }

    public static String readString(DataInput in) throws IOException {
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        return new String(buffer, "UTF-8");
    }

    public static void writeStringArray(DataOutput out, String[] s2) throws IOException {
        out.writeInt(s2.length);
        for (int i = 0; i < s2.length; ++i) {
            WritableUtils.writeString(out, s2[i]);
        }
    }

    public static void writeCompressedStringArray(DataOutput out, String[] s2) throws IOException {
        if (s2 == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(s2.length);
        for (int i = 0; i < s2.length; ++i) {
            WritableUtils.writeCompressedString(out, s2[i]);
        }
    }

    public static String[] readStringArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        String[] s2 = new String[len];
        for (int i = 0; i < len; ++i) {
            s2[i] = WritableUtils.readString(in);
        }
        return s2;
    }

    public static String[] readCompressedStringArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        String[] s2 = new String[len];
        for (int i = 0; i < len; ++i) {
            s2[i] = WritableUtils.readCompressedString(in);
        }
        return s2;
    }

    public static void displayByteArray(byte[] record) {
        int i;
        for (i = 0; i < record.length - 1; ++i) {
            if (i % 16 == 0) {
                System.out.println();
            }
            System.out.print(Integer.toHexString(record[i] >> 4 & 0xF));
            System.out.print(Integer.toHexString(record[i] & 0xF));
            System.out.print(",");
        }
        System.out.print(Integer.toHexString(record[i] >> 4 & 0xF));
        System.out.print(Integer.toHexString(record[i] & 0xF));
        System.out.println();
    }

    public static <T extends Writable> T clone(T orig, Configuration conf) {
        try {
            Writable newInst = (Writable).ReflectionUtils.newInstance(orig.getClass(), (Configuration)conf);
            .ReflectionUtils.copy((Configuration)conf, orig, (Object)newInst);
            return (T)newInst;
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing/reading clone buffer", e);
        }
    }

    @Deprecated
    public static void cloneInto(Writable dst, Writable src) throws IOException {
        .ReflectionUtils.cloneWritableInto((Writable)dst, (Writable)src);
    }

    public static void writeVInt(DataOutput stream, int i) throws IOException {
        WritableUtils.writeVLong(stream, i);
    }

    public static void writeVLong(DataOutput stream, long i) throws IOException {
        if (i >= -112L && i <= 127L) {
            stream.writeByte((byte)i);
            return;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        stream.writeByte((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            stream.writeByte((byte)((i & mask) >> shiftbits));
        }
    }

    public static long readVLong(DataInput stream) throws IOException {
        byte firstByte = stream.readByte();
        int len = WritableUtils.decodeVIntSize(firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = stream.readByte();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt(firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int readVInt(DataInput stream) throws IOException {
        long n = WritableUtils.readVLong(stream);
        if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE) {
            throw new IOException("value too long to fit in integer");
        }
        return (int)n;
    }

    public static int readVIntInRange(DataInput stream, int lower, int upper) throws IOException {
        long n = WritableUtils.readVLong(stream);
        if (n < (long)lower) {
            if (lower == 0) {
                throw new IOException("expected non-negative integer, got " + n);
            }
            throw new IOException("expected integer greater than or equal to " + lower + ", got " + n);
        }
        if (n > (long)upper) {
            throw new IOException("expected integer less or equal to " + upper + ", got " + n);
        }
        return (int)n;
    }

    public static boolean isNegativeVInt(byte value) {
        return value < -120 || value >= -112 && value < 0;
    }

    public static int decodeVIntSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }

    public static int getVIntSize(long i) {
        if (i >= -112L && i <= 127L) {
            return 1;
        }
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
        }
        int dataBits = 64 - Long.numberOfLeadingZeros(i);
        return (dataBits + 7) / 8 + 1;
    }

    public static <T extends Enum<T>> T readEnum(DataInput in, Class<T> enumType) throws IOException {
        return Enum.valueOf(enumType, Text.readString(in));
    }

    public static void writeEnum(DataOutput out, Enum<?> enumVal) throws IOException {
        Text.writeString(out, enumVal.name());
    }

    public static void skipFully(DataInput in, int len) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < len && (cur = in.skipBytes(len - total)) > 0; total += cur) {
        }
        if (total < len) {
            throw new IOException("Not able to skip " + len + " bytes, possibly due to end of input.");
        }
    }

    public static byte[] toByteArray(Writable ... writables) {
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            for (Writable w : writables) {
                w.write(out);
            }
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to convert writables to a byte array", e);
        }
        return out.getData();
    }

    public static String readStringSafely(DataInput in, int maxLength) throws IOException, IllegalArgumentException {
        int length = WritableUtils.readVInt(in);
        if (length < 0 || length > maxLength) {
            throw new IllegalArgumentException("Encoded byte size for String was " + length + ", which is outside of 0.." + maxLength + " range.");
        }
        byte[] bytes = new byte[length];
        in.readFully(bytes, 0, length);
        return Text.decode(bytes);
    }
}

