/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.NativeMemory;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.UnsafeUtil;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.ArrayOfItemsSerDe;

public class ArrayOfUtf16StringsSerDe
extends ArrayOfItemsSerDe<String> {
    public byte[] serializeToByteArray(String[] items) {
        int length = 0;
        for (int i = 0; i < items.length; ++i) {
            length += items[i].length() * 2 + 4;
        }
        byte[] bytes = new byte[length];
        NativeMemory mem = new NativeMemory(bytes);
        long offsetBytes = 0L;
        for (int i = 0; i < items.length; ++i) {
            mem.putInt(offsetBytes, items[i].length());
            mem.putCharArray(offsetBytes += 4L, items[i].toCharArray(), 0, items[i].length());
            offsetBytes += (long)(items[i].length() * 2);
        }
        return bytes;
    }

    public String[] deserializeFromMemory(Memory mem, int numItems) {
        String[] array = new String[numItems];
        long offsetBytes = 0L;
        for (int i = 0; i < numItems; ++i) {
            UnsafeUtil.checkBounds(offsetBytes, 4L, mem.getCapacity());
            int strLength = mem.getInt(offsetBytes);
            char[] chars = new char[strLength];
            UnsafeUtil.checkBounds(offsetBytes += 4L, strLength * 2, mem.getCapacity());
            mem.getCharArray(offsetBytes, chars, 0, strLength);
            array[i] = new String(chars);
            offsetBytes += (long)(strLength * 2);
        }
        return array;
    }
}

