/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linkedin.coral.calcite.;
import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.common.HiveRelBuilder;
import com.linkedin.coral.common.HiveSchema;
import com.linkedin.coral.common.HiveTypeSystem;
import com.linkedin.coral.common.LocalMetastoreHiveSchema;
import com.linkedin.coral.hive.metastore.api.Table;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;

public abstract class ToRelConverter {
    private final HiveMetastoreClient hiveMetastoreClient;
    private final FrameworkConfig config;
    private final SqlRexConvertletTable convertletTable = this.getConvertletTable();
    private CalciteCatalogReader catalogReader;
    private RelBuilder relBuilder;

    protected abstract SqlRexConvertletTable getConvertletTable();

    protected abstract SqlValidator getSqlValidator();

    protected abstract SqlOperatorTable getOperatorTable();

    protected abstract SqlToRelConverter getSqlToRelConverter();

    protected abstract SqlNode toSqlNode(String var1, Table var2);

    protected ToRelConverter(@Nonnull HiveMetastoreClient hiveMetastoreClient) {
        Preconditions.checkNotNull((Object)hiveMetastoreClient);
        this.hiveMetastoreClient = hiveMetastoreClient;
        SchemaPlus schemaPlus = Frameworks.createRootSchema(false);
        schemaPlus.add("hive", new HiveSchema(hiveMetastoreClient));
        new Driver();
        this.config = Frameworks.newConfigBuilder().convertletTable(this.convertletTable).defaultSchema(schemaPlus).typeSystem(new HiveTypeSystem()).traitDefs((List<RelTraitDef>)null).operatorTable(this.getOperatorTable()).programs(Programs.ofRules(Programs.RULE_SET)).build();
    }

    protected ToRelConverter(Map<String, Map<String, List<String>>> localMetaStore) {
        this.hiveMetastoreClient = null;
        SchemaPlus schemaPlus = Frameworks.createRootSchema(false);
        schemaPlus.add("hive", new LocalMetastoreHiveSchema(localMetaStore));
        new Driver();
        this.config = Frameworks.newConfigBuilder().convertletTable(this.convertletTable).defaultSchema(schemaPlus).typeSystem(new HiveTypeSystem()).traitDefs((List<RelTraitDef>)null).operatorTable(this.getOperatorTable()).programs(Programs.ofRules(Programs.RULE_SET)).build();
    }

    public RelNode convertSql(String sql) {
        return this.toRel(this.toSqlNode(sql));
    }

    public RelNode convertView(String hiveDbName, String hiveViewName) {
        SqlNode sqlNode = this.processView(hiveDbName, hiveViewName);
        return this.toRel(sqlNode);
    }

    @.VisibleForTesting
    public SqlNode toSqlNode(String sql) {
        return this.toSqlNode(sql, null);
    }

    @.VisibleForTesting
    public SqlNode processView(String dbName, String tableName) {
        Table table = this.hiveMetastoreClient.getTable(dbName, tableName);
        if (table == null) {
            throw new RuntimeException(String.format("Unknown table %s.%s", dbName, tableName));
        }
        String stringViewExpandedText = null;
        stringViewExpandedText = table.getTableType().equals("VIRTUAL_VIEW") ? table.getViewExpandedText() : "SELECT * FROM " + dbName + "." + tableName;
        return this.toSqlNode(stringViewExpandedText, table);
    }

    @.VisibleForTesting
    protected RelNode toRel(SqlNode sqlNode) {
        RelRoot root = this.getSqlToRelConverter().convertQuery(sqlNode, true, true);
        return root.rel;
    }

    protected RelBuilder getRelBuilder() {
        if (this.relBuilder == null) {
            Hook.REL_BUILDER_SIMPLIFY.add(Hook.propertyJ(false));
            this.relBuilder = HiveRelBuilder.create(this.config);
        }
        return this.relBuilder;
    }

    protected CalciteCatalogReader getCalciteCatalogReader() {
        CalciteConnectionConfig connectionConfig;
        if (this.config.getContext() != null) {
            connectionConfig = this.config.getContext().unwrap(CalciteConnectionConfig.class);
        } else {
            Properties properties = new Properties();
            properties.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(false));
            connectionConfig = new CalciteConnectionConfigImpl(properties);
        }
        if (this.catalogReader == null) {
            this.catalogReader = new MultiSchemaPathCalciteCatalogReader(this.config.getDefaultSchema().unwrap(CalciteSchema.class), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"hive", (Object)"default"), (Object)ImmutableList.of((Object)"hive"), (Object)ImmutableList.of()), this.getRelBuilder().getTypeFactory(), connectionConfig);
        }
        return this.catalogReader;
    }

    static class MultiSchemaPathCalciteCatalogReader
    extends CalciteCatalogReader {
        public MultiSchemaPathCalciteCatalogReader(CalciteSchema rootSchema, List<List<String>> schemaPathList, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
            super(rootSchema, SqlNameMatchers.withCaseSensitive(config != null && config.caseSensitive()), Util.immutableCopy(schemaPathList), typeFactory, config);
        }
    }
}

