/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common.transformers;

import com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.utils.TypeDerivationUtil;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public abstract class SqlCallTransformer {
    private TypeDerivationUtil typeDerivationUtil;

    public SqlCallTransformer() {
    }

    public SqlCallTransformer(TypeDerivationUtil typeDerivationUtil) {
        this.typeDerivationUtil = typeDerivationUtil;
    }

    protected abstract boolean condition(SqlCall var1);

    protected abstract SqlCall transform(SqlCall var1);

    public SqlCall apply(SqlCall sqlCall) {
        if (this.condition(sqlCall)) {
            return this.transform(sqlCall);
        }
        return sqlCall;
    }

    protected RelDataType deriveRelDatatype(SqlNode sqlNode) {
        if (this.typeDerivationUtil == null) {
            throw new RuntimeException("TypeDerivationUtil does not exist to derive the RelDataType for SqlNode: " + sqlNode);
        }
        return this.typeDerivationUtil.getRelDataType(sqlNode);
    }

    protected RelDataType leastRestrictive(List<RelDataType> types) {
        return this.typeDerivationUtil.leastRestrictive(types);
    }

    protected static SqlOperator createSqlOperator(String functionName, SqlReturnTypeInference typeInference) {
        SqlIdentifier sqlIdentifier = new SqlIdentifier((List<String>)ImmutableList.of((Object)functionName), SqlParserPos.ZERO);
        return new SqlUserDefinedFunction(sqlIdentifier, typeInference, null, null, null, null);
    }
}

