/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.trino2rel;

import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.common.HiveRelBuilder;
import com.linkedin.coral.common.ToRelConverter;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.hive.hive2rel.DaliOperatorTable;
import com.linkedin.coral.hive.hive2rel.HiveConvertletTable;
import com.linkedin.coral.hive.hive2rel.HiveSqlValidator;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionResolver;
import com.linkedin.coral.hive.hive2rel.functions.StaticHiveFunctionRegistry;
import com.linkedin.coral.hive.metastore.api.Table;
import com.linkedin.coral.trino.trino2rel.Trino2CoralOperatorConverter;
import com.linkedin.coral.trino.trino2rel.TrinoSqlConformance;
import com.linkedin.coral.trino.trino2rel.TrinoSqlToRelConverter;
import com.linkedin.coral.trino.trino2rel.TrinoViewExpander;
import com.linkedin.coral.trino.trino2rel.parsetree.ParseTreeBuilder;
import com.linkedin.coral.trino.trino2rel.parsetree.ParserVisitorContext;
import com.linkedin.coral.trino.trino2rel.parsetree.TrinoParserDriver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;

public class TrinoToRelConverter
extends ToRelConverter {
    private final ParseTreeBuilder parseTreeBuilder = new ParseTreeBuilder();
    private final ParserVisitorContext parserVisitorContext = new ParserVisitorContext();
    private final HiveFunctionResolver functionResolver = new HiveFunctionResolver(new StaticHiveFunctionRegistry(), new ConcurrentHashMap<String, Function>());
    private final SqlValidator sqlValidator = new HiveSqlValidator(this.getOperatorTable(), this.getCalciteCatalogReader(), (JavaTypeFactory)this.getRelBuilder().getTypeFactory(), TrinoSqlConformance.TRINO_SQL);

    public TrinoToRelConverter(HiveMetastoreClient hiveMetastoreClient) {
        super(hiveMetastoreClient);
    }

    public TrinoToRelConverter(Map<String, Map<String, List<String>>> localMetaStore) {
        super(localMetaStore);
    }

    @Override
    protected SqlRexConvertletTable getConvertletTable() {
        return new HiveConvertletTable();
    }

    @Override
    protected SqlValidator getSqlValidator() {
        return this.sqlValidator;
    }

    @Override
    protected SqlOperatorTable getOperatorTable() {
        return ChainedSqlOperatorTable.of(SqlStdOperatorTable.instance(), new DaliOperatorTable(this.functionResolver));
    }

    @Override
    protected SqlToRelConverter getSqlToRelConverter() {
        return new TrinoSqlToRelConverter((RelOptTable.ViewExpander)new TrinoViewExpander(this), this.getSqlValidator(), (Prepare.CatalogReader)this.getCalciteCatalogReader(), RelOptCluster.create(new VolcanoPlanner(), this.getRelBuilder().getRexBuilder()), this.getConvertletTable(), SqlToRelConverter.configBuilder().withRelBuilderFactory(HiveRelBuilder.LOGICAL_BUILDER).build());
    }

    @Override
    protected SqlNode toSqlNode(String sql, Table trinoView) {
        String trimmedSql = TrinoToRelConverter.trimParenthesis(sql.toUpperCase());
        SqlNode parsedSqlNode = TrinoParserDriver.parse(trimmedSql).accept(this.parseTreeBuilder, this.parserVisitorContext);
        SqlNode convertedSqlNode = parsedSqlNode.accept(new Trino2CoralOperatorConverter());
        return convertedSqlNode;
    }

    private static String trimParenthesis(String value) {
        String str = value.trim();
        if (str.startsWith("(") && str.endsWith(")")) {
            return TrinoToRelConverter.trimParenthesis(str.substring(1, str.length() - 1));
        }
        return str;
    }
}

