/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import com.linkedin.coral.calcite.;
import com.linkedin.coral.calcite.$internal.com.google.common.cache.CacheBuilder;
import com.linkedin.coral.calcite.$internal.com.google.common.cache.CacheLoader;
import com.linkedin.coral.calcite.$internal.com.google.common.cache.LoadingCache;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.calcite.$internal.com.google.common.primitives.Ints;
import com.linkedin.coral.calcite.$internal.org.apache.commons.dbcp2.BasicDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;

final class JdbcUtils {
    private JdbcUtils() {
        throw new AssertionError((Object)"no instances!");
    }

    static class DataSourcePool {
        public static final DataSourcePool INSTANCE = new DataSourcePool();
        private final LoadingCache<List<String>, BasicDataSource> cache = CacheBuilder.newBuilder().softValues().build(CacheLoader.from(DataSourcePool::dataSource));

        DataSourcePool() {
        }

        @.Nonnull
        private static BasicDataSource dataSource(@.Nonnull List<String> key) {
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setUrl(key.get(0));
            dataSource.setUsername(key.get(1));
            dataSource.setPassword(key.get(2));
            dataSource.setDriverClassName(key.get(3));
            return dataSource;
        }

        public DataSource get(String url, String driverClassName, String username, String password) {
            List<String> key = ImmutableNullableList.of(url, username, password, driverClassName);
            return this.cache.getUnchecked(key);
        }
    }

    static class ObjectArrayRowBuilder
    implements Function0<Object[]> {
        private final ResultSet resultSet;
        private final int columnCount;
        private final ColumnMetaData.Rep[] reps;
        private final int[] types;

        ObjectArrayRowBuilder(ResultSet resultSet, ColumnMetaData.Rep[] reps, int[] types) throws SQLException {
            this.resultSet = resultSet;
            this.reps = reps;
            this.types = types;
            this.columnCount = resultSet.getMetaData().getColumnCount();
        }

        public static Function1<ResultSet, Function0<Object[]>> factory(List<Pair<ColumnMetaData.Rep, Integer>> list) {
            return resultSet -> {
                try {
                    return new ObjectArrayRowBuilder((ResultSet)resultSet, Pair.left(list).toArray(new ColumnMetaData.Rep[list.size()]), Ints.toArray(Pair.right(list)));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        @Override
        public Object[] apply() {
            try {
                Object[] values = new Object[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    values[i] = this.value(i);
                }
                return values;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private Object value(int i) throws SQLException {
            switch (this.types[i]) {
                case 93: {
                    return ObjectArrayRowBuilder.shift(this.resultSet.getTimestamp(i + 1));
                }
                case 92: {
                    return ObjectArrayRowBuilder.shift(this.resultSet.getTime(i + 1));
                }
                case 91: {
                    return ObjectArrayRowBuilder.shift(this.resultSet.getDate(i + 1));
                }
            }
            return this.reps[i].jdbcGet(this.resultSet, i + 1);
        }

        private static Timestamp shift(Timestamp v) {
            if (v == null) {
                return null;
            }
            long time = v.getTime();
            int offset = TimeZone.getDefault().getOffset(time);
            return new Timestamp(time + (long)offset);
        }

        private static Time shift(Time v) {
            if (v == null) {
                return null;
            }
            long time = v.getTime();
            int offset = TimeZone.getDefault().getOffset(time);
            return new Time((time + (long)offset) % 86400000L);
        }

        private static Date shift(Date v) {
            if (v == null) {
                return null;
            }
            long time = v.getTime();
            int offset = TimeZone.getDefault().getOffset(time);
            return new Date(time + (long)offset);
        }
    }

    static class DialectPool {
        final Map<DataSource, Map<SqlDialectFactory, SqlDialect>> map0 = new IdentityHashMap<DataSource, Map<SqlDialectFactory, SqlDialect>>();
        final Map<List, SqlDialect> map = new HashMap<List, SqlDialect>();
        public static final DialectPool INSTANCE = new DialectPool();

        DialectPool() {
        }

        synchronized SqlDialect get(SqlDialectFactory dialectFactory, DataSource dataSource) {
            SqlDialect sqlDialect;
            Map<SqlDialectFactory, SqlDialect> dialectMap = this.map0.get(dataSource);
            if (dialectMap != null && (sqlDialect = dialectMap.get(dialectFactory)) != null) {
                return sqlDialect;
            }
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                String productName = metaData.getDatabaseProductName();
                String productVersion = metaData.getDatabaseProductVersion();
                ImmutableList<SqlDialectFactory> key = ImmutableList.of(productName, productVersion, dialectFactory);
                SqlDialect dialect = this.map.get(key);
                if (dialect == null) {
                    dialect = dialectFactory.create(metaData);
                    this.map.put(key, dialect);
                    if (dialectMap == null) {
                        dialectMap = new IdentityHashMap<SqlDialectFactory, SqlDialect>();
                        this.map0.put(dataSource, dialectMap);
                    }
                    dialectMap.put(dialectFactory, dialect);
                }
                connection.close();
                connection = null;
                SqlDialect sqlDialect2 = dialect;
                return sqlDialect2;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

