/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.errorprone.annotations.FormatMethod;
import io.trino.parquet.ParquetDataSourceId;
import java.io.IOException;

public class ParquetCorruptionException
extends IOException {
    public ParquetCorruptionException(ParquetDataSourceId dataSourceId, String message) {
        this(dataSourceId, "%s", message);
    }

    @FormatMethod
    public ParquetCorruptionException(Throwable cause, ParquetDataSourceId dataSourceId, String messageFormat, Object ... args) {
        super(ParquetCorruptionException.formatMessage(dataSourceId, messageFormat, args), cause);
    }

    @FormatMethod
    public ParquetCorruptionException(ParquetDataSourceId dataSourceId, String messageFormat, Object ... args) {
        super(ParquetCorruptionException.formatMessage(dataSourceId, messageFormat, args));
    }

    private static String formatMessage(ParquetDataSourceId dataSourceId, String messageFormat, Object[] args) {
        return "Malformed Parquet file. " + String.format(messageFormat, args) + " [" + dataSourceId + "]";
    }
}

