/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Preconditions;
import io.trino.parquet.DataPageV1;
import io.trino.parquet.DataPageV2;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.Page;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.reader.ChunkedInputStream;
import io.trino.parquet.reader.MetadataReader;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;

public final class ParquetColumnChunkIterator
implements Iterator<Page> {
    private final ParquetDataSourceId dataSourceId;
    private final Optional<String> fileCreatedBy;
    private final ColumnDescriptor descriptor;
    private final ColumnChunkMetaData metadata;
    private final ChunkedInputStream input;
    private final OffsetIndex offsetIndex;
    private long valueCount;
    private int dataPageCount;

    public ParquetColumnChunkIterator(ParquetDataSourceId dataSourceId, Optional<String> fileCreatedBy, ColumnDescriptor descriptor, ColumnChunkMetaData metadata, ChunkedInputStream input, @Nullable OffsetIndex offsetIndex) {
        this.dataSourceId = Objects.requireNonNull(dataSourceId, "dataSourceId is null");
        this.fileCreatedBy = Objects.requireNonNull(fileCreatedBy, "fileCreatedBy is null");
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.input = Objects.requireNonNull(input, "input is null");
        this.offsetIndex = offsetIndex;
    }

    @Override
    public boolean hasNext() {
        return this.hasMorePages(this.valueCount, this.dataPageCount);
    }

    @Override
    public Page next() {
        Preconditions.checkState((boolean)this.hasNext(), (String)"No more data left to read in column (%s), metadata (%s), valueCount %s, dataPageCount %s", (Object)this.descriptor, (Object)this.metadata, (Object)this.valueCount, (Object)this.dataPageCount);
        try {
            PageHeader pageHeader = this.readPageHeader();
            int uncompressedPageSize = pageHeader.getUncompressed_page_size();
            int compressedPageSize = pageHeader.getCompressed_page_size();
            Page result = null;
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    if (this.dataPageCount != 0) {
                        throw new ParquetCorruptionException(this.dataSourceId, "Column (%s) has a dictionary page after the first position in column chunk", this.descriptor);
                    }
                    result = this.readDictionaryPage(pageHeader, pageHeader.getUncompressed_page_size(), pageHeader.getCompressed_page_size());
                    break;
                }
                case DATA_PAGE: {
                    result = this.readDataPageV1(pageHeader, uncompressedPageSize, compressedPageSize, ParquetColumnChunkIterator.getFirstRowIndex(this.dataPageCount, this.offsetIndex));
                    ++this.dataPageCount;
                    break;
                }
                case DATA_PAGE_V2: {
                    result = this.readDataPageV2(pageHeader, uncompressedPageSize, compressedPageSize, ParquetColumnChunkIterator.getFirstRowIndex(this.dataPageCount, this.offsetIndex));
                    ++this.dataPageCount;
                    break;
                }
                default: {
                    this.input.skip(compressedPageSize);
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private PageHeader readPageHeader() throws IOException {
        return Util.readPageHeader((InputStream)this.input);
    }

    private boolean hasMorePages(long valuesCountReadSoFar, int dataPageCountReadSoFar) {
        if (this.offsetIndex == null) {
            return valuesCountReadSoFar < this.metadata.getValueCount();
        }
        return dataPageCountReadSoFar < this.offsetIndex.getPageCount();
    }

    private DictionaryPage readDictionaryPage(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize) throws IOException {
        DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
        return new DictionaryPage(this.input.getSlice(compressedPageSize), uncompressedPageSize, dicHeader.getNum_values(), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dicHeader.getEncoding().name())));
    }

    private DataPageV1 readDataPageV1(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, OptionalLong firstRowIndex) throws IOException {
        DataPageHeader dataHeaderV1 = pageHeader.getData_page_header();
        this.valueCount += (long)dataHeaderV1.getNum_values();
        return new DataPageV1(this.input.getSlice(compressedPageSize), dataHeaderV1.getNum_values(), uncompressedPageSize, firstRowIndex, ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getRepetition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getDefinition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getEncoding().name())));
    }

    private DataPageV2 readDataPageV2(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, OptionalLong firstRowIndex) throws IOException {
        DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
        int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
        this.valueCount += (long)dataHeaderV2.getNum_values();
        return new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), this.input.getSlice(dataHeaderV2.getRepetition_levels_byte_length()), this.input.getSlice(dataHeaderV2.getDefinition_levels_byte_length()), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV2.getEncoding().name())), this.input.getSlice(dataSize), uncompressedPageSize, firstRowIndex, MetadataReader.readStats(this.fileCreatedBy, Optional.ofNullable(dataHeaderV2.getStatistics()), this.descriptor.getPrimitiveType()), dataHeaderV2.isIs_compressed());
    }

    private static OptionalLong getFirstRowIndex(int pageIndex, OffsetIndex offsetIndex) {
        return offsetIndex == null ? OptionalLong.empty() : OptionalLong.of(offsetIndex.getFirstRowIndex(pageIndex));
    }
}

