/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ValueDecoder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesReader;

public class ApacheParquetValueDecoders {
    private ApacheParquetValueDecoders() {
    }

    public static final class BooleanApacheParquetValueDecoder
    implements ValueDecoder<byte[]> {
        private final ValuesReader delegate;

        public BooleanApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            byte[] buffer = input.readBytes();
            try {
                int valueCount = buffer.length * 8;
                this.delegate.initFromPage(valueCount, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(buffer, 0, buffer.length)}));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = ParquetReaderUtils.castToByte(this.delegate.readBoolean());
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }
}

