/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.file.cache.store.PageReadTargetBuffer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The target byte array is exposed as we expect.")
public class ByteArrayTargetBuffer
implements PageReadTargetBuffer {
    private final byte[] mTarget;
    private int mOffset;

    public ByteArrayTargetBuffer(byte[] target, int offset) {
        this.mTarget = target;
        this.mOffset = offset;
    }

    @Override
    public byte[] byteArray() {
        return this.mTarget;
    }

    @Override
    public ByteBuffer byteBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long offset() {
        return this.mOffset;
    }

    @Override
    public long remaining() {
        return this.mTarget.length - this.mOffset;
    }

    @Override
    public void writeBytes(byte[] srcArray, int srcOffset, int length) {
        System.arraycopy(srcArray, srcOffset, this.mTarget, this.mOffset, length);
        this.mOffset += length;
    }

    @Override
    public int readFromFile(RandomAccessFile file, int length) throws IOException {
        int bytesRead = file.read(this.mTarget, this.mOffset, length);
        if (bytesRead != -1) {
            this.mOffset += bytesRead;
        }
        return bytesRead;
    }

    @Override
    public WritableByteChannel byteChannel() {
        throw new UnsupportedOperationException();
    }
}

