/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.grpc.CheckAccessPOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.hadoop.AlluxioFileStatus;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.hadoop.HadoopUtils;
import alluxio.hadoop.HdfsFileInputStream;
import alluxio.master.MasterInquireClient;
import alluxio.security.CurrentUser;
import alluxio.security.authorization.Mode;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.net.HostAndPort;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.WorkerNetAddress;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileSystem.class);
    protected AlluxioConfiguration mAlluxioConf = null;
    protected alluxio.client.file.FileSystem mFileSystem = null;
    private URI mUri = null;
    private Path mWorkingDir = new Path("/");
    private FileSystem.Statistics mStatistics = null;
    private String mAlluxioHeader = null;
    private boolean mExcludeMountInfoOnListStatus;

    protected AbstractFileSystem(alluxio.client.file.FileSystem fileSystem) {
        this.mFileSystem = fileSystem;
    }

    protected AbstractFileSystem() {
    }

    public void access(Path path, FsAction mode) throws IOException {
        LOG.debug("access({}, {})", (Object)path, (Object)mode);
        AlluxioURI uri = this.getAlluxioPath(path);
        CheckAccessPOptions options = CheckAccessPOptions.newBuilder().setBits(Mode.Bits.fromShort((short)mode.ordinal()).toProto()).build();
        try {
            this.mFileSystem.checkAccess(uri, options);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        LOG.debug("append({}, {}, {})", new Object[]{path, bufferSize, progress});
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        AlluxioURI uri = this.getAlluxioPath(path);
        try {
            if (this.mFileSystem.exists(uri)) {
                throw new IOException("append() to existing Alluxio path is currently not supported: " + uri);
            }
            return new FSDataOutputStream((OutputStream)this.mFileSystem.createFile(uri, CreateFilePOptions.newBuilder().setRecursive(true).build()), this.mStatistics);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        super.close();
        this.mFileSystem.close();
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FileOutStream outStream;
        LOG.debug("create({}, {}, {}, {}, {}, {}, {})", new Object[]{path, permission, overwrite, bufferSize, replication, blockSize, progress});
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        AlluxioURI uri = this.getAlluxioPath(path);
        CreateFilePOptions options = CreateFilePOptions.newBuilder().setBlockSizeBytes(blockSize).setMode(new Mode(permission.toShort()).toProto()).setRecursive(true).setOverwrite(overwrite).build();
        try {
            outStream = this.mFileSystem.createFile(uri, options);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        return new FSDataOutputStream((OutputStream)outStream, this.mStatistics);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        AlluxioURI parentUri = this.getAlluxioPath(path.getParent());
        this.ensureExists(parentUri);
        return this.create(path, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        LOG.debug("delete({}, {})", (Object)path, (Object)recursive);
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        AlluxioURI uri = this.getAlluxioPath(path);
        DeletePOptions options = DeletePOptions.newBuilder().setRecursive(recursive).build();
        try {
            this.mFileSystem.delete(uri, options);
            return true;
        }
        catch (FileDoesNotExistException | InvalidPathException e) {
            LOG.debug("delete failed: {}", (Object)e.toString());
            return false;
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    protected int getDefaultPort() {
        return (Integer)PropertyKey.MASTER_RPC_PORT.getDefaultValue();
    }

    protected URI canonicalizeUri(URI uri) {
        return uri;
    }

    public long getDefaultBlockSize() {
        return this.mFileSystem.getConf().getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    public String getCanonicalServiceName() {
        return null;
    }

    @Nullable
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        LOG.debug("getFileBlockLocations({}, {}, {})", new Object[]{file == null ? null : file.getPath().getName(), start, len});
        if (file == null) {
            LOG.debug("getFileBlockLocations({}, {}, {}) returned null", new Object[]{null, start, len});
            return null;
        }
        if (this.mStatistics != null) {
            this.mStatistics.incrementReadOps(1);
        }
        ArrayList blockLocations = new ArrayList();
        try {
            List<BlockLocationInfo> locations;
            if (file instanceof AlluxioFileStatus) {
                locations = this.mFileSystem.getBlockLocations(((AlluxioFileStatus)file).getUriStatus());
            } else {
                AlluxioURI path = this.getAlluxioPath(file.getPath());
                locations = this.mFileSystem.getBlockLocations(path);
            }
            locations.forEach(location -> {
                FileBlockInfo info = location.getBlockInfo();
                List<WorkerNetAddress> workers = location.getLocations();
                long offset = location.getBlockInfo().getOffset();
                long end = offset + info.getBlockInfo().getLength();
                if (end >= start && offset <= start + len) {
                    List addresses = workers.stream().map(worker -> HostAndPort.fromParts(worker.getHost(), worker.getDataPort())).collect(Collectors.toList());
                    String[] names = (String[])addresses.stream().map(HostAndPort::toString).toArray(String[]::new);
                    String[] hosts = (String[])addresses.stream().map(HostAndPort::getHost).toArray(String[]::new);
                    blockLocations.add(new BlockLocation(names, hosts, offset, info.getBlockInfo().getLength()));
                }
            });
            Object[] ret = blockLocations.toArray(new BlockLocation[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileBlockLocations({}, {}, {}) returned {}", new Object[]{file.getPath().getName(), start, len, Arrays.toString(ret)});
            }
            return ret;
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    public short getDefaultReplication() {
        return (short)Math.max(1, this.mFileSystem.getConf().getInt(PropertyKey.USER_FILE_REPLICATION_MIN));
    }

    public boolean setReplication(Path path, short replication) throws IOException {
        AlluxioURI uri = this.getAlluxioPath(path);
        try {
            if (!this.mFileSystem.exists(uri) || this.mFileSystem.getStatus(uri).isFolder()) {
                return false;
            }
            this.mFileSystem.setAttribute(uri, SetAttributePOptions.newBuilder().setReplicationMin(replication).build());
            return true;
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        URIStatus fileStatus;
        LOG.debug("getFileStatus({})", (Object)path);
        if (this.mStatistics != null) {
            this.mStatistics.incrementReadOps(1);
        }
        AlluxioURI uri = this.getAlluxioPath(path);
        try {
            fileStatus = this.mFileSystem.getStatus(uri);
        }
        catch (FileDoesNotExistException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        return new AlluxioFileStatus(fileStatus, this.getFsPath(this.mAlluxioHeader, fileStatus));
    }

    private int getReplica(URIStatus status) {
        return status.getReplicationMin();
    }

    public void setOwner(Path path, String username, String groupname) throws IOException {
        LOG.debug("setOwner({},{},{})", new Object[]{path, username, groupname});
        AlluxioURI uri = this.getAlluxioPath(path);
        SetAttributePOptions.Builder optionsBuilder = SetAttributePOptions.newBuilder();
        boolean ownerOrGroupChanged = false;
        if (username != null && !username.isEmpty()) {
            optionsBuilder.setOwner(username).setRecursive(false);
            ownerOrGroupChanged = true;
        }
        if (groupname != null && !groupname.isEmpty()) {
            optionsBuilder.setGroup(groupname).setRecursive(false);
            ownerOrGroupChanged = true;
        }
        if (ownerOrGroupChanged) {
            try {
                this.mFileSystem.setAttribute(uri, optionsBuilder.build());
            }
            catch (AlluxioException e) {
                throw new IOException(e);
            }
        }
    }

    public void setPermission(Path path, FsPermission permission) throws IOException {
        LOG.debug("setMode({},{})", (Object)path, (Object)permission);
        AlluxioURI uri = this.getAlluxioPath(path);
        SetAttributePOptions options = SetAttributePOptions.newBuilder().setMode(new Mode(permission.toShort()).toProto()).setRecursive(false).build();
        try {
            this.mFileSystem.setAttribute(uri, options);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    public abstract String getScheme();

    public URI getUri() {
        return this.mUri;
    }

    public Path getWorkingDirectory() {
        LOG.debug("getWorkingDirectory: {}", (Object)this.mWorkingDir);
        return this.mWorkingDir;
    }

    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        this.initialize(uri, conf, null);
    }

    @VisibleForTesting
    public synchronized void initialize(URI uri, Configuration conf, @Nullable AlluxioConfiguration alluxioConfiguration) throws IOException {
        this.validateFsUri(uri);
        super.initialize(uri, conf);
        LOG.debug("initialize({}, {}). Connecting to Alluxio", (Object)uri, (Object)conf);
        HadoopUtils.addSwiftCredentials(conf);
        this.setConf(conf);
        String authority = uri.getAuthority() == null ? "/" : uri.getAuthority();
        this.mAlluxioHeader = this.getFsScheme(uri) + "://" + authority;
        this.mStatistics = this.statistics;
        this.mUri = URI.create(this.mAlluxioHeader);
        Map<String, Object> uriConfProperties = this.getConfigurationFromUri(uri, conf);
        Map<String, Object> hadoopConfProperties = HadoopConfigurationUtils.getConfigurationFromHadoop(conf);
        LOG.info("Creating Alluxio configuration from Hadoop configuration {}, uri configuration {}", hadoopConfProperties, uriConfProperties);
        AlluxioProperties alluxioProps = alluxioConfiguration != null ? alluxioConfiguration.copyProperties() : alluxio.conf.Configuration.copyProperties();
        alluxioProps.merge(hadoopConfProperties, Source.RUNTIME);
        alluxioProps.merge(uriConfProperties, Source.RUNTIME);
        this.mAlluxioConf = new InstancedConfiguration(alluxioProps);
        this.mAlluxioConf.validate();
        this.mExcludeMountInfoOnListStatus = this.mAlluxioConf.getBoolean(PropertyKey.USER_HDFS_CLIENT_EXCLUDE_MOUNT_INFO_ON_LIST_STATUS);
        if (this.mFileSystem != null) {
            return;
        }
        Subject subject = this.getHadoopSubject();
        LOG.debug("Using Hadoop subject: {}", (Object)subject);
        LOG.info("Initializing filesystem with connect details {}", (Object)MasterInquireClient.Factory.getConnectDetails(this.mAlluxioConf));
        boolean enableUriValidation = uri.getScheme() == null || uri.getScheme().equals("alluxio");
        this.mFileSystem = FileSystem.Factory.create(ClientContext.create(subject, this.mAlluxioConf).setUriValidationEnabled(enableUriValidation));
    }

    private Subject getSubjectFromUGI(UserGroupInformation ugi) throws IOException, InterruptedException {
        return (Subject)ugi.doAs(() -> {
            AccessControlContext context = AccessController.getContext();
            return Subject.getSubject(context);
        });
    }

    private Subject getHadoopSubject() throws IOException {
        Subject subject = null;
        UserGroupInformation ugi = null;
        try {
            ugi = UserGroupInformation.getCurrentUser();
            subject = this.getSubjectFromUGI(ugi);
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to get Hadoop subject for the Alluxio client. ugi: %s", ugi), e);
        }
        if (subject == null) {
            LOG.warn("Hadoop subject does not exist. Creating a fresh subject for Alluxio client");
            subject = new Subject(false, new HashSet(), new HashSet(), new HashSet());
        }
        if (subject.getPrincipals(CurrentUser.class).isEmpty() && ugi != null) {
            subject.getPrincipals().add(new CurrentUser(ugi.getShortUserName(), this.mUri.toString()));
        }
        return subject;
    }

    @Deprecated
    protected abstract boolean isZookeeperMode();

    public FileStatus[] listStatus(Path path) throws IOException {
        List<URIStatus> statuses;
        LOG.debug("listStatus({})", (Object)path);
        if (this.mStatistics != null) {
            this.mStatistics.incrementReadOps(1);
        }
        AlluxioURI uri = this.getAlluxioPath(path);
        try {
            ListStatusPOptions listStatusPOptions = ListStatusPOptions.getDefaultInstance().toBuilder().setExcludeMountInfo(this.mExcludeMountInfoOnListStatus).build();
            statuses = this.mFileSystem.listStatus(uri, listStatusPOptions);
        }
        catch (FileDoesNotExistException e) {
            throw new FileNotFoundException(this.getAlluxioPath(path).toString());
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        FileStatus[] ret = new FileStatus[statuses.size()];
        for (int k = 0; k < statuses.size(); ++k) {
            URIStatus status = statuses.get(k);
            ret[k] = new AlluxioFileStatus(status, this.getFsPath(this.mAlluxioHeader, status));
        }
        return ret;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        LOG.debug("mkdirs({}, {})", (Object)path, (Object)permission);
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        AlluxioURI uri = this.getAlluxioPath(path);
        CreateDirectoryPOptions options = CreateDirectoryPOptions.newBuilder().setRecursive(true).setAllowExists(true).setMode(new Mode(permission.toShort()).toProto()).build();
        try {
            this.mFileSystem.createDirectory(uri, options);
            return true;
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        LOG.debug("open({}, {})", (Object)path, (Object)bufferSize);
        if (this.mStatistics != null) {
            this.mStatistics.incrementReadOps(1);
        }
        AlluxioURI uri = this.getAlluxioPath(path);
        return new FSDataInputStream((InputStream)new HdfsFileInputStream(this.mFileSystem, uri, this.mStatistics));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        LOG.debug("rename({}, {})", (Object)src, (Object)dst);
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        AlluxioURI srcPath = this.getAlluxioPath(src);
        AlluxioURI dstPath = this.getAlluxioPath(dst);
        try {
            this.mFileSystem.rename(srcPath, dstPath);
        }
        catch (FileDoesNotExistException e) {
            LOG.warn("rename failed: {}", (Object)e.toString());
            return false;
        }
        catch (AlluxioException e) {
            URIStatus dstStatus;
            this.ensureExists(srcPath);
            try {
                dstStatus = this.mFileSystem.getStatus(dstPath);
            }
            catch (AlluxioException | IOException e2) {
                LOG.warn("rename failed: {}", (Object)e.toString());
                return false;
            }
            if (dstStatus == null || !dstStatus.isFolder()) {
                LOG.warn("rename failed: {}", (Object)e.toString());
                return false;
            }
            dstPath = dstPath.joinUnsafe(srcPath.getName());
            try {
                this.mFileSystem.rename(srcPath, dstPath);
            }
            catch (AlluxioException | IOException e2) {
                LOG.error("Failed to rename {} to {}", new Object[]{src, dst, e2});
                return false;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to rename {} to {}", new Object[]{src, dst, e});
            return false;
        }
        return true;
    }

    public void setWorkingDirectory(Path path) {
        LOG.debug("setWorkingDirectory({})", (Object)path);
        this.mWorkingDir = path.isAbsolute() ? path : new Path(this.mWorkingDir, path);
    }

    private void ensureExists(AlluxioURI path) throws IOException {
        try {
            this.mFileSystem.getStatus(path);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    protected abstract Map<String, Object> getConfigurationFromUri(URI var1, Configuration var2);

    protected abstract void validateFsUri(URI var1) throws IOException, IllegalArgumentException;

    protected abstract String getFsScheme(URI var1);

    protected abstract AlluxioURI getAlluxioPath(Path var1);

    protected abstract Path getFsPath(String var1, URIStatus var2);
}

