/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.bin;

import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonWriter;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionSymbolToken;
import alluxio.shaded.client.software.amazon.ionimpl.bin.Symbols;
import java.io.IOException;
import java.util.Iterator;

abstract class AbstractSymbolTable
implements ionSymbolTable {
    private final String name;
    private final int version;

    public AbstractSymbolTable(String name, int version) {
        this.name = name;
        this.version = version;
    }

    public final String getName() {
        return this.name;
    }

    public final int getVersion() {
        return this.version;
    }

    public final String getIonVersionId() {
        return "$ion_1_0";
    }

    public final int findSymbol(String name) {
        ionSymbolToken token = this.find(name);
        if (token == null) {
            return -1;
        }
        return token.getSid();
    }

    public final void writeTo(ionIonWriter writer) throws IOException {
        ionSymbolTable[] imports;
        if (this.isSharedTable()) {
            writer.setTypeAnnotationSymbols(Symbols.systemSymbol(9));
        } else if (this.isLocalTable()) {
            writer.setTypeAnnotationSymbols(Symbols.systemSymbol(3));
        } else {
            throw new IllegalStateException("Invalid symbol table, neither shared nor local");
        }
        writer.stepIn(ionIonType.STRUCT);
        if (this.isSharedTable()) {
            writer.setFieldNameSymbol(Symbols.systemSymbol(4));
            writer.writeString(this.name);
            writer.setFieldNameSymbol(Symbols.systemSymbol(5));
            writer.writeInt(this.version);
        }
        if ((imports = this.getImportedTables()) != null && imports.length > 0) {
            writer.setFieldNameSymbol(Symbols.systemSymbol(6));
            writer.stepIn(ionIonType.LIST);
            for (ionSymbolTable st : imports) {
                writer.stepIn(ionIonType.STRUCT);
                writer.setFieldNameSymbol(Symbols.systemSymbol(4));
                writer.writeString(st.getName());
                writer.setFieldNameSymbol(Symbols.systemSymbol(5));
                writer.writeInt(st.getVersion());
                writer.setFieldNameSymbol(Symbols.systemSymbol(8));
                writer.writeInt(st.getMaxId());
                writer.stepOut();
            }
            writer.stepOut();
        }
        writer.setFieldNameSymbol(Symbols.systemSymbol(7));
        writer.stepIn(ionIonType.LIST);
        Iterator<String> iter = this.iterateDeclaredSymbolNames();
        while (iter.hasNext()) {
            writer.writeString(iter.next());
        }
        writer.stepOut();
        writer.stepOut();
    }

    public void makeReadOnly() {
    }
}

