/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.exception.status.NotFoundException;
import alluxio.exception.status.UnavailableException;
import alluxio.metrics.MetricsSystem;
import alluxio.recorder.Recorder;
import alluxio.resource.CloseableResource;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UfsManager
extends Closeable {
    public void addMount(long var1, AlluxioURI var3, UnderFileSystemConfiguration var4);

    public void addMountWithRecorder(long var1, AlluxioURI var3, UnderFileSystemConfiguration var4, Recorder var5);

    public void removeMount(long var1);

    public UfsClient get(long var1) throws NotFoundException, UnavailableException;

    public UfsClient getRoot();

    public UfsClient getJournal(URI var1);

    public boolean hasMount(long var1);

    public static class UfsClient {
        private static final Logger LOG = LoggerFactory.getLogger(UfsClient.class);
        private final AtomicReference<UnderFileSystem> mUfs;
        private final AlluxioURI mUfsMountPointUri;
        private final Supplier<UnderFileSystem> mUfsSupplier;
        private final Counter mCounter;

        public UfsClient(Supplier<UnderFileSystem> ufsSupplier, AlluxioURI ufsMountPointUri) {
            this.mUfsSupplier = Preconditions.checkNotNull(ufsSupplier, "ufsSupplier is null");
            this.mUfsMountPointUri = Preconditions.checkNotNull(ufsMountPointUri, "ufsMountPointUri is null");
            this.mCounter = MetricsSystem.counter(String.format("UfsSessionCount-Ufs:%s", MetricsSystem.escape(this.mUfsMountPointUri)));
            this.mUfs = new AtomicReference();
        }

        public CloseableResource<UnderFileSystem> acquireUfsResource() {
            UnderFileSystem ufs;
            if (this.mUfs.get() == null && !this.mUfs.compareAndSet(null, ufs = this.mUfsSupplier.get())) {
                try {
                    ufs.close();
                }
                catch (IOException e) {
                    LOG.warn(String.format("Failed to close extra UFS. mount point: %s error: %s", this.mUfsMountPointUri, e.toString()));
                }
            }
            this.mCounter.inc();
            return new CloseableResource<UnderFileSystem>(this.mUfs.get()){

                @Override
                public void closeResource() {
                    mCounter.dec();
                }
            };
        }

        public AlluxioURI getUfsMountPointUri() {
            return this.mUfsMountPointUri;
        }
    }
}

