/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsParentContext;
import io.opentelemetry.instrumentation.awssdk.v2_2.TracingExecutionInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

final class SqsImpl {
    private SqsImpl() {
    }

    static boolean afterReceiveMessageExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes, TracingExecutionInterceptor config) {
        SdkResponse rawResponse = context.response();
        if (!(rawResponse instanceof ReceiveMessageResponse)) {
            return false;
        }
        ReceiveMessageResponse response = (ReceiveMessageResponse)rawResponse;
        SdkHttpResponse httpResponse = context.httpResponse();
        for (Message message : response.messages()) {
            SqsImpl.createConsumerSpan(message, httpResponse, executionAttributes, config);
        }
        return true;
    }

    private static void createConsumerSpan(Message message, SdkHttpResponse httpResponse, ExecutionAttributes executionAttributes, TracingExecutionInterceptor config) {
        Instrumenter<ExecutionAttributes, SdkHttpResponse> consumerInstrumenter;
        Context parentContext = Context.root();
        TextMapPropagator messagingPropagator = config.getMessagingPropagator();
        if (messagingPropagator != null) {
            parentContext = SqsParentContext.ofMessageAttributes(message.messageAttributes(), messagingPropagator);
        }
        if (config.shouldUseXrayPropagator() && parentContext == Context.root()) {
            parentContext = SqsParentContext.ofSystemAttributes(message.attributesAsStrings());
        }
        if ((consumerInstrumenter = config.getConsumerInstrumenter()).shouldStart(parentContext, (Object)executionAttributes)) {
            Context context = consumerInstrumenter.start(parentContext, (Object)executionAttributes);
            consumerInstrumenter.end(context, (Object)executionAttributes, (Object)httpResponse, null);
        }
    }

    @Nullable
    static SdkRequest modifyRequest(SdkRequest request, Context otelContext, boolean useXrayPropagator, TextMapPropagator messagingPropagator) {
        if (request instanceof ReceiveMessageRequest) {
            return SqsImpl.modifyReceiveMessageRequest((ReceiveMessageRequest)request, useXrayPropagator, messagingPropagator);
        }
        if (messagingPropagator != null) {
            if (request instanceof SendMessageRequest) {
                return SqsImpl.injectIntoSendMessageRequest((SendMessageRequest)request, otelContext, messagingPropagator);
            }
            if (request instanceof SendMessageBatchRequest) {
                return SqsImpl.injectIntoSendMessageBatchRequest((SendMessageBatchRequest)request, otelContext, messagingPropagator);
            }
        }
        return null;
    }

    private static SdkRequest injectIntoSendMessageBatchRequest(SendMessageBatchRequest request, Context otelContext, TextMapPropagator messagingPropagator) {
        ArrayList<SendMessageBatchRequestEntry> entries = new ArrayList<SendMessageBatchRequestEntry>(request.entries());
        for (int i = 0; i < entries.size(); ++i) {
            SendMessageBatchRequestEntry entry = (SendMessageBatchRequestEntry)entries.get(i);
            HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>(entry.messageAttributes());
            if (!SqsImpl.injectIntoMessageAttributes(messageAttributes, otelContext, messagingPropagator)) continue;
            entries.set(i, (SendMessageBatchRequestEntry)entry.toBuilder().messageAttributes(messageAttributes).build());
        }
        return (SdkRequest)request.toBuilder().entries(entries).build();
    }

    private static SdkRequest injectIntoSendMessageRequest(SendMessageRequest request, Context otelContext, TextMapPropagator messagingPropagator) {
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>(request.messageAttributes());
        if (!SqsImpl.injectIntoMessageAttributes(messageAttributes, otelContext, messagingPropagator)) {
            return request;
        }
        return (SdkRequest)request.toBuilder().messageAttributes(messageAttributes).build();
    }

    private static boolean injectIntoMessageAttributes(Map<String, MessageAttributeValue> messageAttributes, Context otelContext, TextMapPropagator messagingPropagator) {
        messagingPropagator.inject(otelContext, messageAttributes, (carrier, k, v) -> carrier.put(k, (MessageAttributeValue)MessageAttributeValue.builder().stringValue(v).dataType("String").build()));
        return messageAttributes.size() <= 10;
    }

    private static SdkRequest modifyReceiveMessageRequest(ReceiveMessageRequest request, boolean useXrayPropagator, TextMapPropagator messagingPropagator) {
        boolean hasXrayAttribute = true;
        List existingAttributeNames = null;
        if (useXrayPropagator) {
            existingAttributeNames = request.attributeNamesAsStrings();
            hasXrayAttribute = existingAttributeNames.contains("AWSTraceHeader");
        }
        boolean hasMessageAttribute = true;
        List existingMessageAttributeNames = null;
        if (messagingPropagator != null) {
            existingMessageAttributeNames = request.messageAttributeNames();
            hasMessageAttribute = existingMessageAttributeNames.containsAll(messagingPropagator.fields());
        }
        if (hasMessageAttribute && hasXrayAttribute) {
            return request;
        }
        ReceiveMessageRequest.Builder builder = request.toBuilder();
        if (!hasXrayAttribute) {
            ArrayList<String> attributeNames = new ArrayList<String>(existingAttributeNames);
            attributeNames.add("AWSTraceHeader");
            builder.attributeNamesWithStrings(attributeNames);
        }
        if (messagingPropagator != null) {
            ArrayList<String> messageAttributeNames = new ArrayList<String>(existingMessageAttributeNames);
            for (String field : messagingPropagator.fields()) {
                if (existingMessageAttributeNames.contains(field)) continue;
                messageAttributeNames.add(field);
            }
            builder.messageAttributeNames(messageAttributeNames);
        }
        return (SdkRequest)builder.build();
    }

    static {
        String string = SqsClient.class.getName();
    }
}

