/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.UnionToRowCoercionUtils;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.hive.formats.avro.AvroTypeUtils;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.apache.avro.Resolver;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.FastReaderBuilder;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.apache.avro.util.internal.Accessor;

public class AvroPageDataReader
implements DatumReader<Optional<Page>> {
    private static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;
    private final Schema readerSchema;
    private Schema writerSchema;
    private final PageBuilder pageBuilder;
    private RowBlockBuildingDecoder rowBlockBuildingDecoder;
    private final AvroTypeManager typeManager;

    public AvroPageDataReader(Schema readerSchema, AvroTypeManager typeManager) throws AvroTypeException {
        this.writerSchema = this.readerSchema = Objects.requireNonNull(readerSchema, "readerSchema is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        try {
            Type readerSchemaType = AvroTypeUtils.typeFromAvro(this.readerSchema, typeManager);
            Verify.verify((boolean)(readerSchemaType instanceof RowType), (String)"Root Avro type must be a row", (Object[])new Object[0]);
            this.pageBuilder = new PageBuilder(readerSchemaType.getTypeParameters());
            this.initialize();
        }
        catch (org.apache.avro.AvroTypeException e) {
            throw new AvroTypeException(e);
        }
    }

    private void initialize() throws AvroTypeException {
        Verify.verify((this.readerSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (String)"Avro schema for page reader must be record", (Object[])new Object[0]);
        Verify.verify((this.writerSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (String)"File Avro schema for page reader must be record", (Object[])new Object[0]);
        this.rowBlockBuildingDecoder = new RowBlockBuildingDecoder(this.writerSchema, this.readerSchema, this.typeManager);
    }

    public void setSchema(Schema schema) {
        Objects.requireNonNull(schema, "schema is null");
        if (schema != this.writerSchema) {
            this.writerSchema = schema;
            try {
                this.initialize();
            }
            catch (org.apache.avro.AvroTypeException e) {
                throw new UncheckedAvroTypeException(new AvroTypeException(e));
            }
            catch (AvroTypeException e) {
                throw new UncheckedAvroTypeException(e);
            }
        }
    }

    public Optional<Page> read(Optional<Page> ignoredReuse, Decoder decoder) throws IOException {
        Optional<Page> page = Optional.empty();
        this.rowBlockBuildingDecoder.decodeIntoPageBuilder(decoder, this.pageBuilder);
        if (this.pageBuilder.isFull()) {
            page = Optional.of(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        return page;
    }

    public Optional<Page> flush() {
        if (!this.pageBuilder.isEmpty()) {
            Optional<Page> lastPage = Optional.of(this.pageBuilder.build());
            this.pageBuilder.reset();
            return lastPage;
        }
        return Optional.empty();
    }

    private static BlockBuildingDecoder createBlockBuildingDecoderForAction(Resolver.Action action, AvroTypeManager typeManager) throws AvroTypeException {
        Optional<BiConsumer<BlockBuilder, Object>> consumer = typeManager.overrideBuildingFunctionForSchema(action.reader);
        if (consumer.isPresent()) {
            return new UserDefinedBlockBuildingDecoder(action.reader, action.writer, consumer.get());
        }
        return switch (action.type) {
            default -> throw new IncompatibleClassChangeError();
            case Resolver.Action.Type.DO_NOTHING -> {
                switch (action.reader.getType()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NULL: {
                        yield NullBlockBuildingDecoder.INSTANCE;
                    }
                    case BOOLEAN: {
                        yield BooleanBlockBuildingDecoder.INSTANCE;
                    }
                    case INT: {
                        yield IntBlockBuildingDecoder.INSTANCE;
                    }
                    case LONG: {
                        yield new LongBlockBuildingDecoder();
                    }
                    case FLOAT: {
                        yield new FloatBlockBuildingDecoder();
                    }
                    case DOUBLE: {
                        yield new DoubleBlockBuildingDecoder();
                    }
                    case STRING: {
                        yield StringBlockBuildingDecoder.INSTANCE;
                    }
                    case BYTES: {
                        yield BytesBlockBuildingDecoder.INSTANCE;
                    }
                    case FIXED: {
                        yield new FixedBlockBuildingDecoder(action.reader.getFixedSize());
                    }
                    case ENUM: 
                    case ARRAY: 
                    case MAP: 
                    case RECORD: 
                    case UNION: 
                }
                throw new IllegalStateException("Do Nothing action type not compatible with reader schema type " + action.reader.getType());
            }
            case Resolver.Action.Type.PROMOTE -> {
                switch (action.reader.getType()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LONG: {
                        yield new LongBlockBuildingDecoder(AvroPageDataReader.getLongPromotionFunction(action.writer));
                    }
                    case FLOAT: {
                        yield new FloatBlockBuildingDecoder(AvroPageDataReader.getFloatPromotionFunction(action.writer));
                    }
                    case DOUBLE: {
                        yield new DoubleBlockBuildingDecoder(AvroPageDataReader.getDoublePromotionFunction(action.writer));
                    }
                    case STRING: {
                        if (action.writer.getType() == Schema.Type.BYTES) {
                            yield StringBlockBuildingDecoder.INSTANCE;
                        }
                        throw new AvroTypeException("Unable to promote to String from type " + action.writer.getType());
                    }
                    case BYTES: {
                        if (action.writer.getType() == Schema.Type.STRING) {
                            yield BytesBlockBuildingDecoder.INSTANCE;
                        }
                        throw new AvroTypeException("Unable to promote to Bytes from type " + action.writer.getType());
                    }
                    case NULL: 
                    case BOOLEAN: 
                    case INT: 
                    case FIXED: 
                    case ENUM: 
                    case ARRAY: 
                    case MAP: 
                    case RECORD: 
                    case UNION: 
                }
                throw new AvroTypeException("Promotion action not allowed for reader schema type " + action.reader.getType());
            }
            case Resolver.Action.Type.CONTAINER -> {
                switch (action.reader.getType()) {
                    case ARRAY: {
                        yield new ArrayBlockBuildingDecoder((Resolver.Container)action, typeManager);
                    }
                    case MAP: {
                        yield new MapBlockBuildingDecoder((Resolver.Container)action, typeManager);
                    }
                }
                throw new AvroTypeException("Not possible to have container action type with non container reader schema " + action.reader.getType());
            }
            case Resolver.Action.Type.RECORD -> new RowBlockBuildingDecoder(action, typeManager);
            case Resolver.Action.Type.ENUM -> new EnumBlockBuildingDecoder((Resolver.EnumAdjust)action);
            case Resolver.Action.Type.WRITER_UNION -> {
                if (AvroTypeUtils.isSimpleNullableUnion(action.reader)) {
                    yield new WriterUnionBlockBuildingDecoder((Resolver.WriterUnion)action, typeManager);
                }
                yield new WriterUnionCoercedIntoRowBlockBuildingDecoder((Resolver.WriterUnion)action, typeManager);
            }
            case Resolver.Action.Type.READER_UNION -> {
                if (AvroTypeUtils.isSimpleNullableUnion(action.reader)) {
                    yield AvroPageDataReader.createBlockBuildingDecoderForAction(((Resolver.ReaderUnion)action).actualAction, typeManager);
                }
                yield new ReaderUnionCoercedIntoRowBlockBuildingDecoder((Resolver.ReaderUnion)action, typeManager);
            }
            case Resolver.Action.Type.ERROR -> throw new AvroTypeException("Resolution action returned with error " + action);
            case Resolver.Action.Type.SKIP -> throw new IllegalStateException("Skips filtered by row step");
        };
    }

    private static LongIoFunction<Decoder> getLongPromotionFunction(Schema writerSchema) throws AvroTypeException {
        if (writerSchema.getType() == Schema.Type.INT) {
            return Decoder::readInt;
        }
        throw new AvroTypeException("Cannot promote type %s to long".formatted(writerSchema.getType()));
    }

    private static FloatIoFunction<Decoder> getFloatPromotionFunction(Schema writerSchema) throws AvroTypeException {
        return switch (writerSchema.getType()) {
            case Schema.Type.INT -> Decoder::readInt;
            case Schema.Type.LONG -> Decoder::readLong;
            default -> throw new AvroTypeException("Cannot promote type %s to float".formatted(writerSchema.getType()));
        };
    }

    private static DoubleIoFunction<Decoder> getDoublePromotionFunction(Schema writerSchema) throws AvroTypeException {
        return switch (writerSchema.getType()) {
            case Schema.Type.INT -> Decoder::readInt;
            case Schema.Type.LONG -> Decoder::readLong;
            case Schema.Type.FLOAT -> Decoder::readFloat;
            default -> throw new AvroTypeException("Cannot promote type %s to double".formatted(writerSchema.getType()));
        };
    }

    private static IoConsumer<BlockBuilder> getDefaultBlockBuilder(Schema.Field field, AvroTypeManager typeManager) throws AvroTypeException {
        BlockBuildingDecoder buildingDecoder = AvroPageDataReader.createBlockBuildingDecoderForAction(Resolver.resolve((Schema)field.schema(), (Schema)field.schema()), typeManager);
        byte[] defaultBytes = AvroPageDataReader.getDefaultByes(field);
        BinaryDecoder reuse = DecoderFactory.get().binaryDecoder(defaultBytes, null);
        return blockBuilder -> buildingDecoder.decodeIntoBlock((Decoder)DecoderFactory.get().binaryDecoder(defaultBytes, reuse), (BlockBuilder)blockBuilder);
    }

    private static byte[] getDefaultByes(Schema.Field field) throws AvroTypeException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
            ResolvingGrammarGenerator.encode((Encoder)e, (Schema)field.schema(), (JsonNode)Accessor.defaultValue((Schema.Field)field));
            e.flush();
            return out.toByteArray();
        }
        catch (IOException exception) {
            throw new AvroTypeException("Unable to encode to bytes for default value in field " + field, exception);
        }
    }

    private static class RowBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final RowBuildingAction[] buildSteps;

        private RowBlockBuildingDecoder(Schema writeSchema, Schema readSchema, AvroTypeManager typeManager) throws AvroTypeException {
            this(Resolver.resolve((Schema)writeSchema, (Schema)readSchema, (GenericData)new GenericData()), typeManager);
        }

        private RowBlockBuildingDecoder(Resolver.Action action, AvroTypeManager typeManager) throws AvroTypeException {
            int i;
            if (action instanceof Resolver.ErrorAction) {
                Resolver.ErrorAction errorAction = (Resolver.ErrorAction)action;
                throw new AvroTypeException("Error in resolution of types for row building: " + errorAction.error);
            }
            if (!(action instanceof Resolver.RecordAdjust)) {
                throw new AvroTypeException("Write and Read Schemas must be records when building a row block building decoder. Illegal action: " + action);
            }
            Resolver.RecordAdjust recordAdjust = (Resolver.RecordAdjust)action;
            this.buildSteps = new RowBuildingAction[recordAdjust.fieldActions.length + recordAdjust.readerOrder.length - recordAdjust.firstDefault];
            int readerFieldCount = 0;
            for (i = 0; i < recordAdjust.fieldActions.length; ++i) {
                Resolver.Action fieldAction = recordAdjust.fieldActions[i];
                if (fieldAction instanceof Resolver.Skip) {
                    Resolver.Skip skip = (Resolver.Skip)fieldAction;
                    this.buildSteps[i] = new SkipSchemaBuildingAction(skip.writer);
                    continue;
                }
                Schema.Field readField = recordAdjust.readerOrder[readerFieldCount++];
                this.buildSteps[i] = new BuildIntoBlockAction(AvroPageDataReader.createBlockBuildingDecoderForAction(fieldAction, typeManager), readField.pos());
            }
            while (i < this.buildSteps.length) {
                Schema.Field readField = recordAdjust.readerOrder[readerFieldCount++];
                this.buildSteps[i] = new ConstantBlockAction(AvroPageDataReader.getDefaultBlockBuilder(readField, typeManager), readField.pos());
                ++i;
            }
            Verify.verify((Arrays.stream(this.buildSteps).mapToInt(RowBuildingAction::getOutputChannel).filter(a -> a >= 0).distinct().sum() == recordAdjust.reader.getFields().size() * (recordAdjust.reader.getFields().size() - 1) / 2 ? 1 : 0) != 0, (String)"Every channel in output block builder must be accounted for", (Object[])new Object[0]);
            Verify.verify((Arrays.stream(this.buildSteps).mapToInt(RowBuildingAction::getOutputChannel).filter(a -> a >= 0).distinct().count() == (long)recordAdjust.reader.getFields().size() ? 1 : 0) != 0, (String)"Every channel in output block builder must be accounted for", (Object[])new Object[0]);
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            ((RowBlockBuilder)builder).buildEntry(fieldBuilders -> this.decodeIntoBlockProvided(decoder, fieldBuilders::get));
        }

        protected void decodeIntoPageBuilder(Decoder decoder, PageBuilder builder) throws IOException {
            builder.declarePosition();
            this.decodeIntoBlockProvided(decoder, arg_0 -> ((PageBuilder)builder).getBlockBuilder(arg_0));
        }

        protected void decodeIntoBlockProvided(Decoder decoder, IntFunction<BlockBuilder> fieldBlockBuilder) throws IOException {
            for (RowBuildingAction buildStep : this.buildSteps) {
                if (buildStep instanceof SkipSchemaBuildingAction) {
                    SkipSchemaBuildingAction skipSchemaBuildingAction = (SkipSchemaBuildingAction)buildStep;
                    skipSchemaBuildingAction.skip(decoder);
                    continue;
                }
                if (buildStep instanceof BuildIntoBlockAction) {
                    BuildIntoBlockAction buildIntoBlockAction = (BuildIntoBlockAction)buildStep;
                    buildIntoBlockAction.decode(decoder, fieldBlockBuilder);
                    continue;
                }
                if (buildStep instanceof ConstantBlockAction) {
                    ConstantBlockAction constantBlockAction = (ConstantBlockAction)buildStep;
                    constantBlockAction.addConstant(fieldBlockBuilder);
                    continue;
                }
                throw new IllegalStateException("Unhandled buildingAction");
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static interface RowBuildingAction {
            public int getOutputChannel();
        }

        private static final class SkipSchemaBuildingAction
        implements RowBuildingAction {
            private final SkipAction skipAction;

            SkipSchemaBuildingAction(Schema schema) {
                this.skipAction = SkipSchemaBuildingAction.createSkipActionForSchema(Objects.requireNonNull(schema, "schema is null"));
            }

            public void skip(Decoder decoder) throws IOException {
                this.skipAction.skip(decoder);
            }

            @Override
            public int getOutputChannel() {
                return -1;
            }

            private static SkipAction createSkipActionForSchema(Schema schema) {
                return switch (schema.getType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Schema.Type.NULL -> Decoder::readNull;
                    case Schema.Type.BOOLEAN -> Decoder::readBoolean;
                    case Schema.Type.INT -> Decoder::readInt;
                    case Schema.Type.LONG -> Decoder::readLong;
                    case Schema.Type.FLOAT -> Decoder::readFloat;
                    case Schema.Type.DOUBLE -> Decoder::readDouble;
                    case Schema.Type.STRING -> Decoder::skipString;
                    case Schema.Type.BYTES -> Decoder::skipBytes;
                    case Schema.Type.ENUM -> Decoder::readEnum;
                    case Schema.Type.FIXED -> {
                        int size = schema.getFixedSize();
                        yield decoder -> decoder.skipFixed(size);
                    }
                    case Schema.Type.ARRAY -> new ArraySkipAction(schema.getElementType());
                    case Schema.Type.MAP -> new MapSkipAction(schema.getValueType());
                    case Schema.Type.RECORD -> new RecordSkipAction(schema.getFields());
                    case Schema.Type.UNION -> new UnionSkipAction(schema.getTypes());
                };
            }

            @FunctionalInterface
            private static interface SkipAction {
                public void skip(Decoder var1) throws IOException;
            }

            private static class ArraySkipAction
            implements SkipAction {
                private final SkipAction elementSkipAction;

                public ArraySkipAction(Schema elementSchema) {
                    this.elementSkipAction = SkipSchemaBuildingAction.createSkipActionForSchema(Objects.requireNonNull(elementSchema, "elementSchema is null"));
                }

                @Override
                public void skip(Decoder decoder) throws IOException {
                    long i = decoder.skipArray();
                    while (i != 0L) {
                        for (long j = 0L; j < i; ++j) {
                            this.elementSkipAction.skip(decoder);
                        }
                        i = decoder.skipArray();
                    }
                }
            }

            private static class MapSkipAction
            implements SkipAction {
                private final SkipAction valueSkipAction;

                public MapSkipAction(Schema valueSchema) {
                    this.valueSkipAction = SkipSchemaBuildingAction.createSkipActionForSchema(Objects.requireNonNull(valueSchema, "valueSchema is null"));
                }

                @Override
                public void skip(Decoder decoder) throws IOException {
                    long i = decoder.skipMap();
                    while (i != 0L) {
                        for (long j = 0L; j < i; ++j) {
                            decoder.skipString();
                            this.valueSkipAction.skip(decoder);
                        }
                        i = decoder.skipMap();
                    }
                }
            }

            private static class RecordSkipAction
            implements SkipAction {
                private final SkipAction[] fieldSkips;

                public RecordSkipAction(List<Schema.Field> fields) {
                    this.fieldSkips = new SkipAction[Objects.requireNonNull(fields, "fields is null").size()];
                    for (int i = 0; i < fields.size(); ++i) {
                        this.fieldSkips[i] = SkipSchemaBuildingAction.createSkipActionForSchema(fields.get(i).schema());
                    }
                }

                @Override
                public void skip(Decoder decoder) throws IOException {
                    for (SkipAction fieldSkipAction : this.fieldSkips) {
                        fieldSkipAction.skip(decoder);
                    }
                }
            }

            private static class UnionSkipAction
            implements SkipAction {
                private final SkipAction[] skipActions;

                private UnionSkipAction(List<Schema> types) {
                    this.skipActions = new SkipAction[Objects.requireNonNull(types, "types is null").size()];
                    for (int i = 0; i < types.size(); ++i) {
                        this.skipActions[i] = SkipSchemaBuildingAction.createSkipActionForSchema(types.get(i));
                    }
                }

                @Override
                public void skip(Decoder decoder) throws IOException {
                    this.skipActions[decoder.readIndex()].skip(decoder);
                }
            }
        }

        private static final class BuildIntoBlockAction
        implements RowBuildingAction {
            private final BlockBuildingDecoder delegate;
            private final int outputChannel;

            public BuildIntoBlockAction(BlockBuildingDecoder delegate, int outputChannel) {
                this.delegate = Objects.requireNonNull(delegate, "delegate is null");
                Preconditions.checkArgument((outputChannel >= 0 ? 1 : 0) != 0, (Object)"outputChannel must be positive");
                this.outputChannel = outputChannel;
            }

            public void decode(Decoder decoder, IntFunction<BlockBuilder> channelSelector) throws IOException {
                this.delegate.decodeIntoBlock(decoder, channelSelector.apply(this.outputChannel));
            }

            @Override
            public int getOutputChannel() {
                return this.outputChannel;
            }
        }

        protected static final class ConstantBlockAction
        implements RowBuildingAction {
            private final IoConsumer<BlockBuilder> addConstantFunction;
            private final int outputChannel;

            public ConstantBlockAction(IoConsumer<BlockBuilder> addConstantFunction, int outputChannel) {
                this.addConstantFunction = Objects.requireNonNull(addConstantFunction, "addConstantFunction is null");
                Preconditions.checkArgument((outputChannel >= 0 ? 1 : 0) != 0, (Object)"outputChannel must be positive");
                this.outputChannel = outputChannel;
            }

            public void addConstant(IntFunction<BlockBuilder> channelSelector) throws IOException {
                this.addConstantFunction.accept(channelSelector.apply(this.outputChannel));
            }

            @Override
            public int getOutputChannel() {
                return this.outputChannel;
            }
        }
    }

    protected static class UncheckedAvroTypeException
    extends RuntimeException {
        private final AvroTypeException avroTypeException;

        public UncheckedAvroTypeException(AvroTypeException cause) {
            super(Objects.requireNonNull(cause, "cause is null"));
            this.avroTypeException = cause;
        }

        public AvroTypeException getAvroTypeException() {
            return this.avroTypeException;
        }
    }

    private static class UserDefinedBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final BiConsumer<BlockBuilder, Object> userBuilderFunction;
        private final DatumReader<Object> datumReader;

        public UserDefinedBlockBuildingDecoder(Schema readerSchema, Schema writerSchema, BiConsumer<BlockBuilder, Object> userBuilderFunction) throws AvroTypeException {
            Objects.requireNonNull(readerSchema, "readerSchema is null");
            Objects.requireNonNull(writerSchema, "writerSchema is null");
            try {
                FastReaderBuilder fastReaderBuilder = new FastReaderBuilder(new GenericData());
                this.datumReader = fastReaderBuilder.createDatumReader(writerSchema, readerSchema);
            }
            catch (IOException ioException) {
                throw new AvroTypeException("Unable to decode default value in schema " + readerSchema, ioException);
            }
            this.userBuilderFunction = Objects.requireNonNull(userBuilderFunction, "userBuilderFunction is null");
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            this.userBuilderFunction.accept(builder, this.datumReader.read(null, decoder));
        }
    }

    private static class NullBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final NullBlockBuildingDecoder INSTANCE = new NullBlockBuildingDecoder();

        private NullBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            decoder.readNull();
            builder.appendNull();
        }
    }

    private static class BooleanBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final BooleanBlockBuildingDecoder INSTANCE = new BooleanBlockBuildingDecoder();

        private BooleanBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            BooleanType.BOOLEAN.writeBoolean(builder, decoder.readBoolean());
        }
    }

    private static class IntBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final IntBlockBuildingDecoder INSTANCE = new IntBlockBuildingDecoder();

        private IntBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            IntegerType.INTEGER.writeLong(builder, (long)decoder.readInt());
        }
    }

    private static class LongBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final LongIoFunction<Decoder> DEFAULT_EXTRACT_LONG = Decoder::readLong;
        private final LongIoFunction<Decoder> extractLong;

        public LongBlockBuildingDecoder() {
            this(DEFAULT_EXTRACT_LONG);
        }

        public LongBlockBuildingDecoder(LongIoFunction<Decoder> extractLong) {
            this.extractLong = Objects.requireNonNull(extractLong, "extractLong is null");
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            BigintType.BIGINT.writeLong(builder, this.extractLong.apply(decoder));
        }
    }

    private static class FloatBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final FloatIoFunction<Decoder> DEFAULT_EXTRACT_FLOAT = Decoder::readFloat;
        private final FloatIoFunction<Decoder> extractFloat;

        public FloatBlockBuildingDecoder() {
            this(DEFAULT_EXTRACT_FLOAT);
        }

        public FloatBlockBuildingDecoder(FloatIoFunction<Decoder> extractFloat) {
            this.extractFloat = Objects.requireNonNull(extractFloat, "extractFloat is null");
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(this.extractFloat.apply(decoder)));
        }
    }

    private static class DoubleBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final DoubleIoFunction<Decoder> DEFAULT_EXTRACT_DOUBLE = Decoder::readDouble;
        private final DoubleIoFunction<Decoder> extractDouble;

        public DoubleBlockBuildingDecoder() {
            this(DEFAULT_EXTRACT_DOUBLE);
        }

        public DoubleBlockBuildingDecoder(DoubleIoFunction<Decoder> extractDouble) {
            this.extractDouble = Objects.requireNonNull(extractDouble, "extractDouble is null");
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            DoubleType.DOUBLE.writeDouble(builder, this.extractDouble.apply(decoder));
        }
    }

    private static class StringBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final StringBlockBuildingDecoder INSTANCE = new StringBlockBuildingDecoder();

        private StringBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro String with size greater than %s. Found String size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            VarcharType.VARCHAR.writeSlice(builder, Slices.wrappedBuffer((byte[])bytes));
        }
    }

    private static class BytesBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final BytesBlockBuildingDecoder INSTANCE = new BytesBlockBuildingDecoder();

        private BytesBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro Bytes with size greater than %s. Found Bytes size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            VarbinaryType.VARBINARY.writeSlice(builder, Slices.wrappedBuffer((byte[])bytes));
        }
    }

    private static class FixedBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final int expectedSize;

        public FixedBlockBuildingDecoder(int expectedSize) {
            Verify.verify((expectedSize >= 0 ? 1 : 0) != 0, (String)"expected size must be greater than or equal to 0", (Object[])new Object[0]);
            this.expectedSize = expectedSize;
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            byte[] slice = new byte[this.expectedSize];
            decoder.readFixed(slice);
            VarbinaryType.VARBINARY.writeSlice(builder, Slices.wrappedBuffer((byte[])slice));
        }
    }

    @FunctionalInterface
    private static interface LongIoFunction<A> {
        public long apply(A var1) throws IOException;
    }

    @FunctionalInterface
    private static interface FloatIoFunction<A> {
        public float apply(A var1) throws IOException;
    }

    @FunctionalInterface
    private static interface DoubleIoFunction<A> {
        public double apply(A var1) throws IOException;
    }

    private static class ArrayBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final BlockBuildingDecoder elementBlockBuildingDecoder;

        public ArrayBlockBuildingDecoder(Resolver.Container containerAction, AvroTypeManager typeManager) throws AvroTypeException {
            Objects.requireNonNull(containerAction, "containerAction is null");
            Verify.verify((containerAction.reader.getType() == Schema.Type.ARRAY ? 1 : 0) != 0, (String)"Reader schema must be a array", (Object[])new Object[0]);
            this.elementBlockBuildingDecoder = AvroPageDataReader.createBlockBuildingDecoderForAction(containerAction.elementAction, typeManager);
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            ((ArrayBlockBuilder)builder).buildEntry(elementBuilder -> {
                long elementsInBlock = decoder.readArrayStart();
                if (elementsInBlock > 0L) {
                    do {
                        int i = 0;
                        while ((long)i < elementsInBlock) {
                            this.elementBlockBuildingDecoder.decodeIntoBlock(decoder, elementBuilder);
                            ++i;
                        }
                    } while ((elementsInBlock = decoder.arrayNext()) > 0L);
                }
            });
        }
    }

    private static class MapBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final BlockBuildingDecoder keyBlockBuildingDecoder = new StringBlockBuildingDecoder();
        private final BlockBuildingDecoder valueBlockBuildingDecoder;

        public MapBlockBuildingDecoder(Resolver.Container containerAction, AvroTypeManager typeManager) throws AvroTypeException {
            Objects.requireNonNull(containerAction, "containerAction is null");
            Verify.verify((containerAction.reader.getType() == Schema.Type.MAP ? 1 : 0) != 0, (String)"Reader schema must be a map", (Object[])new Object[0]);
            this.valueBlockBuildingDecoder = AvroPageDataReader.createBlockBuildingDecoderForAction(containerAction.elementAction, typeManager);
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            ((MapBlockBuilder)builder).buildEntry((keyBuilder, valueBuilder) -> {
                long entriesInBlock = decoder.readMapStart();
                if (entriesInBlock > 0L) {
                    do {
                        int i = 0;
                        while ((long)i < entriesInBlock) {
                            this.keyBlockBuildingDecoder.decodeIntoBlock(decoder, keyBuilder);
                            this.valueBlockBuildingDecoder.decodeIntoBlock(decoder, valueBuilder);
                            ++i;
                        }
                    } while ((entriesInBlock = decoder.mapNext()) > 0L);
                }
            });
        }
    }

    private static class EnumBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private Slice[] symbols;

        public EnumBlockBuildingDecoder(Resolver.EnumAdjust action) throws AvroTypeException {
            List symbolsList = Objects.requireNonNull(action, (String)"action is null").reader.getEnumSymbols();
            this.symbols = (Slice[])symbolsList.stream().map(Slices::utf8Slice).toArray(Slice[]::new);
            if (!action.noAdjustmentsNeeded) {
                Slice[] adjustedSymbols = new Slice[action.writer.getEnumSymbols().size()];
                for (int i = 0; i < action.adjustments.length; ++i) {
                    if (action.adjustments[i] < 0) {
                        throw new AvroTypeException("No reader Enum value for writer Enum value " + (String)action.writer.getEnumSymbols().get(i));
                    }
                    adjustedSymbols[i] = this.symbols[action.adjustments[i]];
                }
                this.symbols = adjustedSymbols;
            }
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            VarcharType.VARCHAR.writeSlice(builder, this.symbols[decoder.readEnum()]);
        }
    }

    private static class WriterUnionBlockBuildingDecoder
    extends BlockBuildingDecoder {
        protected final BlockBuildingDecoder[] blockBuildingDecoders;

        public WriterUnionBlockBuildingDecoder(Resolver.WriterUnion writerUnion, AvroTypeManager typeManager) throws AvroTypeException {
            Objects.requireNonNull(writerUnion, "writerUnion is null");
            this.blockBuildingDecoders = new BlockBuildingDecoder[writerUnion.actions.length];
            for (int i = 0; i < writerUnion.actions.length; ++i) {
                this.blockBuildingDecoders[i] = AvroPageDataReader.createBlockBuildingDecoderForAction(writerUnion.actions[i], typeManager);
            }
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            this.decodeIntoBlock(decoder.readIndex(), decoder, builder);
        }

        protected void decodeIntoBlock(int blockBuilderIndex, Decoder decoder, BlockBuilder builder) throws IOException {
            this.blockBuildingDecoders[blockBuilderIndex].decodeIntoBlock(decoder, builder);
        }
    }

    private static class WriterUnionCoercedIntoRowBlockBuildingDecoder
    extends WriterUnionBlockBuildingDecoder {
        private final boolean readUnionEquiv;
        private final int[] indexToChannel;
        private final int totalChannels;

        public WriterUnionCoercedIntoRowBlockBuildingDecoder(Resolver.WriterUnion writerUnion, AvroTypeManager avroTypeManager) throws AvroTypeException {
            super(writerUnion, avroTypeManager);
            this.readUnionEquiv = writerUnion.unionEquiv;
            List readSchemas = writerUnion.reader.getTypes();
            Preconditions.checkArgument((readSchemas.size() == writerUnion.actions.length ? 1 : 0) != 0, (Object)"each read schema must have resolvedAction For it");
            this.indexToChannel = WriterUnionCoercedIntoRowBlockBuildingDecoder.getIndexToChannel(readSchemas);
            this.totalChannels = (int)IntStream.of(this.indexToChannel).filter(i -> i >= 0).count();
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            int index = decoder.readIndex();
            if (this.readUnionEquiv) {
                if (this.indexToChannel[index] < 0) {
                    NullBlockBuildingDecoder.INSTANCE.decodeIntoBlock(decoder, builder);
                } else {
                    WriterUnionCoercedIntoRowBlockBuildingDecoder.makeSingleRowWithTagAndAllFieldsNullButOne(this.indexToChannel[index], this.totalChannels, this.blockBuildingDecoders[index], decoder, builder);
                }
            } else {
                this.decodeIntoBlock(index, decoder, builder);
            }
        }

        protected static void makeSingleRowWithTagAndAllFieldsNullButOne(int outputChannel, int totalChannels, BlockBuildingDecoder blockBuildingDecoder, Decoder decoder, BlockBuilder builder) throws IOException {
            ((RowBlockBuilder)builder).buildEntry(fieldBuilders -> {
                UnionToRowCoercionUtils.UNION_FIELD_TAG_TYPE.writeLong((BlockBuilder)fieldBuilders.get(0), (long)outputChannel);
                for (int channel = 1; channel <= totalChannels; ++channel) {
                    if (channel == outputChannel + 1) {
                        blockBuildingDecoder.decodeIntoBlock(decoder, (BlockBuilder)fieldBuilders.get(channel));
                        continue;
                    }
                    ((BlockBuilder)fieldBuilders.get(channel)).appendNull();
                }
            });
        }

        protected static int[] getIndexToChannel(List<Schema> schemas) {
            int[] indexToChannel = new int[schemas.size()];
            int outputChannel = 0;
            for (int i = 0; i < indexToChannel.length; ++i) {
                indexToChannel[i] = schemas.get(i).getType() == Schema.Type.NULL ? -1 : outputChannel++;
            }
            return indexToChannel;
        }
    }

    private static abstract class BlockBuildingDecoder {
        private BlockBuildingDecoder() {
        }

        protected abstract void decodeIntoBlock(Decoder var1, BlockBuilder var2) throws IOException;
    }

    private static class ReaderUnionCoercedIntoRowBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final BlockBuildingDecoder delegateBuilder;
        private final int outputChannel;
        private final int totalChannels;

        public ReaderUnionCoercedIntoRowBlockBuildingDecoder(Resolver.ReaderUnion readerUnion, AvroTypeManager avroTypeManager) throws AvroTypeException {
            Objects.requireNonNull(readerUnion, "readerUnion is null");
            Objects.requireNonNull(avroTypeManager, "avroTypeManger is null");
            int[] indexToChannel = WriterUnionCoercedIntoRowBlockBuildingDecoder.getIndexToChannel(readerUnion.reader.getTypes());
            this.outputChannel = indexToChannel[readerUnion.firstMatch];
            this.delegateBuilder = AvroPageDataReader.createBlockBuildingDecoderForAction(readerUnion.actualAction, avroTypeManager);
            this.totalChannels = (int)IntStream.of(indexToChannel).filter(i -> i >= 0).count();
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            if (this.outputChannel < 0) {
                NullBlockBuildingDecoder.INSTANCE.decodeIntoBlock(decoder, builder);
            } else {
                WriterUnionCoercedIntoRowBlockBuildingDecoder.makeSingleRowWithTagAndAllFieldsNullButOne(this.outputChannel, this.totalChannels, this.delegateBuilder, decoder, builder);
            }
        }
    }

    @FunctionalInterface
    private static interface IoConsumer<A> {
        public void accept(A var1) throws IOException;
    }
}

