/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.Table;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkTelemetry;
import io.trino.plugin.hive.AllowHiveTableRename;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.glue.DefaultGlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.DefaultGlueMetastoreTableFilterProvider;
import io.trino.plugin.hive.metastore.glue.ForGlueColumnStatisticsRead;
import io.trino.plugin.hive.metastore.glue.ForGlueColumnStatisticsWrite;
import io.trino.plugin.hive.metastore.glue.ForGlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueCatalogIdRequestHandler;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.GlueCredentialsProvider;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.HiveGlueClientProvider;
import io.trino.plugin.hive.metastore.glue.ProxyApiRequestHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import org.weakref.jmx.guice.ExportBinder;

public class GlueMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        GlueHiveMetastoreConfig glueConfig = (GlueHiveMetastoreConfig)this.buildConfigObject(GlueHiveMetastoreConfig.class);
        Multibinder requestHandlers = Multibinder.newSetBinder((Binder)binder, RequestHandler2.class, ForGlueHiveMetastore.class);
        glueConfig.getCatalogId().ifPresent(catalogId -> requestHandlers.addBinding().toInstance((Object)new GlueCatalogIdRequestHandler((String)catalogId)));
        glueConfig.getGlueProxyApiId().ifPresent(glueProxyApiId -> requestHandlers.addBinding().toInstance((Object)new ProxyApiRequestHandler((String)glueProxyApiId)));
        binder.bind(AWSCredentialsProvider.class).toProvider(GlueCredentialsProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get((TypeLiteral)new TypeLiteral<Predicate<Table>>(){}, ForGlueHiveMetastore.class)).setDefault().toProvider(DefaultGlueMetastoreTableFilterProvider.class).in(Scopes.SINGLETON);
        binder.bind(GlueHiveMetastore.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(HiveMetastoreFactory.class, RawHiveMetastoreFactory.class)).setDefault().to(GlueHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        binder.bind(GlueHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        binder.bind(Key.get(GlueMetastoreStats.class, ForGlueHiveMetastore.class)).toInstance((Object)new GlueMetastoreStats());
        binder.bind(AWSGlueAsync.class).toProvider(HiveGlueClientProvider.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(GlueHiveMetastoreFactory.class).as(generator -> generator.generatedNameOf(GlueHiveMetastore.class));
        binder.bind(Key.get(Boolean.TYPE, AllowHiveTableRename.class)).toInstance((Object)false);
        OptionalBinder.newOptionalBinder((Binder)binder, GlueColumnStatisticsProviderFactory.class).setDefault().to(DefaultGlueColumnStatisticsProviderFactory.class).in(Scopes.SINGLETON);
    }

    @ProvidesIntoSet
    @Singleton
    @ForGlueHiveMetastore
    public RequestHandler2 createRequestHandler(OpenTelemetry openTelemetry) {
        return AwsSdkTelemetry.builder((OpenTelemetry)openTelemetry).setCaptureExperimentalSpanAttributes(true).build().newRequestHandler();
    }

    @Provides
    @Singleton
    @ForGlueHiveMetastore
    public Executor createExecutor(GlueHiveMetastoreConfig hiveConfig) {
        return this.createExecutor("hive-glue-partitions-%s", hiveConfig.getGetPartitionThreads());
    }

    @Provides
    @Singleton
    @ForGlueColumnStatisticsRead
    public Executor createStatisticsReadExecutor(GlueHiveMetastoreConfig hiveConfig) {
        return this.createExecutor("hive-glue-statistics-read-%s", hiveConfig.getReadStatisticsThreads());
    }

    @Provides
    @Singleton
    @ForGlueColumnStatisticsWrite
    public Executor createStatisticsWriteExecutor(GlueHiveMetastoreConfig hiveConfig) {
        return this.createExecutor("hive-glue-statistics-write-%s", hiveConfig.getWriteStatisticsThreads());
    }

    private Executor createExecutor(String nameTemplate, int threads) {
        if (threads == 1) {
            return MoreExecutors.directExecutor();
        }
        return new BoundedExecutor((Executor)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)nameTemplate)), threads);
    }
}

