/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.PageSorter;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class SortBuffer {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SortBuffer.class);
    private final long maxMemoryBytes;
    private final List<Type> types;
    private final List<Integer> sortFields;
    private final List<SortOrder> sortOrders;
    private final PageSorter pageSorter;
    private final List<Page> pages = new ArrayList<Page>();
    private final PageBuilder pageBuilder;
    private long usedMemoryBytes;
    private int rowCount;

    public SortBuffer(DataSize maxMemory, List<Type> types, List<Integer> sortFields, List<SortOrder> sortOrders, PageSorter pageSorter) {
        Preconditions.checkArgument((maxMemory.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxMemory is zero");
        this.maxMemoryBytes = maxMemory.toBytes();
        this.types = Objects.requireNonNull(types, "types is null");
        this.sortFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortFields, "sortFields is null"));
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.pageBuilder = new PageBuilder(types);
    }

    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.usedMemoryBytes;
    }

    public boolean isEmpty() {
        return this.pages.isEmpty();
    }

    public boolean canAdd(Page page) {
        return this.usedMemoryBytes < this.maxMemoryBytes && (long)this.rowCount + (long)page.getPositionCount() <= Integer.MAX_VALUE;
    }

    public void add(Page page) {
        Preconditions.checkState((boolean)this.canAdd(page), (Object)"page buffer is full");
        this.pages.add(page);
        this.usedMemoryBytes += page.getRetainedSizeInBytes();
        this.rowCount = Math.addExact(this.rowCount, page.getPositionCount());
    }

    public static void appendPositionTo(Page page, int position, PageBuilder pageBuilder) {
        pageBuilder.declarePosition();
        for (int i = 0; i < page.getChannelCount(); ++i) {
            Type type = pageBuilder.getType(i);
            Block block = page.getBlock(i);
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
            type.appendTo(block, position, blockBuilder);
        }
    }

    public void flushTo(Consumer<Page> consumer) {
        int i;
        Preconditions.checkState((!this.pages.isEmpty() ? 1 : 0) != 0, (Object)"page buffer is empty");
        long[] addresses = this.pageSorter.sort(this.types, this.pages, this.sortFields, this.sortOrders, this.rowCount);
        int[] pageIndex = new int[addresses.length];
        int[] positionIndex = new int[addresses.length];
        for (i = 0; i < addresses.length; ++i) {
            pageIndex[i] = this.pageSorter.decodePageIndex(addresses[i]);
            positionIndex[i] = this.pageSorter.decodePositionIndex(addresses[i]);
        }
        Verify.verify((boolean)this.pageBuilder.isEmpty());
        for (i = 0; i < pageIndex.length; ++i) {
            Page page = this.pages.get(pageIndex[i]);
            int position = positionIndex[i];
            SortBuffer.appendPositionTo(page, position, this.pageBuilder);
            if (!this.pageBuilder.isFull()) continue;
            consumer.accept(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        if (!this.pageBuilder.isEmpty()) {
            consumer.accept(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        this.pages.clear();
        this.rowCount = 0;
        this.usedMemoryBytes = 0L;
    }
}

