/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import io.trino.orc.OrcWriter;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidSchema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.util.ConfigurationUtils;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public abstract class AbstractHiveAcidWriters {
    public static final Block DELETE_OPERATION_BLOCK = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcWriter.OrcOperation.DELETE.getOperationNumber());
    public static final Block INSERT_OPERATION_BLOCK = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcWriter.OrcOperation.INSERT.getOperationNumber());
    public static final Pattern BUCKET_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<dirStart>delta_[\\d]+_[\\d]+)_(?<statementId>[\\d]+)/(?<filenameBase>bucket_(?<bucketNumber>[\\d]+))(?<attemptId>_[\\d]+)?$");
    public static final Pattern ORIGINAL_FILE_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<filename>(?<bucketNumber>[\\d]+)_(?<rest>.*)?)$");
    public static final Pattern BASE_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<dirStart>base_[\\d]+(_v[\\d]+)?)/(?<filenameBase>bucket_(?<bucketNumber>[\\d]+))(?<attemptId>_[\\d]+)?$");
    protected final AcidTransaction transaction;
    protected final OptionalInt bucketNumber;
    protected final int statementId;
    private final OrcFileWriterFactory orcFileWriterFactory;
    private final Configuration configuration;
    protected final ConnectorSession session;
    protected final HiveType hiveRowType;
    private final Properties hiveAcidSchema;
    protected final Path deleteDeltaDirectory;
    private final String bucketFilename;
    protected Optional<Path> deltaDirectory;
    protected Optional<FileWriter> deleteFileWriter = Optional.empty();
    protected Optional<FileWriter> insertFileWriter = Optional.empty();

    public AbstractHiveAcidWriters(AcidTransaction transaction, int statementId, OptionalInt bucketNumber, Path bucketPath, boolean originalFile, OrcFileWriterFactory orcFileWriterFactory, Configuration configuration, ConnectorSession session, HiveType hiveRowType, AcidOperation updateKind) {
        Matcher matcher;
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.statementId = statementId;
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.orcFileWriterFactory = Objects.requireNonNull(orcFileWriterFactory, "orcFileWriterFactory is null");
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.session = Objects.requireNonNull(session, "session is null");
        Preconditions.checkArgument((boolean)transaction.isTransactional(), (String)"Not in a transaction: %s", (Object)transaction);
        this.hiveRowType = Objects.requireNonNull(hiveRowType, "hiveRowType is null");
        this.hiveAcidSchema = AcidSchema.createAcidSchema(hiveRowType);
        Objects.requireNonNull(bucketPath, "bucketPath is null");
        if (originalFile) {
            matcher = ORIGINAL_FILE_PATH_MATCHER.matcher(bucketPath.toString());
            Preconditions.checkArgument((boolean)matcher.matches(), (String)"Original file bucketPath doesn't have the required format: %s", (Object)bucketPath);
            this.bucketFilename = String.format("bucket_%05d", bucketNumber.isEmpty() ? 0 : bucketNumber.getAsInt());
        } else {
            matcher = BASE_PATH_MATCHER.matcher(bucketPath.toString());
            if (matcher.matches()) {
                this.bucketFilename = matcher.group("filenameBase");
            } else {
                matcher = BUCKET_PATH_MATCHER.matcher(bucketPath.toString());
                Preconditions.checkArgument((boolean)matcher.matches(), (String)"bucketPath doesn't have the required format: %s", (Object)bucketPath);
                this.bucketFilename = matcher.group("filenameBase");
            }
        }
        long writeId = transaction.getWriteId();
        this.deleteDeltaDirectory = new Path(String.format("%s/%s", matcher.group("rootDir"), AcidUtils.deleteDeltaSubdir((long)writeId, (long)writeId, (int)statementId)));
        this.deltaDirectory = updateKind == AcidOperation.UPDATE ? Optional.of(new Path(String.format("%s/%s", matcher.group("rootDir"), AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)statementId)))) : Optional.empty();
    }

    protected void lazyInitializeDeleteFileWriter() {
        if (this.deleteFileWriter.isEmpty()) {
            Properties schemaCopy = new Properties();
            schemaCopy.putAll((Map<?, ?>)this.hiveAcidSchema);
            this.deleteFileWriter = this.orcFileWriterFactory.createFileWriter(new Path(String.format("%s/%s", this.deleteDeltaDirectory, this.bucketFilename)), AcidSchema.ACID_COLUMN_NAMES, StorageFormat.fromHiveStorageFormat(HiveStorageFormat.ORC), schemaCopy, ConfigurationUtils.toJobConf(this.configuration), this.session, this.bucketNumber, this.transaction, true, WriterKind.DELETE);
        }
    }

    protected void lazyInitializeInsertFileWriter() {
        if (this.insertFileWriter.isEmpty()) {
            Properties schemaCopy = new Properties();
            schemaCopy.putAll((Map<?, ?>)this.hiveAcidSchema);
            Path deltaDir = this.deltaDirectory.orElseThrow(() -> new IllegalArgumentException("deltaDirectory not present"));
            this.insertFileWriter = this.orcFileWriterFactory.createFileWriter(new Path(String.format("%s/%s", deltaDir, this.bucketFilename)), AcidSchema.ACID_COLUMN_NAMES, StorageFormat.fromHiveStorageFormat(HiveStorageFormat.ORC), schemaCopy, ConfigurationUtils.toJobConf(this.configuration), this.session, this.bucketNumber, this.transaction, true, WriterKind.INSERT);
        }
    }
}

